/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.kdtree;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.graph.GraphUtils;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.KDTree;
import net.imglib2.RealLocalizable;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import net.imglib2.neighborsearch.KNearestNeighborSearchOnKDTree;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.scijava.Cancelable;

public class NearestNeighborTracker
extends MultiThreadedBenchmarkAlgorithm
implements SpotTracker,
Cancelable {
    protected final SpotCollection spots;
    protected final Map<String, Object> settings;
    protected Logger logger = Logger.VOID_LOGGER;
    protected SimpleDirectedWeightedGraph<Spot, DefaultWeightedEdge> graph;
    private boolean isCanceled;
    private String cancelReason;

    public NearestNeighborTracker(SpotCollection spots, Map<String, Object> settings) {
        this.spots = spots;
        this.settings = settings;
    }

    public boolean checkInput() {
        StringBuilder errrorHolder = new StringBuilder();
        boolean ok = NearestNeighborTracker.checkInput(this.settings, errrorHolder);
        if (!ok) {
            this.errorMessage = errrorHolder.toString();
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() {
        long start = System.currentTimeMillis();
        this.isCanceled = false;
        this.cancelReason = null;
        this.reset();
        double maxLinkingDistance = (Double)this.settings.get("LINKING_MAX_DISTANCE");
        final double maxDistSquare = maxLinkingDistance * maxLinkingDistance;
        final TreeSet<Integer> frames = new TreeSet<Integer>((SortedSet<Integer>)this.spots.keySet());
        final AtomicInteger progress = new AtomicInteger(0);
        ExecutorService executors = Threads.newFixedThreadPool(this.numThreads);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(frames.size());
        int i = frames.first();
        while (i < frames.last()) {
            final int bl = i++;
            Future<Void> future = executors.submit(new Callable<Void>(){
                final /* synthetic */ NearestNeighborTracker this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    if (this.this$0.isCanceled()) {
                        return null;
                    }
                    int sourceFrame = bl;
                    int targetFrame = frames.higher(bl);
                    int nTargetSpots = this.this$0.spots.getNSpots(targetFrame, true);
                    if (nTargetSpots < 1) {
                        this.this$0.logger.setProgress((double)progress.incrementAndGet() / (double)frames.size());
                        return null;
                    }
                    Iterable<Spot> targetSpots = this.this$0.spots.iterable(targetFrame, true);
                    KDTree tree = new KDTree(nTargetSpots, targetSpots, targetSpots);
                    KNearestNeighborSearchOnKDTree search = new KNearestNeighborSearchOnKDTree(tree, nTargetSpots);
                    Iterator<Spot> sourceIt = this.this$0.spots.iterator(sourceFrame, true);
                    block3: while (sourceIt.hasNext()) {
                        double squareDist;
                        Spot source = sourceIt.next();
                        search.search((RealLocalizable)source);
                        int iNeighbor = -1;
                        while (++iNeighbor < nTargetSpots && !((squareDist = search.getSquareDistance(iNeighbor)) > maxDistSquare)) {
                            Spot target = (Spot)search.getSampler(iNeighbor).get();
                            if (this.this$0.graph.inDegreeOf((Object)target) > 0) continue;
                            SimpleDirectedWeightedGraph<Spot, DefaultWeightedEdge> simpleDirectedWeightedGraph = this.this$0.graph;
                            synchronized (simpleDirectedWeightedGraph) {
                                DefaultWeightedEdge edge = (DefaultWeightedEdge)this.this$0.graph.addEdge((Object)source, (Object)target);
                                this.this$0.graph.setEdgeWeight((Object)edge, squareDist);
                                continue block3;
                            }
                        }
                    }
                    this.this$0.logger.setProgress((double)progress.incrementAndGet() / (double)frames.size());
                    return null;
                }
            });
            futures.add(future);
        }
        this.logger.setStatus("Tracking...");
        this.logger.setProgress(0.0);
        try {
            for (Future future : futures) {
                future.get();
            }
            executors.shutdown();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            this.errorMessage = e.getMessage();
            boolean bl = false;
            return bl;
        }
        finally {
            this.logger.setProgress(1.0);
            this.logger.setStatus("");
            long end = System.currentTimeMillis();
            this.processingTime = end - start;
        }
        return true;
    }

    public SimpleWeightedGraph<Spot, DefaultWeightedEdge> getResult() {
        return GraphUtils.convertToSimpleWeightedGraph(this.graph);
    }

    public void reset() {
        this.graph = new SimpleDirectedWeightedGraph(DefaultWeightedEdge.class);
        Iterator<Spot> it = this.spots.iterator(true);
        while (it.hasNext()) {
            this.graph.addVertex((Object)it.next());
        }
    }

    public static boolean checkInput(Map<String, Object> settings, StringBuilder errrorHolder) {
        boolean ok = TMUtils.checkParameter(settings, "LINKING_MAX_DISTANCE", Double.class, errrorHolder);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("LINKING_MAX_DISTANCE");
        return ok &= TMUtils.checkMapKeys(settings, mandatoryKeys, null, errrorHolder);
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel(String reason) {
        this.isCanceled = true;
        this.cancelReason = reason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

