/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.viewer.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.event.AxisPositionEvent;
import net.imagej.display.event.DelayedPositionEvent;
import net.imagej.display.event.LUTsChangedEvent;
import net.imagej.ui.swing.SwingColorBar;
import net.imagej.ui.swing.viewer.image.JHotDrawImageCanvas;
import net.imagej.ui.swing.viewer.image.SwingImageDisplayViewer;
import net.imagej.ui.viewer.image.ImageDisplayPanel;
import net.imglib2.display.ColorTable;
import net.miginfocom.swing.MigLayout;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.plugin.Parameter;
import org.scijava.ui.awt.AWTInputEventDispatcher;
import org.scijava.ui.swing.StaticSwingUtils;
import org.scijava.ui.viewer.DisplayPanel;
import org.scijava.ui.viewer.DisplayWindow;

public class SwingImageDisplayPanel
extends JPanel
implements ImageDisplayPanel {
    private final SwingImageDisplayViewer displayViewer;
    private final ImageDisplay display;
    private final JLabel imageLabel;
    private final JPanel imagePane;
    private final SwingColorBar colorBar;
    private final JPanel sliderPanel;
    private final DisplayWindow window;
    private boolean initialScaleCalculated = false;
    private final Map<AxisType, JScrollBar> axisSliders = new ConcurrentHashMap<AxisType, JScrollBar>();
    private final Map<AxisType, JLabel> axisLabels = new HashMap<AxisType, JLabel>();
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private EventService eventService;

    public SwingImageDisplayPanel(SwingImageDisplayViewer displayViewer, DisplayWindow window) {
        this.displayViewer = displayViewer;
        this.window = window;
        this.display = displayViewer.getDisplay();
        this.imageLabel = new JLabel(" ");
        int prefHeight = this.imageLabel.getPreferredSize().height;
        this.imageLabel.setPreferredSize(new Dimension(0, prefHeight));
        this.imagePane = new JPanel();
        this.imagePane.setLayout((LayoutManager)new MigLayout("ins 0,wrap 1", "fill,grow", "[fill,grow|]"));
        this.imagePane.add(displayViewer.getCanvas());
        int colorBarHeight = 8;
        this.colorBar = new SwingColorBar(8);
        this.colorBar.setPreferredSize(new Dimension(0, 8));
        this.colorBar.setBorder(new LineBorder(Color.black));
        this.imagePane.add(this.colorBar);
        this.sliderPanel = new JPanel();
        this.sliderPanel.setLayout((LayoutManager)new MigLayout("fillx,wrap 2", "[right|fill,grow]"));
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.add((Component)this.imageLabel, "North");
        this.add((Component)this.imagePane, "Center");
        this.add((Component)this.sliderPanel, "South");
        window.setContent((DisplayPanel)this);
        this.display.getContext().inject((Object)this);
    }

    public void addEventDispatcher(AWTInputEventDispatcher dispatcher) {
        dispatcher.register((Component)this, true, false);
    }

    @Override
    public ImageDisplay getDisplay() {
        return this.display;
    }

    public DisplayWindow getWindow() {
        return this.window;
    }

    public void redoLayout() {
        int oldSliderHeight = this.sliderPanel.getPreferredSize().height;
        this.createSliders();
        this.updateColorBar(0);
        this.sliderPanel.setVisible(this.sliderPanel.getComponentCount() > 0);
        this.doInitialSizing();
        this.displayViewer.getCanvas().rebuild();
        this.revalidate();
        int newSliderHeight = this.sliderPanel.getPreferredSize().height;
        int heightIncrease = newSliderHeight - oldSliderHeight;
        if (heightIncrease > 0) {
            Component c = (Component)this.getWindow();
            Dimension size = c.getSize();
            size.height += heightIncrease;
            c.setSize(size);
        }
        this.repaint();
    }

    public void setLabel(String s) {
        this.imageLabel.setText(s);
    }

    public void redraw() {
        DatasetView view = this.imageDisplayService.getActiveDatasetView(this.display);
        if (view == null || view.getProjector() == null) {
            return;
        }
        view.getProjector().map();
        this.displayViewer.getCanvas().update();
    }

    @EventHandler
    protected void onEvent(AxisPositionEvent event) {
        if (event.getDisplay() != this.getDisplay()) {
            return;
        }
        AxisType axis = event.getAxis();
        this.updateAxis(axis);
        this.eventService.publish((SciJavaEvent)new DelayedPositionEvent(this.display, axis));
    }

    @EventHandler
    protected void onEvent(LUTsChangedEvent event) {
        if (!this.getDisplay().contains(event.getView())) {
            return;
        }
        int value = (int)this.display.getLongPosition(Axes.CHANNEL);
        this.updateColorBar(value);
    }

    private void createSliders() {
        for (final AxisType axis : this.axisSliders.keySet()) {
            if (this.display.dimensionIndex(axis) >= 0) continue;
            this.sliderPanel.remove(this.axisSliders.get(axis));
            this.sliderPanel.remove(this.axisLabels.get(axis));
            this.axisSliders.remove(axis);
            this.axisLabels.remove(axis);
        }
        for (int i = 0; i < this.display.numDimensions(); ++i) {
            AxisType axis;
            axis = ((CalibratedAxis)this.display.axis(i)).type();
            if (axis.isXY()) continue;
            int min = (int)this.display.min(i);
            int max = (int)this.display.max(i) + 1;
            if (max - min <= 1) continue;
            int value = (int)this.display.getLongPosition(axis);
            JScrollBar axisSlider = this.axisSliders.get(axis);
            if (axisSlider == null) {
                JLabel label = new JLabel(axis.getLabel());
                label.setHorizontalAlignment(4);
                this.axisLabels.put(axis, label);
                final JScrollBar slider = new JScrollBar(0, value, 1, min, max);
                slider.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent e) {
                        SwingImageDisplayPanel.this.display.setPosition(slider.getValue(), axis);
                    }
                });
                this.axisSliders.put(axis, slider);
                this.sliderPanel.add(label);
                this.sliderPanel.add(slider);
                continue;
            }
            if (axisSlider.getMinimum() != min || axisSlider.getMaximum() != max) {
                axisSlider.setValues(value, 1, min, max);
                continue;
            }
            if (axisSlider.getValue() == value) continue;
            axisSlider.setValue(value);
        }
    }

    private void updateColorBar(int c) {
        DatasetView view = this.imageDisplayService.getActiveDatasetView(this.display);
        if (view == null) {
            return;
        }
        List<ColorTable> colorTables = view.getColorTables();
        if (c >= colorTables.size()) {
            return;
        }
        ColorTable lut = colorTables.get(c);
        this.colorBar.setColorTable(lut);
        this.colorBar.repaint();
    }

    private void doInitialSizing() {
        double scale = this.findFullyVisibleScale();
        double zoomLevel = this.display.getCanvas().getBestZoomLevel(scale);
        ImageCanvas canvas = this.displayViewer.getDisplay().getCanvas();
        canvas.setZoomAndCenter(zoomLevel);
        if (!this.initialScaleCalculated) {
            canvas.setInitialScale(canvas.getZoomFactor());
            this.initialScaleCalculated = true;
        }
    }

    private void updateAxis(AxisType axis) {
        JScrollBar scrollBar;
        int value = (int)this.display.getLongPosition(axis);
        if (axis == Axes.CHANNEL) {
            this.updateColorBar(value);
        }
        if ((scrollBar = this.axisSliders.get(axis)) != null) {
            scrollBar.setValue(value);
        }
        this.getDisplay().update();
    }

    private double findFullyVisibleScale() {
        JHotDrawImageCanvas canvas = this.displayViewer.getCanvas();
        Dimension canvasSize = canvas.getPreferredSize();
        Rectangle deskBounds = StaticSwingUtils.getWorkSpaceBounds();
        int labelHeight = this.imageLabel.getPreferredSize().height;
        int sliderHeight = this.sliderPanel.getPreferredSize().height;
        boolean extraSpace = false;
        int maxViewHeight = deskBounds.height - labelHeight - sliderHeight - 0;
        int maxViewWidth = deskBounds.width - 0;
        if (canvasSize.width > maxViewWidth || canvasSize.height > maxViewHeight) {
            double canvasAspect = 1.0 * (double)canvasSize.width / (double)canvasSize.height;
            double viewAspect = 1.0 * (double)maxViewWidth / (double)maxViewHeight;
            if (canvasAspect < viewAspect) {
                return 1.0 * (double)maxViewHeight / (double)canvasSize.height;
            }
            return 1.0 * (double)maxViewWidth / (double)canvasSize.width;
        }
        return 1.0;
    }
}

