/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.file;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;

public class SaveFileAction
extends AbstractViewAction {
    public static final String ID = "file.save";
    private boolean saveAs;
    private Component oldFocusOwner;

    public SaveFileAction(Application app, @Nullable View view) {
        this(app, view, false);
    }

    public SaveFileAction(Application app, @Nullable View view, boolean saveAs) {
        super(app, view);
        this.saveAs = saveAs;
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    protected URIChooser getChooser(View view) {
        URIChooser chsr = (URIChooser)view.getComponent().getClientProperty("saveChooser");
        if (chsr == null) {
            chsr = this.getApplication().getModel().createSaveChooser(this.getApplication(), view);
            view.getComponent().putClientProperty("saveChooser", chsr);
        }
        return chsr;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final View view = this.getActiveView();
        if (view == null) {
            return;
        }
        if (view.isEnabled()) {
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(view.getComponent()).getFocusOwner();
            view.setEnabled(false);
            if (!this.saveAs && view.getURI() != null && view.canSaveTo(view.getURI())) {
                this.saveViewToURI(view, view.getURI(), null);
            } else {
                URIChooser fileChooser = this.getChooser(view);
                JSheet.showSaveSheet(fileChooser, (Component)view.getComponent(), new SheetListener(){

                    @Override
                    public void optionSelected(SheetEvent evt) {
                        if (evt.getOption() == 0) {
                            URI uri = evt.getChooser() instanceof JFileURIChooser && evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()).toURI() : evt.getChooser().getSelectedURI();
                            SaveFileAction.this.saveViewToURI(view, uri, evt.getChooser());
                        } else {
                            view.setEnabled(true);
                            if (SaveFileAction.this.oldFocusOwner != null) {
                                SaveFileAction.this.oldFocusOwner.requestFocus();
                            }
                        }
                    }
                });
            }
        }
    }

    protected void saveViewToURI(final View view, final URI file, final @Nullable URIChooser chooser) {
        view.execute(new Worker(){

            protected Object construct() throws IOException {
                view.write(file, chooser);
                return null;
            }

            protected void done(Object value) {
                view.setURI(file);
                view.markChangesAsSaved();
                int multiOpenId = 1;
                for (View p : view.getApplication().views()) {
                    if (p == view || p.getURI() == null || !p.getURI().equals(file)) continue;
                    multiOpenId = Math.max(multiOpenId, p.getMultipleOpenId() + 1);
                }
                SaveFileAction.this.getApplication().addRecentURI(file);
                view.setMultipleOpenId(multiOpenId);
            }

            @Override
            protected void failed(Throwable value) {
                value.printStackTrace();
                String message = value.getMessage() != null ? value.getMessage() : value.toString();
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                JSheet.showMessageSheet((Component)SaveFileAction.this.getActiveView().getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.save.couldntSave.message", URIUtil.getName(file)) + "</b><p>" + (message == null ? "" : message)), 0);
            }

            @Override
            protected void finished() {
                view.setEnabled(true);
                SwingUtilities.getWindowAncestor(view.getComponent()).toFront();
                if (SaveFileAction.this.oldFocusOwner != null) {
                    SaveFileAction.this.oldFocusOwner.requestFocus();
                }
            }
        });
    }
}

