/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import org.jhotdraw.gui.plaf.palette.PaletteToolBarUI;

public class PaletteToolBarBorder
extends AbstractBorder
implements SwingConstants {
    private static final float[] enabledStops = new float[]{0.0f, 0.5f, 1.0f};
    private static final Color[] enabledStopColors = new Color[]{new Color(0xF8F8F8), new Color(0xC8C8C8), new Color(0xF8F8F8)};
    private static final float[] selectedStops = new float[]{0.0f, 0.1f, 0.9f, 1.0f};
    private static final Color[] selectedStopColors = new Color[]{new Color(0x666666), new Color(0xCCCCCC), new Color(0x999999), new Color(0xB1B1B1)};
    private static final Color bright = new Color(0x999999, true);
    private static final Color dark = new Color(0x8C8C8C);
    private static final Color divider = new Color(0x9F9F9F);

    @Override
    public void paintBorder(Component component, Graphics gr, int x, int y, int w, int h) {
        JToolBar c;
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (component instanceof JToolBar && ((JToolBar)component).getUI() instanceof PaletteToolBarUI && (c = (JToolBar)component).isFloatable()) {
            int hx = x;
            int hy = y;
            int hw = w;
            int hh = h;
            if (c.getOrientation() == 0) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    int barW = 18;
                    int barH = h;
                    int barX = 0;
                    int barY = 0;
                    int borderColor = -5921371;
                    float[] stops = enabledStops;
                    Color[] stopColors = enabledStopColors;
                    g.setColor(new Color(borderColor, true));
                    g.drawRect(barX, barY, barW - 1, barH - 1);
                    LinearGradientPaint lgp = new LinearGradientPaint(new Point2D.Float(1.0f, 1.0f), new Point2D.Float(19.0f, 1.0f), stops, stopColors, MultipleGradientPaint.CycleMethod.REPEAT);
                    g.setPaint(lgp);
                    g.fillRect(barX + 1, barX + 1, barW - 2, barH - 2);
                    Icon icon = (Icon)c.getClientProperty("Palette.ToolBar.icon");
                    if (icon != null) {
                        icon.paintIcon(component, gr, barX + (barW - icon.getIconWidth()) / 2, barY + barH - 4 - icon.getIconHeight());
                    }
                    int textIconGap = c.getClientProperty("Palette.ToolBar.icon") instanceof Integer ? (Integer)c.getClientProperty("Palette.ToolBar.icon") : 2;
                    String theTitle = c.getName();
                    if (theTitle != null) {
                        FontMetrics fm = g.getFontMetrics();
                        int titleW = barH - 8;
                        if (icon != null) {
                            titleW -= icon.getIconHeight() + textIconGap;
                        }
                        theTitle = this.clippedText(theTitle, fm, titleW);
                        AffineTransform savedTransform = g.getTransform();
                        AffineTransform t = g.getTransform();
                        t.rotate(-1.5707963267948966, barX + 2 + fm.getAscent(), titleW + 4);
                        g.setTransform(t);
                        g.setColor(Color.black);
                        g.drawString(theTitle, barX + 2 + fm.getAscent(), titleW + 4);
                        g.setTransform(savedTransform);
                    }
                } else {
                    g.setColor(bright);
                    g.fillRect(hw - hx - 3, hy + 2, 1, hh - 4);
                    g.fillRect(hw - hx - 5, hy + 2, 1, hh - 4);
                    g.setColor(dark);
                    g.fillRect(hw - hx - 2, hy + 2, 1, hh - 4);
                    g.fillRect(hw - hx - 6, hy + 2, 1, hh - 4);
                }
            } else {
                g.setColor(bright);
                g.fillRect(hx + 2, hy + 2, hw - 4, 1);
                g.fillRect(hx + 2, hy + 5, hw - 4, 1);
                g.setColor(dark);
                g.fillRect(hx + 2, hy + 3, hw - 4, 1);
                g.fillRect(hx + 2, hy + 6, hw - 4, 1);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getDragInsets(Component c) {
        return new Insets(0, 18, 0, 0);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets newInsets) {
        JComponent c;
        if (newInsets == null) {
            newInsets = new Insets(0, 0, 0, 0);
        }
        if ((c = (JComponent)component).getClientProperty("Palette.ToolBar.insetsOverride") instanceof Insets) {
            Insets override = (Insets)c.getClientProperty("Palette.ToolBar.insetsOverride");
            newInsets.top = override.top;
            newInsets.left = override.left;
            newInsets.bottom = override.bottom;
            newInsets.right = override.right;
            return newInsets;
        }
        newInsets.top = 0;
        newInsets.left = 18;
        newInsets.bottom = 0;
        newInsets.right = 0;
        return newInsets;
    }

    private String clippedText(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || text.equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, text);
        String clipString = "\u2026";
        if (textWidth > availTextWidth) {
            int nChars;
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            for (nChars = 0; nChars < text.length() && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
            }
            text = text.substring(0, nChars) + clipString;
        }
        return text;
    }

    public static class UIResource
    extends PaletteToolBarBorder
    implements javax.swing.plaf.UIResource {
    }
}

