/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.AbstractLanguageSupport;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.scijava.plugin.Plugin;
import org.scijava.plugins.scripteditor.jython.JythonAutoCompletion;
import org.scijava.plugins.scripteditor.jython.JythonAutocompletionProvider;
import org.scijava.plugins.scripteditor.jython.JythonImportFormat;
import org.scijava.ui.swing.script.LanguageSupportPlugin;

@Plugin(type=LanguageSupportPlugin.class, priority=100.0)
public class JythonLanguageSupportPlugin
extends AbstractLanguageSupport
implements LanguageSupportPlugin {
    private AutoCompletion ac;
    private RSyntaxTextArea text_area;

    public JythonLanguageSupportPlugin() {
        this.setAutoCompleteEnabled(true);
        this.setParameterAssistanceEnabled(true);
        this.setShowDescWindow(true);
    }

    public String getLanguageName() {
        return "Python (Jython)";
    }

    public void install(RSyntaxTextArea textArea) {
        this.text_area = textArea;
        this.ac = this.createAutoCompletion(null);
        this.ac.setParameterAssistanceEnabled(true);
        this.ac.install((JTextComponent)textArea);
        super.installImpl(textArea, this.ac);
    }

    public void uninstall(RSyntaxTextArea textArea) {
        if (textArea == this.text_area) {
            super.uninstallImpl(textArea);
        }
    }

    protected AutoCompletion createAutoCompletion(CompletionProvider p) {
        return new JythonAutoCompletion((CompletionProvider)new JythonAutocompletionProvider(this.text_area, new JythonImportFormat()));
    }
}

