/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.data;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.network.node.ClusterNode;
import java.io.Serializable;

public abstract class DataChunk<T>
implements Serializable {
    private static final long serialVersionUID = 3307652134796685516L;
    private long lastOn = -1L;
    private long lastTime = -1L;
    private long id;
    private final int mark;

    public DataChunk() {
        this.id = FijiArchipelago.getUniqueID();
        this.mark = 0;
    }

    public DataChunk(DataChunk chunk) {
        this.id = chunk.id;
        this.mark = chunk.mark + 1;
    }

    public long getID() {
        return this.id;
    }

    public void setProcessingOn(ClusterNode node) {
        this.lastOn = node.getID();
        this.lastTime = System.currentTimeMillis();
    }

    public long lastProcessedOn() {
        return this.lastOn;
    }

    public int getMark() {
        return this.mark;
    }

    public abstract T getData();
}

