/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.BoundingPolytope;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.GeometryRetained;
import org.scijava.java3d.IndexedGeometryArrayRetained;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.PickBounds;
import org.scijava.java3d.PickCone;
import org.scijava.java3d.PickCylinder;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.PickRay;
import org.scijava.java3d.PickSegment;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.Transform3D;
import org.scijava.vecmath.Point3d;

class IndexedTriangleArrayRetained
extends IndexedGeometryArrayRetained {
    IndexedTriangleArrayRetained() {
        this.geoType = 9;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Point3d[] pnts = new Point3d[3];
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int[] vtxIndexArr = new int[3];
        int i = this.initialIndexIndex;
        int loopStopIndex = this.initialIndexIndex + this.validIndexCount;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        pnts[2] = new Point3d();
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i < loopStopIndex) {
                    for (int j = 0; j < 3; ++j) {
                        vtxIndexArr[j] = this.indexCoord[i];
                        this.getVertexData(this.indexCoord[i++], pnts[j]);
                    }
                    if (!this.intersectRay(pnts, pickRay, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                while (i < loopStopIndex) {
                    for (int j = 0; j < 3; ++j) {
                        vtxIndexArr[j] = this.indexCoord[i];
                        this.getVertexData(this.indexCoord[i++], pnts[j]);
                    }
                    if (!this.intersectSegment(pnts, pickSegment.start, pickSegment.end, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 6: {
                BoundingBox bbox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (i < loopStopIndex) {
                    for (int j = 0; j < 3; ++j) {
                        vtxIndexArr[j] = this.indexCoord[i];
                        this.getVertexData(this.indexCoord[i++], pnts[j]);
                    }
                    if (!this.intersectBoundingBox(pnts, bbox, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (i < loopStopIndex) {
                    for (int j = 0; j < 3; ++j) {
                        vtxIndexArr[j] = this.indexCoord[i];
                        this.getVertexData(this.indexCoord[i++], pnts[j]);
                    }
                    if (!this.intersectBoundingSphere(pnts, bsphere, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (i < loopStopIndex) {
                    for (int j = 0; j < 3; ++j) {
                        vtxIndexArr[j] = this.indexCoord[i];
                        this.getVertexData(this.indexCoord[i++], pnts[j]);
                    }
                    if (!this.intersectBoundingPolytope(pnts, bpolytope, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i < loopStopIndex) {
                    for (int j = 0; j < 3; ++j) {
                        vtxIndexArr[j] = this.indexCoord[i];
                        this.getVertexData(this.indexCoord[i++], pnts[j]);
                    }
                    if (!this.intersectCylinder(pnts, pickCylinder, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i < loopStopIndex) {
                    for (int j = 0; j < 3; ++j) {
                        vtxIndexArr[j] = this.indexCoord[i];
                        this.getVertexData(this.indexCoord[i++], pnts[j]);
                    }
                    if (!this.intersectCone(pnts, pickCone, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Point3d[] points = new Point3d[3];
        double[] dist = new double[1];
        int i = this.initialIndexIndex;
        int loopStopIndex = this.initialIndexIndex + this.validIndexCount;
        points[0] = new Point3d();
        points[1] = new Point3d();
        points[2] = new Point3d();
        switch (pnts.length) {
            case 3: {
                while (i < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i++], points[0]);
                    this.getVertexData(this.indexCoord[i++], points[1]);
                    this.getVertexData(this.indexCoord[i++], points[2]);
                    if (!this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2])) continue;
                    return true;
                }
                break;
            }
            case 4: {
                while (i < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i++], points[0]);
                    this.getVertexData(this.indexCoord[i++], points[1]);
                    this.getVertexData(this.indexCoord[i++], points[2]);
                    if (!this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2]) && !this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[2], pnts[3])) continue;
                    return true;
                }
                break;
            }
            case 2: {
                while (i < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i++], points[0]);
                    this.getVertexData(this.indexCoord[i++], points[1]);
                    this.getVertexData(this.indexCoord[i++], points[2]);
                    if (!this.intersectSegment(points, pnts[0], pnts[1], dist, null)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                while (i < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i++], points[0]);
                    this.getVertexData(this.indexCoord[i++], points[1]);
                    this.getVertexData(this.indexCoord[i++], points[2]);
                    if (!this.intersectTriPnt(points[0], points[1], points[2], pnts[0])) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        Point3d[] pnts = new Point3d[3];
        int i = this.initialIndexIndex;
        int loopStopIndex = this.initialIndexIndex + this.validIndexCount;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        pnts[2] = new Point3d();
        while (i < loopStopIndex) {
            this.getVertexData(this.indexCoord[i++], pnts[0]);
            this.getVertexData(this.indexCoord[i++], pnts[1]);
            this.getVertexData(this.indexCoord[i++], pnts[2]);
            thisToOtherVworld.transform(pnts[0]);
            thisToOtherVworld.transform(pnts[1]);
            thisToOtherVworld.transform(pnts[2]);
            if (!geom.intersect(pnts)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        Point3d[] pnts = new Point3d[3];
        int i = this.initialIndexIndex;
        int loopStopIndex = this.initialIndexIndex + this.validIndexCount;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        pnts[2] = new Point3d();
        switch (targetBound.getPickType()) {
            case 6: {
                BoundingBox box = (BoundingBox)targetBound;
                while (i < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i++], pnts[0]);
                    this.getVertexData(this.indexCoord[i++], pnts[1]);
                    this.getVertexData(this.indexCoord[i++], pnts[2]);
                    if (!this.intersectBoundingBox(pnts, box, null, null)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)targetBound;
                while (i < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i++], pnts[0]);
                    this.getVertexData(this.indexCoord[i++], pnts[1]);
                    this.getVertexData(this.indexCoord[i++], pnts[1]);
                    if (!this.intersectBoundingSphere(pnts, bsphere, null, null)) continue;
                    return true;
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)targetBound;
                while (i < loopStopIndex) {
                    this.getVertexData(this.indexCoord[i++], pnts[0]);
                    this.getVertexData(this.indexCoord[i++], pnts[1]);
                    this.getVertexData(this.indexCoord[i++], pnts[2]);
                    if (!this.intersectBoundingPolytope(pnts, bpolytope, null, null)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + targetBound);
            }
        }
        return false;
    }

    @Override
    int getClassType() {
        return 3;
    }
}

