/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.write.NetcdfFormatWriter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

abstract class WriterCFPointAbstract
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(WriterCFPointAbstract.class);
    static final String recordName = "obs";
    static final String recordDimName = "obs";
    static final String latName = "latitude";
    static final String lonName = "longitude";
    static final String altName = "altitude";
    static final String timeName = "time";
    static final String stationStructName = "station";
    static final String stationDimName = "station";
    static final String stationIdName = "station_id";
    static final String stationAltName = "stationAltitude";
    static final String descName = "station_description";
    static final String wmoName = "wmo_id";
    static final String stationIndexName = "stationIndex";
    static final String profileStructName = "profile";
    static final String profileDimName = "profile";
    static final String profileIdName = "profileId";
    static final String numberOfObsName = "nobs";
    static final String profileTimeName = "profileTime";
    static final String trajStructName = "trajectory";
    static final String trajDimName = "traj";
    static final String trajIdName = "trajectoryId";
    static final int idMissingValue = -9999;
    private static final int defaultStringLength = 20;
    private static final List<String> reservedGlobalAtts = Arrays.asList("Conventions", "geospatial_lat_min", "geospatial_lat_max", "geospatial_lon_min", "geospatial_lon_max", "time_coverage_start", "time_coverage_end", "_CoordSysBuilder", "CF:featureType", "CF:feature_type");
    private static final List<String> reservedVariableAtts = Arrays.asList("sample_dimension", "instance_dimension");
    private final List<VariableSimpleIF> dataVars;
    final CalendarDateUnit timeUnit;
    @Nullable
    final String altUnits;
    private final CFPointWriterConfig config;
    private final boolean isExtendedModel;
    private final Map<String, Dimension> newDimensions = new HashMap<String, Dimension>();
    final NetcdfFormatWriter.Builder writerb;
    private NetcdfFormatWriter writer;
    int nfeatures;
    int id_strlen;
    boolean useAlt = true;
    String altitudeCoordinateName = "altitude";
    Structure record;
    private Dimension recordDim;
    HashSet<String> dataMap = new HashSet();
    private List<Variable> extra = new ArrayList<Variable>();
    LatLonRect llbb;
    private CalendarDate minDate;
    private CalendarDate maxDate;

    WriterCFPointAbstract(String fileOut, AttributeContainer atts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, @Nullable String altUnits, CFPointWriterConfig config) {
        this.dataVars = dataVars;
        this.timeUnit = timeUnit;
        this.altUnits = altUnits;
        this.config = config;
        this.isExtendedModel = config.getVersion().isExtendedModel();
        this.writerb = NetcdfFormatWriter.builder().setNewFile(true).setFormat(config.getFormat()).setLocation(fileOut).setChunker(config.getChunking()).setFill(false);
        this.addGlobalAtts(atts);
        this.addNetcdf3UnknownAtts(config.isNoTimeCoverage());
    }

    private void addGlobalAtts(AttributeContainer atts) {
        this.writerb.addAttribute(new Attribute("Conventions", this.isExtendedModel ? "CDM-Extended-CF" : "CF-1.9"));
        this.writerb.addAttribute(new Attribute("history", "Written by CFPointWriter"));
        for (Attribute att : atts) {
            if (reservedGlobalAtts.contains(att.getShortName())) continue;
            this.writerb.addAttribute(att);
        }
    }

    private void addNetcdf3UnknownAtts(boolean noTimeCoverage) {
        if (!noTimeCoverage) {
            CalendarDate now = CalendarDate.of(new Date());
            this.writerb.addAttribute(new Attribute("time_coverage_start", CalendarDateFormatter.toDateTimeStringISO(now)));
            this.writerb.addAttribute(new Attribute("time_coverage_end", CalendarDateFormatter.toDateTimeStringISO(now)));
        }
        this.writerb.addAttribute(new Attribute("geospatial_lat_min", 0.0));
        this.writerb.addAttribute(new Attribute("geospatial_lat_max", 0.0));
        this.writerb.addAttribute(new Attribute("geospatial_lon_min", 0.0));
        this.writerb.addAttribute(new Attribute("geospatial_lon_max", 0.0));
    }

    void setFeatureAuxInfo(int nfeatures, int id_strlen) {
        this.nfeatures = nfeatures;
        this.id_strlen = id_strlen;
    }

    void setExtraVariables(List<Variable> extra) {
        this.extra = extra;
        if (extra != null) {
            for (Variable v : extra) {
                CoordinateAxis axis;
                if (!(v instanceof CoordinateAxis) || (axis = (CoordinateAxis)v).getAxisType() != AxisType.Height) continue;
                this.useAlt = false;
                this.altitudeCoordinateName = v.getFullName();
            }
        }
    }

    @Nullable
    VariableSimpleIF findDataVar(String name) {
        return this.dataVars.stream().filter(v -> v.getShortName().equals(name)).findFirst().orElse(null);
    }

    abstract void makeFeatureVariables(List<StructureData> var1, boolean var2);

    void makeMiddleVariables(List<StructureData> middleData, boolean isExtended) {
    }

    protected void writeHeader(List<VariableSimpleIF> obsCoords, Iterable<? extends PointFeatureCollection> stationFeatures, List<StructureData> featureDataStruct, @Nullable List<StructureData> middleDataStruct) throws IOException {
        this.recordDim = Dimension.builder().setName("obs").setIsUnlimited(true).build();
        this.writerb.addDimension(this.recordDim);
        this.addExtraVariables();
        if (featureDataStruct != null) {
            this.makeFeatureVariables(featureDataStruct, this.isExtendedModel);
        }
        if (middleDataStruct != null) {
            this.makeMiddleVariables(middleDataStruct, this.isExtendedModel);
        }
        Structure.Builder recordb = null;
        if (this.isExtendedModel) {
            recordb = this.writerb.addStructure("obs", "obs");
            this.addCoordinatesExtended(recordb, obsCoords);
        } else {
            this.addCoordinatesClassic(this.recordDim, obsCoords, this.dataMap);
        }
        for (PointFeatureCollection pointFeatureCollection : stationFeatures) {
            PeekingIterator iter = Iterators.peekingIterator(pointFeatureCollection.iterator());
            if (!iter.hasNext()) continue;
            PointFeature pointFeat = (PointFeature)iter.peek();
            StructureData obsData = pointFeat.getFeatureData();
            Formatter coordNames = new Formatter().format("%s %s %s", pointFeatureCollection.getTimeName(), latName, lonName);
            if (!Double.isNaN(pointFeat.getLocation().getAltitude())) {
                coordNames.format(" %s", this.altitudeCoordinateName);
            }
            if (this.isExtendedModel) {
                this.addDataVariablesExtended(recordb, obsData, coordNames.toString());
                continue;
            }
            this.addDataVariablesClassic(this.recordDim, obsData, this.dataMap, coordNames.toString());
        }
        this.writer = this.writerb.build();
        this.writeExtraVariables();
        this.finishBuilding();
    }

    private void addExtraVariables() {
        if (this.extra == null) {
            return;
        }
        this.addDimensionsClassic(this.extra);
        for (VariableSimpleIF variableSimpleIF : this.extra) {
            List<Dimension> dims = this.makeDimensionList(variableSimpleIF.getDimensions());
            this.writerb.addVariable(variableSimpleIF.getShortName(), variableSimpleIF.getDataType(), dims).addAttributes(variableSimpleIF.attributes());
        }
    }

    void addCoordinatesClassic(Dimension recordDim, List<VariableSimpleIF> coords, Set<String> varSet) {
        this.addDimensionsClassic(coords);
        for (VariableSimpleIF oldVar : coords) {
            Object newVar;
            List<Dimension> dims = this.makeDimensionList(oldVar.getDimensions());
            dims.add(0, recordDim);
            if (oldVar.getDataType() == DataType.STRING && !this.isExtendedModel) {
                String name = oldVar.getShortName();
                Dimension strlen = new Dimension(name + "_strlen", 20);
                newVar = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(name)).setDataType(DataType.CHAR)).setDimensions(dims)).addDimension(strlen);
                this.writerb.getRootGroup().addDimensionIfNotExists(strlen);
            } else {
                newVar = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(oldVar.getShortName())).setDataType(oldVar.getDataType())).setDimensions(dims);
            }
            if (this.writerb.getRootGroup().replaceVariable((Variable.Builder<?>)newVar)) {
                logger.info("Variable was already added =" + oldVar.getShortName());
            }
            ((Variable.Builder)newVar).addAttributes(oldVar.attributes());
            varSet.add(oldVar.getShortName());
        }
    }

    void addCoordinatesExtended(Structure.Builder<?> parent, List<VariableSimpleIF> coords) {
        for (VariableSimpleIF vs : coords) {
            String dims = Dimensions.makeDimensionsString(vs.getDimensions());
            Object member = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(vs.getShortName())).setDataType(vs.getDataType())).setParentGroupBuilder(this.writerb.getRootGroup())).setDimensionsByName(dims);
            if (parent.replaceMemberVariable((Variable.Builder<?>)member)) {
                logger.warn("Variable already exists =" + vs.getShortName());
            }
            ((Variable.Builder)member).addAttributes(vs.attributes());
        }
    }

    private void addDataVariablesClassic(Dimension recordDim, StructureData stnData, HashSet<String> varSet, String coordVars) {
        this.addDimensionsClassic(this.dataVars);
        for (StructureMembers.Member m : stnData.getMembers()) {
            Object newVar;
            VariableSimpleIF oldVar = this.findDataVar(m.getName());
            if (oldVar == null) continue;
            List<Dimension> dims = this.makeDimensionList(oldVar.getDimensions());
            dims.add(0, recordDim);
            if (oldVar.getDataType() == DataType.STRING && !this.isExtendedModel) {
                String name = oldVar.getShortName();
                Dimension strlen = new Dimension(name + "_strlen", 20);
                newVar = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(name)).setDataType(DataType.CHAR)).setDimensions(dims)).addDimension(strlen);
                this.writerb.getRootGroup().addDimensionIfNotExists(strlen);
            } else {
                newVar = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(oldVar.getShortName())).setDataType(oldVar.getDataType())).setDimensions(dims);
            }
            if (this.writerb.getRootGroup().replaceVariable((Variable.Builder<?>)newVar)) {
                logger.warn("Variable was already added =" + oldVar.getShortName());
            }
            for (Attribute att : oldVar.attributes()) {
                String attName = att.getShortName();
                if (reservedVariableAtts.contains(attName) || attName.startsWith("_Coordinate")) continue;
                ((Variable.Builder)newVar).addAttribute(att);
            }
            ((Variable.Builder)newVar).addAttribute(new Attribute("coordinates", coordVars));
            varSet.add(oldVar.getShortName());
        }
    }

    private void addDataVariablesExtended(Structure.Builder<?> recordb, StructureData obsData, String coordNames) {
        for (StructureMembers.Member m : obsData.getMembers()) {
            VariableSimpleIF oldVar = this.findDataVar(m.getName());
            if (oldVar == null || recordb.findMemberVariable(m.getName()).isPresent()) continue;
            StringBuilder dimNames = new StringBuilder();
            for (Dimension d : oldVar.getDimensions()) {
                if (d.isUnlimited() || d.getShortName() != null && d.getShortName().equals("obs")) continue;
                dimNames.append(" ").append(d.getLength());
            }
            Object newVar = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(oldVar.getShortName())).setDataType(oldVar.getDataType())).setParentGroupBuilder(this.writerb.getRootGroup())).setDimensionsByName(dimNames.toString());
            recordb.addMemberVariable((Variable.Builder<?>)newVar);
            for (Attribute att : oldVar.attributes()) {
                String attName = att.getShortName();
                if (reservedVariableAtts.contains(attName) || attName.startsWith("_Coordinate")) continue;
                ((Variable.Builder)newVar).addAttribute(att);
            }
            ((Variable.Builder)newVar).addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    private void addDimensionsClassic(List<? extends VariableSimpleIF> vars) {
        HashSet<Dimension> oldDims = new HashSet<Dimension>(20);
        for (VariableSimpleIF variableSimpleIF : vars) {
            List<Dimension> dims = variableSimpleIF.getDimensions();
            oldDims.addAll(dims);
        }
        for (Dimension dimension : oldDims) {
            String dimName = this.getSharedDimName(dimension);
            if (this.writerb.getRootGroup().findDimension(dimName).isPresent()) continue;
            Dimension newDim = Dimension.builder(dimName, dimension.getLength()).setIsVariableLength(dimension.isVariableLength()).build();
            this.writerb.addDimension(newDim);
            this.newDimensions.put(dimName, newDim);
        }
    }

    private List<Dimension> makeDimensionList(List<Dimension> oldDims) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        for (Dimension dim : oldDims) {
            Dimension newDim = this.newDimensions.get(this.getSharedDimName(dim));
            assert (newDim != null) : "Oops, we screwed up: dimMap doesn't contain " + this.getSharedDimName(dim);
            result.add(newDim);
        }
        return result;
    }

    private String getSharedDimName(Dimension dim) {
        if (dim.getShortName() == null) {
            return "len" + dim.getLength();
        }
        return dim.getShortName();
    }

    void finishBuilding() throws IOException {
        this.record = this.findStructure("obs");
    }

    @Nullable
    Structure findStructure(String name) {
        NetcdfFile outputFile = this.writer.getOutputFile();
        Variable s = outputFile.getVariables().stream().filter(v -> v.getShortName().equals(name)).findFirst().orElse(null);
        return s instanceof Structure ? (Structure)s : null;
    }

    @Nullable
    private Variable findVariable(String name) {
        NetcdfFile outputFile = this.writer.getOutputFile();
        return outputFile.getVariables().stream().filter(v -> v.getShortName().equals(name)).findFirst().orElse(null);
    }

    private void writeExtraVariables() throws IOException {
        if (this.extra == null) {
            return;
        }
        for (Variable v : this.extra) {
            NetcdfFile ncfile = this.writer.getOutputFile();
            Variable mv = ncfile.findVariable(v.getFullName());
            if (mv == null) continue;
            try {
                this.writer.write(mv, v.read());
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
    }

    int writeStructureData(int recno, Structure s, StructureData sdata, Set<String> varSet) throws IOException {
        int[] origin = new int[]{recno};
        try {
            if (this.isExtendedModel) {
                if (s.isUnlimited()) {
                    return this.writer.appendStructureData(s, sdata);
                }
                ArrayStructureW as = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
                as.setStructureData(sdata, 0);
                this.writer.write(s, origin, (Array)as);
                return recno + 1;
            }
            this.writeStructureDataClassic(origin, sdata, varSet);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        return recno + 1;
    }

    private void writeStructureDataClassic(int[] origin, StructureData sdata, Set<String> varSet) throws IOException, InvalidRangeException {
        for (StructureMembers.Member m : sdata.getMembers()) {
            Variable mv = this.findVariable(m.getName());
            if (!varSet.contains(m.getName()) || mv == null) continue;
            Array org = sdata.getArray(m);
            if (m.getDataType() == DataType.STRING) {
                int strlen = mv.getDimension(mv.getDimensions().size() - 1).getLength();
                org = ArrayChar.makeFromStringArray((ArrayObject)org, strlen);
            }
            Array orgPlus1 = Array.makeArrayRankPlusOne(org);
            int[] useOrigin = origin;
            if (org.getRank() > 0) {
                useOrigin = new int[org.getRank() + 1];
                useOrigin[0] = origin[0];
            }
            this.writer.write(mv, useOrigin, orgPlus1);
        }
    }

    void trackBB(LatLonPoint loc, CalendarDate obsDate) {
        if (loc != null) {
            this.llbb = this.llbb == null ? new LatLonRect(loc, 0.001, 0.001) : LatLonRect.extend(this.llbb, loc);
        }
        if (this.minDate == null || this.minDate.isAfter(obsDate)) {
            this.minDate = obsDate;
        }
        if (this.maxDate == null || this.maxDate.isBefore(obsDate)) {
            this.maxDate = obsDate;
        }
    }

    public void finish() throws IOException {
        if (this.llbb != null) {
            this.writer.updateAttribute(null, new Attribute("geospatial_lat_min", this.llbb.getLowerLeftPoint().getLatitude()));
            this.writer.updateAttribute(null, new Attribute("geospatial_lat_max", this.llbb.getUpperRightPoint().getLatitude()));
            this.writer.updateAttribute(null, new Attribute("geospatial_lon_min", this.llbb.getLowerLeftPoint().getLongitude()));
            this.writer.updateAttribute(null, new Attribute("geospatial_lon_max", this.llbb.getUpperRightPoint().getLongitude()));
        }
        if (!this.config.isNoTimeCoverage()) {
            if (this.minDate == null) {
                this.minDate = CalendarDate.present();
            }
            if (this.maxDate == null) {
                this.maxDate = CalendarDate.present();
            }
            this.writer.updateAttribute(null, new Attribute("time_coverage_start", CalendarDateFormatter.toDateTimeStringISO(this.minDate)));
            this.writer.updateAttribute(null, new Attribute("time_coverage_end", CalendarDateFormatter.toDateTimeStringISO(this.maxDate)));
        }
        this.writer.close();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

