/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jpedal.external.ImageHandler;
import org.jpedal.objects.GraphicsState;

public class ExampleImageHandler
implements ImageHandler {
    public boolean alwaysIgnoreGenericHandler() {
        return true;
    }

    public boolean imageHasBeenScaled() {
        return true;
    }

    public BufferedImage processImageData(Map map, GraphicsState graphicsState) {
        BufferedImage bufferedImage = null;
        int n = (int)graphicsState.CTM[0][0];
        int n2 = (int)graphicsState.CTM[1][1];
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setPaint(Color.RED);
        graphics2D.drawLine(0, 0, n, n2);
        graphics2D.drawLine(0, n2, n, 0);
        graphics2D.drawRect(0, 0, n - 1, n2 - 1);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(0.0, -n2);
        affineTransform.scale(1.0, -1.0);
        graphics2D.setTransform(affineTransform);
        String string = "Image removed";
        int n3 = n / string.length();
        Font font = new Font("serif", 0, n3);
        Rectangle2D rectangle2D = font.getStringBounds(string, 0, string.length(), graphics2D.getFontRenderContext());
        graphics2D.setFont(font);
        graphics2D.drawString(string, (int)(((double)n - rectangle2D.getWidth()) / 2.0), -n2 - n2 / 2);
        return bufferedImage;
    }
}

