/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.model;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.editor.labkit.model.ImpBdvShowable;
import fiji.plugin.trackmate.gui.editor.labkit.model.LabkitImporter;
import fiji.plugin.trackmate.gui.editor.labkit.model.TMImageLabelingModel;
import fiji.plugin.trackmate.gui.editor.labkit.model.TMLabKitUtils;
import fiji.plugin.trackmate.util.SpotUtil;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import ij.ImagePlus;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgView;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImgPlusViews;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.Context;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.inputimage.DatasetInputImage;
import sc.fiji.labkit.ui.inputimage.InputImage;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.SegmentationModel;
import sc.fiji.labkit.ui.models.SegmenterListModel;

public class TMLabKitModel
implements SegmentationModel {
    private final Context context;
    private final TMImageLabelingModel imageLabelingModel;
    private final Model model;
    private final double dt;
    private final double[] calibration;

    protected TMLabKitModel(Context context, Model model, InputImage inputImage, ImagePlus imp) {
        this.context = context;
        this.model = model;
        this.imageLabelingModel = new TMImageLabelingModel(inputImage);
        this.dt = imp.getCalibration().frameInterval;
        this.calibration = TMUtils.getSpatialCalibration(imp);
    }

    public Context context() {
        return this.context;
    }

    public TMImageLabelingModel imageLabelingModel() {
        return this.imageLabelingModel;
    }

    public SegmenterListModel segmenterList() {
        throw new UnsupportedOperationException("TrackMate editor does not have segmenting capabilities");
    }

    @Deprecated
    public <T extends IntegerType<T> & NativeType<T>> List<RandomAccessibleInterval<T>> getSegmentations(T type) {
        throw new UnsupportedOperationException("TrackMate editor does not have segmenting capabilities");
    }

    @Deprecated
    public List<RandomAccessibleInterval<FloatType>> getPredictions() {
        throw new UnsupportedOperationException("TrackMate editor does not have segmenting capabilities");
    }

    public boolean isTrained() {
        throw new UnsupportedOperationException("TrackMate editor does not have segmenting capabilities");
    }

    public static final TMLabKitModel create(Model model, ImagePlus imp, Interval interval, DisplaySettings displaySettings, int timepoint, Context context) {
        Pair<Labeling, Map<Label, Spot>> out = TMLabKitModel.createLabeling(model, imp, interval, displaySettings, timepoint);
        Labeling labeling = (Labeling)out.getA();
        Map initialMapping = (Map)out.getB();
        DatasetInputImage input = TMLabKitModel.makeInput(imp, interval, timepoint);
        TMLabKitModel lbModel = new TMLabKitModel(context, model, (InputImage)input, imp);
        lbModel.imageLabelingModel().labeling().set((Object)labeling);
        Img<UnsignedIntType> initialIndexImg = TMLabKitUtils.copy((RandomAccessibleInterval<UnsignedIntType>)labeling.getIndexImg());
        lbModel.imageLabelingModel().setInitialState(initialMapping, (RandomAccessibleInterval<UnsignedIntType>)initialIndexImg);
        return lbModel;
    }

    public boolean hasChanges() {
        Labeling labeling = (Labeling)this.imageLabelingModel.labeling().get();
        RandomAccessibleInterval indexImg = labeling.getIndexImg();
        RandomAccessibleInterval<UnsignedIntType> initialIndexImg = this.imageLabelingModel.initialIndexImg();
        return TMLabKitUtils.isDifferent(initialIndexImg, (RandomAccessibleInterval<UnsignedIntType>)indexImg);
    }

    public void updateTrackMateModel(boolean simplifyContours, int timepoint) {
        Labeling labeling = (Labeling)this.imageLabelingModel().labeling().get();
        Map<Label, Spot> initialMapping = this.imageLabelingModel().initialMapping();
        RandomAccessibleInterval<UnsignedIntType> initialIndexImg = this.imageLabelingModel().initialIndexImg();
        LabkitImporter.create().trackmateModel(this.model).labeling(labeling).initialIndexImg(initialIndexImg).initialMapping(initialMapping).targetTimePoint(timepoint).calibration(this.calibration).frameInterval(this.dt).simplifyContours(simplifyContours).get().run();
    }

    private static final DatasetInputImage makeInput(ImagePlus imp, Interval interval, int timepoint) {
        ImgPlus fov;
        ImgPlus all = TMUtils.rawWraps(imp);
        int timeAxis = all.dimensionIndex(Axes.TIME);
        boolean singleTimePoint = timepoint >= 0;
        ImgPlus view = singleTimePoint && timeAxis >= 0 ? ImgPlusViews.hyperSlice((ImgPlus)all, (int)timeAxis, (long)timepoint) : all;
        if (interval != null) {
            int cAxis;
            long[] min = view.minAsLongArray();
            long[] max = view.maxAsLongArray();
            int xAxis = view.dimensionIndex(Axes.X);
            int yAxis = view.dimensionIndex(Axes.Y);
            min[xAxis] = interval.min(xAxis);
            min[yAxis] = interval.min(yAxis);
            max[xAxis] = interval.max(xAxis);
            max[yAxis] = interval.max(yAxis);
            IntervalView crop = Views.interval((RandomAccessible)view, (long[])min, (long[])max);
            fov = ImgPlus.wrapRAI((RandomAccessibleInterval)crop);
            if (!singleTimePoint && timeAxis >= 0) {
                fov.setAxis(view.axis(timeAxis), timeAxis);
            }
            if ((cAxis = view.dimensionIndex(Axes.CHANNEL)) > 0) {
                fov.setAxis(view.axis(cAxis), cAxis);
            }
        } else {
            fov = view;
        }
        ImpBdvShowable showable = ImpBdvShowable.fromImp(fov, imp);
        return new DatasetInputImage(fov, (BdvShowable)showable);
    }

    private static final Pair<Labeling, Map<Label, Spot>> createLabeling(Model model, ImagePlus imp, Interval interval, DisplaySettings displaySettings, int timepoint) {
        long[] origin;
        AxisType[] axisTypeArray;
        boolean singleTimePoint;
        boolean is3D = !DetectionUtils.is2D(imp);
        boolean bl = singleTimePoint = timepoint >= 0;
        if (is3D) {
            if (singleTimePoint) {
                AxisType[] axisTypeArray2 = new AxisType[3];
                axisTypeArray2[0] = Axes.X;
                axisTypeArray2[1] = Axes.Y;
                axisTypeArray = axisTypeArray2;
                axisTypeArray2[2] = Axes.Z;
            } else {
                AxisType[] axisTypeArray3 = new AxisType[4];
                axisTypeArray3[0] = Axes.X;
                axisTypeArray3[1] = Axes.Y;
                axisTypeArray3[2] = Axes.Z;
                axisTypeArray = axisTypeArray3;
                axisTypeArray3[3] = Axes.TIME;
            }
        } else if (singleTimePoint) {
            AxisType[] axisTypeArray4 = new AxisType[2];
            axisTypeArray4[0] = Axes.X;
            axisTypeArray = axisTypeArray4;
            axisTypeArray4[1] = Axes.Y;
        } else {
            AxisType[] axisTypeArray5 = new AxisType[3];
            axisTypeArray5[0] = Axes.X;
            axisTypeArray5[1] = Axes.Y;
            axisTypeArray = axisTypeArray5;
            axisTypeArray5[2] = Axes.TIME;
        }
        AxisType[] axes = axisTypeArray;
        if (is3D) {
            throw new UnsupportedOperationException("Using LabKit with TrackMate is only supported for 2D for now.");
        }
        int nDims = is3D ? (singleTimePoint ? 3 : 4) : (singleTimePoint ? 2 : 3);
        long[] dims = new long[nDims];
        int dim = 0;
        dims[dim++] = imp.getWidth();
        dims[dim++] = imp.getHeight();
        if (is3D) {
            dims[dim++] = imp.getNSlices();
        }
        if (!singleTimePoint) {
            dims[dim++] = imp.getNFrames();
        }
        if (interval != null) {
            dims[0] = interval.dimension(0);
            dims[1] = interval.dimension(1);
            origin = new long[dims.length];
            origin[0] = interval.min(0);
            origin[1] = interval.min(1);
        } else {
            origin = null;
        }
        ArrayImg lblImg = ArrayImgs.unsignedInts((long[])dims);
        if (origin != null) {
            IntervalView translated = Views.translate((RandomAccessibleInterval)lblImg, origin);
            lblImg = ImgView.wrap((RandomAccessibleInterval)translated);
        }
        double[] c = TMUtils.getSpatialCalibration(imp);
        double[] calibration = new double[nDims];
        dim = 0;
        calibration[dim++] = c[0];
        calibration[dim++] = c[1];
        if (is3D) {
            calibration[dim++] = c[2];
        }
        if (!singleTimePoint) {
            calibration[dim++] = 1.0;
        }
        ImgPlus lblImgPlus = new ImgPlus((Img)lblImg, "LblImg", axes, calibration);
        Labeling labeling = Labeling.fromImg((RandomAccessibleInterval)lblImgPlus);
        CalibratedAxis[] caxes = new CalibratedAxis[axes.length];
        lblImgPlus.axes((Axis[])caxes);
        labeling.setAxes(Arrays.asList(caxes));
        DisplaySettings defaultStyle = DisplaySettings.defaultStyle().copy();
        defaultStyle.setSpotColorBy(DisplaySettings.TrackMateObject.SPOTS, "RANDOM_COLOR");
        DisplaySettings ds = displaySettings == null ? defaultStyle : displaySettings;
        FeatureColorGenerator<Spot> colorGen = FeatureUtils.createSpotColorGenerator(model, ds);
        SpotCollection spots = model.getSpots();
        HashMap<Label, Spot> spotLabels = new HashMap<Label, Spot>();
        long[] sourceImgMax = new long[]{imp.getWidth() - 1, imp.getHeight() - 1};
        if (singleTimePoint) {
            TMLabKitModel.processFrame(labeling, (ImgPlus<UnsignedIntType>)lblImgPlus, spots, timepoint, origin, colorGen, spotLabels, sourceImgMax);
        } else {
            for (int t = 0; t < imp.getNFrames(); ++t) {
                TMLabKitModel.processFrame(labeling, (ImgPlus<UnsignedIntType>)lblImgPlus, spots, t, origin, colorGen, spotLabels, sourceImgMax);
            }
        }
        return new ValuePair((Object)labeling, spotLabels);
    }

    private static void processFrame(Labeling labeling, ImgPlus<UnsignedIntType> lblImgPlus, SpotCollection spots, int timepoint, long[] origin, FeatureColorGenerator<Spot> colorGen, Map<Label, Spot> spotLabels, long[] sourceImgMax) {
        ImgPlus img;
        RandomAccess ra;
        int timeDim = lblImgPlus.dimensionIndex(Axes.TIME);
        if (timeDim < 0) {
            ra = labeling.randomAccess();
            img = lblImgPlus;
        } else {
            ra = Views.hyperSlice((RandomAccessibleInterval)labeling, (int)timeDim, (long)timepoint).randomAccess();
            img = ImgPlusViews.hyperSlice(lblImgPlus, (int)timeDim, (long)timepoint);
        }
        Iterable<Spot> spotsThisFrame = spots.iterable(timepoint, true);
        if (null == origin) {
            for (Spot spot : spotsThisFrame) {
                Label label = labeling.addLabel(spot.getName());
                label.setColor(new ARGBType(colorGen.color(spot).getRGB()));
                Cursor c = SpotUtil.iterable(spot, img).localizingCursor();
                while (c.hasNext()) {
                    c.fwd();
                    if (!Intervals.contains((Interval)img, (Localizable)c)) continue;
                    ra.setPosition((Localizable)c);
                    ((LabelingType)ra.get()).add((Object)label);
                }
                spotLabels.put(label, spot);
            }
        } else {
            long[] intervalMax = new long[2];
            img.max(intervalMax);
            for (int d = 0; d < 2; ++d) {
                if (sourceImgMax[d] != intervalMax[d]) continue;
                int n = d;
                intervalMax[n] = intervalMax[n] + 1L;
            }
            FinalInterval imgBB = Intervals.createMinMax((long[])new long[]{origin[0], origin[1], intervalMax[0], intervalMax[1]});
            long[] min = new long[2];
            long[] max = new long[2];
            FinalInterval spotBB = FinalInterval.wrap((long[])min, (long[])max);
            for (Spot spot : spotsThisFrame) {
                TMLabKitUtils.boundingBox(spot, (ImgPlus<UnsignedIntType>)img, min, max);
                boolean isInside = Intervals.contains((Interval)imgBB, (Interval)spotBB);
                if (!isInside) continue;
                Label label = labeling.addLabel(spot.getName());
                label.setColor(new ARGBType(colorGen.color(spot).getRGB()));
                Cursor c = SpotUtil.iterable(spot, img).localizingCursor();
                while (c.hasNext()) {
                    c.fwd();
                    if (!Intervals.contains((Interval)img, (Localizable)c)) continue;
                    ra.setPosition((Localizable)c);
                    ((LabelingType)ra.get()).add((Object)label);
                }
                spotLabels.put(label, spot);
            }
        }
    }
}

