/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Platforms {
    public static final OperatingSystem OS;
    public static final CpuArchitecture ARCH;
    public static final String PLATFORM;

    private Platforms() {
    }

    public static boolean isWindows() {
        return OS == OperatingSystem.WINDOWS;
    }

    public static boolean isMacOS() {
        return OS == OperatingSystem.MACOS;
    }

    public static boolean isLinux() {
        return OS == OperatingSystem.LINUX;
    }

    public static boolean isExecutable(File file) {
        return OS == OperatingSystem.WINDOWS ? file.exists() && file.getName().toLowerCase().endsWith(".exe") : file.canExecute();
    }

    public static List<String> baseCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        if (Platforms.isWindows()) {
            cmd.addAll(Arrays.asList("cmd.exe", "/c"));
        }
        return cmd;
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        OS = osName.contains("linux") || osName.endsWith("ix") ? OperatingSystem.LINUX : (osName.startsWith("mac") || osName.startsWith("darwin") ? OperatingSystem.MACOS : (osName.startsWith("windows") ? OperatingSystem.WINDOWS : OperatingSystem.UNKNOWN));
        String cpuArch = System.getProperty("os.arch").toLowerCase();
        ARCH = Arrays.asList("aarch64", "arm64").contains(cpuArch) ? CpuArchitecture.ARM64 : (Arrays.asList("arm", "armv6").contains(cpuArch) ? CpuArchitecture.ARMV6 : (Arrays.asList("aarch32", "arm32", "armv7").contains(cpuArch) ? CpuArchitecture.ARMV7 : (Arrays.asList("powerpc64", "ppc64").contains(cpuArch) ? CpuArchitecture.PPC64 : (Arrays.asList("powerpc64le", "ppc64le").contains(cpuArch) ? CpuArchitecture.PPC64LE : (Arrays.asList("riskv64", "riscv64gc", "rv64gc").contains(cpuArch) ? CpuArchitecture.RV64GC : (Arrays.asList("s390x").contains(cpuArch) ? CpuArchitecture.S390X : (Arrays.asList("i386", "i486", "i586", "i686", "x32", "x86", "x86-32", "x86_32").contains(cpuArch) ? CpuArchitecture.X32 : (Arrays.asList("amd64", "x86-64", "x86_64", "x64").contains(cpuArch) ? CpuArchitecture.X64 : CpuArchitecture.UNKNOWN))))))));
        PLATFORM = (Object)((Object)OS) + "|" + (Object)((Object)ARCH);
    }

    public static enum CpuArchitecture {
        ARM64,
        ARMV6,
        ARMV7,
        PPC64,
        PPC64LE,
        RV64GC,
        S390X,
        X32,
        X64,
        UNKNOWN;

    }

    public static enum OperatingSystem {
        LINUX,
        MACOS,
        WINDOWS,
        UNKNOWN;

    }
}

