/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.utils.CachingThread;
import ini.trakem2.utils.IJError;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractOffscreenThread
extends CachingThread {
    protected volatile RepaintProperties rp = null;
    private final AtomicBoolean mustRepaint = new AtomicBoolean(false);

    AbstractOffscreenThread(String name) {
        super(name);
        this.setPriority(5);
        try {
            this.setDaemon(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(RepaintProperties rp) {
        AbstractOffscreenThread abstractOffscreenThread = this;
        synchronized (abstractOffscreenThread) {
            this.rp = rp;
            this.mustRepaint.set(true);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                if (this.mustRepaint.getAndSet(false)) {
                    this.paint();
                    continue;
                }
                AbstractOffscreenThread abstractOffscreenThread = this;
                synchronized (abstractOffscreenThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        this.interrupt();
        AbstractOffscreenThread abstractOffscreenThread = this;
        synchronized (abstractOffscreenThread) {
            this.notifyAll();
        }
    }

    public void waitOnRepaintCycle() {
        while (this.mustRepaint.get()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public abstract void paint();

    protected static interface RepaintProperties {
    }
}

