/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.IJ;
import ij.IJEventListener;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.process.ImageProcessor;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.analysis.Graph;
import ini.trakem2.display.AffineTransformMode;
import ini.trakem2.display.AreaContainer;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.AreaTree;
import ini.trakem2.display.AreaWrapper;
import ini.trakem2.display.Ball;
import ini.trakem2.display.Channel;
import ini.trakem2.display.Connector;
import ini.trakem2.display.ContrastAdjustmentMode;
import ini.trakem2.display.Coordinate;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.DefaultMode;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.DisplayNavigator;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.DisplayableChooser;
import ini.trakem2.display.DisplayablePanel;
import ini.trakem2.display.Dissector;
import ini.trakem2.display.DoStep;
import ini.trakem2.display.FakeImagePlus;
import ini.trakem2.display.ImageData;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerPanel;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.ManualAlignMode;
import ini.trakem2.display.Mode;
import ini.trakem2.display.Node;
import ini.trakem2.display.NonLinearTransformMode;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Pipe;
import ini.trakem2.display.Polyline;
import ini.trakem2.display.Profile;
import ini.trakem2.display.RollingPanel;
import ini.trakem2.display.Selection;
import ini.trakem2.display.Stack;
import ini.trakem2.display.Tag;
import ini.trakem2.display.Tree;
import ini.trakem2.display.TreeConnectorsView;
import ini.trakem2.display.Treeline;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.YesNoDialog;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.display.inspect.InspectPatchTrianglesMode;
import ini.trakem2.imaging.Blending;
import ini.trakem2.imaging.LayerStack;
import ini.trakem2.imaging.PatchStack;
import ini.trakem2.imaging.Segmentation;
import ini.trakem2.imaging.filters.FilterEditor;
import ini.trakem2.io.NeuroML;
import ini.trakem2.parallel.Process;
import ini.trakem2.parallel.TaskFactory;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.Loader;
import ini.trakem2.persistence.ProjectTiler;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.DNDInsertImage;
import ini.trakem2.utils.Dispatcher;
import ini.trakem2.utils.Filter;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.Operation;
import ini.trakem2.utils.OptionPanel;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Saver;
import ini.trakem2.utils.Search;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.BasicStroke;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Scrollbar;
import java.awt.Shape;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import lenscorrection.DistortionCorrectionTask;
import lenscorrection.NonLinearTransform;
import mpicbg.ij.clahe.Flat;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.trakem2.align.AlignLayersTask;
import mpicbg.trakem2.align.AlignTask;
import mpicbg.trakem2.transform.AffineModel3D;
import mpicbg.trakem2.transform.CoordinateTransform;
import mpicbg.trakem2.transform.CoordinateTransformList;
import mpicbg.trakem2.transform.InvertibleCoordinateTransform;
import org.janelia.intensity.MatchIntensities;

public final class Display
extends DBObject
implements ActionListener,
IJEventListener {
    public static final int CT_REPLACE = 0;
    public static final int CT_APPEND = 1;
    public static final int CT_PREAPPEND = 2;
    private Layer layer;
    private Displayable active = null;
    private final Selection selection = new Selection(this);
    private JFrame frame;
    private JTabbedPane tabs;
    private Hashtable<Class<?>, RollingPanel> ht_tabs;
    private RollingPanel panel_patches;
    private RollingPanel panel_profiles;
    private RollingPanel panel_zdispl;
    private JScrollPane scroll_channels;
    private JPanel panel_channels;
    private RollingPanel panel_labels;
    private JPanel panel_layers;
    private JScrollPane scroll_layers;
    private final Hashtable<Layer, LayerPanel> layer_panels = new Hashtable();
    private OptionPanel tool_options;
    private JScrollPane scroll_options;
    private OptionPanel filter_options;
    private JScrollPane scroll_filter_options;
    private JEditorPane annot_editor;
    private JLabel annot_label;
    private JPanel annot_panel;
    private static HashMap<Displayable, Document> annot_docs = new HashMap();
    private JSlider transp_slider;
    private DisplayNavigator navigator;
    private JScrollBar scroller;
    private DisplayCanvas canvas;
    private JPanel all;
    private JPopupMenu popup = null;
    private ToolbarPanel toolbar_panel = null;
    private int c_alphas = -1;
    private Channel[] channels;
    private final Hashtable<Displayable, DisplayablePanel> ht_panels = new Hashtable();
    private DNDInsertImage dnd;
    private int scroll_step = 1;
    private static final Object DISPLAY_LOCK = new Object();
    private static Set<Display> al_displays = new HashSet<Display>();
    private static Display front = null;
    private static final Hashtable<Display, Object[]> ht_later = new Hashtable();
    protected final Dispatcher dispatcher = new Dispatcher("Display GUI Updater");
    private static WindowAdapter window_listener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent we) {
            Object source = we.getSource();
            for (Display d : al_displays) {
                if (source != d.frame) continue;
                d.remove(false);
                break;
            }
        }

        @Override
        public void windowActivated(WindowEvent we) {
            ImageJ ij = IJ.getInstance();
            if (null != ij && ij.quitting()) {
                return;
            }
            Object source = we.getSource();
            for (Display d : al_displays) {
                if (source != d.frame) continue;
                front = d;
                ProjectToolbar.setProjectToolbar();
                front.getProject().select(front.layer);
                d.setTempCurrentImage();
                if (IJ.isMacintosh() && IJ.getInstance() != null) {
                    IJ.wait((int)10);
                    d.frame.setMenuBar(Menus.getMenuBar());
                }
                return;
            }
        }

        @Override
        public void windowDeactivated(WindowEvent we) {
        }

        @Override
        public void windowStateChanged(WindowEvent we) {
            Object source = we.getSource();
            for (Display d : al_displays) {
                if (source != d.frame) continue;
                d.pack();
                break;
            }
        }
    };
    private final ComponentListener canvas_size_listener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent ce) {
            Display.this.canvas.adjustDimensions();
            Display.this.canvas.repaint(true);
            Display.this.navigator.repaint(false);
        }
    };
    private static ChangeListener tabs_listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent ce) {
            Object source = ce.getSource();
            block0: for (Display d : al_displays) {
                if (source != d.tabs) continue;
                if (null == d.frame || null == d.canvas) {
                    return;
                }
                Container tab = (Container)d.tabs.getSelectedComponent();
                if (tab == d.scroll_channels) {
                    for (int i = 0; i < d.channels.length; ++i) {
                        if (!d.channels[i].isActive()) continue;
                        d.transp_slider.setValue((int)(d.channels[i].getAlpha() * 100.0f));
                        break block0;
                    }
                    break;
                }
                RollingPanel p = null;
                if (tab == d.panel_zdispl) {
                    p = d.panel_zdispl;
                } else if (tab == d.panel_patches) {
                    p = d.panel_patches;
                } else if (tab == d.panel_labels) {
                    p = d.panel_labels;
                } else if (tab == d.panel_profiles) {
                    p = d.panel_profiles;
                } else {
                    if (tab == d.scroll_layers) {
                        return;
                    }
                    if (tab == d.scroll_options) {
                        d.updateToolTab();
                        return;
                    }
                }
                d.updateTab(p);
                if (null == d.active) break;
                d.transp_slider.setValue((int)(d.active.getAlpha() * 100.0f));
                break;
            }
        }
    };
    private final AdjustmentListener scroller_listener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent ae) {
            int index = ae.getValue();
            Layer la = Display.this.layer.getParent().getLayer(index);
            if (la != Display.this.layer) {
                Display.this.slt.set(la);
            }
        }
    };
    private final SetLayerThread slt = new SetLayerThread();
    private final ImagePreloader imagePreloader = new ImagePreloader();
    private static boolean repaint_disabled = false;
    protected GridOverlay gridoverlay = null;
    private ByTypeListener bytypelistener = new ByTypeListener(this);
    private boolean filter_enabled = false;
    private boolean filter_invert = false;
    private boolean filter_clahe_enabled = false;
    private boolean filter_min_max_enabled = false;
    private int filter_clahe_block_size = 127;
    private int filter_clahe_histogram_bins = 256;
    private int filter_min = 0;
    private int filter_max = 255;
    private float filter_clahe_max_slope = 3.0f;
    private final HashMap<Color, Layer> layer_channels = new HashMap();
    private final TreeMap<Integer, LayerPanel> layer_alpha = new TreeMap();
    private final HashMap<Layer, Byte> layer_composites = new HashMap();
    boolean invert_colors = false;
    boolean transp_overlay_images = true;
    boolean transp_overlay_areas = false;
    boolean transp_overlay_text_labels = false;
    Set<Class<?>> classes_to_multipaint = this.getClassesToMultiPaint();
    protected static final int REPAINT_SINGLE_LAYER = 0;
    protected static final int REPAINT_MULTI_LAYER = 1;
    protected static final int REPAINT_RGB_LAYER = 2;
    private Mode mode = new DefaultMode(this);

    public static final Vector<Display> getDisplays() {
        return new Vector<Display>(al_displays);
    }

    public static final int getDisplayCount() {
        return al_displays.size();
    }

    public static final void clearColumnScreenshots(LayerSet ls) {
        for (Display d : al_displays) {
            if (d.layer.getParent() != ls) continue;
            d.clearColumnScreenshots();
        }
    }

    private final void preloadImagesAhead(Layer oldLayer, Layer newLayer, int nLayers) {
        this.imagePreloader.reset(oldLayer, newLayer, nLayers);
    }

    public final void clearColumnScreenshots() {
        this.getLayerSet().clearScreenshots();
    }

    private final void createColumnScreenshots() {
        int n;
        try {
            int ahead;
            if (this.mode.getClass() == DefaultMode.class) {
                ahead = this.project.getProperty("look_ahead_cache", 0);
                if (ahead < 0) {
                    ahead = 0;
                }
                if (0 == ahead) {
                    return;
                }
            } else {
                return;
            }
            n = ahead;
        }
        catch (Exception e) {
            IJError.print(e);
            return;
        }
        this.project.getLoader().doLater(new Callable<Object>(){

            @Override
            public Object call() {
                int i;
                Layer current = Display.this.layer;
                ArrayList<DisplayCanvas.Screenshot> s = new ArrayList<DisplayCanvas.Screenshot>();
                Layer now = current;
                Layer prev = now.getParent().previous(now);
                Layer next = now.getParent().next(now);
                for (i = 0; now != next && i < n; ++i) {
                    s.add(Display.this.canvas.createScreenshot(next));
                    now = next;
                    next = now.getParent().next(now);
                }
                now = current;
                for (i = 0; now != prev && i < n; ++i) {
                    s.add(0, Display.this.canvas.createScreenshot(prev));
                    now = prev;
                    prev = now.getParent().previous(now);
                }
                for (final DisplayCanvas.Screenshot sc : s) {
                    if (current.getParent().containsScreenshot(sc)) continue;
                    sc.init();
                    current.getParent().storeScreenshot(sc);
                    Display.this.project.getLoader().doLater(new Callable<Object>(){

                        @Override
                        public Object call() {
                            sc.createImage();
                            return null;
                        }
                    });
                }
                current.getParent().trimScreenshots();
                return null;
            }
        });
    }

    public static void createDisplay(final Project project, final Layer layer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display display = new Display(project, layer);
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle srcRect = new Rectangle(0, 0, (int)layer.getLayerWidth(), (int)layer.getLayerHeight());
                double mag = (float)screen.width / layer.getLayerWidth();
                if (mag * (double)layer.getLayerHeight() > (double)screen.height) {
                    mag = (float)screen.height / layer.getLayerHeight();
                }
                if ((mag = display.canvas.getLowerZoomLevel2(mag)) > 1.0) {
                    mag = 1.0;
                }
                display.getCanvas().setMagnification(mag);
                display.getCanvas().setSrcRect(srcRect.x, srcRect.y, srcRect.width, srcRect.height);
                display.getCanvas().setDrawingSize((int)Math.ceil((double)srcRect.width * mag), (int)Math.ceil((double)srcRect.height * mag));
                display.updateFrameTitle(layer);
                GUI.center((Window)display.frame);
                display.frame.pack();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void addDisplay(Display display) {
        if (null == display) {
            return;
        }
        Object object = DISPLAY_LOCK;
        synchronized (object) {
            HashSet<Display> a = new HashSet<Display>();
            if (null != al_displays) {
                a.addAll(al_displays);
            }
            a.add(display);
            al_displays = a;
            front = display;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void removeDisplay(Display display) {
        if (null == display) {
            return;
        }
        Object object = DISPLAY_LOCK;
        synchronized (object) {
            HashSet<Display> a = new HashSet<Display>(al_displays);
            a.remove(display);
            if (null == front || front == display) {
                front = a.size() > 0 ? (Display)a.iterator().next() : null;
            }
            al_displays = a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display(Project project, long id, Layer layer, Object[] props) {
        super(project, id);
        Hashtable<Display, Object[]> hashtable = ht_later;
        synchronized (hashtable) {
            ht_later.put(this, props);
        }
        this.layer = layer;
        IJ.addEventListener((IJEventListener)this);
        Display.addDisplay(this);
    }

    public Display(Project project, Layer layer) {
        this(project, layer, null);
    }

    public Display(Project project, Layer layer, Displayable displ) {
        super(project);
        this.active = displ;
        this.layer = layer;
        this.makeGUI(layer, null);
        IJ.addEventListener((IJEventListener)this);
        this.setLayer(layer);
        this.layer = layer;
        this.addToDatabase();
        Display.addDisplay(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display(Project project, long id, Layer layer, HashMap<String, String> ht) {
        super(project, id);
        if (null == layer) {
            Utils.log2("Display: need a non-null Layer for id=" + id);
            return;
        }
        Rectangle srcRect = new Rectangle(0, 0, (int)layer.getLayerWidth(), (int)layer.getLayerHeight());
        double magnification = 0.25;
        java.awt.Point p = new java.awt.Point(0, 0);
        int c_alphas = -1;
        int c_alphas_state = -1;
        String data = ht.get("srcrect_x");
        if (null != data) {
            srcRect.x = Integer.parseInt(data);
        }
        if (null != (data = ht.get("srcrect_y"))) {
            srcRect.y = Integer.parseInt(data);
        }
        if (null != (data = ht.get("srcrect_width"))) {
            srcRect.width = Integer.parseInt(data);
        }
        if (null != (data = ht.get("srcrect_height"))) {
            srcRect.height = Integer.parseInt(data);
        }
        if (null != (data = ht.get("magnification"))) {
            magnification = Double.parseDouble(data);
        }
        if (null != (data = ht.get("x"))) {
            p.x = Integer.parseInt(data);
        }
        if (null != (data = ht.get("y"))) {
            p.y = Integer.parseInt(data);
        }
        if (null != (data = ht.get("c_alphas"))) {
            try {
                c_alphas = Integer.parseInt(data);
            }
            catch (Exception ex) {
                c_alphas = -1;
            }
        }
        if (null != (data = ht.get("c_alphas_state"))) {
            try {
                c_alphas_state = Integer.parseInt(data);
            }
            catch (Exception ex) {
                IJError.print(ex);
                c_alphas_state = -1;
            }
        }
        if (null != (data = ht.get("scroll_step"))) {
            try {
                this.setScrollStep(Integer.parseInt(data));
            }
            catch (Exception ex) {
                IJError.print(ex);
                this.setScrollStep(1);
            }
        }
        if (null != (data = ht.get("filter_enabled"))) {
            this.filter_enabled = Boolean.parseBoolean(data);
        }
        if (null != (data = ht.get("filter_min_max_enabled"))) {
            this.filter_min_max_enabled = Boolean.parseBoolean(data);
        }
        if (null != (data = ht.get("filter_min"))) {
            this.filter_min = Integer.parseInt(data);
        }
        if (null != (data = ht.get("filter_max"))) {
            this.filter_max = Integer.parseInt(data);
        }
        if (null != (data = ht.get("filter_invert"))) {
            this.filter_invert = Boolean.parseBoolean(data);
        }
        if (null != (data = ht.get("filter_clahe_enabled"))) {
            this.filter_clahe_enabled = Boolean.parseBoolean(data);
        }
        if (null != (data = ht.get("filter_clahe_block_size"))) {
            this.filter_clahe_block_size = Integer.parseInt(data);
        }
        if (null != (data = ht.get("filter_clahe_histogram_bins"))) {
            this.filter_clahe_histogram_bins = Integer.parseInt(data);
        }
        if (null != (data = ht.get("filter_clahe_max_slope"))) {
            this.filter_clahe_max_slope = Float.parseFloat(data);
        }
        Object[] props = new Object[]{p, new Double(magnification), srcRect, new Long(layer.getId()), new Integer(c_alphas), new Integer(c_alphas_state)};
        Hashtable<Display, Object[]> hashtable = ht_later;
        synchronized (hashtable) {
            ht_later.put(this, props);
        }
        this.layer = layer;
        IJ.addEventListener((IJEventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bureaucrat openLater() {
        Project[] ps;
        HashMap<Display, Object[]> ht_later_local;
        Hashtable<Display, Object[]> hashtable = ht_later;
        synchronized (hashtable) {
            if (0 == ht_later.size()) {
                return null;
            }
            ht_later_local = new HashMap<Display, Object[]>(ht_later);
            ht_later.keySet().removeAll(ht_later_local.keySet());
            HashSet<Project> unique = new HashSet<Project>();
            for (Display d : ht_later_local.keySet()) {
                unique.add(d.project);
            }
            ps = unique.toArray(new Project[unique.size()]);
        }
        Worker.Task worker = new Worker.Task("Opening displays"){

            @Override
            public void exec() {
                try {
                    Thread.sleep(300L);
                    for (final Display d : ht_later_local.keySet()) {
                        Display.addDisplay(d);
                        Object[] props = (Object[])ht_later_local.get(d);
                        if (ControlWindow.isGUIEnabled()) {
                            d.makeGUI(d.layer, props);
                        }
                        d.setLayerLater(d.layer, d.layer.get((Long)props[3]));
                        if (!ControlWindow.isGUIEnabled()) continue;
                        d.updateFrameTitle(d.layer);
                        if (d.canvas.getMagnification() > 0.499) {
                            Utils.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Display.repaint(d.layer);
                                    d.project.getLoader().setChanged(false);
                                    Utils.log2("A set to false");
                                }
                            });
                        }
                        d.project.getLoader().setChanged(false);
                        Utils.log2("B set to false");
                    }
                    if (null != front) {
                        front.getProject().select(front.layer);
                    }
                }
                catch (Throwable t) {
                    IJError.print(t);
                }
            }
        };
        return Bureaucrat.createAndStart((Worker)worker, ps);
    }

    private void makeGUI(final Layer layer, final Object[] props) {
        java.awt.Point p;
        double mag = 1.0;
        Rectangle srcRect = null;
        if (null != props) {
            p = (java.awt.Point)props[0];
            mag = (Double)props[1];
            srcRect = (Rectangle)props[2];
        } else {
            p = null;
        }
        this.transp_slider = new JSlider(0, 0, 100, 100);
        this.transp_slider.setBackground(Color.white);
        this.transp_slider.setMinimumSize(new Dimension(250, 20));
        this.transp_slider.setMaximumSize(new Dimension(250, 20));
        this.transp_slider.setPreferredSize(new Dimension(250, 20));
        TransparencySliderListener tsl = new TransparencySliderListener();
        this.transp_slider.addChangeListener(tsl);
        this.transp_slider.addMouseListener(tsl);
        for (KeyListener kl : this.transp_slider.getKeyListeners()) {
            this.transp_slider.removeKeyListener(kl);
        }
        this.tabs = new JTabbedPane();
        this.tabs.setMinimumSize(new Dimension(250, 300));
        this.tabs.setBackground(Color.white);
        this.tabs.addChangeListener(tabs_listener);
        this.panel_patches = new RollingPanel(this, Patch.class);
        this.addTab("Patches", this.panel_patches);
        this.panel_profiles = new RollingPanel(this, Profile.class);
        this.addTab("Profiles", this.panel_profiles);
        this.panel_zdispl = new RollingPanel(this, ZDisplayable.class);
        this.addTab("Z space", this.panel_zdispl);
        this.panel_channels = this.makeTabPanel();
        this.scroll_channels = this.makeScrollPane(this.panel_channels);
        this.channels = new Channel[4];
        this.channels[0] = new Channel(this, 1);
        this.channels[1] = new Channel(this, 2);
        this.channels[2] = new Channel(this, 4);
        this.channels[3] = new Channel(this, 8);
        this.addGBRow(this.panel_channels, this.channels[1], null);
        this.addGBRow(this.panel_channels, this.channels[2], this.channels[1]);
        this.addGBRow(this.panel_channels, this.channels[3], this.channels[2]);
        this.addTab("Opacity", this.scroll_channels);
        this.panel_labels = new RollingPanel(this, DLabel.class);
        this.addTab("Labels", this.panel_labels);
        this.panel_layers = this.makeTabPanel();
        this.scroll_layers = this.makeScrollPane(this.panel_layers);
        this.recreateLayerPanels(layer);
        this.scroll_layers.addMouseWheelListener(this.canvas);
        this.addTab("Layers", this.scroll_layers);
        this.tool_options = new OptionPanel();
        this.scroll_options = this.makeScrollPane(this.tool_options);
        this.scroll_options.setHorizontalScrollBarPolicy(30);
        this.addTab("Tool options", this.scroll_options);
        this.annot_editor = new JEditorPane();
        this.annot_editor.setEnabled(false);
        this.annot_editor.setMinimumSize(new Dimension(200, 50));
        this.annot_label = new JLabel("(No selected object)");
        this.annot_panel = this.makeAnnotationsPanel(this.annot_editor, this.annot_label);
        this.addTab("Annotations", this.annot_panel);
        this.filter_options = this.createFilterOptionPanel();
        this.scroll_filter_options = this.makeScrollPane(this.filter_options);
        this.scroll_filter_options.setHorizontalScrollBarPolicy(30);
        this.addTab("Live filter", this.scroll_filter_options);
        this.ht_tabs = new Hashtable();
        this.ht_tabs.put(Patch.class, this.panel_patches);
        this.ht_tabs.put(Profile.class, this.panel_profiles);
        this.ht_tabs.put(ZDisplayable.class, this.panel_zdispl);
        this.ht_tabs.put(AreaList.class, this.panel_zdispl);
        this.ht_tabs.put(Pipe.class, this.panel_zdispl);
        this.ht_tabs.put(Polyline.class, this.panel_zdispl);
        this.ht_tabs.put(Treeline.class, this.panel_zdispl);
        this.ht_tabs.put(AreaTree.class, this.panel_zdispl);
        this.ht_tabs.put(Connector.class, this.panel_zdispl);
        this.ht_tabs.put(Ball.class, this.panel_zdispl);
        this.ht_tabs.put(Dissector.class, this.panel_zdispl);
        this.ht_tabs.put(DLabel.class, this.panel_labels);
        this.ht_tabs.put(Stack.class, this.panel_zdispl);
        this.navigator = new DisplayNavigator(this, layer.getLayerWidth(), layer.getLayerHeight());
        int extent = (int)(250.0 / (double)layer.getParent().size());
        if (extent < 10) {
            extent = 10;
        }
        this.scroller = new JScrollBar(0);
        this.scroller.setModel(new ScrollerModel(layer));
        this.updateLayerScroller(layer);
        this.scroller.addAdjustmentListener(this.scroller_listener);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.all = new JPanel();
        this.all.setBackground(Color.white);
        this.all.setLayout(layout);
        c.insets = new Insets(0, 0, 0, 5);
        this.toolbar_panel = new ToolbarPanel();
        layout.setConstraints(this.toolbar_panel, c);
        this.all.add(this.toolbar_panel);
        ++c.gridy;
        c.fill = 2;
        layout.setConstraints(this.transp_slider, c);
        this.all.add(this.transp_slider);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        layout.setConstraints(this.tabs, c);
        this.all.add(this.tabs);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        layout.setConstraints(this.navigator, c);
        this.all.add(this.navigator);
        ++c.gridy;
        c.fill = 2;
        layout.setConstraints(this.scroller, c);
        this.all.add(this.scroller);
        this.canvas = new DisplayCanvas(this, (int)Math.ceil(layer.getLayerWidth()), (int)Math.ceil(layer.getLayerHeight()));
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.anchor = 18;
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        layout.setConstraints((Component)((Object)this.canvas), c);
        this.all.add((Component)((Object)this.canvas));
        if (!this.project.isInputEnabled()) {
            this.canvas.setReceivesInput(false);
        }
        this.canvas.addComponentListener(this.canvas_size_listener);
        this.navigator.addMouseWheelListener(this.canvas);
        this.transp_slider.addKeyListener(this.canvas);
        this.frame = ControlWindow.createJFrame(layer.toString());
        this.frame.setBackground(Color.white);
        this.frame.getContentPane().setBackground(Color.white);
        if (IJ.isMacintosh() && IJ.getInstance() != null) {
            IJ.wait((int)10);
            this.frame.setMenuBar(Menus.getMenuBar());
        }
        this.frame.addWindowListener(window_listener);
        this.frame.getContentPane().add(this.all);
        if (null != props) {
            this.canvas.setup(mag, srcRect);
            int cs = (Integer)props[5];
            int[] sel = new int[]{(cs & 0xFF000000) >> 24, (cs & 0xFF0000) >> 16, (cs & 0xFF00) >> 8, cs & 0xFF};
            this.c_alphas = (Integer)props[4];
            this.channels[0].setAlpha((float)((this.c_alphas & 0xFF000000) >> 24) / 255.0f, 0 != sel[0]);
            this.channels[1].setAlpha((float)((this.c_alphas & 0xFF0000) >> 16) / 255.0f, 0 != sel[1]);
            this.channels[2].setAlpha((float)((this.c_alphas & 0xFF00) >> 8) / 255.0f, 0 != sel[2]);
            this.channels[3].setAlpha((float)(this.c_alphas & 0xFF) / 255.0f, 0 != sel[3]);
            this.c_alphas = ((0 != sel[0] ? (int)(255.0f * this.channels[0].getAlpha()) : 0) << 24) + ((0 != sel[1] ? (int)(255.0f * this.channels[1].getAlpha()) : 0) << 16) + ((0 != sel[2] ? (int)(255.0f * this.channels[2].getAlpha()) : 0) << 8) + (0 != sel[3] ? (int)(255.0f * this.channels[3].getAlpha()) : 0);
        }
        if (null != this.active && null != layer) {
            Rectangle r = this.active.getBoundingBox();
            r.x -= r.width / 2;
            r.y -= r.height / 2;
            r.width += r.width;
            r.height += r.height;
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if ((float)r.width > layer.getLayerWidth()) {
                r.width = (int)layer.getLayerWidth();
            }
            if ((float)r.height > layer.getLayerHeight()) {
                r.height = (int)layer.getLayerHeight();
            }
            double magn = (double)layer.getLayerWidth() / (double)r.width;
            this.canvas.setup(magn, r);
        }
        this.tabs.addKeyListener(this.canvas);
        this.frame.addKeyListener(this.canvas);
        this.dnd = new DNDInsertImage(this);
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.this.frame.pack();
                GUI.center((Window)Display.this.frame);
                Display.this.frame.setVisible(true);
                ProjectToolbar.setProjectToolbar();
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                if (null != props) {
                    if (p.x >= 0 && p.x < screen.width - 50 && p.y >= 0 && p.y <= screen.height - 50) {
                        Display.this.frame.setLocation(p);
                    } else {
                        Display.this.frame.setLocation(0, 0);
                    }
                }
                Rectangle box = Display.this.frame.getBounds();
                int x = box.x;
                int y = box.y;
                int width = box.width;
                int height = box.height;
                if (box.width > screen.width) {
                    x = 0;
                    width = screen.width;
                }
                if (box.height > screen.height) {
                    y = 0;
                    height = screen.height;
                }
                if (x != box.x || y != box.y) {
                    Display.this.frame.setLocation(x, y + (0 == y ? 30 : 0));
                }
                if (width != box.width || height != box.height) {
                    Display.this.frame.setSize(new Dimension(width - 10, height - 30));
                }
                if (null == props) {
                    double magn = layer.getLayerHeight() / (float)screen.height;
                    if (magn > 1.0) {
                        magn = 1.0;
                    }
                    long size = 0L;
                    for (Displayable pa : layer.getDisplayables(Patch.class)) {
                        Rectangle ba = pa.getBoundingBox();
                        size += (long)(ba.width * ba.height);
                    }
                    if (size > 10000000L) {
                        Display.this.canvas.setInitialMagnification(0.25);
                    } else {
                        Display.this.frame.setSize(new Dimension((int)((double)screen.width * 0.66), (int)((double)screen.height * 0.66)));
                    }
                }
                Display.this.updateTab(Display.this.panel_patches);
                Display.this.tabs.validate();
                ((FakeImagePlus)Display.this.canvas.getFakeImagePlus()).setCalibrationSuper(layer.getParent().getCalibrationCopy());
                Display.this.updateFrameTitle(layer);
                Display.this.setTempCurrentImage();
                if (null != props) {
                    Display.this.canvas.repaint(true);
                }
                ControlWindow.setLookAndFeel();
            }
        });
    }

    public static void repaintToolbar() {
        for (final Display d : al_displays) {
            if (null == d.toolbar_panel) continue;
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    d.toolbar_panel.repaint();
                }
            });
        }
    }

    private JPanel makeTabPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        return panel;
    }

    private JScrollPane makeScrollPane(Component c) {
        JPanel p = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        p.setLayout(gb);
        GridBagConstraints co = new GridBagConstraints();
        co.anchor = 18;
        co.fill = 2;
        co.gridy = 0;
        co.weighty = 0.0;
        gb.setConstraints(c, co);
        p.add(c);
        JPanel padding = new JPanel();
        padding.setPreferredSize(new Dimension(0, 0));
        co.fill = 1;
        co.gridy = 1;
        co.weighty = 1.0;
        gb.setConstraints(padding, co);
        p.add(padding);
        JScrollPane jsp = new JScrollPane(p);
        jsp.setBackground(Color.white);
        jsp.getViewport().setBackground(Color.white);
        jsp.getVerticalScrollBar().setBlockIncrement(52);
        jsp.getVerticalScrollBar().setUnitIncrement(52);
        jsp.setHorizontalScrollBarPolicy(31);
        jsp.setPreferredSize(new Dimension(250, 300));
        jsp.setMinimumSize(new Dimension(250, 300));
        return jsp;
    }

    private void addGBRow(Container container, Component comp, Component previous) {
        GridBagLayout gb = (GridBagLayout)container.getLayout();
        GridBagConstraints c = null;
        if (null == previous) {
            c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 2;
            c.gridy = 0;
        } else {
            c = gb.getConstraints(previous);
            ++c.gridy;
        }
        gb.setConstraints(comp, c);
        container.add(comp);
    }

    private JPanel makeAnnotationsPanel(JEditorPane ep, JLabel label) {
        JPanel p = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(gb);
        c.fill = 2;
        c.anchor = 18;
        c.ipadx = 5;
        c.ipady = 5;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabel title = new JLabel("Annotate:");
        gb.setConstraints(title, c);
        p.add(title);
        ++c.gridy;
        gb.setConstraints(label, c);
        p.add(label);
        c.weighty = 1.0;
        ++c.gridy;
        c.fill = 1;
        c.ipadx = 0;
        c.ipady = 0;
        JScrollPane sp = new JScrollPane(ep, 20, 30);
        sp.setPreferredSize(new Dimension(250, 300));
        sp.setMinimumSize(new Dimension(250, 300));
        gb.setConstraints(sp, c);
        p.add(sp);
        return p;
    }

    public DisplayCanvas getCanvas() {
        return this.canvas;
    }

    public synchronized void setLayer(Layer new_layer) {
        this.setLayer(new_layer, false);
    }

    private synchronized void setLayer(final Layer new_layer, boolean bypass_checks) {
        if (!(bypass_checks || null != new_layer && new_layer != this.layer && new_layer.getParent() == this.layer.getParent())) {
            return;
        }
        final Layer current_layer = this.layer;
        if (!this.mode.canChangeLayer()) {
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((ScrollerModel)Display.this.scroller.getModel()).setValueWithoutEvent(current_layer.getParent().indexOf(current_layer));
                }
            });
            return;
        }
        this.layer = new_layer;
        ArrayList<Displayable> sel = this.selection.getSelected();
        Displayable last_active = this.active;
        int sel_next = -1;
        Iterator<Displayable> it = sel.iterator();
        while (it.hasNext()) {
            Displayable d = it.next();
            if (d instanceof ZDisplayable) continue;
            it.remove();
            this.selection.remove(d);
            if (d != last_active || sel.size() <= 0) continue;
            sel_next = sel.size() - 1;
        }
        if (-1 != sel_next && sel.size() > 0) {
            this.select(sel.get(sel_next), true);
        }
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.this.translateLayerColors(current_layer, new_layer);
                if (Display.this.tabs.getSelectedComponent() == Display.this.scroll_layers) {
                    Display.this.scrollToShow(Display.this.scroll_layers, (JPanel)Display.this.layer_panels.get(new_layer));
                }
                int index = Display.this.layer.getParent().indexOf(new_layer);
                if (Display.this.scroller.getValue() != index) {
                    ((ScrollerModel)Display.this.scroller.getModel()).setValueWithoutEvent(index);
                }
                if (Display.this.tabs.getSelectedComponent() != Display.this.panel_zdispl) {
                    Display.this.updateVisibleDisplayableTab();
                }
                Display.this.updateFrameTitle(new_layer);
                Display.this.project.select(new_layer);
                Display.this.navigator.repaint(true);
                Display.this.canvas.repaint(true);
                Utils.updateComponent(Display.this.tabs);
                Component c = Display.this.tabs.getSelectedComponent();
                if (null == c) {
                    c = Display.this.panel_patches;
                    Display.this.tabs.setSelectedComponent(Display.this.panel_patches);
                }
                Utils.updateComponent(c);
                Display.this.project.getProjectTree().updateUILater();
                Display.this.setTempCurrentImage();
            }
        });
    }

    public static void updateVisibleTabs() {
        for (Display d : al_displays) {
            d.updateVisibleDisplayableTab();
        }
    }

    public static void updateVisibleTabs(Project p) {
        for (Display d : al_displays) {
            if (d.project != p) continue;
            d.updateVisibleDisplayableTab();
        }
    }

    private void updateVisibleDisplayableTab() {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component c = Display.this.tabs.getSelectedComponent();
                if (c instanceof RollingPanel) {
                    ((RollingPanel)c).updateList();
                }
            }
        });
    }

    private void setLayerLater(Layer layer, final Displayable active) {
        if (null == layer) {
            return;
        }
        this.layer = layer;
        if (!ControlWindow.isGUIEnabled()) {
            return;
        }
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.this.navigator.repaint(true);
                Display.this.setActive(active);
                Container c = (Container)Display.this.tabs.getSelectedComponent();
                if (c != Display.this.panel_zdispl) {
                    Display.this.updateTab(c);
                }
            }
        });
    }

    private void setTransparency(float value) {
        Component scroll = this.tabs.getSelectedComponent();
        if (scroll == this.scroll_channels) {
            for (int i = 0; i < 4; ++i) {
                if (this.channels[i].getBackground() != Color.cyan) continue;
                this.channels[i].setAlpha(value);
                return;
            }
        } else if (null != this.active && value != this.active.getAlpha()) {
            this.selection.setAlpha(value);
            Display.repaint(this.active.getLayerSet(), this.active, this.active.getBoundingBox(), 5, false);
        }
    }

    public void setTransparencySlider(final float transp) {
        if (transp >= 0.0f && transp <= 1.0f) {
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Display.this.transp_slider.setValue((int)(transp * 100.0f));
                }
            });
        }
    }

    public static void setUpdateGraphics(Layer layer, Displayable displ) {
        for (Display d : al_displays) {
            if (layer != d.layer || null == d.active || d.active == displ) continue;
            d.canvas.setUpdateGraphics(true);
        }
    }

    public static void setUpdateGraphics(Layer layer, boolean update) {
        for (Display d : al_displays) {
            if (layer != d.layer) continue;
            d.canvas.setUpdateGraphics(update);
        }
    }

    public void setUpdateGraphics(boolean b) {
        this.canvas.setUpdateGraphics(b);
    }

    public static void update() {
        for (Display d : al_displays) {
            d.updateLayerScroller(d.layer);
            d.updateVisibleDisplayableTab();
            d.toolbar_panel.repaint();
            d.navigator.repaint(true);
            d.canvas.repaint(true);
        }
    }

    public static void update(Layer layer) {
        if (null == layer) {
            return;
        }
        for (Display d : al_displays) {
            if (!d.isShowing(layer)) continue;
            d.repaintAll();
        }
    }

    public static void update(LayerSet set) {
        Display.update(set, true);
    }

    public static void update(LayerSet set, boolean update_canvas_dimensions) {
        if (null == set) {
            return;
        }
        for (Display d : al_displays) {
            if (d.layer.getParent() != set) continue;
            d.updateSnapshots();
            if (update_canvas_dimensions) {
                d.canvas.setDimensions(set.getLayerWidth(), set.getLayerHeight());
            }
            d.repaintAll();
        }
    }

    protected void destroy() {
        Display.removeDisplay(this);
        this.dispatcher.quit();
        this.canvas.setReceivesInput(false);
        this.slt.quit();
        this.imagePreloader.interrupt();
        if (!this.project.isBeingDestroyed()) {
            try {
                this.project.getProjectTree().updateUILater();
                this.project.getLayerTree().updateUILater();
            }
            catch (Exception e) {
                Utils.log2("updateUI failed at Display.destroy()");
            }
        }
        this.frame.removeWindowListener(window_listener);
        this.frame.removeWindowFocusListener(window_listener);
        this.frame.removeWindowStateListener(window_listener);
        this.frame.removeKeyListener(this.canvas);
        this.canvas.removeKeyListener(this.canvas);
        this.tabs.removeChangeListener(tabs_listener);
        this.tabs.removeKeyListener(this.canvas);
        IJ.removeEventListener((IJEventListener)this);
        this.bytypelistener = null;
        this.canvas.destroy();
        this.navigator.destroy();
        this.scroller.removeAdjustmentListener(this.scroller_listener);
        this.frame.setVisible(false);
        this.active = null;
        if (null != this.selection) {
            this.selection.clear();
        }
        try {
            this.project.getLayerTree().updateUILater();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dnd.destroy();
    }

    public static synchronized void close(Project project) {
        Display[] d = new Display[al_displays.size()];
        al_displays.toArray(d);
        for (int i = 0; i < d.length; ++i) {
            if (d[i].getProject() != project) continue;
            Display.removeDisplay(d[i]);
            d[i].destroy();
        }
    }

    public static void close(Layer layer) {
        for (Display d : al_displays) {
            if (!d.isShowing(layer)) continue;
            d.remove(false);
        }
    }

    public static void remove(Layer layer) {
        for (Display d : al_displays) {
            if (!d.isShowing(layer)) continue;
            Layer la = layer.getParent().next(layer);
            if (layer == la || null == la) {
                la = layer.getParent().previous(layer);
            }
            if (null == la || layer == la) {
                d.remove(false);
                continue;
            }
            d.slt.set(la);
        }
    }

    @Override
    public boolean remove(boolean check) {
        if (check && !Utils.check("Delete the Display ?")) {
            return false;
        }
        this.destroy();
        this.removeFromDatabase();
        return true;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public LayerSet getLayerSet() {
        return this.layer.getParent();
    }

    public boolean isShowing(Layer layer) {
        return this.layer == layer;
    }

    public DisplayNavigator getNavigator() {
        return this.navigator;
    }

    public void repaintAll() {
        if (repaint_disabled) {
            return;
        }
        this.navigator.repaint(true);
        this.canvas.repaint(true);
        Utils.updateComponent(this.tabs);
        this.updateFrameTitle();
    }

    public void repaintAll2() {
        if (repaint_disabled) {
            return;
        }
        this.navigator.repaint(false);
        this.canvas.repaint(true);
        this.updateFrameTitle();
    }

    public void repaintAll3() {
        if (repaint_disabled) {
            return;
        }
        this.navigator.repaint(false);
        this.canvas.repaint(true);
        this.updateFrameTitle();
    }

    protected static void repaintSnapshots(LayerSet set) {
        if (repaint_disabled) {
            return;
        }
        for (Display d : al_displays) {
            if (d.getLayer().getParent() != set) continue;
            d.navigator.repaint(true);
            Utils.updateComponent(d.tabs);
        }
    }

    protected static void repaintSnapshots(Layer layer) {
        if (repaint_disabled) {
            return;
        }
        for (Display d : al_displays) {
            if (d.getLayer() != layer) continue;
            d.navigator.repaint(true);
            Utils.updateComponent(d.tabs);
        }
    }

    public void pack() {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.this.frame.pack();
                Display.this.navigator.repaint(false);
            }
        });
    }

    public static void pack(LayerSet ls) {
        for (Display d : al_displays) {
            if (d.layer.getParent() != ls) continue;
            d.pack();
        }
    }

    public static void setFront(Layer layer, Displayable displ) {
        if (null == front) {
            Display display = new Display(layer.getProject(), layer);
            display.showCentered(displ);
        } else if (layer == Display.front.layer) {
            front.showCentered(displ);
        } else {
            for (Display d : al_displays) {
                if (d.layer != layer) continue;
                d.frame.toFront();
                d.showCentered(displ);
                return;
            }
            new Display(layer.getProject(), layer).showCentered(displ);
        }
    }

    protected static void add(Layer layer, Displayable displ, boolean activate) {
        for (Display d : al_displays) {
            if (d.layer != layer) continue;
            if (front == d) {
                d.add(displ, activate, true);
                continue;
            }
            d.add(displ, false, true);
        }
    }

    protected static void add(Layer layer, Displayable displ) {
        Display.add(layer, displ, true);
    }

    protected static void add(LayerSet set, ZDisplayable zdispl) {
        for (Display d : al_displays) {
            if (d.layer.getParent() != set) continue;
            if (front == d) {
                zdispl.setLayer(d.layer);
                d.add(zdispl, true, true);
                continue;
            }
            d.add(zdispl, false, true);
        }
    }

    protected static void addAll(Layer layer, Collection<? extends Displayable> coll) {
        for (Display d : al_displays) {
            if (d.layer != layer) continue;
            d.addAll(coll);
        }
    }

    protected static void addAll(LayerSet set, Collection<? extends ZDisplayable> coll) {
        for (Display d : al_displays) {
            if (d.layer.getParent() != set) continue;
            for (ZDisplayable zDisplayable : coll) {
                if (front != d) continue;
                zDisplayable.setLayer(d.layer);
            }
            d.addAll(coll);
        }
    }

    private final void addAll(Collection<? extends Displayable> coll) {
        this.updateVisibleDisplayableTab();
        this.selection.clear();
        this.navigator.repaint(true);
    }

    private final void add(Displayable d, boolean activate, boolean repaint_snapshot) {
        if (activate) {
            this.updateVisibleDisplayableTab();
            this.selection.clear();
            this.selection.add(d);
            Display.repaint(d.getLayerSet());
            Utils.log2("Added " + d);
        }
        if (repaint_snapshot) {
            this.navigator.repaint(true);
        }
    }

    public static void remove(Layer layer, Displayable displ) {
        for (Display d : al_displays) {
            if (layer != d.layer) continue;
            d.remove(displ);
        }
    }

    private void remove(Displayable displ) {
        RollingPanel rp;
        DisplayablePanel ob = this.ht_panels.remove(displ);
        if (null != ob && null != (rp = this.ht_tabs.get(displ.getClass()))) {
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    rp.updateList();
                }
            });
        }
        this.canvas.setUpdateGraphics(true);
        this.repaint(displ, null, 5, true, false);
        this.selection.remove(displ);
    }

    public static void remove(ZDisplayable zdispl) {
        for (Display d : al_displays) {
            if (zdispl.getLayerSet() != d.layer.getParent()) continue;
            d.remove(zdispl);
        }
    }

    public static void repaint(Layer layer, Displayable displ, int extra) {
        Display.repaint(layer, displ, displ.getBoundingBox(), extra);
    }

    public static void repaint(Layer layer, Displayable displ, Rectangle r, int extra) {
        Display.repaint(layer, displ, r, extra, true);
    }

    public static void repaint(Layer layer, Displayable displ, Rectangle r, int extra, boolean repaint_navigator) {
        Display.repaint(layer, displ, r, extra, false, repaint_navigator);
    }

    public static void repaint(Layer layer, Displayable displ, Rectangle r, int extra, boolean update_graphics, boolean repaint_navigator) {
        if (repaint_disabled) {
            return;
        }
        for (Display d : al_displays) {
            if (layer != d.layer) continue;
            d.repaint(displ, r, extra, repaint_navigator, update_graphics);
        }
    }

    public static void repaint(Displayable d) {
        if (d instanceof ZDisplayable) {
            Display.repaint(d.getLayerSet(), d, d.getBoundingBox(null), 5, true);
        }
        Display.repaint(d.getLayer(), d, d.getBoundingBox(null), 5, true);
    }

    private void repaint(Displayable displ, Rectangle r, int extra, boolean repaint_navigator, boolean update_graphics) {
        if (repaint_disabled || null == displ) {
            return;
        }
        boolean bl = update_graphics = update_graphics || displ.getClass() == Patch.class || displ != this.active;
        if (null != r) {
            this.canvas.repaint(r, extra, update_graphics);
        } else {
            this.canvas.repaint(displ, extra, update_graphics);
        }
        if (repaint_navigator) {
            final DisplayablePanel dp = this.ht_panels.get(displ);
            if (null != dp) {
                Utils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dp.repaint();
                    }
                });
            }
            this.navigator.repaint(true);
        }
    }

    public static void repaintSnapshot(Displayable displ) {
        for (Display d : al_displays) {
            if (!d.layer.contains(displ) || d.navigator.isPainted(displ)) continue;
            DisplayablePanel dp = d.ht_panels.get(displ);
            if (null != dp) {
                dp.repaint();
            }
            d.navigator.repaint(displ);
        }
    }

    public static void repaint(Layer layer, Rectangle r, int extra) {
        Display.repaint(layer, extra, r, true, true);
    }

    public static void repaint(Layer layer, int extra, Rectangle r, boolean update_navigator) {
        Display.repaint(layer, extra, r, update_navigator, true);
    }

    public static void repaint(Layer layer, int extra, Rectangle r, boolean update_navigator, boolean update_graphics) {
        if (repaint_disabled) {
            return;
        }
        for (Display d : al_displays) {
            if (layer != d.layer) continue;
            d.canvas.setUpdateGraphics(update_graphics);
            d.canvas.repaint(r, extra);
            if (!update_navigator) continue;
            d.navigator.repaint(true);
            Utils.updateComponent(d.tabs.getSelectedComponent());
        }
    }

    public static void repaint(Layer layer, Rectangle r, int extra, boolean update_graphics) {
        if (repaint_disabled) {
            return;
        }
        for (Display d : al_displays) {
            if (layer != d.layer) continue;
            d.canvas.setUpdateGraphics(update_graphics);
            d.canvas.repaint(r, extra);
            d.navigator.repaint(update_graphics);
            if (!update_graphics) continue;
            Utils.updateComponent(d.tabs.getSelectedComponent());
        }
    }

    public static void repaint(Layer layer, Displayable displ) {
        if (repaint_disabled) {
            return;
        }
        for (Display d : al_displays) {
            if (layer != d.layer) continue;
            DisplayablePanel dp = d.ht_panels.get(displ);
            if (null != dp) {
                dp.repaint();
            }
            d.navigator.repaint(true);
        }
    }

    public static void repaint(LayerSet set, Displayable displ, int extra) {
        Display.repaint(set, displ, null, extra);
    }

    public static void repaint(LayerSet set, Displayable displ, Rectangle r, int extra) {
        Display.repaint(set, displ, r, extra, true);
    }

    public static void repaint(LayerSet set, Displayable displ, Rectangle r, int extra, boolean repaint_navigator) {
        if (repaint_disabled) {
            return;
        }
        if (null == set) {
            return;
        }
        for (Display d : al_displays) {
            if (d.layer.getParent() != set) continue;
            if (repaint_navigator) {
                DisplayablePanel dp;
                if (null != displ && null != (dp = d.ht_panels.get(displ))) {
                    dp.repaint();
                }
                d.navigator.repaint(true);
            }
            if (null == displ || displ != d.active || displ instanceof ImageData) {
                d.setUpdateGraphics(true);
            }
            if (null != r) {
                d.canvas.repaint(r, extra);
                continue;
            }
            d.canvas.repaint(displ, extra);
        }
    }

    public static void repaint(LayerSet set) {
        if (repaint_disabled) {
            return;
        }
        for (Display d : al_displays) {
            if (d.layer.getParent() != set) continue;
            d.navigator.repaint(true);
            d.canvas.repaint(true);
        }
    }

    public static void repaint(LayerSet set, Rectangle box) {
        if (repaint_disabled) {
            return;
        }
        for (Display d : al_displays) {
            if (d.layer.getParent() != set) continue;
            d.navigator.repaint(box);
            d.canvas.repaint(box, 0, true);
        }
    }

    public static void repaint(Layer layer) {
        if (repaint_disabled) {
            return;
        }
        for (Display d : al_displays) {
            if (layer != d.layer) continue;
            d.navigator.repaint(true);
            d.canvas.repaint(true);
        }
    }

    public static void repaint() {
        if (repaint_disabled) {
            Utils.logAll("Can't repaint -- repainting is disabled!");
            return;
        }
        for (Display d : al_displays) {
            d.navigator.repaint(true);
            d.canvas.repaint(true);
        }
    }

    protected static void setRepaint(boolean b) {
        repaint_disabled = !b;
    }

    public Rectangle getBounds() {
        return this.frame.getBounds();
    }

    public java.awt.Point getLocation() {
        return this.frame.getLocation();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabs;
    }

    public int addTab(String title, Component comp) {
        this.tabs.add(title, comp);
        return this.tabs.getTabCount() - 1;
    }

    public void setLocation(java.awt.Point p) {
        this.frame.setLocation(p);
    }

    public Displayable getActive() {
        return this.active;
    }

    public void select(Displayable d) {
        this.select(d, false);
    }

    public void select(Displayable d, boolean shift_down) {
        if (null != this.active && this.active != d && this.active.getClass() != Patch.class) {
            String prop = this.active.getClass() == DLabel.class ? this.project.getProperty("label_nolinks") : this.project.getProperty("segmentations_nolinks");
            HashSet<Displayable> glinked = null;
            if ((null == prop || !prop.equals("true")) && this.active.linkPatches()) {
                glinked = this.active.getLinkedGroup(null);
                Display.updateCheckboxes(glinked, 1, true);
            }
            Display.updateCheckboxes(null == glinked ? this.active.getLinkedGroup(null) : glinked, 4);
        }
        if (null == d) {
            this.canvas.setUpdateGraphics(true);
            this.selection.clear();
            return;
        }
        if (!shift_down) {
            if (d != this.active) {
                this.selection.clear();
                this.selection.add(d);
            }
        } else if (this.selection.contains(d)) {
            if (this.active == d) {
                this.selection.remove(d);
            } else {
                this.selection.setActive(d);
            }
        } else {
            this.selection.add(d);
        }
    }

    protected void choose(int screen_x_p, int screen_y_p, int x_p, int y_p, Class<?> c) {
        this.choose(screen_x_p, screen_y_p, x_p, y_p, false, c);
    }

    protected void choose(int screen_x_p, int screen_y_p, int x_p, int y_p) {
        this.choose(screen_x_p, screen_y_p, x_p, y_p, false, null);
    }

    protected void choose(int screen_x_p, int screen_y_p, int x_p, int y_p, boolean shift_down, Class<?> c) {
        ArrayList<Displayable> al = new ArrayList<Displayable>(this.layer.find(x_p, (double)y_p, true));
        al.addAll(this.layer.getParent().findZDisplayables(this.layer, x_p, y_p, true));
        if (al.isEmpty()) {
            Displayable act = this.active;
            this.selection.clear();
            this.canvas.setUpdateGraphics(true);
            if (null != act) {
                Display.repaint(this.layer, act, 5);
            }
        } else if (1 == al.size()) {
            Displayable d = al.get(0);
            if (null != c && d.getClass() != c) {
                this.selection.clear();
                return;
            }
            this.select(d, shift_down);
        } else if (!al.contains(this.active) || shift_down) {
            if (null != c) {
                Iterator<Displayable> it = al.iterator();
                while (it.hasNext()) {
                    Displayable ob = it.next();
                    if (ob.getClass() == c) continue;
                    it.remove();
                }
                if (0 == al.size()) {
                    this.selection.clear();
                    return;
                }
                if (1 == al.size()) {
                    this.select(al.get(0), shift_down);
                    return;
                }
            }
            this.choose(screen_x_p, screen_y_p, al, shift_down, x_p, y_p);
        }
    }

    private void choose(final int screen_x_p, final int screen_y_p, final Collection<Displayable> al, final boolean shift_down, final int x_p, final int y_p) {
        new Thread(){
            {
                this.setPriority(5);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock = new Object();
                DisplayableChooser d_chooser = new DisplayableChooser(al, lock);
                final JPopupMenu pop = new JPopupMenu("Select:");
                for (Displayable d : al) {
                    JMenuItem menu_item = new JMenuItem(d.toString());
                    menu_item.addActionListener(d_chooser);
                    pop.add(menu_item);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pop.show((Component)((Object)Display.this.canvas), screen_x_p, screen_y_p);
                    }
                });
                Object object = lock;
                synchronized (object) {
                    do {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (d_chooser.isWaiting() && pop.isShowing());
                }
                Displayable d = d_chooser.getChosen();
                if (null == d) {
                    Utils.log2("Display.choose: returning a null!");
                }
                Display.this.select(d, shift_down);
                pop.setVisible(false);
                Display.this.getMode().mouseReleased(null, x_p, y_p, x_p, y_p, x_p, y_p);
            }
        }.start();
    }

    protected void setActive(final Displayable displ) {
        final Displayable prev_active = this.active;
        this.active = displ;
        Utils.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (null != displ && displ == prev_active && Display.this.tabs.getSelectedComponent() != Display.this.annot_panel) {
                    Display.this.selectTab(displ);
                    return;
                }
                if (null != prev_active) {
                    Display.this.canvas.repaint(Display.this.selection.getBox(), 4);
                    HashMap hashMap = annot_docs;
                    synchronized (hashMap) {
                        boolean remove_doc = true;
                        for (Display d : al_displays) {
                            if (prev_active != d.active) continue;
                            remove_doc = false;
                            break;
                        }
                        if (remove_doc) {
                            annot_docs.remove(prev_active);
                        }
                    }
                }
                if (null != displ) {
                    Display.this.updateInDatabase("active_displayable_id");
                    if (displ.getClass() != Patch.class) {
                        Display.this.project.select(displ);
                    }
                    if (Display.this.tabs.getSelectedComponent() != Display.this.annot_panel) {
                        Display.this.selectTab(displ);
                    }
                    boolean update_graphics = null == prev_active || Display.this.paintsBelow(prev_active, displ);
                    Display.this.repaint(displ, null, 5, false, update_graphics);
                    Display.this.transp_slider.setValue((int)(displ.getAlpha() * 100.0f));
                    HashMap hashMap = annot_docs;
                    synchronized (hashMap) {
                        Display.this.annot_label.setText(displ.toString());
                        Document doc = (Document)annot_docs.get(displ);
                        if (null == doc) {
                            doc = Display.this.annot_editor.getEditorKit().createDefaultDocument();
                            doc.addDocumentListener(new DocumentListener(){

                                @Override
                                public void changedUpdate(DocumentEvent e) {
                                }

                                @Override
                                public void insertUpdate(DocumentEvent e) {
                                    this.push();
                                }

                                @Override
                                public void removeUpdate(DocumentEvent e) {
                                    this.push();
                                }

                                private void push() {
                                    displ.setAnnotation(Display.this.annot_editor.getText());
                                }
                            });
                            annot_docs.put(displ, doc);
                        }
                        Display.this.annot_editor.setDocument(doc);
                        if (null != displ.getAnnotation()) {
                            Display.this.annot_editor.setText(displ.getAnnotation());
                        }
                    }
                    Display.this.annot_editor.setEnabled(true);
                } else {
                    Utils.updateComponent(Display.this.tabs.getSelectedComponent());
                    Display.this.annot_label.setText("(No selected object)");
                    Display.this.annot_editor.setDocument(Display.this.annot_editor.getEditorKit().createDefaultDocument());
                    Display.this.annot_editor.setEnabled(false);
                }
            }
        });
    }

    public boolean paintsBelow(Displayable base, Displayable other) {
        boolean zd_base = base instanceof ZDisplayable;
        boolean zd_other = other instanceof ZDisplayable;
        if (zd_other) {
            if (base instanceof DLabel) {
                return true;
            }
            if (!zd_base) {
                return false;
            }
            ArrayList<ZDisplayable> al = other.getLayerSet().getZDisplayables();
            return al.indexOf(base) > al.indexOf(other);
        }
        if (!zd_base) {
            ArrayList<Displayable> al = other.getLayer().getDisplayables();
            return al.indexOf(base) > al.indexOf(other);
        }
        return !(other instanceof DLabel);
    }

    private void selectTab(final Displayable displ) {
        Method method = null;
        try {
            if (!(displ instanceof LayerSet)) {
                method = Display.class.getDeclaredMethod("selectTab", displ.getClass());
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        if (null != method) {
            final Method me = method;
            this.dispatcher.exec(new Runnable(){

                @Override
                public void run() {
                    try {
                        me.setAccessible(true);
                        me.invoke((Object)Display.this, displ);
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                }
            });
        }
    }

    private void selectTab(Patch patch) {
        this.tabs.setSelectedComponent(this.panel_patches);
        this.panel_patches.scrollToShow(patch);
    }

    private void selectTab(Profile profile) {
        this.tabs.setSelectedComponent(this.panel_profiles);
        this.panel_profiles.scrollToShow(profile);
    }

    private void selectTab(DLabel label) {
        this.tabs.setSelectedComponent(this.panel_labels);
        this.panel_labels.scrollToShow(label);
    }

    private void selectTab(ZDisplayable zd) {
        this.tabs.setSelectedComponent(this.panel_zdispl);
        this.panel_zdispl.scrollToShow(zd);
    }

    private void selectTab(Pipe d) {
        this.selectTab((ZDisplayable)d);
    }

    private void selectTab(Polyline d) {
        this.selectTab((ZDisplayable)d);
    }

    private void selectTab(Treeline d) {
        this.selectTab((ZDisplayable)d);
    }

    private void selectTab(AreaTree d) {
        this.selectTab((ZDisplayable)d);
    }

    private void selectTab(Connector d) {
        this.selectTab((ZDisplayable)d);
    }

    private void selectTab(AreaList d) {
        this.selectTab((ZDisplayable)d);
    }

    private void selectTab(Ball d) {
        this.selectTab((ZDisplayable)d);
    }

    private void selectTab(Dissector d) {
        this.selectTab((ZDisplayable)d);
    }

    private void selectTab(Stack d) {
        this.selectTab((ZDisplayable)d);
    }

    private void updateTab(Container tab) {
        if (tab instanceof RollingPanel) {
            ((RollingPanel)tab).updateList();
        }
    }

    public static void setActive(Object event, Displayable displ) {
        if (!(event instanceof InputEvent)) {
            return;
        }
        for (Display d : al_displays) {
            if (!d.isOrigin((InputEvent)event)) continue;
            d.setActive(displ);
            break;
        }
    }

    public boolean isTransforming() {
        return this.canvas.isTransforming();
    }

    public static boolean isTransforming(Displayable displ) {
        for (Display d : al_displays) {
            if (null == d.active || d.active != displ || !d.canvas.isTransforming()) continue;
            return true;
        }
        return false;
    }

    private boolean isOrigin(InputEvent event) {
        Object source = event.getSource();
        return this.canvas == source;
    }

    public static Layer getFrontLayer() {
        Display d = front;
        if (null == d) {
            return null;
        }
        return d.layer;
    }

    public static Layer getFrontLayer(Project project) {
        Display df = front;
        if (null == df) {
            return null;
        }
        if (df.project == project) {
            return df.layer;
        }
        for (Display d : al_displays) {
            if (d.project != project) continue;
            d.frame.toFront();
            return d.layer;
        }
        return null;
    }

    public static Display getFront(Project project) {
        Display df = front;
        if (null == df) {
            return null;
        }
        if (df.project == project) {
            return df;
        }
        for (Display d : al_displays) {
            if (d.project != project) continue;
            d.frame.toFront();
            return d;
        }
        return null;
    }

    public static List<Displayable> getSelected() {
        Display d = front;
        if (null == d) {
            return new ArrayList<Displayable>();
        }
        return d.selection.getSelected();
    }

    public static List<? extends Displayable> getSelected(Class<? extends Displayable> c) {
        Display d = front;
        if (null == d) {
            return new ArrayList();
        }
        return d.selection.getSelected(c);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected void showPopup(Component c, int x, int y) {
        Display d = front;
        if (null == d) {
            return;
        }
        d.getPopupMenu().show(c, x, y);
    }

    protected JPopupMenu getPopupMenu() {
        Class<?> aclass;
        if (!this.canvas.isInputEnabled()) {
            return this.project.getLoader().getJobsPopup(this);
        }
        this.popup = new JPopupMenu();
        JMenuItem item = null;
        JMenu menu = null;
        if (this.mode instanceof InspectPatchTrianglesMode) {
            item = new JMenuItem("Exit inspection");
            item.addActionListener(this);
            this.popup.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(27, 0, true));
            return this.popup;
        }
        if (this.canvas.isTransforming()) {
            item = new JMenuItem("Apply transform");
            item.addActionListener(this);
            this.popup.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(10, 0, true));
            item = new JMenuItem("Apply transform propagating to last layer");
            item.addActionListener(this);
            this.popup.add(item);
            if (this.layer.getParent().indexOf(this.layer) == this.layer.getParent().size() - 1) {
                item.setEnabled(false);
            }
            if (this.getMode().getClass() != AffineTransformMode.class && this.getMode().getClass() != NonLinearTransformMode.class) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Apply transform propagating to first layer");
            item.addActionListener(this);
            this.popup.add(item);
            if (0 == this.layer.getParent().indexOf(this.layer)) {
                item.setEnabled(false);
            }
            if (this.getMode().getClass() != AffineTransformMode.class && this.getMode().getClass() != NonLinearTransformMode.class) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Cancel transform");
            item.addActionListener(this);
            this.popup.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(27, 0, true));
            item = new JMenuItem("Specify transform...");
            item.addActionListener(this);
            this.popup.add(item);
            if (this.getMode().getClass() != AffineTransformMode.class) {
                item.setEnabled(false);
            }
            if (this.getMode().getClass() == ManualAlignMode.class) {
                final JMenuItem lexport = new JMenuItem("Export landmarks");
                this.popup.add(lexport);
                final JMenuItem limport = new JMenuItem("Import landmarks");
                this.popup.add(limport);
                ActionListener a = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ManualAlignMode mam = (ManualAlignMode)Display.this.getMode();
                        Object source = ae.getSource();
                        if (lexport == source) {
                            mam.exportLandmarks();
                        } else if (limport == source) {
                            mam.importLandmarks();
                        }
                    }
                };
                lexport.addActionListener(a);
                limport.addActionListener(a);
            }
            return this.popup;
        }
        Class<?> clazz = aclass = null == this.active ? null : this.active.getClass();
        if (null != this.active) {
            if (Profile.class == aclass) {
                item = new JMenuItem("Duplicate, link and send to next layer");
                item.addActionListener(this);
                this.popup.add(item);
                Layer nl = this.layer.getParent().next(this.layer);
                if (nl == this.layer) {
                    item.setEnabled(false);
                }
                item = new JMenuItem("Duplicate, link and send to previous layer");
                item.addActionListener(this);
                this.popup.add(item);
                nl = this.layer.getParent().previous(this.layer);
                if (nl == this.layer) {
                    item.setEnabled(false);
                }
                menu = new JMenu("Duplicate, link and send to");
                int i = 1;
                for (Layer la : this.layer.getParent().getLayers()) {
                    item = new JMenuItem(i + ": z = " + la.getZ());
                    item.addActionListener(this);
                    menu.add(item);
                    if (la == this.layer) {
                        item.setEnabled(false);
                    }
                    ++i;
                }
                this.popup.add(menu);
                item = new JMenuItem("Duplicate, link and send to...");
                item.addActionListener(this);
                this.popup.add(item);
                this.popup.addSeparator();
                item = new JMenuItem("Unlink from images");
                item.addActionListener(this);
                this.popup.add(item);
                if (!this.active.isLinked()) {
                    item.setEnabled(false);
                }
                item = new JMenuItem("Show in 3D");
                item.addActionListener(this);
                this.popup.add(item);
                this.popup.addSeparator();
            } else if (Patch.class == aclass) {
                JMenu m = new JMenu("Patch");
                item = new JMenuItem("Fill ROI in alpha mask");
                item.addActionListener(this);
                m.add(item);
                item.setAccelerator(KeyStroke.getKeyStroke(70, 0));
                item.setEnabled(null != this.getRoi());
                item = new JMenuItem("Fill inverse ROI in alpha mask");
                item.addActionListener(this);
                m.add(item);
                item.setAccelerator(KeyStroke.getKeyStroke(70, 1));
                item.setEnabled(null != this.getRoi());
                item = new JMenuItem("Remove alpha mask");
                item.addActionListener(this);
                m.add(item);
                if (!((Patch)this.active).hasAlphaMask()) {
                    item.setEnabled(false);
                }
                item = new JMenuItem("Unlink from images");
                item.addActionListener(this);
                m.add(item);
                if (!this.active.isLinked(Patch.class)) {
                    item.setEnabled(false);
                }
                if (((Patch)this.active).isStack()) {
                    item = new JMenuItem("Unlink slices");
                    item.addActionListener(this);
                    m.add(item);
                }
                int n_sel_patches = this.selection.getSelected(Patch.class).size();
                item = new JMenuItem("Snap");
                item.addActionListener(this);
                m.add(item);
                item.setEnabled(1 == n_sel_patches);
                item = new JMenuItem("Montage");
                item.addActionListener(this);
                m.add(item);
                item.setEnabled(n_sel_patches > 1);
                item = new JMenuItem("Lens correction");
                item.addActionListener(this);
                m.add(item);
                item.setEnabled(n_sel_patches > 1);
                item = new JMenuItem("Blend");
                item.addActionListener(this);
                m.add(item);
                item.setEnabled(n_sel_patches > 1);
                item = new JMenuItem("Open image");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (Patch p : Display.this.selection.get(Patch.class)) {
                            p.getImagePlus().show();
                        }
                    }
                });
                m.add(item);
                item.setAccelerator(KeyStroke.getKeyStroke(68, 1, true));
                item = new JMenuItem("Open original image");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (Patch p : Display.this.selection.get(Patch.class)) {
                            p.getProject().getLoader().releaseToFit(p.getOWidth(), p.getOHeight(), p.getType(), 5.0f);
                            p.getProject().getLoader().openImagePlus(p.getImageFilePath()).show();
                        }
                    }
                });
                item = new JMenuItem("View volume");
                item.addActionListener(this);
                m.add(item);
                HashSet<Displayable> hs = this.active.getLinked(Patch.class);
                if (null == hs || 0 == hs.size()) {
                    item.setEnabled(false);
                }
                item = new JMenuItem("View orthoslices");
                item.addActionListener(this);
                m.add(item);
                if (null == hs || 0 == hs.size()) {
                    item.setEnabled(false);
                }
                this.popup.add(m);
                this.popup.addSeparator();
            } else {
                item = new JMenuItem("Unlink");
                item.addActionListener(this);
                this.popup.add(item);
                item = new JMenuItem("Show in 3D");
                item.addActionListener(this);
                this.popup.add(item);
                this.popup.addSeparator();
            }
            if (AreaList.class == aclass) {
                ArrayList<Displayable> al = this.selection.getSelected();
                int n = 0;
                Iterator<Displayable> it = al.iterator();
                while (it.hasNext()) {
                    if (it.next().getClass() != AreaList.class) continue;
                    ++n;
                }
                item = new JMenuItem("Merge");
                item.addActionListener(this);
                this.popup.add(item);
                if (n < 2) {
                    item.setEnabled(false);
                }
                item = new JMenuItem("Split");
                item.addActionListener(this);
                this.popup.add(item);
                if (n < 1) {
                    item.setEnabled(false);
                }
                this.addAreaListAreasMenu(this.popup, this.active);
                this.popup.addSeparator();
            } else if (Pipe.class == aclass) {
                item = new JMenuItem("Reverse point order");
                item.addActionListener(this);
                this.popup.add(item);
                this.popup.addSeparator();
            } else if (Treeline.class == aclass || AreaTree.class == aclass) {
                Object nodeRadius;
                if (AreaTree.class == aclass) {
                    this.addAreaTreeAreasMenu(this.popup, (AreaTree)this.active);
                }
                item = new JMenuItem("Reroot");
                item.addActionListener(this);
                this.popup.add(item);
                item = new JMenuItem("Part subtree");
                item.addActionListener(this);
                this.popup.add(item);
                item = new JMenuItem("Join");
                item.addActionListener(this);
                this.popup.add(item);
                item = new JMenuItem("Show tabular view");
                item.addActionListener(this);
                this.popup.add(item);
                final List<Tree> trees = this.selection.get(Tree.class);
                JMenu nodeMenu = new JMenu("Nodes");
                item = new JMenuItem("Mark");
                item.addActionListener(this);
                nodeMenu.add(item);
                item = new JMenuItem("Clear marks (selected Trees)");
                item.addActionListener(this);
                nodeMenu.add(item);
                final JMenuItem nodeColor = new JMenuItem("Color...");
                nodeMenu.add(nodeColor);
                nodeColor.setAccelerator(KeyStroke.getKeyStroke(67, 1, true));
                final JMenuItem nodePairColor = new JMenuItem("Color path between two nodes tagged as...");
                nodeMenu.add(nodePairColor);
                Object object = nodeRadius = this.active instanceof Treeline ? new JMenuItem("Radius...") : null;
                if (null != nodeRadius) {
                    nodeMenu.add((JMenuItem)nodeRadius);
                    ((JMenuItem)nodeRadius).setAccelerator(KeyStroke.getKeyStroke(79, 0, true));
                }
                JMenuItem removeAllTags = new JMenuItem("Drop all tags (selected trees)");
                nodeMenu.add(removeAllTags);
                JMenuItem removeTag = new JMenuItem("Drop all occurrences of tag...");
                nodeMenu.add(removeTag);
                JMenuItem colorizeByNodeCentrality = new JMenuItem("Colorize by node betweenness centrality");
                nodeMenu.add(colorizeByNodeCentrality);
                JMenuItem colorizeByBranchCentrality = new JMenuItem("Colorize by branch betweenness centrality");
                nodeMenu.add(colorizeByBranchCentrality);
                this.popup.add(nodeMenu);
                ActionListener ln = new ActionListener((JMenuItem)nodeRadius, removeAllTags, removeTag, colorizeByNodeCentrality, colorizeByBranchCentrality){
                    final /* synthetic */ JMenuItem val$nodeRadius;
                    final /* synthetic */ JMenuItem val$removeAllTags;
                    final /* synthetic */ JMenuItem val$removeTag;
                    final /* synthetic */ JMenuItem val$colorizeByNodeCentrality;
                    final /* synthetic */ JMenuItem val$colorizeByBranchCentrality;
                    {
                        this.val$nodeRadius = jMenuItem3;
                        this.val$removeAllTags = jMenuItem4;
                        this.val$removeTag = jMenuItem5;
                        this.val$colorizeByNodeCentrality = jMenuItem6;
                        this.val$colorizeByBranchCentrality = jMenuItem7;
                    }

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (null == Display.this.active) {
                            Utils.showMessage("No tree selected!");
                            return;
                        }
                        if (!(Display.this.active instanceof Tree)) {
                            Utils.showMessage("The selected object is not a Tree!");
                            return;
                        }
                        Tree tree = (Tree)Display.this.active;
                        Object src = ae.getSource();
                        if (src == nodeColor) {
                            Node nd = tree.getLastVisited();
                            if (null == nd) {
                                Utils.showMessage("Select a node first by clicking on it\nor moving the mouse over it and pushing 'g'.");
                                return;
                            }
                            tree.adjustNodeColors(nd);
                        } else if (src == nodePairColor) {
                            Tag downstreamTag;
                            TreeMap sm = Display.getTags(tree);
                            if (null == sm) {
                                return;
                            }
                            if (1 == sm.size()) {
                                Utils.showMessage("Need at least two different tags in the tree!");
                                return;
                            }
                            Color color = tree.getColor();
                            GenericDialog gd = new GenericDialog("Node colors");
                            gd.addSlider("Red: ", 0.0, 255.0, (double)color.getRed());
                            gd.addSlider("Green: ", 0.0, 255.0, (double)color.getGreen());
                            gd.addSlider("Blue: ", 0.0, 255.0, (double)color.getBlue());
                            String[] stags = Display.asStrings(sm);
                            sm.keySet().toArray(stags);
                            gd.addChoice("Upstream tag:", stags, stags[0]);
                            gd.addChoice("Downstream tag:", stags, stags[1]);
                            gd.showDialog();
                            if (gd.wasCanceled()) {
                                return;
                            }
                            Color newColor = new Color((int)gd.getNextNumber(), (int)gd.getNextNumber(), (int)gd.getNextNumber());
                            Tag upstreamTag = (Tag)sm.get(gd.getNextChoice());
                            List<Tree.NodePath> list = tree.findTaggedPairs(upstreamTag, downstreamTag = (Tag)sm.get(gd.getNextChoice()));
                            if (null == list || list.isEmpty()) {
                                Utils.showMessage("No pairs found for '" + upstreamTag + "' and '" + downstreamTag + "'");
                                return;
                            }
                            Display.this.getLayerSet().addDataEditStep(tree);
                            for (Tree.NodePath pair : list) {
                                for (Node nd : pair.path) {
                                    nd.setColor(newColor);
                                }
                            }
                            Display.this.getLayerSet().addDataEditStep(tree);
                            Display.repaint();
                        } else if (src == this.val$nodeRadius) {
                            if (!(tree instanceof Treeline)) {
                                return;
                            }
                            Node<Float> nd = tree.getLastVisited();
                            if (null == nd) {
                                Utils.showMessage("Select a node first by clicking on it\nor moving the mouse over it and pushing 'g'.");
                                return;
                            }
                            ((Treeline)tree).askAdjustRadius(nd);
                        } else if (src == this.val$removeAllTags) {
                            if (!Utils.check("Really remove all tags from all selected trees?")) {
                                return;
                            }
                            List<Tree> sel = Display.this.selection.get(Tree.class);
                            Display.this.getLayerSet().addDataEditStep(new HashSet<Tree>(sel));
                            try {
                                for (Tree t : sel) {
                                    t.dropAllTags();
                                }
                                Display.this.getLayerSet().addDataEditStep(new HashSet<Tree>(sel));
                            }
                            catch (Exception e) {
                                Display.this.getLayerSet().undoOneStep();
                                IJError.print(e);
                            }
                            Display.repaint();
                        } else if (src == this.val$removeTag) {
                            TreeMap tags = Display.getTags(tree);
                            String[] ts = Display.asStrings(tags);
                            GenericDialog gd = new GenericDialog("Remove tags");
                            gd.addChoice("Tag:", ts, ts[0]);
                            String[] c = new String[]{"Active tree", "All selected trees and connectors", "All trees and connectors"};
                            gd.addChoice("From: ", c, c[0]);
                            gd.showDialog();
                            if (gd.wasCanceled()) {
                                return;
                            }
                            HashSet<ZDisplayable> ds = new HashSet<ZDisplayable>();
                            Tag tag = (Tag)tags.get(gd.getNextChoice());
                            switch (gd.getNextChoiceIndex()) {
                                case 0: {
                                    ds.add(tree);
                                    break;
                                }
                                case 1: {
                                    ds.addAll(Display.this.selection.get(Tree.class));
                                }
                                case 2: {
                                    ds.addAll(Display.this.getLayerSet().getZDisplayables(Tree.class, true));
                                }
                            }
                            Display.this.getLayerSet().addDataEditStep(ds);
                            try {
                                for (Displayable displayable : ds) {
                                    Tree t = (Tree)displayable;
                                    t.removeTag(tag);
                                }
                                Display.this.getLayerSet().addDataEditStep(ds);
                            }
                            catch (Exception e) {
                                Display.this.getLayerSet().undoOneStep();
                                IJError.print(e);
                            }
                            Display.repaint();
                        } else if (src == this.val$colorizeByNodeCentrality) {
                            List<Tree> ts = Display.this.selection.get(Tree.class);
                            HashSet<Tree> ds = new HashSet<Tree>(ts);
                            Display.this.getLayerSet().addDataEditStep(ds);
                            try {
                                for (Tree t : ts) {
                                    t.colorizeByNodeBetweennessCentrality();
                                }
                                Display.this.getLayerSet().addDataEditStep(ds);
                                Display.repaint();
                            }
                            catch (Exception e) {
                                Display.this.getLayerSet().undoOneStep();
                                IJError.print(e);
                            }
                        } else if (src == this.val$colorizeByBranchCentrality) {
                            List<Tree> ts = Display.this.selection.get(Tree.class);
                            HashSet<Tree> ds = new HashSet<Tree>(ts);
                            Display.this.getLayerSet().addDataEditStep(ds);
                            try {
                                for (Tree t : ts) {
                                    t.colorizeByBranchBetweennessCentrality(2);
                                }
                                Display.this.getLayerSet().addDataEditStep(ds);
                                Display.repaint();
                            }
                            catch (Exception e) {
                                Display.this.getLayerSet().undoOneStep();
                                IJError.print(e);
                            }
                        }
                    }
                };
                for (JMenuItem a : new JMenuItem[]{nodeColor, nodePairColor, nodeRadius, removeAllTags, removeTag, colorizeByNodeCentrality, colorizeByBranchCentrality}) {
                    if (null == a) continue;
                    a.addActionListener(ln);
                }
                JMenu review = new JMenu("Review");
                final JMenuItem tgenerate = new JMenuItem("Generate review stacks (selected Trees)");
                review.add(tgenerate);
                tgenerate.setEnabled(trees.size() > 0);
                final JMenuItem tslab = new JMenuItem("Generate review stack for current slab");
                review.add(tslab);
                final JMenuItem tsubtree = new JMenuItem("Generate review stacks for subtree");
                review.add(tsubtree);
                final JMenuItem tremove = new JMenuItem("Remove reviews (selected Trees)");
                review.add(tremove);
                tremove.setEnabled(trees.size() > 0);
                JMenuItem tconnectors = new JMenuItem("View table of outgoing/incoming connectors");
                review.add(tconnectors);
                ActionListener l = new ActionListener(){

                    @Override
                    public void actionPerformed(final ActionEvent ae) {
                        if (!Utils.check("Really " + ae.getActionCommand())) {
                            return;
                        }
                        Display.this.dispatcher.exec(new Runnable(){

                            @Override
                            public void run() {
                                int count = 0;
                                for (Tree t : trees) {
                                    java.awt.Point po;
                                    Utils.log("Processing " + ++count + "/" + trees.size());
                                    Bureaucrat bu = null;
                                    if (ae.getSource() == tgenerate) {
                                        bu = t.generateAllReviewStacks();
                                    } else if (ae.getSource() == tremove) {
                                        bu = t.removeReviews();
                                    } else if (ae.getSource() == tslab) {
                                        po = Display.this.canvas.consumeLastPopupPoint();
                                        Utils.log2(po, Display.this.layer, 1.0);
                                        bu = t.generateReviewStackForSlab(po.x, po.y, Display.this.layer, 1.0);
                                    } else if (ae.getSource() == tsubtree) {
                                        po = Display.this.canvas.consumeLastPopupPoint();
                                        bu = t.generateSubtreeReviewStacks(po.x, po.y, Display.this.layer, 1.0);
                                    }
                                    if (null == bu) continue;
                                    try {
                                        bu.getWorker().join();
                                    }
                                    catch (InterruptedException ie) {
                                        return;
                                    }
                                }
                            }
                        });
                    }
                };
                for (JMenuItem c : new JMenuItem[]{tgenerate, tslab, tsubtree, tremove}) {
                    c.addActionListener(l);
                }
                tconnectors.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        for (Tree t : trees) {
                            TreeConnectorsView.create(t);
                        }
                    }
                });
                this.popup.add(review);
                JMenu go = new JMenu("Go");
                item = new JMenuItem("Previous branch node or start");
                item.addActionListener(this);
                go.add(item);
                item.setAccelerator(KeyStroke.getKeyStroke(66, 0, true));
                item = new JMenuItem("Next branch node or end");
                item.addActionListener(this);
                go.add(item);
                item.setAccelerator(KeyStroke.getKeyStroke(78, 0, true));
                item = new JMenuItem("Root");
                item.addActionListener(this);
                go.add(item);
                item.setAccelerator(KeyStroke.getKeyStroke(82, 0, true));
                go.addSeparator();
                item = new JMenuItem("Last added node");
                item.addActionListener(this);
                go.add(item);
                item.setAccelerator(KeyStroke.getKeyStroke(76, 0, true));
                item = new JMenuItem("Last edited node");
                item.addActionListener(this);
                go.add(item);
                item.setAccelerator(KeyStroke.getKeyStroke(69, 0, true));
                this.popup.add(go);
                JMenu tmeasure = new JMenu("Measure");
                JMenuItem dist_to_root = new JMenuItem("Distance from this node to root");
                tmeasure.add(dist_to_root);
                JMenuItem dist_to_tag = new JMenuItem("Distance from this node to all nodes tagged as...");
                tmeasure.add(dist_to_tag);
                JMenuItem dist_to_mark = new JMenuItem("Distance from this node to the marked node");
                tmeasure.add(dist_to_mark);
                JMenuItem dist_pairs = new JMenuItem("Shortest distances between all pairs of nodes tagged as...");
                tmeasure.add(dist_pairs);
                ActionListener tma = this.getTreePathMeasureListener((Tree)this.active);
                for (JMenuItem mi : new JMenuItem[]{dist_to_root, dist_to_tag, dist_to_mark, dist_pairs}) {
                    mi.addActionListener(tma);
                }
                this.popup.add(tmeasure);
                String[] name = new String[]{AreaTree.class.getSimpleName(), Treeline.class.getSimpleName()};
                if (Treeline.class == aclass) {
                    String a = name[0];
                    name[0] = name[1];
                    name[1] = a;
                }
                item = new JMenuItem("Duplicate " + name[0] + " as " + name[1]);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Bureaucrat.createAndStart((Worker)new Worker.Task("Converting"){

                            @Override
                            public void exec() {
                                try {
                                    Display.this.getLayerSet().addChangeTreesStep();
                                    Map<Tree<?>, Tree<?>> m = Tree.duplicateAs(Display.this.selection.getSelected(), Treeline.class == aclass ? AreaTree.class : Treeline.class);
                                    if (m.isEmpty()) {
                                        Display.this.getLayerSet().removeLastUndoStep();
                                    } else {
                                        Display.this.getLayerSet().addChangeTreesStep();
                                    }
                                }
                                catch (Exception e) {
                                    IJError.print(e);
                                }
                            }
                        }, Display.this.getProject());
                    }
                });
                this.popup.add(item);
                this.popup.addSeparator();
            } else if (Connector.class == aclass) {
                item = new JMenuItem("Merge");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (null == Display.this.getActive() || Display.this.getActive().getClass() != Connector.class) {
                            Utils.log("Active object must be a Connector!");
                            return;
                        }
                        final List<Connector> col = Display.this.selection.get(Connector.class);
                        if (col.size() < 2) {
                            Utils.log("Select more than one Connector!");
                            return;
                        }
                        if (col.get(0) != Display.this.getActive()) {
                            if (col.remove(Display.this.getActive())) {
                                col.add(0, (Connector)Display.this.getActive());
                            } else {
                                Utils.log("ERROR: cannot find active object in selection list!");
                                return;
                            }
                        }
                        Bureaucrat.createAndStart((Worker)new Worker.Task("Merging connectors"){

                            @Override
                            public void exec() {
                                Display.this.getLayerSet().addChangeTreesStep();
                                Connector base = null;
                                try {
                                    base = Connector.merge(col);
                                }
                                catch (Exception e) {
                                    IJError.print(e);
                                }
                                if (null == base) {
                                    Utils.log("ERROR: could not merge connectors!");
                                    Display.this.getLayerSet().undoOneStep();
                                } else {
                                    Display.this.getLayerSet().addChangeTreesStep();
                                }
                                Display.repaint();
                            }
                        }, Display.this.getProject());
                    }
                });
                this.popup.add(item);
                item.setEnabled(this.selection.getSelected(Connector.class).size() > 1);
                this.popup.addSeparator();
            }
            item = new JMenuItem("Duplicate");
            item.addActionListener(this);
            this.popup.add(item);
            item = new JMenuItem("Color...");
            item.addActionListener(this);
            this.popup.add(item);
            if (this.active instanceof LayerSet) {
                item.setEnabled(false);
            }
            if (this.active.isLocked()) {
                item = new JMenuItem("Unlock");
                item.addActionListener(this);
                this.popup.add(item);
            } else {
                item = new JMenuItem("Lock");
                item.addActionListener(this);
                this.popup.add(item);
            }
            menu = new JMenu("Move");
            this.popup.addSeparator();
            LayerSet ls = this.layer.getParent();
            item = new JMenuItem("Move to top");
            item.addActionListener(this);
            menu.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(36, 0, true));
            if (ls.isTop(this.active)) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Move up");
            item.addActionListener(this);
            menu.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(33, 0, true));
            if (ls.isTop(this.active)) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Move down");
            item.addActionListener(this);
            menu.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(34, 0, true));
            if (ls.isBottom(this.active)) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Move to bottom");
            item.addActionListener(this);
            menu.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(35, 0, true));
            if (ls.isBottom(this.active)) {
                item.setEnabled(false);
            }
            this.popup.add(menu);
            this.popup.addSeparator();
            item = new JMenuItem("Delete...");
            item.addActionListener(this);
            this.popup.add(item);
            try {
                if (Patch.class == aclass && !this.active.isOnlyLinkedTo(Patch.class)) {
                    item.setEnabled(false);
                }
            }
            catch (Exception e) {
                IJError.print(e);
                item.setEnabled(false);
            }
            if (Patch.class == aclass) {
                item = new JMenuItem("Revert");
                item.addActionListener(this);
                this.popup.add(item);
                if (null == ((Patch)this.active).getOriginalPath()) {
                    item.setEnabled(false);
                }
                this.popup.addSeparator();
            }
            item = new JMenuItem("Properties...");
            item.addActionListener(this);
            this.popup.add(item);
            item = new JMenuItem("Show centered");
            item.addActionListener(this);
            this.popup.add(item);
            this.popup.addSeparator();
            if (!(this.active instanceof ZDisplayable)) {
                int i_layer = this.layer.getParent().indexOf(this.layer);
                int n_layers = this.layer.getParent().size();
                item = new JMenuItem("Send to previous layer");
                item.addActionListener(this);
                this.popup.add(item);
                if (1 == n_layers || 0 == i_layer || this.active.isLinked()) {
                    item.setEnabled(false);
                } else if (this.active instanceof Profile && !this.active.canSendTo(this.layer.getParent().previous(this.layer))) {
                    item.setEnabled(false);
                }
                item = new JMenuItem("Send to next layer");
                item.addActionListener(this);
                this.popup.add(item);
                if (1 == n_layers || n_layers - 1 == i_layer || this.active.isLinked()) {
                    item.setEnabled(false);
                } else if (this.active instanceof Profile && !this.active.canSendTo(this.layer.getParent().next(this.layer))) {
                    item.setEnabled(false);
                }
                menu = new JMenu("Send linked group to...");
                if (this.active.hasLinkedGroupWithinLayer(this.layer)) {
                    int i = 1;
                    for (Layer la : ls.getLayers()) {
                        String layer_title = i + ": " + la.getTitle();
                        if (-1 == layer_title.indexOf(32)) {
                            layer_title = layer_title + " ";
                        }
                        item = new JMenuItem(layer_title);
                        item.addActionListener(this);
                        menu.add(item);
                        if (la == this.layer) {
                            item.setEnabled(false);
                        }
                        ++i;
                    }
                    this.popup.add(menu);
                } else {
                    menu.setEnabled(false);
                }
                this.popup.add(menu);
                this.popup.addSeparator();
            }
        }
        item = new JMenuItem("Undo");
        item.addActionListener(this);
        this.popup.add(item);
        if (!this.layer.getParent().canUndo() || this.canvas.isTransforming()) {
            item.setEnabled(false);
        }
        item.setAccelerator(KeyStroke.getKeyStroke(90, Utils.getControlModifier(), true));
        item = new JMenuItem("Redo");
        item.addActionListener(this);
        this.popup.add(item);
        if (!this.layer.getParent().canRedo() || this.canvas.isTransforming()) {
            item.setEnabled(false);
        }
        item.setAccelerator(KeyStroke.getKeyStroke(90, 1 | Utils.getControlModifier(), true));
        this.popup.addSeparator();
        try {
            boolean none;
            menu = new JMenu("Hide/Unhide");
            item = new JMenuItem("Hide deselected");
            item.addActionListener(this);
            menu.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(72, 1, true));
            boolean bl = none = 0 == this.selection.getNSelected();
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Hide deselected except images");
            item.addActionListener(this);
            menu.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(72, 9, true));
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Hide selected");
            item.addActionListener(this);
            menu.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(72, 0, true));
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.getParent().containsDisplayable(DLabel.class);
            item = new JMenuItem("Hide all labels");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all labels");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.getParent().contains(AreaList.class);
            item = new JMenuItem("Hide all arealists");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all arealists");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.contains(Profile.class);
            item = new JMenuItem("Hide all profiles");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all profiles");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.getParent().contains(Pipe.class);
            item = new JMenuItem("Hide all pipes");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all pipes");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.getParent().contains(Polyline.class);
            item = new JMenuItem("Hide all polylines");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all polylines");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.getParent().contains(Treeline.class);
            item = new JMenuItem("Hide all treelines");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all treelines");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.getParent().contains(AreaTree.class);
            item = new JMenuItem("Hide all areatrees");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all areatrees");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.getParent().contains(Ball.class);
            item = new JMenuItem("Hide all balls");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all balls");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.getParent().contains(Connector.class);
            item = new JMenuItem("Hide all connectors");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all connectors");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            none = !this.layer.getParent().containsDisplayable(Patch.class);
            item = new JMenuItem("Hide all images");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Unhide all images");
            item.addActionListener(this);
            menu.add(item);
            if (none) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Hide all but images");
            item.addActionListener(this);
            menu.add(item);
            item = new JMenuItem("Unhide all");
            item.addActionListener(this);
            menu.add(item);
            item.setAccelerator(KeyStroke.getKeyStroke(72, 8, true));
            this.popup.add(menu);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        Utils.addPlugIns(this.popup, "Display", this.project, new Callable<Displayable>(){

            @Override
            public Displayable call() {
                return Display.this.getActive();
            }
        });
        JMenu align_menu = new JMenu("Align");
        item = new JMenuItem("Align stack slices");
        item.addActionListener(this);
        align_menu.add(item);
        if (this.selection.isEmpty() || this.getActive().getClass() != Patch.class || !((Patch)this.getActive()).isStack()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Align layers");
        item.addActionListener(this);
        align_menu.add(item);
        if (1 == this.layer.getParent().size()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Align layers manually with landmarks");
        item.addActionListener(this);
        align_menu.add(item);
        if (1 == this.layer.getParent().size()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Align multi-layer mosaic");
        item.addActionListener(this);
        align_menu.add(item);
        if (1 == this.layer.getParent().size()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Montage all images in this layer");
        item.addActionListener(this);
        align_menu.add(item);
        if (this.layer.getDisplayables(Patch.class).size() < 2) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Montage selected images");
        item.addActionListener(this);
        align_menu.add(item);
        if (this.selection.getSelected(Patch.class).size() < 2) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Montage multiple layers");
        item.addActionListener(this);
        align_menu.add(item);
        this.popup.add(align_menu);
        JMenu st = new JMenu("Transform");
        StartTransformMenuListener tml = new StartTransformMenuListener();
        item = new JMenuItem("Transform (affine)");
        item.addActionListener(tml);
        ((Container)st).add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(84, 0, true));
        if (null == this.active) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Transform (non-linear)");
        item.addActionListener(tml);
        ((Container)st).add(item);
        if (null == this.active) {
            item.setEnabled(false);
        }
        item.setAccelerator(KeyStroke.getKeyStroke(84, 1, true));
        item = new JMenuItem("Cancel transform");
        ((Container)st).add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(27, 0, true));
        item.setEnabled(false);
        item = new JMenuItem("Remove rotation, scaling and shear (selected images)");
        item.addActionListener(tml);
        ((Container)st).add(item);
        if (null == this.active) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Remove rotation, scaling and shear layer-wise");
        item.addActionListener(tml);
        ((Container)st).add(item);
        item = new JMenuItem("Remove coordinate transforms (selected images)");
        item.addActionListener(tml);
        ((Container)st).add(item);
        if (null == this.active) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Remove coordinate transforms layer-wise");
        item.addActionListener(tml);
        ((Container)st).add(item);
        item = new JMenuItem("Adjust mesh resolution (selected images)");
        item.addActionListener(tml);
        ((Container)st).add(item);
        if (null == this.active) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Adjust mesh resolution layer-wise");
        item.addActionListener(tml);
        ((Container)st).add(item);
        item = new JMenuItem("Set coordinate transform of selected image to other selected images");
        item.addActionListener(tml);
        ((Container)st).add(item);
        if (null == this.active) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Set coordinate transform of selected image layer-wise");
        item.addActionListener(tml);
        ((Container)st).add(item);
        if (null == this.active) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Set affine transform of selected image to other selected images");
        item.addActionListener(tml);
        ((Container)st).add(item);
        if (null == this.active) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Set affine transform of selected image layer-wise");
        item.addActionListener(tml);
        ((Container)st).add(item);
        if (null == this.active) {
            item.setEnabled(false);
        }
        this.popup.add(st);
        JMenu link_menu = new JMenu("Link");
        item = new JMenuItem("Link images...");
        item.addActionListener(this);
        link_menu.add(item);
        item = new JMenuItem("Unlink all selected images");
        item.addActionListener(this);
        link_menu.add(item);
        item.setEnabled(this.selection.getSelected(Patch.class).size() > 0);
        item = new JMenuItem("Unlink all");
        item.addActionListener(this);
        link_menu.add(item);
        this.popup.add(link_menu);
        JMenu adjust_menu = new JMenu("Adjust images");
        item = new JMenuItem("Enhance contrast layer-wise...");
        item.addActionListener(this);
        adjust_menu.add(item);
        item = new JMenuItem("Enhance contrast (selected images)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        if (this.selection.isEmpty()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Adjust image filters (selected images)");
        item.addActionListener(this);
        adjust_menu.add(item);
        if (this.selection.isEmpty()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Set Min and Max layer-wise...");
        item.addActionListener(this);
        adjust_menu.add(item);
        item = new JMenuItem("Set Min and Max (selected images)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        if (this.selection.isEmpty()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Adjust min and max (selected images)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(74, 0));
        if (this.selection.isEmpty()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Mask image borders (layer-wise)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        item = new JMenuItem("Mask image borders (selected images)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        if (this.selection.isEmpty()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Remove alpha masks (layer-wise)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        item = new JMenuItem("Remove alpha masks (selected images)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        if (this.selection.isEmpty()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Split images under polyline ROI");
        item.addActionListener(this);
        adjust_menu.add(item);
        Roi roi = this.canvas.getFakeImagePlus().getRoi();
        if (null == roi || roi.getType() != 6 && roi.getType() != 7) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Blend (layer-wise)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        item = new JMenuItem("Blend (selected images)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        if (this.selection.isEmpty()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Match intensities (layer-wise)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        item = new JMenuItem("Remove intensity maps (layer-wise)...");
        item.addActionListener(this);
        adjust_menu.add(item);
        this.popup.add(adjust_menu);
        JMenu script = new JMenu("Script");
        MenuScriptListener msl = new MenuScriptListener();
        item = new JMenuItem("Set preprocessor script layer-wise...");
        item.addActionListener(msl);
        script.add(item);
        item = new JMenuItem("Set preprocessor script (selected images)...");
        item.addActionListener(msl);
        script.add(item);
        if (this.selection.isEmpty()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Remove preprocessor script layer-wise...");
        item.addActionListener(msl);
        script.add(item);
        item = new JMenuItem("Remove preprocessor script (selected images)...");
        item.addActionListener(msl);
        script.add(item);
        if (this.selection.isEmpty()) {
            item.setEnabled(false);
        }
        this.popup.add(script);
        menu = new JMenu("Import");
        item = new JMenuItem("Import image");
        item.addActionListener(this);
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(73, 0, true));
        item = new JMenuItem("Import stack...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Import stack with landmarks...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Import grid...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Import sequence as grid...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Import from text file...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Import labels as arealists...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Tags ...");
        item.addActionListener(this);
        menu.add(item);
        this.popup.add(menu);
        menu = new JMenu("Export");
        boolean has_arealists = this.layer.getParent().contains(AreaList.class);
        item = new JMenuItem("Make flat image...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Arealists as labels (tif)");
        item.addActionListener(this);
        menu.add(item);
        item.setEnabled(has_arealists);
        item = new JMenuItem("Arealists as labels (amira)");
        item.addActionListener(this);
        menu.add(item);
        item.setEnabled(has_arealists);
        item = new JMenuItem("Image stack under selected Arealist");
        item.addActionListener(this);
        menu.add(item);
        item.setEnabled(null != this.active && AreaList.class == this.active.getClass());
        item = new JMenuItem("Fly through selected Treeline/AreaTree");
        item.addActionListener(this);
        menu.add(item);
        item.setEnabled(null != this.active && Tree.class.isInstance(this.active));
        item = new JMenuItem("Tags...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Connectivity graph...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("NeuroML...");
        item.addActionListener(this);
        menu.add(item);
        this.popup.add(menu);
        menu = new JMenu("Display");
        item = new JMenuItem("Resize canvas/LayerSet...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Autoresize canvas/LayerSet");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Resize canvas/LayerSet to ROI");
        item.addActionListener(this);
        menu.add(item);
        item.setEnabled(null != this.canvas.getFakeImagePlus().getRoi());
        item = new JMenuItem("Properties ...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Calibration...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Grid overlay...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Adjust snapping parameters...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Adjust fast-marching parameters...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Adjust arealist paint parameters...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Show current 2D position in 3D");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Show layers as orthoslices in 3D");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Inspect image mesh triangles");
        item.addActionListener(this);
        menu.add(item);
        this.popup.add(menu);
        menu = new JMenu("Project");
        this.project.getLoader().setupMenuItems(menu, this.getProject());
        item = new JMenuItem("Project properties...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Create subproject");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Create sibling project with retiled layers");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Release memory...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Flush image cache");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Regenerate all mipmaps");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Regenerate mipmaps (selected images)");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Measurement options...");
        item.addActionListener(this);
        menu.add(item);
        this.popup.add(menu);
        menu = new JMenu("Selection");
        item = new JMenuItem("Select all");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Select all visible");
        item.addActionListener(this);
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(65, Utils.getControlModifier(), true));
        if (0 == this.layer.getDisplayableList().size() && 0 == this.layer.getParent().getDisplayableList().size()) {
            item.setEnabled(false);
        }
        item = new JMenuItem("Select all that match...");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Select none");
        item.addActionListener(this);
        menu.add(item);
        if (0 == this.selection.getNSelected()) {
            item.setEnabled(false);
        }
        item.setAccelerator(KeyStroke.getKeyStroke(27, 0, true));
        JMenu bytype = new JMenu("Select all by type");
        item = new JMenuItem("AreaList");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("AreaTree");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("Ball");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("Connector");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("Dissector");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("Image");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("Pipe");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("Polyline");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("Profile");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("Text");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        item = new JMenuItem("Treeline");
        item.addActionListener(this.bytypelistener);
        bytype.add(item);
        menu.add(bytype);
        item = new JMenuItem("Restore selection");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Select under ROI");
        item.addActionListener(this);
        menu.add(item);
        if (this.canvas.getFakeImagePlus().getRoi() == null) {
            item.setEnabled(false);
        }
        JMenu graph = new JMenu("Graph");
        GraphMenuListener gl = new GraphMenuListener();
        item = new JMenuItem("Select outgoing Connectors");
        item.addActionListener(gl);
        graph.add(item);
        item = new JMenuItem("Select incoming Connectors");
        item.addActionListener(gl);
        graph.add(item);
        item = new JMenuItem("Select downstream targets");
        item.addActionListener(gl);
        graph.add(item);
        item = new JMenuItem("Select upstream targets");
        item.addActionListener(gl);
        graph.add(item);
        graph.setEnabled(!this.selection.isEmpty());
        menu.add(graph);
        item = new JMenuItem("Measure");
        item.addActionListener(this);
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(77, 0, true));
        item.setEnabled(!this.selection.isEmpty());
        this.popup.add(menu);
        menu = new JMenu("Tool");
        item = new JMenuItem("Rectangular ROI");
        item.addActionListener(new SetToolListener(0));
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(112, 0, true));
        item = new JMenuItem("Polygon ROI");
        item.addActionListener(new SetToolListener(2));
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(113, 0, true));
        item = new JMenuItem("Freehand ROI");
        item.addActionListener(new SetToolListener(3));
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(114, 0, true));
        item = new JMenuItem("Text");
        item.addActionListener(new SetToolListener(9));
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(115, 0, true));
        item = new JMenuItem("Magnifier glass");
        item.addActionListener(new SetToolListener(11));
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(116, 0, true));
        item = new JMenuItem("Hand");
        item.addActionListener(new SetToolListener(12));
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(117, 0, true));
        item = new JMenuItem("Select");
        item.addActionListener(new SetToolListener(10));
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(120, 0, true));
        item = new JMenuItem("Pencil");
        item.addActionListener(new SetToolListener(15));
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(121, 0, true));
        item = new JMenuItem("Pen");
        item.addActionListener(new SetToolListener(16));
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(122, 0, true));
        this.popup.add(menu);
        item = new JMenuItem("Search...");
        item.addActionListener(this);
        this.popup.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(70, Utils.getControlModifier(), true));
        return this.popup;
    }

    private void addAreaTreeAreasMenu(JPopupMenu popup, final AreaTree atree) {
        ActionListener listener = new ActionListener(){

            private final Node<?> findNearestNode() {
                Layer la = Display.this.getLayer();
                java.awt.Point p = Display.this.canvas.consumeLastPopupPoint();
                Node lv = atree.getLastVisited();
                boolean use_last_visited = false;
                if (null != lv) {
                    float[] xy = new float[]{lv.x, lv.y};
                    atree.getAffineTransform().transform(xy, 0, xy, 0, 1);
                    use_last_visited = lv.getLayer() == la && Display.this.canvas.getSrcRect().contains((int)xy[0], (int)xy[1]);
                }
                return atree.findNodeNear(p.x, p.y, la, Display.this.canvas, use_last_visited);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                final String command = ae.getActionCommand();
                final LayerSet ls = atree.getLayerSet();
                Bureaucrat.createAndStart((Worker)new Worker.Task(command){

                    @Override
                    public void exec() {
                        Node nd = this.findNearestNode();
                        if (null == nd) {
                            Utils.log("No node found in the field of view!");
                            return;
                        }
                        if (command.equals("Copy area")) {
                            Area area = (Area)nd.getData();
                            if (null == area) {
                                return;
                            }
                            DisplayCanvas.setCopyBuffer(atree.getClass(), area.createTransformedArea(atree.getAffineTransform()));
                        } else if (command.equals("Paste area")) {
                            Area wa = (Area)DisplayCanvas.getCopyBuffer(atree.getClass());
                            if (null == wa) {
                                return;
                            }
                            try {
                                Display.this.getLayerSet().addDataEditStep(atree);
                                atree.addWorldAreaTo(nd, wa);
                                atree.calculateBoundingBox(nd.getLayer());
                                Display.this.getLayerSet().addDataEditStep(atree);
                            }
                            catch (Exception e) {
                                IJError.print(e);
                                Display.this.getLayerSet().removeLastUndoStep();
                            }
                        } else if (command.equals("Interpolate gaps towards parent (node-centric)")) {
                            this.interpolate(nd, true);
                        } else if (command.equals("Interpolate gaps towards parent (absolute)")) {
                            this.interpolate(nd, false);
                        } else if (command.equals("Interpolate all gaps")) {
                            GenericDialog gd = new GenericDialog("Interpolate");
                            String[] a = new String[]{"node-centric", "absolute"};
                            gd.addChoice("Mode", a, a[0]);
                            gd.addCheckbox("Always use distance map", Display.this.project.getBooleanProperty("always_interpolate_areas_with_distance_map"));
                            String[] b = new String[]{"All selected AreaTrees", "Active AreaTree"};
                            gd.addChoice("Process", b, b[0]);
                            gd.showDialog();
                            if (gd.wasCanceled()) {
                                return;
                            }
                            boolean node_centric = 0 == gd.getNextChoiceIndex();
                            boolean use_distance_map = gd.getNextBoolean();
                            boolean all = 0 == gd.getNextChoiceIndex();
                            HashSet<AreaTree> s = new HashSet<AreaTree>();
                            if (all) {
                                s.addAll(Display.this.selection.get(AreaTree.class));
                            } else {
                                s.add(atree);
                            }
                            ls.addDataEditStep(s);
                            try {
                                for (Displayable displayable : s) {
                                    ((AreaTree)displayable).interpolateAllGaps(node_centric, use_distance_map);
                                }
                                ls.addDataEditStep(s);
                            }
                            catch (Exception e) {
                                IJError.print(e);
                                ls.undoOneStep();
                            }
                            Display.repaint();
                        }
                    }

                    private final void interpolate(Node<?> nd, boolean node_centric) {
                        if (null == nd.getDataCopy() || ((Area)nd.getData()).isEmpty()) {
                            Utils.log("Can't interpolate: node lacks an area!");
                            return;
                        }
                        ls.addDataEditStep(atree);
                        try {
                            if (atree.interpolateTowardsParent((AreaTree.AreaNode)nd, node_centric, Display.this.project.getBooleanProperty("always_interpolate_areas_with_distance_map"))) {
                                ls.addDataEditStep(atree);
                            } else {
                                Utils.log("Nothing to interpolate: the parent node already has an area.");
                                ls.removeLastUndoStep();
                            }
                        }
                        catch (Exception e) {
                            IJError.print(e);
                            ls.undoOneStep();
                        }
                        Display.repaint();
                    }
                }, atree.getProject());
            }
        };
        JMenu interpolate = new JMenu("Areas");
        JMenuItem item = new JMenuItem("Interpolate gaps towards parent (node-centric)");
        item.addActionListener(listener);
        interpolate.add(item);
        item = new JMenuItem("Interpolate gaps towards parent (absolute)");
        item.addActionListener(listener);
        interpolate.add(item);
        item = new JMenuItem("Interpolate all gaps");
        item.addActionListener(listener);
        interpolate.add(item);
        item = new JMenuItem("Area interpolation options...");
        item.addActionListener(this);
        interpolate.add(item);
        interpolate.addSeparator();
        item = new JMenuItem("Copy area");
        item.addActionListener(listener);
        interpolate.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(67, 0, true));
        item = new JMenuItem("Paste area");
        item.addActionListener(listener);
        interpolate.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(86, 0, true));
        item.setEnabled(null != DisplayCanvas.getCopyBuffer(this.active.getClass()));
        popup.add(interpolate);
    }

    private void addAreaListAreasMenu(JPopupMenu popup2, final Displayable active) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                final String command = ae.getActionCommand();
                Bureaucrat.createAndStart((Worker)new Worker.Task(command){

                    @Override
                    public void exec() {
                        if (command.equals("Copy area")) {
                            if (null == active || !(active instanceof AreaList)) {
                                return;
                            }
                            AreaList ali = (AreaList)active;
                            Area area = ali.getArea(Display.this.getLayer());
                            if (null == area) {
                                return;
                            }
                            DisplayCanvas.setCopyBuffer(ali.getClass(), area.createTransformedArea(ali.getAffineTransform()));
                        } else if (command.equals("Paste area")) {
                            if (null == active || !(active instanceof AreaList)) {
                                return;
                            }
                            AreaList ali = (AreaList)active;
                            Area wa = (Area)DisplayCanvas.getCopyBuffer(ali.getClass());
                            if (null == wa) {
                                return;
                            }
                            try {
                                Display.this.getLayerSet().addDataEditStep(ali);
                                ali.addArea(Display.this.getLayer().getId(), wa.createTransformedArea(ali.getAffineTransform().createInverse()));
                                ali.calculateBoundingBox(Display.this.getLayer());
                                Display.this.getLayerSet().addDataEditStep(ali);
                            }
                            catch (NoninvertibleTransformException e) {
                                IJError.print(e);
                                Display.this.getLayerSet().undoOneStep();
                            }
                        } else if (command.equals("Interpolate gaps towards previous area")) {
                            if (null == active || !(active instanceof AreaList)) {
                                return;
                            }
                            AreaList ali = (AreaList)active;
                            Layer current = Display.this.getLayer();
                            if (null == ali.getArea(current)) {
                                return;
                            }
                            LayerSet ls = Display.this.getLayerSet();
                            if (0 == ls.indexOf(current)) {
                                return;
                            }
                            Layer previous = null;
                            ListIterator<Layer> it = ls.getLayers().listIterator(ls.indexOf(current));
                            while (it.hasPrevious()) {
                                Layer la = it.previous();
                                if (null == ali.getArea(la)) continue;
                                previous = la;
                                break;
                            }
                            if (null == previous) {
                                return;
                            }
                            try {
                                ls.addDataEditStep(ali);
                                ali.interpolate(previous, current, Display.this.project.getBooleanProperty("always_interpolate_areas_with_distance_map"));
                                ls.addDataEditStep(ali);
                            }
                            catch (Exception e) {
                                IJError.print(e);
                                ls.undoOneStep();
                            }
                        } else if (command.equals("Interpolate gaps towards next area")) {
                            if (null == active || !(active instanceof AreaList)) {
                                return;
                            }
                            AreaList ali = (AreaList)active;
                            Layer current = Display.this.getLayer();
                            if (null == ali.getArea(current)) {
                                return;
                            }
                            LayerSet ls = Display.this.getLayerSet();
                            if (ls.size() - 1 == ls.indexOf(current)) {
                                return;
                            }
                            Layer next = null;
                            ListIterator<Layer> it = ls.getLayers().listIterator(ls.indexOf(current) + 1);
                            while (it.hasNext()) {
                                Layer la = it.next();
                                if (null == ali.getArea(la)) continue;
                                next = la;
                                break;
                            }
                            if (null == next) {
                                return;
                            }
                            try {
                                ls.addDataEditStep(ali);
                                ali.interpolate(current, next, Display.this.project.getBooleanProperty("always_interpolate_areas_with_distance_map"));
                                ls.addDataEditStep(ali);
                            }
                            catch (Exception e) {
                                IJError.print(e);
                                ls.undoOneStep();
                            }
                        } else if (command.equals("Interpolate all gaps")) {
                            if (null == active || !(active instanceof AreaList)) {
                                return;
                            }
                            AreaList ali = (AreaList)active;
                            Layer first = null;
                            Layer last = null;
                            LayerSet ls = Display.this.getLayerSet();
                            ArrayList<Layer> las = ls.getLayers();
                            for (Layer la : las) {
                                if (null != first || null == ali.getArea(la)) continue;
                                first = la;
                                break;
                            }
                            ListIterator it = las.listIterator(las.size());
                            while (it.hasPrevious()) {
                                Layer la;
                                la = (Layer)it.previous();
                                if (null != last || null == ali.getArea(la)) continue;
                                last = la;
                                break;
                            }
                            Utils.log2(first, last);
                            if (null != first && first != last) {
                                try {
                                    ls.addDataEditStep(ali);
                                    ali.interpolate(first, last, Display.this.project.getBooleanProperty("always_interpolate_areas_with_distance_map"));
                                    ls.addDataEditStep(ali);
                                }
                                catch (Exception e) {
                                    IJError.print(e);
                                    ls.undoOneStep();
                                }
                            }
                        }
                        Display.repaint(Display.this.getLayer());
                    }
                }, active.getProject());
            }
        };
        JMenu interpolate = new JMenu("Areas");
        JMenuItem item = new JMenuItem("Interpolate gaps towards previous area");
        item.addActionListener(listener);
        interpolate.add(item);
        item = new JMenuItem("Interpolate gaps towards next area");
        item.addActionListener(listener);
        interpolate.add(item);
        item = new JMenuItem("Interpolate all gaps");
        item.addActionListener(listener);
        interpolate.add(item);
        item = new JMenuItem("Area interpolation options...");
        item.addActionListener(this);
        interpolate.add(item);
        interpolate.addSeparator();
        item = new JMenuItem("Copy area");
        item.addActionListener(listener);
        interpolate.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(67, 0, true));
        item = new JMenuItem("Paste area");
        item.addActionListener(listener);
        interpolate.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(86, 0, true));
        item.setEnabled(null != DisplayCanvas.getCopyBuffer(active.getClass()));
        this.popup.add(interpolate);
    }

    private static final TreeMap<String, Tag> getTags(Tree tree) {
        Set<Tag> tags = tree.findTags();
        if (tags.isEmpty()) {
            Utils.log("The nodes of the tree '" + tree + "' don't have any tags!");
            return null;
        }
        TreeMap<String, Tag> sm = new TreeMap<String, Tag>();
        for (Tag t : tags) {
            sm.put(t.toString(), t);
        }
        return sm;
    }

    private static final String[] asStrings(TreeMap<String, Tag> tags) {
        if (null == tags) {
            return null;
        }
        String[] stags = new String[tags.size()];
        tags.keySet().toArray(stags);
        return stags;
    }

    private ActionListener getTreePathMeasureListener(final Tree tree) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                if (command.equals("Shortest distances between all pairs of nodes tagged as...")) {
                    TreeMap sm = Display.getTags(tree);
                    if (null == sm) {
                        return;
                    }
                    if (1 == sm.size()) {
                        Utils.showMessage("Need at least two different tags in the tree!");
                        return;
                    }
                    String[] stags = Display.asStrings(sm);
                    sm.keySet().toArray(stags);
                    GenericDialog gd = new GenericDialog("Choose tag");
                    gd.addChoice("Upstream tag:", stags, stags[0]);
                    gd.addChoice("Downstream tag:", stags, stags[1]);
                    gd.addNumericField("Scale:", 1.0, 2);
                    LayerSet ls = tree.getLayerSet();
                    int resample = Display3D.estimateResamplingFactor(ls, ls.getLayerWidth(), ls.getLayerHeight());
                    gd.addSlider("Resample: ", 1.0, (double)Math.max(resample, 100), (double)resample);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    Tag upstreamTag = (Tag)sm.get(gd.getNextChoice());
                    Tag downstreamTag = (Tag)sm.get(gd.getNextChoice());
                    List<Tree.MeasurementPair> pairs = tree.measureTaggedPairs(upstreamTag, downstreamTag);
                    ResultsTable rt = null;
                    int index = 1;
                    for (Tree.MeasurementPair pair : pairs) {
                        rt = pair.toResultsTable(rt, index++, 1.0, resample);
                        Utils.showProgress((double)index / (double)pairs.size());
                    }
                    if (index > 0) {
                        rt.show(pairs.get(0).getResultsTableTitle());
                    } else {
                        Utils.logAll("No pairs found for '" + upstreamTag + "' and '" + downstreamTag + "'");
                    }
                    return;
                }
                java.awt.Point p = Display.this.getCanvas().consumeLastPopupPoint();
                Node clicked = tree.findClosestNodeW(p.x, (float)p.y, Display.this.getLayer(), Display.this.canvas.getMagnification());
                if (null == clicked) {
                    Calibration cal = Display.this.getLayerSet().getCalibration();
                    Utils.log("No node found at " + (double)p.x * cal.pixelWidth + ", " + (double)p.y * cal.pixelHeight);
                    return;
                }
                ResultsTable rt = null;
                if (command.equals("Distance from this node to root")) {
                    rt = tree.measurePathDistance(clicked, tree.getRoot(), null);
                } else if (command.equals("Distance from this node to the marked node")) {
                    if (null == tree.getMarked()) {
                        Utils.log("No marked node!");
                        return;
                    }
                    rt = tree.measurePathDistance(clicked, tree.getMarked(), null);
                } else if (command.equals("Distance from this node to all nodes tagged as...")) {
                    Set<Tag> tags = tree.findTags();
                    if (tags.isEmpty()) {
                        Utils.log("The nodes of the tree '" + tree + "' don't have any tags!");
                        return;
                    }
                    TreeMap<String, Tag> sm = new TreeMap<String, Tag>();
                    for (Tag t : tags) {
                        sm.put(t.toString(), t);
                    }
                    String[] stags = new String[sm.size()];
                    sm.keySet().toArray(stags);
                    GenericDialog gd = new GenericDialog("Choose tag");
                    gd.addChoice("Tag:", stags, stags[0]);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    Tag tag = (Tag)sm.get(gd.getNextChoice());
                    for (Node nd : tree.getRoot().getSubtreeNodes()) {
                        if (!nd.hasTag(tag)) continue;
                        rt = tree.measurePathDistance(clicked, nd, rt);
                    }
                }
                if (null == rt) {
                    Utils.log("No nodes found!");
                } else {
                    rt.show("Tree path measurements");
                }
            }
        };
    }

    public Bureaucrat removeScalingRotationShear(final List<Patch> patches) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Removing coordinate transforms"){

            @Override
            public void exec() {
                Display.this.getLayerSet().addTransformStep(patches);
                for (Patch p : patches) {
                    Rectangle box = p.getBoundingBox();
                    AffineTransform aff = new AffineTransform();
                    aff.setToTranslation((float)box.x + ((float)box.width - p.getWidth()) / 2.0f, (float)box.y + ((float)box.height - p.getHeight()) / 2.0f);
                    p.setAffineTransform(aff);
                }
                Display.this.getLayerSet().addTransformStep(patches);
                Display.repaint();
            }
        }, this.project);
    }

    public Bureaucrat applyPatchTask(final List<Patch> patches, String taskTitle, final Operation<Boolean, Patch> task, final Filter<Patch> filter) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task(taskTitle){

            @Override
            public void exec() {
                HashSet<Patch> ds = new HashSet<Patch>();
                for (Patch p : patches) {
                    if (p.isLinked()) {
                        Utils.logAll("Cannot apply task: some images are linked to segmentations!");
                        return;
                    }
                    if (Thread.currentThread().isInterrupted() || this.hasQuitted()) {
                        return;
                    }
                    if (!filter.accept(p)) continue;
                    ds.add(p);
                }
                if (ds.isEmpty()) {
                    Utils.log("Nothing to do.");
                    return;
                }
                Display.this.getLayerSet().addDataEditStep(ds);
                ArrayList fus = new ArrayList();
                for (Patch p : ds) {
                    if (Thread.currentThread().isInterrupted() || this.hasQuitted()) {
                        return;
                    }
                    if (!((Boolean)task.apply(p)).booleanValue()) continue;
                    fus.add(p.getProject().getLoader().regenerateMipMaps(p));
                }
                Utils.wait(fus);
                Display.this.getLayerSet().addDataEditStep(ds);
            }
        }, this.project);
    }

    public Bureaucrat removeCoordinateTransforms(List<Patch> patches) {
        return this.applyPatchTask(patches, "Removing coordinate transforms", new Operation<Boolean, Patch>(){

            @Override
            public Boolean apply(Patch o) {
                o.setCoordinateTransform(null);
                return true;
            }
        }, new Filter<Patch>(){

            @Override
            public boolean accept(Patch t) {
                return t.hasCoordinateTransform();
            }
        });
    }

    public Bureaucrat setCoordinateTransform(List<Patch> patches, final CoordinateTransform ct, final int existingTransform) {
        return this.applyPatchTask(patches, "Set coordinate transform", new Operation<Boolean, Patch>(){

            @Override
            public Boolean apply(Patch o) {
                switch (existingTransform) {
                    case 0: {
                        o.setCoordinateTransform(ct);
                        break;
                    }
                    case 1: {
                        o.appendCoordinateTransform(ct);
                        break;
                    }
                    case 2: {
                        o.preAppendCoordinateTransform(ct);
                    }
                }
                return true;
            }
        }, new Filter<Patch>(){

            @Override
            public boolean accept(Patch t) {
                return true;
            }
        });
    }

    @Deprecated
    public Bureaucrat setCoordinateTransform(List<Patch> patches, CoordinateTransform ct, boolean append) {
        return this.setCoordinateTransform(patches, ct, append ? 1 : 0);
    }

    public Bureaucrat setMeshResolution(List<Patch> patches, final int meshResolution) {
        if (meshResolution < 1) {
            Utils.log("Cannot apply a mesh resolution smaller than 1!");
            return null;
        }
        return this.applyPatchTask(patches, "Alter mesh resolution", new Operation<Boolean, Patch>(){

            @Override
            public Boolean apply(Patch o) {
                o.setMeshResolution(meshResolution);
                return null != o.getCoordinateTransform();
            }
        }, new Filter<Patch>(){

            @Override
            public boolean accept(Patch t) {
                return t.getMeshResolution() != meshResolution;
            }
        });
    }

    public boolean isWithinViewport(Displayable d) {
        Component comp = this.tabs.getSelectedComponent();
        if (!(comp instanceof RollingPanel)) {
            return false;
        }
        RollingPanel rp = (RollingPanel)this.tabs.getSelectedComponent();
        if (this.ht_tabs.get(d.getClass()) == rp) {
            return rp.isShowing(d);
        }
        return false;
    }

    public boolean isPartiallyWithinViewport(Displayable d) {
        RollingPanel rp = this.ht_tabs.get(d.getClass());
        return rp.isShowing(d);
    }

    private void scrollToShow(final JScrollPane scroll, final JPanel dp) {
        if (null == dp) {
            return;
        }
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                JViewport view = scroll.getViewport();
                java.awt.Point current = view.getViewPosition();
                Dimension extent = view.getExtentSize();
                int panel_y = dp.getY();
                if (panel_y + 52 - current.y <= extent.height && panel_y >= current.y) {
                    return;
                }
                if (panel_y - current.y < 0) {
                    view.setViewPosition(new java.awt.Point(0, panel_y));
                } else if (panel_y + 50 > current.y + extent.height) {
                    view.setViewPosition(new java.awt.Point(0, panel_y - extent.height + 50));
                }
            }
        });
    }

    public static void updateTitle(Layer layer, Displayable displ) {
        for (Display d : al_displays) {
            DisplayablePanel dp;
            if (layer != d.layer || null == (dp = d.ht_panels.get(displ))) continue;
            dp.updateTitle();
        }
    }

    public static void updateTitle(Layer layer) {
        for (Display d : al_displays) {
            if (d.layer != layer) continue;
            d.updateFrameTitle();
        }
    }

    public static void updateTitle(Project project) {
        for (Display d : al_displays) {
            if (d.project != project) continue;
            d.updateFrameTitle();
        }
    }

    public static void updateTitle(LayerSet ls) {
        for (Display d : al_displays) {
            if (d.layer.getParent() != ls) continue;
            d.updateFrameTitle(d.layer);
        }
    }

    public void updateFrameTitle() {
        this.updateFrameTitle(this.layer);
    }

    private void updateFrameTitle(Layer layer) {
        String scale = "";
        double magnification = this.canvas.getMagnification();
        if (magnification != 1.0) {
            double percent = magnification * 100.0;
            scale = " (" + Utils.d2s(percent, percent == (double)((int)percent) ? 0 : 1) + "%)";
        }
        LayerSet ls = layer.getParent();
        Calibration cal = ls.getCalibration();
        Layer last = ls.getLayer(ls.size() - 1);
        double depth = (last.getZ() - ls.getLayer(0).getZ() + last.getThickness()) * cal.pixelWidth;
        final String title = new StringBuilder(100).append(layer.getParent().indexOf(layer) + 1).append('/').append(layer.getParent().size()).append("  z:").append(layer.getZ() * cal.pixelWidth).append(' ').append(cal.getUnits()).append(' ').append(' ').append(layer.getLayerThingTitle()).append(scale).append(" -- ").append(this.getProject().toString()).append(' ').append(' ').append(Utils.cutNumber((double)layer.getParent().getLayerWidth() * cal.pixelWidth, 2, true)).append('x').append(Utils.cutNumber((double)layer.getParent().getLayerHeight() * cal.pixelHeight, 2, true)).append('x').append(Utils.cutNumber(depth, 2, true)).append(' ').append(cal.getUnit()).toString();
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.this.frame.setTitle(title);
            }
        });
        this.canvas.getFakeImagePlus().setTitle(title);
    }

    public void nextLayer(int modifiers) {
        Layer l;
        if (0 == (modifiers ^ 1)) {
            l = this.layer.getParent().nextNonEmpty(this.layer);
        } else if (this.scroll_step > 1) {
            int i = this.layer.getParent().indexOf(this.layer);
            Layer la = this.layer.getParent().getLayer(i + this.scroll_step);
            l = null != la ? la : null;
        } else {
            l = this.layer.getParent().next(this.layer);
        }
        if (l != this.layer) {
            this.slt.set(l);
            this.updateInDatabase("layer_id");
        }
    }

    private final void translateLayerColors(Layer current, Layer other) {
        if (current == other) {
            return;
        }
        if (this.layer_channels.size() > 0) {
            LayerSet ls = this.getLayerSet();
            int dist = ls.indexOf(other) - ls.indexOf(current);
            this.translateLayerColor(Color.red, dist);
            this.translateLayerColor(Color.blue, dist);
        }
    }

    private final void translateLayerColor(Color color, int dist) {
        LayerSet ls = this.getLayerSet();
        Layer l = this.layer_channels.get(color);
        if (null == l) {
            return;
        }
        this.updateColor(Color.white, this.layer_panels.get(l));
        Layer l2 = ls.getLayer(ls.indexOf(l) + dist);
        if (null != l2) {
            this.updateColor(color, this.layer_panels.get(l2));
        }
    }

    private final void updateColor(Color color, LayerPanel lp) {
        lp.setColor(color);
        this.setColorChannel(lp.layer, color);
    }

    public void toLayer(Layer la) {
        if (la.getParent() != this.layer.getParent()) {
            return;
        }
        if (la == this.layer) {
            return;
        }
        this.slt.set(la);
        this.updateInDatabase("layer_id");
    }

    public void previousLayer(int modifiers) {
        Layer l;
        if (0 == (modifiers ^ 1)) {
            l = this.layer.getParent().previousNonEmpty(this.layer);
        } else if (this.scroll_step > 1) {
            int i = this.layer.getParent().indexOf(this.layer);
            Layer la = this.layer.getParent().getLayer(i - this.scroll_step);
            l = null != la ? la : null;
        } else {
            l = this.layer.getParent().previous(this.layer);
        }
        if (l != this.layer) {
            this.slt.set(l);
            this.updateInDatabase("layer_id");
        }
    }

    public static void updateLayerScroller(LayerSet set) {
        for (Display d : al_displays) {
            if (d.layer.getParent() != set) continue;
            d.updateLayerScroller(d.layer);
        }
    }

    private void updateLayerScroller(final Layer layer) {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                int size = layer.getParent().size();
                if (size <= 1) {
                    Display.this.scroller.setValues(0, 1, 0, 0);
                    Display.this.scroller.setEnabled(false);
                } else {
                    Display.this.scroller.setEnabled(true);
                    Display.this.scroller.setValues(layer.getParent().indexOf(layer), 1, 0, size);
                }
                Display.this.recreateLayerPanels(layer);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void recreateLayerPanels(Layer layer) {
        HashMap<Color, Layer> hashMap = this.layer_channels;
        synchronized (hashMap) {
            this.panel_layers.removeAll();
            GridBagLayout gb = (GridBagLayout)this.panel_layers.getLayout();
            this.panel_layers.setLayout(gb);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            if (0 == this.layer_panels.size()) {
                for (Layer la : layer.getParent().getLayers()) {
                    LayerPanel lp = new LayerPanel(this, la);
                    this.layer_panels.put(la, lp);
                    gb.setConstraints(lp, c);
                    this.panel_layers.add(lp);
                    ++c.gridy;
                }
            } else {
                Map.Entry<Serializable, Object> e;
                this.layer_panels.keySet().retainAll(layer.getParent().getLayers());
                for (Layer la : layer.getParent().getLayers()) {
                    LayerPanel lp = this.layer_panels.get(la);
                    if (null == lp) {
                        lp = new LayerPanel(this, la);
                        this.layer_panels.put(la, lp);
                    }
                    gb.setConstraints(lp, c);
                    this.panel_layers.add(lp);
                    ++c.gridy;
                }
                Iterator<Map.Entry<Serializable, Object>> it = this.layer_alpha.entrySet().iterator();
                while (it.hasNext()) {
                    e = it.next();
                    if (-1 != this.getLayerSet().indexOf(e.getValue().layer)) continue;
                    it.remove();
                }
                it = this.layer_channels.entrySet().iterator();
                while (it.hasNext()) {
                    e = it.next();
                    if (-1 != this.getLayerSet().indexOf((Layer)e.getValue())) continue;
                    it.remove();
                }
                this.scroll_layers.repaint();
            }
        }
    }

    private void updateSnapshots() {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Enumeration e = Display.this.ht_panels.elements();
                while (e.hasMoreElements()) {
                    ((DisplayablePanel)e.nextElement()).repaint();
                }
                Utils.updateComponent(Display.this.tabs.getSelectedComponent());
            }
        });
    }

    public static void updatePanel(Layer layer, Displayable displ) {
        if (null == layer && null != front) {
            layer = Display.front.layer;
        }
        for (Display d : al_displays) {
            if (d.layer != layer) continue;
            d.updatePanel(displ);
        }
    }

    private void updatePanel(Displayable d) {
        RollingPanel c = null;
        if (d instanceof Profile) {
            c = this.panel_profiles;
        } else if (d instanceof Patch) {
            c = this.panel_patches;
        } else if (d instanceof DLabel) {
            c = this.panel_labels;
        } else if (d instanceof Pipe) {
            c = this.panel_zdispl;
        }
        if (null == c) {
            return;
        }
        DisplayablePanel dp = this.ht_panels.get(d);
        if (null != dp) {
            dp.repaint();
            Utils.updateComponent(c);
        }
    }

    @Deprecated
    public static void updatePanelIndex(Layer layer, Displayable displ) {
        for (Display d : al_displays) {
            if (d.layer != layer && !(displ instanceof ZDisplayable)) continue;
            d.updatePanelIndex(displ);
        }
    }

    @Deprecated
    private void updatePanelIndex(final Displayable d) {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((RollingPanel)Display.this.ht_tabs.get(d.getClass())).updateList();
            }
        });
    }

    public void repairGUI() {
        this.setLayer(this.layer, true);
    }

    @Override
    public void actionPerformed(final ActionEvent ae) {
        this.dispatcher.exec(new Runnable(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                final String command = ae.getActionCommand();
                if (command.startsWith("Job")) {
                    if (Utils.checkYN("Really cancel job?")) {
                        Display.this.project.getLoader().quitJob(command);
                        Display.this.repairGUI();
                    }
                    return;
                }
                if (command.equals("Move to top")) {
                    if (null == Display.this.active) {
                        return;
                    }
                    Display.this.canvas.setUpdateGraphics(true);
                    Display.this.getLayerSet().addUndoMoveStep(Display.this.active);
                    Display.this.layer.getParent().move(13, Display.this.active);
                    Display.this.getLayerSet().addUndoMoveStep(Display.this.active);
                    Display.repaint(Display.this.layer.getParent(), Display.this.active, 5);
                } else if (command.equals("Move up")) {
                    if (null == Display.this.active) {
                        return;
                    }
                    Display.this.canvas.setUpdateGraphics(true);
                    Display.this.getLayerSet().addUndoMoveStep(Display.this.active);
                    Display.this.layer.getParent().move(14, Display.this.active);
                    Display.this.getLayerSet().addUndoMoveStep(Display.this.active);
                    Display.repaint(Display.this.layer.getParent(), Display.this.active, 5);
                } else if (command.equals("Move down")) {
                    if (null == Display.this.active) {
                        return;
                    }
                    Display.this.canvas.setUpdateGraphics(true);
                    Display.this.getLayerSet().addUndoMoveStep(Display.this.active);
                    Display.this.layer.getParent().move(15, Display.this.active);
                    Display.this.getLayerSet().addUndoMoveStep(Display.this.active);
                    Display.repaint(Display.this.layer.getParent(), Display.this.active, 5);
                } else if (command.equals("Move to bottom")) {
                    if (null == Display.this.active) {
                        return;
                    }
                    Display.this.canvas.setUpdateGraphics(true);
                    Display.this.getLayerSet().addUndoMoveStep(Display.this.active);
                    Display.this.layer.getParent().move(16, Display.this.active);
                    Display.this.getLayerSet().addUndoMoveStep(Display.this.active);
                    Display.repaint(Display.this.layer.getParent(), Display.this.active, 5);
                } else if (command.equals("Duplicate, link and send to next layer")) {
                    Display.this.duplicateLinkAndSendTo(Display.this.active, 1, Display.this.layer.getParent().next(Display.this.layer));
                } else if (command.equals("Duplicate, link and send to previous layer")) {
                    Display.this.duplicateLinkAndSendTo(Display.this.active, 0, Display.this.layer.getParent().previous(Display.this.layer));
                } else if (command.equals("Duplicate, link and send to...")) {
                    Utils.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GenericDialog gd = new GenericDialog("Send to");
                            gd.addMessage("Duplicate, link and send to...");
                            String[] sl = new String[Display.this.layer.getParent().size()];
                            int next = 0;
                            for (Layer la : Display.this.layer.getParent().getLayers()) {
                                sl[next++] = Display.this.project.findLayerThing(la).toString();
                            }
                            gd.addChoice("Layer: ", sl, sl[Display.this.layer.getParent().indexOf(Display.this.layer)]);
                            gd.showDialog();
                            if (gd.wasCanceled()) {
                                return;
                            }
                            Layer la = Display.this.layer.getParent().getLayer(gd.getNextChoiceIndex());
                            if (Display.this.layer == la) {
                                Utils.showMessage("Can't duplicate, link and send to the same layer.");
                                return;
                            }
                            Display.this.duplicateLinkAndSendTo(Display.this.active, 0, la);
                        }
                    });
                } else if (-1 != command.indexOf("z = ")) {
                    Layer target_layer = Display.this.layer.getParent().getLayer(Double.parseDouble(command.substring(command.lastIndexOf(32) + 1)));
                    Utils.log2("layer: __" + command.substring(command.lastIndexOf(32) + 1) + "__");
                    if (null == target_layer) {
                        return;
                    }
                    Display.this.duplicateLinkAndSendTo(Display.this.active, 0, target_layer);
                } else if (-1 != command.indexOf("z=")) {
                    int n;
                    int iz = command.indexOf("z=") + 2;
                    Utils.log2("iz=" + iz + "  other: " + command.indexOf(32, iz + 2));
                    int n2 = command.indexOf(32, iz);
                    if (-1 == n2) {
                        n = command.length();
                    }
                    double lz = Double.parseDouble(command.substring(iz, n));
                    Layer target = Display.this.layer.getParent().getLayer(lz);
                    Display.this.layer.getParent().move(Display.this.selection.getAffected(), Display.this.active.getLayer(), target);
                } else if (command.equals("Unlink")) {
                    if (null == Display.this.active || Display.this.active instanceof Patch) {
                        return;
                    }
                    Display.this.active.unlink();
                    Display.updateSelection();
                } else if (command.equals("Unlink from images")) {
                    if (null == Display.this.active) {
                        return;
                    }
                    try {
                        for (Displayable displayable : Display.this.selection.getSelected()) {
                            displayable.unlinkAll(Patch.class);
                        }
                        Display.updateSelection();
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                } else if (command.equals("Unlink slices")) {
                    YesNoCancelDialog yn = new YesNoCancelDialog((Frame)Display.this.frame, "Attention", "Really unlink all slices from each other?\nThere is no undo.");
                    if (!yn.yesPressed()) {
                        return;
                    }
                    ArrayList<Patch> arrayList = ((Patch)Display.this.active).getStackPatches();
                    for (int i = arrayList.size() - 1; i > 0; --i) {
                        arrayList.get(i).unlink(arrayList.get(i - 1));
                    }
                } else if (command.equals("Send to next layer")) {
                    Rectangle box = Display.this.selection.getBox();
                    try {
                        for (Displayable displ : Display.this.selection.getSelected()) {
                            displ.unlinkAll(Patch.class);
                        }
                        Display.updateSelection();
                    }
                    catch (Exception exception) {
                        IJError.print(exception);
                    }
                    Display.this.selection.moveDown();
                    Display.repaint(Display.this.layer.getParent(), box);
                } else if (command.equals("Send to previous layer")) {
                    Rectangle box = Display.this.selection.getBox();
                    try {
                        for (Displayable displ : Display.this.selection.getSelected()) {
                            displ.unlinkAll(Patch.class);
                        }
                        Display.updateSelection();
                    }
                    catch (Exception exception) {
                        IJError.print(exception);
                    }
                    Display.this.selection.moveUp();
                    Display.repaint(Display.this.layer.getParent(), box);
                } else if (command.equals("Show centered")) {
                    if (Display.this.active == null) {
                        return;
                    }
                    Display.this.showCentered(Display.this.active);
                } else if (command.equals("Delete...")) {
                    Display.this.selection.deleteAll();
                } else if (command.equals("Color...")) {
                    IJ.doCommand((String)"Color Picker...");
                } else if (command.equals("Revert")) {
                    if (null == Display.this.active || Display.this.active.getClass() != Patch.class) {
                        return;
                    }
                    Patch p = (Patch)Display.this.active;
                    if (!p.revert()) {
                        if (null == p.getOriginalPath()) {
                            Utils.log("No editions to save for patch " + p.getTitle() + " #" + p.getId());
                        } else {
                            Utils.log("Could not revert Patch " + p.getTitle() + " #" + p.getId());
                        }
                    }
                } else if (command.equals("Remove alpha mask")) {
                    Display.removeAlphaMasks(Display.this.selection.get(Patch.class));
                } else if (command.equals("Undo")) {
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Undo"){

                        @Override
                        public void exec() {
                            Display.this.layer.getParent().undoOneStep();
                            Display.repaint(Display.this.layer.getParent());
                        }
                    }, Display.this.project);
                } else if (command.equals("Redo")) {
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Redo"){

                        @Override
                        public void exec() {
                            Display.this.layer.getParent().redoOneStep();
                            Display.repaint(Display.this.layer.getParent());
                        }
                    }, Display.this.project);
                } else if (command.equals("Apply transform")) {
                    Display.this.canvas.applyTransform();
                } else if (command.equals("Apply transform propagating to last layer")) {
                    if (Display.this.mode.getClass() == AffineTransformMode.class || Display.this.mode.getClass() == NonLinearTransformMode.class) {
                        LayerSet ls = Display.this.getLayerSet();
                        HashSet<Layer> hashSet = new HashSet<Layer>(ls.getLayers(ls.indexOf(Display.this.layer) + 1, ls.size() - 1));
                        if (Display.this.mode.getClass() == AffineTransformMode.class) {
                            ((AffineTransformMode)Display.this.mode).applyAndPropagate(hashSet);
                        } else if (Display.this.mode.getClass() == NonLinearTransformMode.class) {
                            ((NonLinearTransformMode)Display.this.mode).apply(hashSet);
                        }
                        Display.this.setMode(new DefaultMode(Display.this));
                    }
                } else if (command.equals("Apply transform propagating to first layer")) {
                    if (Display.this.mode.getClass() == AffineTransformMode.class || Display.this.mode.getClass() == NonLinearTransformMode.class) {
                        LayerSet ls = Display.this.getLayerSet();
                        HashSet<Layer> hashSet = new HashSet<Layer>(ls.getLayers(0, ls.indexOf(Display.this.layer) - 1));
                        if (Display.this.mode.getClass() == AffineTransformMode.class) {
                            ((AffineTransformMode)Display.this.mode).applyAndPropagate(hashSet);
                        } else if (Display.this.mode.getClass() == NonLinearTransformMode.class) {
                            ((NonLinearTransformMode)Display.this.mode).apply(hashSet);
                        }
                        Display.this.setMode(new DefaultMode(Display.this));
                    }
                } else if (command.equals("Cancel transform")) {
                    Display.this.canvas.cancelTransform();
                } else if (command.equals("Specify transform...")) {
                    if (null == Display.this.active) {
                        return;
                    }
                    Display.this.selection.specify();
                } else if (command.equals("Exit inspection")) {
                    Display.this.getMode().cancel();
                    Display.this.setMode(new DefaultMode(Display.this));
                } else if (command.equals("Inspect image mesh triangles")) {
                    Display.this.setMode(new InspectPatchTrianglesMode(Display.this));
                } else if (command.equals("Hide all but images")) {
                    ArrayList type = new ArrayList();
                    type.add(Patch.class);
                    type.add(Stack.class);
                    HashSet<Displayable> hashSet = Display.this.layer.getParent().hideExcept(type, false);
                    Display.this.selection.removeAll(hashSet);
                    Display.updateCheckboxes(hashSet, 2);
                    Display.update(Display.this.layer.getParent(), false);
                } else if (command.equals("Unhide all")) {
                    Display.updateCheckboxes(Display.this.layer.getParent().setAllVisible(false), 2);
                    Display.update(Display.this.layer.getParent(), false);
                } else if (command.startsWith("Hide all ")) {
                    String type = command.substring(9, command.length() - 1);
                    HashSet<Displayable> hashSet = Display.this.layer.getParent().setVisible(type, false, true);
                    Display.this.selection.removeAll(hashSet);
                    Display.updateCheckboxes(hashSet, 2);
                } else if (command.startsWith("Unhide all ")) {
                    String type = command.substring(11, command.length() - 1);
                    type = type.substring(0, 1).toUpperCase() + type.substring(1);
                    Display.updateCheckboxes(Display.this.layer.getParent().setVisible(type, true, true), 2);
                } else if (command.equals("Hide deselected")) {
                    Display.this.hideDeselected(0 != (8 & ae.getModifiers()));
                } else if (command.equals("Hide deselected except images")) {
                    Display.this.hideDeselected(true);
                } else if (command.equals("Hide selected")) {
                    Display.this.selection.setVisible(false);
                    Display.updateCheckboxes(Display.this.selection.getSelected(), 2);
                } else if (command.equals("Resize canvas/LayerSet...")) {
                    Display.this.resizeCanvas();
                } else if (command.equals("Autoresize canvas/LayerSet")) {
                    Display.this.layer.getParent().setMinimumDimensions();
                } else if (command.equals("Resize canvas/LayerSet to ROI")) {
                    Roi roi = Display.this.canvas.getFakeImagePlus().getRoi();
                    if (null == roi) {
                        Utils.log("No ROI present!");
                        return;
                    }
                    Display.this.resizeCanvas(roi.getBounds());
                } else if (command.equals("Import image")) {
                    Display.this.importImage();
                } else if (command.equals("Import next image")) {
                    Display.this.importNextImage();
                } else if (command.equals("Import stack...")) {
                    Display.this.getLayerSet().addChangeTreesStep();
                    Rectangle sr = Display.this.getCanvas().getSrcRect();
                    Bureaucrat bureaucrat = Display.this.project.getLoader().importStack(Display.this.layer, sr.x + sr.width / 2, sr.y + sr.height / 2, null, true, null, false);
                    bureaucrat.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().addChangeTreesStep();
                        }
                    });
                } else if (command.equals("Import stack with landmarks...")) {
                    String[] stack_titles;
                    ArrayList<Project> pr = Project.getProjects();
                    if (1 == pr.size()) {
                        Utils.logAll("Need another project open!");
                        return;
                    }
                    GenericDialog genericDialog = new GenericDialog("Landmarks");
                    genericDialog.addStringField("landmarks type:", "landmarks");
                    final String[] none = new String[]{"-- None --"};
                    final Hashtable<String, Project> mpr = new Hashtable<String, Project>();
                    for (Project project : pr) {
                        if (project == Display.this.project) continue;
                        mpr.put(project.toString(), project);
                    }
                    final String[] project_titles = mpr.keySet().toArray(new String[0]);
                    final Hashtable hashtable = Display.findLandmarkNodes(Display.this.project, "landmarks");
                    String[] stringArray = hashtable.isEmpty() ? none : hashtable.keySet().toArray(new String[0]);
                    genericDialog.addChoice("Landmarks node in this project:", stringArray, stringArray[0]);
                    genericDialog.addMessage("");
                    genericDialog.addChoice("Source project:", project_titles, project_titles[0]);
                    final Hashtable map_source = Display.findLandmarkNodes((Project)mpr.get(project_titles[0]), "landmarks");
                    String[] source_landmark_titles = map_source.isEmpty() ? none : map_source.keySet().toArray(new String[0]);
                    genericDialog.addChoice("Landmarks node in source project:", source_landmark_titles, source_landmark_titles[0]);
                    final List stacks = Display.getPatchStacks(((Project)mpr.get(project_titles[0])).getRootLayerSet());
                    if (stacks.isEmpty()) {
                        if (1 == mpr.size()) {
                            IJ.showMessage((String)("Project " + project_titles[0] + " does not contain any Stack."));
                            return;
                        }
                        stack_titles = none;
                    } else {
                        stack_titles = new String[stacks.size()];
                        int next = 0;
                        for (Patch pa : stacks) {
                            stack_titles[next++] = pa.toString();
                        }
                    }
                    genericDialog.addChoice("Stacks:", stack_titles, stack_titles[0]);
                    Vector vc = genericDialog.getChoices();
                    final Choice choice_target_landmarks = (Choice)vc.get(0);
                    final Choice choice_source_projects = (Choice)vc.get(1);
                    final Choice choice_source_landmarks = (Choice)vc.get(2);
                    final Choice choice_stacks = (Choice)vc.get(3);
                    final TextField input = (TextField)genericDialog.getStringFields().get(0);
                    input.addTextListener(new TextListener(){

                        @Override
                        public void textValueChanged(TextEvent te) {
                            String text = input.getText();
                            this.update(choice_target_landmarks, Display.this.project, text, hashtable);
                            this.update(choice_source_landmarks, (Project)mpr.get(choice_source_projects.getSelectedItem()), text, map_source);
                        }

                        private void update(Choice c, Project p, String type, Hashtable<String, ProjectThing> table) {
                            table.clear();
                            table.putAll(Display.findLandmarkNodes(p, type));
                            c.removeAll();
                            if (table.isEmpty()) {
                                c.add(none[0]);
                            } else {
                                for (String t : table.keySet()) {
                                    c.add(t);
                                }
                            }
                        }
                    });
                    choice_source_projects.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            String item = (String)e.getItem();
                            Project p = (Project)mpr.get(choice_source_projects.getSelectedItem());
                            map_source.clear();
                            map_source.putAll(Display.findLandmarkNodes(p, input.getText()));
                            choice_target_landmarks.removeAll();
                            if (map_source.isEmpty()) {
                                choice_target_landmarks.add(none[0]);
                            } else {
                                for (String t : map_source.keySet()) {
                                    choice_target_landmarks.add(t);
                                }
                            }
                            stacks.clear();
                            choice_stacks.removeAll();
                            stacks.addAll(Display.getPatchStacks(((Project)mpr.get(project_titles[0])).getRootLayerSet()));
                            if (stacks.isEmpty()) {
                                choice_stacks.add(none[0]);
                            } else {
                                for (Patch pa : stacks) {
                                    choice_stacks.add(pa.toString());
                                }
                            }
                        }
                    });
                    genericDialog.showDialog();
                    if (genericDialog.wasCanceled()) {
                        return;
                    }
                    String type = genericDialog.getNextString();
                    if (null == type || 0 == type.trim().length()) {
                        Utils.log("Invalid landmarks node type!");
                        return;
                    }
                    ProjectThing target_landmarks_node = (ProjectThing)hashtable.get(genericDialog.getNextChoice());
                    Project source = (Project)mpr.get(genericDialog.getNextChoice());
                    ProjectThing source_landmarks_node = (ProjectThing)map_source.get(genericDialog.getNextChoice());
                    Patch stack_patch = (Patch)stacks.get(genericDialog.getNextChoiceIndex());
                    Display.this.getLayerSet().addLayerContentStep(Display.this.layer);
                    Display.this.insertStack(target_landmarks_node, source, source_landmarks_node, stack_patch);
                    Display.this.getLayerSet().addChangeTreesStep();
                } else if (command.equals("Import grid...")) {
                    Display.this.getLayerSet().addLayerContentStep(Display.this.layer);
                    Bureaucrat burro = Display.this.project.getLoader().importGrid(Display.this.layer);
                    if (null != burro) {
                        burro.addPostTask(new Runnable(){

                            @Override
                            public void run() {
                                Display.this.getLayerSet().addLayerContentStep(Display.this.layer);
                            }
                        });
                    }
                } else if (command.equals("Import sequence as grid...")) {
                    Display.this.getLayerSet().addChangeTreesStep();
                    Bureaucrat burro = Display.this.project.getLoader().importSequenceAsGrid(Display.this.layer);
                    if (null != burro) {
                        burro.addPostTask(new Runnable(){

                            @Override
                            public void run() {
                                Display.this.getLayerSet().addChangeTreesStep();
                            }
                        });
                    }
                } else if (command.equals("Import from text file...")) {
                    Display.this.getLayerSet().addChangeTreesStep();
                    Bureaucrat burro = Display.this.project.getLoader().importImages(Display.this.layer);
                    if (null != burro) {
                        burro.addPostTask(new Runnable(){

                            @Override
                            public void run() {
                                Display.this.getLayerSet().addChangeTreesStep();
                            }
                        });
                    }
                } else if (command.equals("Import labels as arealists...")) {
                    Display.this.getLayerSet().addChangeTreesStep();
                    Bureaucrat burro = Display.this.project.getLoader().importLabelsAsAreaLists(Display.this.layer, null, Double.MAX_VALUE, 0.0, 0.4f, false);
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().addChangeTreesStep();
                        }
                    });
                } else if (command.equals("Make flat image...")) {
                    int n;
                    Rectangle srcRect = null;
                    Roi roi = Display.this.canvas.getFakeImagePlus().getRoi();
                    srcRect = null != roi ? roi.getBounds() : new Rectangle(0, 0, (int)Math.ceil(Display.this.layer.getParent().getLayerWidth()), (int)Math.ceil(Display.this.layer.getParent().getLayerHeight()));
                    double scale = 1.0;
                    String[] types = new String[]{"8-bit grayscale", "RGB Color"};
                    boolean bl = false;
                    GenericDialog genericDialog = new GenericDialog("Choose", (Frame)Display.this.frame);
                    genericDialog.addSlider("Scale: ", 1.0, 100.0, 100.0);
                    genericDialog.addNumericField("Width: ", (double)srcRect.width, 0);
                    genericDialog.addNumericField("height: ", (double)srcRect.height, 0);
                    Vector numfields = genericDialog.getNumericFields();
                    UpdateDimensionField udf = new UpdateDimensionField(srcRect.width, srcRect.height, (TextField)numfields.get(1), (TextField)numfields.get(2), (TextField)numfields.get(0), (Scrollbar)genericDialog.getSliders().get(0));
                    for (Object ob : numfields) {
                        ((TextField)ob).addTextListener(udf);
                    }
                    genericDialog.addChoice("Type: ", types, types[0]);
                    if (Display.this.layer.getParent().size() > 1) {
                        Utils.addLayerRangeChoices(Display.this.layer, genericDialog);
                        genericDialog.addCheckbox("Include non-empty layers only", true);
                    }
                    genericDialog.addMessage("Background color:");
                    Utils.addRGBColorSliders(genericDialog, Color.black);
                    genericDialog.addCheckbox("Best quality", false);
                    genericDialog.addMessage("");
                    String[] choices = new String[]{"Show", "Save to file", "Save for web (CATMAID)"};
                    genericDialog.addChoice("Export:", choices, choices[0]);
                    String[] formats = Saver.formats();
                    genericDialog.addChoice("Format:", formats, formats[0]);
                    genericDialog.addNumericField("Tile_side", 1024.0, 0);
                    final Choice cformats = (Choice)genericDialog.getChoices().get(genericDialog.getChoices().size() - 1);
                    cformats.setEnabled(false);
                    final Choice cchoices = (Choice)genericDialog.getChoices().get(genericDialog.getChoices().size() - 2);
                    final TextField tf = (TextField)genericDialog.getNumericFields().get(genericDialog.getNumericFields().size() - 1);
                    tf.setEnabled(false);
                    genericDialog.addChoice("Directory structure", new String[]{"<section>/<Y>_<X>_<scale_power>.<ext>", "<section>/<scale_power>/<Y>_<X>.<ext>"}, "<section>/<scale_power>/<Y>_<X>.<ext>");
                    Choice tile_directory_structure = (Choice)genericDialog.getChoices().get(genericDialog.getChoices().size() - 1);
                    tile_directory_structure.setEnabled(false);
                    genericDialog.addChoice("Strategy:", new String[]{"Use original images", "Use mipmaps", "Use mipmaps (multi-layer)"}, "Use mipmaps (multi-layer)");
                    Choice cstrategy = (Choice)genericDialog.getChoices().get(genericDialog.getChoices().size() - 1);
                    cstrategy.setEnabled(false);
                    genericDialog.addCheckbox("Skip empty tiles", true);
                    Checkbox cb_skip = (Checkbox)genericDialog.getCheckboxes().get(genericDialog.getCheckboxes().size() - 1);
                    cb_skip.setEnabled(false);
                    genericDialog.addCheckbox("Use layer indices", true);
                    Checkbox cb_li = (Checkbox)genericDialog.getCheckboxes().get(genericDialog.getCheckboxes().size() - 1);
                    cb_li.setEnabled(false);
                    genericDialog.addNumericField("Number of threads", (double)Display.this.project.getProperty("n_mipmap_threads", 1), 0);
                    Component cnt = (Component)genericDialog.getNumericFields().get(genericDialog.getNumericFields().size() - 1);
                    cnt.setEnabled(false);
                    final Component[] cweb = new Component[]{tf, tile_directory_structure, cstrategy, cb_skip, cb_li, cnt};
                    cchoices.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            cformats.setEnabled(cchoices.getSelectedIndex() > 0);
                            if (2 == cchoices.getSelectedIndex()) {
                                cformats.select(".jpg");
                                for (Component c : cweb) {
                                    c.setEnabled(true);
                                }
                            } else {
                                tf.setEnabled(false);
                            }
                        }
                    });
                    genericDialog.showDialog();
                    if (genericDialog.wasCanceled()) {
                        return;
                    }
                    scale = genericDialog.getNextNumber() / 100.0;
                    int n3 = n = 0 == genericDialog.getNextChoiceIndex() ? 0 : 4;
                    if (Double.isNaN(scale) || scale <= 0.0) {
                        Utils.showMessage("Invalid scale.");
                        return;
                    }
                    genericDialog.getNextNumber();
                    genericDialog.getNextNumber();
                    Layer[] layer_array = null;
                    boolean non_empty_only = false;
                    if (Display.this.layer.getParent().size() > 1) {
                        non_empty_only = genericDialog.getNextBoolean();
                        int i_start = genericDialog.getNextChoiceIndex();
                        int i_end = genericDialog.getNextChoiceIndex();
                        ArrayList<Layer> al = new ArrayList<Layer>();
                        ArrayList<ZDisplayable> al_zd = Display.this.layer.getParent().getZDisplayables();
                        ZDisplayable[] zd = new ZDisplayable[al_zd.size()];
                        al_zd.toArray(zd);
                        for (int i = i_start; i <= i_end; ++i) {
                            Layer la = Display.this.layer.getParent().getLayer(i);
                            if (la.isEmpty() && non_empty_only) continue;
                            al.add(la);
                        }
                        if (0 == al.size()) {
                            Utils.showMessage("All layers are empty!");
                            return;
                        }
                        layer_array = new Layer[al.size()];
                        al.toArray(layer_array);
                    } else {
                        layer_array = new Layer[]{Display.this.layer};
                    }
                    Color background = new Color((int)genericDialog.getNextNumber(), (int)genericDialog.getNextNumber(), (int)genericDialog.getNextNumber());
                    boolean quality = genericDialog.getNextBoolean();
                    int choice = genericDialog.getNextChoiceIndex();
                    boolean save_to_file = 1 == choice;
                    boolean save_for_web = 2 == choice;
                    String format = genericDialog.getNextChoice();
                    Saver saver = new Saver(format);
                    int tile_side = (int)genericDialog.getNextNumber();
                    int directory_structure_type = genericDialog.getNextChoiceIndex();
                    int strategy = genericDialog.getNextChoiceIndex();
                    boolean skip_empty_tiles = genericDialog.getNextBoolean();
                    boolean use_layer_indices = genericDialog.getNextBoolean();
                    double nt = genericDialog.getNextNumber();
                    int n_threads = (int)(Double.isNaN(nt) ? 1.0 : Math.max(1.0, nt));
                    if (save_for_web) {
                        Display.this.project.getLoader().makePrescaledTiles(layer_array, Patch.class, srcRect, Display.this.c_alphas, n, null, strategy, saver, tile_side, directory_structure_type, skip_empty_tiles, use_layer_indices, n_threads);
                    } else {
                        Display.this.project.getLoader().makeFlatImage(layer_array, srcRect, scale, Display.this.c_alphas, n, save_to_file, format, quality, background);
                    }
                } else if (command.equals("Lock")) {
                    Display.this.selection.setLocked(true);
                    Utils.revalidateComponent(Display.this.tabs.getSelectedComponent());
                } else if (command.equals("Unlock")) {
                    Display.this.selection.setLocked(false);
                    Utils.revalidateComponent(Display.this.tabs.getSelectedComponent());
                } else if (command.equals("Properties...")) {
                    switch (Display.this.selection.getSelected().size()) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            Display.this.active.adjustProperties();
                            break;
                        }
                        default: {
                            Display.this.adjustGroupProperties(Display.this.selection.getSelected());
                        }
                    }
                    Display.updateSelection();
                } else if (command.equals("Measurement options...")) {
                    Display.this.adjustMeasurementOptions();
                } else if (command.equals("Show current 2D position in 3D")) {
                    java.awt.Point p = Display.this.canvas.consumeLastPopupPoint();
                    if (null == p) {
                        return;
                    }
                    Display3D.addFatPoint("Current 2D Position", Display.this.getLayerSet(), p.x, p.y, Display.this.layer.getZ(), 10.0, Color.magenta);
                } else if (command.equals("Show layers as orthoslices in 3D")) {
                    GenericDialog gd = new GenericDialog("Options");
                    Roi roi = Display.this.canvas.getFakeImagePlus().getRoi();
                    Rectangle r = null == roi ? Display.this.getLayerSet().get2DBounds() : roi.getBounds();
                    gd.addMessage("ROI 2D bounds:");
                    gd.addNumericField("x:", (double)r.x, 0, 30, "pixels");
                    gd.addNumericField("y:", (double)r.y, 0, 30, "pixels");
                    gd.addNumericField("width:", (double)r.width, 0, 30, "pixels");
                    gd.addNumericField("height:", (double)r.height, 0, 30, "pixels");
                    gd.addMessage("Layers to include:");
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.addMessage("Constrain dimensions to:");
                    gd.addNumericField("max width and height:", (double)Display.this.getLayerSet().getPixelsMaxDimension(), 0, 30, "pixels");
                    gd.addMessage("Options:");
                    String[] types = new String[]{"Greyscale", "Color RGB"};
                    gd.addChoice("Image type:", types, types[0]);
                    gd.addCheckbox("Invert images", false);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    int x = (int)gd.getNextNumber();
                    int n = (int)gd.getNextNumber();
                    int n4 = (int)gd.getNextNumber();
                    int height = (int)gd.getNextNumber();
                    int first = gd.getNextChoiceIndex();
                    int last = gd.getNextChoiceIndex();
                    List<Layer> layers = Display.this.getLayerSet().getLayers(first, last);
                    int max_dim = Math.min((int)gd.getNextNumber(), Math.max(n4, height));
                    float scale = 1.0f;
                    if (max_dim < Math.max(n4, height)) {
                        scale = (float)max_dim / (float)Math.max(n4, height);
                    }
                    int type = 0 == gd.getNextChoiceIndex() ? 0 : 4;
                    boolean invert = gd.getNextBoolean();
                    LayerStack stack = new LayerStack(layers, new Rectangle(x, n, n4, height), scale, type, Patch.class, max_dim, invert);
                    Display3D.showOrthoslices(stack.getImagePlus(), "LayerSet [" + x + "," + n + "," + n4 + "," + height + "] " + first + "--" + last, x, n, scale, layers.get(0));
                } else if (command.equals("Align stack slices")) {
                    if (Display.this.getActive() instanceof Patch) {
                        Patch slice = (Patch)Display.this.getActive();
                        if (slice.isStack()) {
                            HashSet<Displayable> hashSet = slice.getLinkedGroup(new HashSet<Displayable>());
                            Iterator<Displayable> it = hashSet.iterator();
                            while (it.hasNext()) {
                                if (it.next().getClass() == Patch.class) continue;
                                Utils.showMessage("Images are linked to other objects, can't proceed to cross-correlate them.");
                                return;
                            }
                            final LayerSet ls = slice.getLayerSet();
                            final HashSet<Displayable> linked = slice.getLinkedGroup(null);
                            ls.addTransformStepWithData(linked);
                            Bureaucrat burro = AlignTask.registerStackSlices((Patch)Display.this.getActive());
                            burro.addPostTask(new Runnable(){

                                @Override
                                public void run() {
                                    ls.enlargeToFit(linked);
                                    ls.addTransformStepWithData(linked);
                                }
                            });
                        } else {
                            Utils.log("Align stack slices: selected image is not part of a stack.");
                        }
                    }
                } else if (command.equals("Align layers manually with landmarks")) {
                    Display.this.setMode(new ManualAlignMode(Display.this));
                } else if (command.equals("Align layers")) {
                    Roi roi = Display.this.canvas.getFakeImagePlus().getRoi();
                    if (null != roi) {
                        YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)Display.this.frame, "Use ROI?", "Snapshot layers using the ROI bounds?\n" + roi.getBounds());
                        if (yesNoCancelDialog.cancelPressed()) {
                            return;
                        }
                        if (!yesNoCancelDialog.yesPressed()) {
                            roi = null;
                        }
                    }
                    final Layer layer = Display.this.layer;
                    layer.getParent().addTransformStep((List<Layer>)layer.getParent().getLayers());
                    Bureaucrat burro = AlignLayersTask.alignLayersTask(layer, null == roi ? null : roi.getBounds());
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().enlargeToFit(Display.this.getLayerSet().getDisplayables(Patch.class));
                            layer.getParent().addTransformStep((List<Layer>)layer.getParent().getLayers());
                        }
                    });
                } else if (command.equals("Align multi-layer mosaic")) {
                    final Layer la = Display.this.layer;
                    la.getParent().addTransformStep();
                    Bureaucrat bureaucrat = AlignTask.alignMultiLayerMosaicTask(la, Display.this.active instanceof Patch ? (Patch)Display.this.active : null);
                    bureaucrat.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().enlargeToFit(Display.this.getLayerSet().getDisplayables(Patch.class));
                            la.getParent().addTransformStep();
                        }
                    });
                } else if (command.equals("Montage all images in this layer")) {
                    final Layer la = Display.this.layer;
                    final ArrayList<Displayable> arrayList = new ArrayList<Displayable>(la.getDisplayables(Patch.class, true));
                    if (arrayList.size() < 2) {
                        Utils.showMessage("Montage needs 2 or more visible images");
                        return;
                    }
                    final Collection<Displayable> col = la.getParent().addTransformStepWithDataForAll(Arrays.asList(la));
                    HashSet<Patch> fixed = new HashSet<Patch>();
                    for (Patch patch : arrayList) {
                        if (!patch.isLocked2() && !Display.this.selection.contains(patch)) continue;
                        fixed.add(patch);
                    }
                    if (arrayList.size() == fixed.size()) {
                        Utils.showMessage("Can't do", "No montage possible: all images are selected,\nand hence all are considered locked.\nSelect only one image to be used as reference, or none.");
                        return;
                    }
                    Utils.log("Using " + fixed.size() + " image" + (fixed.size() == 1 ? "" : "s") + " as reference.");
                    Bureaucrat burro = AlignTask.alignPatchesTask(arrayList, fixed);
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().enlargeToFit(arrayList);
                            la.getParent().addTransformStepWithData(col);
                        }
                    });
                } else if (command.equals("Montage selected images")) {
                    final Layer la = Display.this.layer;
                    if (Display.this.selection.getSelected(Patch.class).size() < 2) {
                        Utils.showMessage("Montage needs 2 or more images selected");
                        return;
                    }
                    final Collection<Displayable> collection = la.getParent().addTransformStepWithDataForAll(Arrays.asList(la));
                    Bureaucrat burro = AlignTask.alignSelectionTask(Display.this.selection);
                    if (null == burro) {
                        return;
                    }
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            la.getParent().enlargeToFit(Display.this.selection.getAffected());
                            la.getParent().addTransformStepWithData(collection);
                        }
                    });
                } else if (command.equals("Montage multiple layers")) {
                    GenericDialog gd = new GenericDialog("Choose range");
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    final List<Layer> list = Display.this.getLayerSet().getLayers(gd.getNextChoiceIndex(), gd.getNextChoiceIndex());
                    final Collection<Displayable> col = Display.this.getLayerSet().addTransformStepWithDataForAll(list);
                    Bureaucrat burro = AlignTask.montageLayersTask(list);
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<Displayable> ds = new ArrayList<Displayable>();
                            for (Layer la : list) {
                                ds.addAll(la.getDisplayables(Patch.class));
                            }
                            Display.this.getLayerSet().enlargeToFit(ds);
                            Display.this.getLayerSet().addTransformStepWithData(col);
                        }
                    });
                } else if (command.equals("Properties ...")) {
                    Display.this.adjustProperties();
                } else if (command.equals("Adjust snapping parameters...")) {
                    AlignTask.p_snap.setup("Snap");
                } else if (command.equals("Adjust fast-marching parameters...")) {
                    Segmentation.fmp.setup();
                } else if (command.equals("Adjust arealist paint parameters...")) {
                    AreaWrapper.PP.setup();
                } else if (command.equals("Fill ROI in alpha mask")) {
                    if (Display.this.active.getClass() == Patch.class) {
                        ((Patch)Display.this.active).keyPressed(new KeyEvent((Component)((Object)Display.this.getCanvas()), -1, System.currentTimeMillis(), 0, 70, 'f'));
                    }
                } else if (command.equals("Fill inverse ROI in alpha mask")) {
                    if (Display.this.active.getClass() == Patch.class) {
                        ((Patch)Display.this.active).keyPressed(new KeyEvent((Component)((Object)Display.this.getCanvas()), -1, System.currentTimeMillis(), 1, 70, 'f'));
                    }
                } else if (command.equals("Search...")) {
                    Search.showWindow();
                } else if (command.equals("Select all")) {
                    Display.this.selection.selectAll();
                    Display.repaint(Display.this.layer, Display.this.selection.getBox(), 0);
                } else if (command.equals("Select all visible")) {
                    Display.this.selection.selectAllVisible();
                    Display.repaint(Display.this.layer, Display.this.selection.getBox(), 0);
                } else if (command.equals("Select all that match...")) {
                    List ds = Display.this.find();
                    Display.this.selection.selectAll(ds);
                    Utils.showStatus("Added " + ds.size() + " to selection.");
                } else if (command.equals("Select none")) {
                    Rectangle box = Display.this.selection.getBox();
                    Display.this.selection.clear();
                    Display.repaint(Display.this.layer, box, 0);
                } else if (command.equals("Restore selection")) {
                    Display.this.selection.restore();
                } else if (command.equals("Select under ROI")) {
                    Roi roi = Display.this.canvas.getFakeImagePlus().getRoi();
                    if (null == roi) {
                        return;
                    }
                    Display.this.selection.selectAll(roi, true);
                } else if (command.equals("Merge") || command.equals("Split")) {
                    Bureaucrat burro = Bureaucrat.create((Worker)new Worker.Task(command + "ing AreaLists"){

                        @Override
                        public void exec() {
                            ArrayList<Displayable> al_sel = Display.this.selection.getSelected(AreaList.class);
                            al_sel.remove(Display.this.active);
                            al_sel.add(0, Display.this.active);
                            HashSet<DoStep> dataedits = new HashSet<DoStep>();
                            if (command.equals("Merge")) {
                                dataedits.add(new Displayable.DoEdit(Display.this.active).init(Display.this.active, new String[]{"data"}));
                                Display.this.getLayerSet().addChangeTreesStep(dataedits);
                                AreaList ali = AreaList.merge(al_sel);
                                if (null != ali) {
                                    for (int i = 1; i < al_sel.size(); ++i) {
                                        Displayable ob = al_sel.get(i);
                                        if (ob.getClass() != AreaList.class) continue;
                                        Display.this.selection.remove(ob);
                                    }
                                    Display.this.selection.updateTransform(ali);
                                    Display.repaint(ali.getLayerSet(), (Displayable)ali, 0);
                                }
                            } else if (command.equals("Split")) {
                                for (Displayable d : al_sel) {
                                    if (d.getClass() != AreaList.class) continue;
                                    dataedits.add(new Displayable.DoEdit(d).init(d, new String[]{"data"}));
                                }
                                Display.this.getLayerSet().addChangeTreesStep(dataedits);
                                try {
                                    ArrayList<AreaList> alis = AreaList.split(al_sel);
                                    for (AreaList ali : alis) {
                                        if (Display.this.selection.contains(ali)) continue;
                                        Display.this.selection.add(ali);
                                    }
                                }
                                catch (Exception e) {
                                    IJError.print(e);
                                    Display.this.getLayerSet().undoOneStep();
                                }
                            }
                        }
                    }, Display.this.project);
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            HashSet<DoStep> dataedits = new HashSet<DoStep>();
                            dataedits.add(new Displayable.DoEdit(Display.this.active).init(Display.this.active, new String[]{"data"}));
                            Display.this.getLayerSet().addChangeTreesStep(dataedits);
                        }
                    });
                    burro.goHaveBreakfast();
                } else if (command.equals("Reroot")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    Display.this.getLayerSet().addDataEditStep(Display.this.active);
                    if (((Tree)Display.this.active).reRoot(((Tree)Display.this.active).getLastVisited())) {
                        Display.this.getLayerSet().addDataEditStep(Display.this.active);
                        Display.repaint(Display.this.getLayerSet());
                    } else {
                        Display.this.getLayerSet().removeLastUndoStep();
                    }
                } else if (command.equals("Part subtree")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    if (!Utils.check("Really part the subtree?")) {
                        return;
                    }
                    LayerSet.DoChangeTrees step = Display.this.getLayerSet().addChangeTreesStep();
                    HashSet<DoStep> hashSet = new HashSet<DoStep>();
                    hashSet.add(new Displayable.DoEdit(Display.this.active).init(Display.this.active, new String[]{"data"}));
                    step.addDependents(hashSet);
                    List ts = ((Tree)Display.this.active).splitAt(((Tree)Display.this.active).getLastVisited());
                    if (null == ts) {
                        Display.this.getLayerSet().removeLastUndoStep();
                        return;
                    }
                    Displayable elder = Display.this.active;
                    HashSet<DoStep> deps2 = new HashSet<DoStep>();
                    for (ZDisplayable zDisplayable : ts) {
                        deps2.add(new Displayable.DoEdit(zDisplayable).init(zDisplayable, new String[]{"data"}));
                        if (zDisplayable == elder) continue;
                        Display.this.getLayerSet().add(zDisplayable);
                        Display.this.project.getProjectTree().addSibling(elder, zDisplayable);
                    }
                    Display.this.selection.clear();
                    Display.this.selection.selectAll(ts);
                    Display.this.selection.add(elder);
                    LayerSet.DoChangeTrees doChangeTrees = Display.this.getLayerSet().addChangeTreesStep();
                    doChangeTrees.addDependents(deps2);
                    Display.repaint(Display.this.getLayerSet());
                } else if (command.equals("Show tabular view")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    ((Tree)Display.this.active).createMultiTableView();
                } else if (command.equals("Mark")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    java.awt.Point p = Display.this.canvas.consumeLastPopupPoint();
                    if (null == p) {
                        return;
                    }
                    if (((Tree)Display.this.active).markNear(p.x, p.y, Display.this.layer, Display.this.canvas.getMagnification())) {
                        Display.repaint(Display.this.getLayerSet());
                    }
                } else if (command.equals("Clear marks (selected Trees)")) {
                    for (Tree tree : Display.this.selection.get(Tree.class)) {
                        tree.unmark();
                    }
                    Display.repaint(Display.this.getLayerSet());
                } else if (command.equals("Join")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    List<?> tlines = Display.this.selection.get(Display.this.active.getClass());
                    if (((Tree)Display.this.active).canJoin(tlines)) {
                        int n = ((Tree)Display.this.active).getRoot().getSubtreeNodes().size();
                        String warning = "";
                        for (Iterator<?> t : tlines) {
                            if (Display.this.active == t) continue;
                            if (null == ((Tree)((Object)t)).getRoot()) {
                                Utils.log("Removed empty tree #" + ((DBObject)((Object)t)).getId() + " from those to join.");
                                tlines.remove(t);
                                continue;
                            }
                            if (((Tree)((Object)t)).getRoot().getSubtreeNodes().size() <= n) continue;
                            warning = "\nWARNING joining into a tree that is not the largest!";
                            break;
                        }
                        if (!Utils.check("Join these " + tlines.size() + " trees into the tree " + Display.this.active + " ?" + warning)) {
                            return;
                        }
                        HashSet<DoStep> dataedits = new HashSet<DoStep>(tlines.size());
                        for (Tree tree : tlines) {
                            dataedits.add(new Displayable.DoEdit(tree).init(tree, new String[]{"data"}));
                        }
                        Display.this.getLayerSet().addChangeTreesStep(dataedits);
                        ((Tree)Display.this.active).join(tlines);
                        for (Tree tree : tlines) {
                            if (tree == Display.this.active) continue;
                            tree.remove2(false);
                        }
                        Display.repaint(Display.this.getLayerSet());
                        HashSet<DoStep> dataedits2 = new HashSet<DoStep>(1);
                        dataedits2.add(new Displayable.DoEdit(Display.this.active).init(Display.this.active, new String[]{"data"}));
                        Display.this.getLayerSet().addChangeTreesStep(dataedits2);
                    } else {
                        Utils.showMessage("Can't do", "Only one tree is selected.\nSelect more than one tree to perform a join operation!");
                    }
                } else if (command.equals("Previous branch node or start")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    java.awt.Point p = Display.this.canvas.consumeLastPopupPoint();
                    if (null == p) {
                        return;
                    }
                    Display.this.center(((Treeline)Display.this.active).findPreviousBranchOrRootPoint(p.x, p.y, Display.this.layer, Display.this.canvas));
                } else if (command.equals("Next branch node or end")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    java.awt.Point p = Display.this.canvas.consumeLastPopupPoint();
                    if (null == p) {
                        return;
                    }
                    Display.this.center(((Tree)Display.this.active).findNextBranchOrEndPoint(p.x, p.y, Display.this.layer, Display.this.canvas));
                } else if (command.equals("Root")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    java.awt.Point p = Display.this.canvas.consumeLastPopupPoint();
                    if (null == p) {
                        return;
                    }
                    Display.this.center(((Tree)Display.this.active).createCoordinate(((Tree)Display.this.active).getRoot()));
                } else if (command.equals("Last added node")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    Display.this.center(((Treeline)Display.this.active).getLastAdded());
                } else if (command.equals("Last edited node")) {
                    if (!(Display.this.active instanceof Tree)) {
                        return;
                    }
                    Display.this.center(((Treeline)Display.this.active).getLastEdited());
                } else if (command.equals("Reverse point order")) {
                    if (!(Display.this.active instanceof Pipe)) {
                        return;
                    }
                    Display.this.getLayerSet().addDataEditStep(Display.this.active);
                    ((Pipe)Display.this.active).reverse();
                    Display.repaint(Display.this.layer);
                    Display.this.getLayerSet().addDataEditStep(Display.this.active);
                } else if (command.equals("View orthoslices")) {
                    if (!(Display.this.active instanceof Patch)) {
                        return;
                    }
                    Display3D.showOrthoslices((Patch)Display.this.active);
                } else if (command.equals("View volume")) {
                    if (!(Display.this.active instanceof Patch)) {
                        return;
                    }
                    Display3D.showVolume((Patch)Display.this.active);
                } else if (command.equals("Show in 3D")) {
                    for (ZDisplayable zDisplayable : Display.this.selection.get(ZDisplayable.class)) {
                        Display3D.show(zDisplayable.getProject().findProjectThing(zDisplayable));
                    }
                    HashSet<ProjectThing> hs = new HashSet<ProjectThing>();
                    for (Profile d : Display.this.selection.get(Profile.class)) {
                        ProjectThing profile_list = (ProjectThing)d.getProject().findProjectThing(d).getParent();
                        if (hs.contains(profile_list)) continue;
                        Display3D.show(profile_list);
                        hs.add(profile_list);
                    }
                } else if (command.equals("Snap")) {
                    if (!(Display.this.active instanceof Patch)) {
                        return;
                    }
                    Display.snap((Patch)Display.this.active);
                } else if (command.equals("Blend") || command.equals("Blend (selected images)...")) {
                    HashSet<Patch> patches = new HashSet<Patch>(Display.this.selection.get(Patch.class));
                    if (patches.size() > 1) {
                        GenericDialog genericDialog = new GenericDialog("Blending");
                        genericDialog.addCheckbox("Respect current alpha mask", true);
                        genericDialog.showDialog();
                        if (genericDialog.wasCanceled()) {
                            return;
                        }
                        Blending.blend(patches, genericDialog.getNextBoolean());
                    } else {
                        IJ.log((String)"Please select more than one overlapping image.");
                    }
                } else if (command.equals("Blend (layer-wise)...")) {
                    GenericDialog gd = new GenericDialog("Blending");
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.addCheckbox("Respect current alpha mask", true);
                    gd.addMessage("Filter:");
                    gd.addStringField("Use only images whose title matches:", "", 30);
                    gd.addCheckbox("Blend visible patches only", true);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    boolean bl = gd.getNextBoolean();
                    String toMatch = gd.getNextString().trim();
                    final String regex = 0 == toMatch.length() ? null : ".*" + toMatch + ".*";
                    final boolean visible_only = gd.getNextBoolean();
                    Blending.blendLayerWise(Display.this.getLayerSet().getLayers(gd.getNextChoiceIndex(), gd.getNextChoiceIndex()), bl, new Filter<Patch>(){

                        @Override
                        public final boolean accept(Patch patch) {
                            if (visible_only && !patch.isVisible()) {
                                return false;
                            }
                            if (null == regex) {
                                return true;
                            }
                            return patch.getTitle().matches(regex);
                        }
                    });
                } else if (command.equals("Match intensities (layer-wise)...")) {
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Match intensities"){

                        @Override
                        public void exec() {
                            MatchIntensities matching = new MatchIntensities();
                            matching.invoke(Display.this.getActive());
                        }
                    }, Display.this.project);
                } else if (command.equals("Remove intensity maps (layer-wise)...")) {
                    final GenericDialog gd = new GenericDialog("Remove intensity maps");
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Match intensities"){

                        @Override
                        public void exec() {
                            for (Layer layer : Display.this.getLayerSet().getLayers(gd.getNextChoiceIndex(), gd.getNextChoiceIndex())) {
                                for (Displayable p : layer.getDisplayables(Patch.class)) {
                                    Patch patch = (Patch)p;
                                    if (!patch.clearIntensityMap()) continue;
                                    patch.updateMipMaps();
                                }
                            }
                        }
                    }, Display.this.project);
                } else if (command.equals("Montage")) {
                    final HashSet<Displayable> affected = new HashSet<Displayable>(Display.this.selection.getAffected());
                    final LayerSet layerSet = Display.this.layer.getParent();
                    layerSet.addTransformStepWithData(affected);
                    Bureaucrat burro = AlignTask.alignSelectionTask(Display.this.selection);
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            layerSet.enlargeToFit(affected);
                            layerSet.addTransformStepWithData(affected);
                        }
                    });
                } else if (command.equals("Lens correction")) {
                    final Layer la = Display.this.layer;
                    la.getParent().addDataEditStep(new HashSet<Displayable>(la.getParent().getDisplayables()));
                    Bureaucrat bureaucrat = DistortionCorrectionTask.correctDistortionFromSelection(Display.this.selection);
                    bureaucrat.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            la.getParent().addDataEditStep(new HashSet<Displayable>(la.getParent().getDisplayables()));
                        }
                    });
                } else if (command.equals("Link images...")) {
                    void var8_232;
                    GenericDialog gd = new GenericDialog("Options");
                    gd.addMessage("Linking images to images (within their own layer only):");
                    String[] stringArray = new String[]{"all images to all images", "each image with any other overlapping image"};
                    gd.addChoice("Link: ", stringArray, stringArray[1]);
                    String[] options2 = new String[]{"selected images only", "all images in this layer", "all images in all layers, within the layer only", "all images in all layers, within and across consecutive layers"};
                    gd.addChoice("Apply to: ", options2, options2[0]);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    Layer lay = Display.this.layer;
                    HashSet<Displayable> ds = new HashSet<Displayable>(lay.getParent().getDisplayables());
                    lay.getParent().addDataEditStep(ds, new String[]{"data"});
                    boolean bl = 1 == gd.getNextChoiceIndex();
                    Object var8_224 = null;
                    switch (gd.getNextChoiceIndex()) {
                        case 0: {
                            ArrayList<Displayable> arrayList = Display.this.selection.getSelected(Patch.class);
                            Patch.crosslink(arrayList, bl);
                            break;
                        }
                        case 1: {
                            ArrayList<Displayable> arrayList = lay.getDisplayables(Patch.class);
                            Patch.crosslink(arrayList, bl);
                            break;
                        }
                        case 2: {
                            ArrayList<Displayable> arrayList = new ArrayList<Displayable>();
                            for (Layer la : lay.getParent().getLayers()) {
                                ArrayList<Displayable> acoll = la.getDisplayables(Patch.class);
                                Patch.crosslink(acoll, bl);
                                arrayList.addAll(acoll);
                            }
                            break;
                        }
                        case 3: {
                            ArrayList<Layer> layers = lay.getParent().getLayers();
                            ArrayList<Displayable> lc1 = layers.get(0).getDisplayables(Patch.class);
                            if (lay == layers.get(0)) {
                                ArrayList<Displayable> arrayList = lc1;
                            }
                            for (int i = 1; i < layers.size(); ++i) {
                                void var8_230;
                                ArrayList<Displayable> lc2 = layers.get(i).getDisplayables(Patch.class);
                                if (null == var8_230 && Display.this.layer == layers.get(i)) {
                                    ArrayList<Displayable> arrayList = lc2;
                                }
                                ArrayList<Displayable> both = new ArrayList<Displayable>();
                                both.addAll(lc1);
                                both.addAll(lc2);
                                Patch.crosslink(both, bl);
                                lc1 = lc2;
                            }
                            break;
                        }
                    }
                    if (null != var8_232) {
                        Display.updateCheckboxes((Collection<Displayable>)var8_232, 4, true);
                    }
                    lay.getParent().addDataEditStep(ds);
                } else if (command.equals("Unlink all selected images")) {
                    if (Utils.check("Really unlink selected images?")) {
                        ArrayList<Displayable> ds = Display.this.selection.getSelected(Patch.class);
                        for (Displayable d : ds) {
                            d.unlink();
                        }
                        Display.updateCheckboxes(ds, 4);
                    }
                } else if (command.equals("Unlink all")) {
                    if (Utils.check("Really unlink all objects from all layers?")) {
                        ArrayList<Displayable> ds = Display.this.layer.getParent().getDisplayables();
                        for (Displayable d : ds) {
                            d.unlink();
                        }
                        Display.updateCheckboxes(ds, 4);
                    }
                } else if (command.equals("Calibration...")) {
                    try {
                        IJ.run((ImagePlus)Display.this.canvas.getFakeImagePlus(), (String)"Properties...", (String)"");
                        Display.updateTitle(Display.this.getLayerSet());
                        Display.this.project.getLayerTree().updateUILater();
                    }
                    catch (RuntimeException re) {
                        Utils.log2("Calibration dialog canceled.");
                    }
                } else if (command.equals("Grid overlay...")) {
                    if (null == Display.this.gridoverlay) {
                        Display.this.gridoverlay = new GridOverlay();
                    }
                    Display.this.gridoverlay.setup(Display.this.canvas.getFakeImagePlus().getRoi());
                    Display.this.canvas.repaint(false);
                } else if (command.equals("Enhance contrast (selected images)...")) {
                    final Layer la = Display.this.layer;
                    ArrayList<Displayable> arrayList = Display.this.selection.getSelected(Patch.class);
                    final HashSet<Displayable> ds = new HashSet<Displayable>(arrayList);
                    la.getParent().addDataEditStep(ds);
                    Displayable active = Display.this.getActive();
                    Patch ref = active.getClass() == Patch.class ? (Patch)active : null;
                    Bureaucrat bureaucrat = Display.this.getProject().getLoader().enhanceContrast(arrayList, ref);
                    bureaucrat.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            la.getParent().addDataEditStep(ds);
                        }
                    });
                } else if (command.equals("Enhance contrast layer-wise...")) {
                    GenericDialog gd = new GenericDialog("Choose range");
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    List<Layer> list = Display.this.layer.getParent().getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1);
                    final HashSet<Displayable> ds = new HashSet<Displayable>();
                    for (Layer l : list) {
                        ds.addAll(l.getDisplayables(Patch.class));
                    }
                    Display.this.getLayerSet().addDataEditStep(ds);
                    Bureaucrat burro = Display.this.project.getLoader().enhanceContrast(list);
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().addDataEditStep(ds);
                        }
                    });
                } else if (command.equals("Adjust image filters (selected images)")) {
                    if (Display.this.selection.isEmpty() || !(Display.this.active instanceof Patch)) {
                        return;
                    }
                    FilterEditor.GUI(Display.this.selection.get(Patch.class), (Patch)Display.this.active);
                } else if (command.equals("Set Min and Max layer-wise...")) {
                    Displayable active = Display.this.getActive();
                    double d = 0.0;
                    double max = 0.0;
                    if (null != active && active.getClass() == Patch.class) {
                        d = ((Patch)active).getMin();
                        max = ((Patch)active).getMax();
                    }
                    GenericDialog genericDialog = new GenericDialog("Min and Max");
                    genericDialog.addMessage("Set min and max to all images in the layer range");
                    Utils.addLayerRangeChoices(Display.this.layer, genericDialog);
                    genericDialog.addNumericField("min: ", d, 2);
                    genericDialog.addNumericField("max: ", max, 2);
                    genericDialog.showDialog();
                    if (genericDialog.wasCanceled()) {
                        return;
                    }
                    d = genericDialog.getNextNumber();
                    max = genericDialog.getNextNumber();
                    ArrayList<Displayable> arrayList = new ArrayList<Displayable>();
                    for (Layer la : Display.this.layer.getParent().getLayers().subList(genericDialog.getNextChoiceIndex(), genericDialog.getNextChoiceIndex() + 1)) {
                        arrayList.addAll(la.getDisplayables(Patch.class));
                    }
                    final HashSet ds = new HashSet(arrayList);
                    Display.this.getLayerSet().addDataEditStep(ds);
                    Bureaucrat burro = Display.this.project.getLoader().setMinAndMax(arrayList, d, max);
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().addDataEditStep(ds);
                        }
                    });
                } else if (command.equals("Set Min and Max (selected images)...")) {
                    Displayable active = Display.this.getActive();
                    double d = 0.0;
                    double max = 0.0;
                    if (null != active && active.getClass() == Patch.class) {
                        d = ((Patch)active).getMin();
                        max = ((Patch)active).getMax();
                    }
                    GenericDialog genericDialog = new GenericDialog("Min and Max");
                    genericDialog.addMessage("Set min and max to all selected images");
                    genericDialog.addNumericField("min: ", d, 2);
                    genericDialog.addNumericField("max: ", max, 2);
                    genericDialog.showDialog();
                    if (genericDialog.wasCanceled()) {
                        return;
                    }
                    d = genericDialog.getNextNumber();
                    max = genericDialog.getNextNumber();
                    final HashSet<Displayable> hashSet = new HashSet<Displayable>(Display.this.selection.getSelected(Patch.class));
                    Display.this.getLayerSet().addDataEditStep(hashSet);
                    Bureaucrat burro = Display.this.project.getLoader().setMinAndMax(Display.this.selection.getSelected(Patch.class), d, max);
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().addDataEditStep(hashSet);
                        }
                    });
                } else if (command.equals("Adjust min and max (selected images)...")) {
                    Display.this.adjustMinAndMaxGUI();
                } else if (command.equals("Mask image borders (layer-wise)...")) {
                    GenericDialog gd = new GenericDialog("Mask borders");
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.addMessage("Borders:");
                    gd.addNumericField("left: ", 6.0, 2);
                    gd.addNumericField("top: ", 6.0, 2);
                    gd.addNumericField("right: ", 6.0, 2);
                    gd.addNumericField("bottom: ", 6.0, 2);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    List<Layer> list = Display.this.layer.getParent().getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1);
                    final HashSet<Displayable> ds = new HashSet<Displayable>();
                    for (Layer l : list) {
                        ds.addAll(l.getDisplayables(Patch.class));
                    }
                    Display.this.getLayerSet().addDataEditStep(ds);
                    Bureaucrat burro = Display.this.project.getLoader().maskBordersLayerWise(list, (int)gd.getNextNumber(), (int)gd.getNextNumber(), (int)gd.getNextNumber(), (int)gd.getNextNumber());
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().addDataEditStep(ds);
                        }
                    });
                } else if (command.equals("Mask image borders (selected images)...")) {
                    GenericDialog gd = new GenericDialog("Mask borders");
                    gd.addMessage("Borders:");
                    gd.addNumericField("left: ", 6.0, 2);
                    gd.addNumericField("top: ", 6.0, 2);
                    gd.addNumericField("right: ", 6.0, 2);
                    gd.addNumericField("bottom: ", 6.0, 2);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    ArrayList<Displayable> arrayList = Display.this.selection.getSelected(Patch.class);
                    final HashSet<Displayable> ds = new HashSet<Displayable>(arrayList);
                    Display.this.getLayerSet().addDataEditStep(ds);
                    Bureaucrat burro = Display.this.project.getLoader().maskBorders(arrayList, (int)gd.getNextNumber(), (int)gd.getNextNumber(), (int)gd.getNextNumber(), (int)gd.getNextNumber());
                    burro.addPostTask(new Runnable(){

                        @Override
                        public void run() {
                            Display.this.getLayerSet().addDataEditStep(ds);
                        }
                    });
                } else if (command.equals("Remove alpha masks (layer-wise)...")) {
                    GenericDialog gd = new GenericDialog("Remove alpha masks");
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.addCheckbox("Visible only", true);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    List<Layer> list = Display.this.layer.getParent().getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1);
                    boolean visible_only = gd.getNextBoolean();
                    ArrayList<Patch> patches = new ArrayList<Patch>();
                    for (Layer layer : list) {
                        patches.addAll(layer.getDisplayables(Patch.class, visible_only));
                    }
                    Display.removeAlphaMasks(patches);
                } else if (command.equals("Remove alpha masks (selected images)...")) {
                    Display.removeAlphaMasks(Display.this.selection.get(Patch.class));
                } else if (command.equals("Split images under polyline ROI")) {
                    Roi roi = Display.this.canvas.getFakeImagePlus().getRoi();
                    if (null == roi) {
                        return;
                    }
                    if (roi.getType() != 6 && roi.getType() != 7) {
                        Utils.showMessage("Need a polyline or freeline ROI, not just any ROI!");
                        return;
                    }
                    if (!Utils.check("Really split images under the ROI?")) {
                        return;
                    }
                    final HashSet<Patch> hashSet = new HashSet<Patch>();
                    PolygonRoi proi = (PolygonRoi)roi;
                    int[] x = proi.getXCoordinates();
                    int[] y = proi.getYCoordinates();
                    Rectangle rectangle = proi.getBounds();
                    Polygon[] polygonArray = new Polygon[proi.getNCoordinates() - 1];
                    for (int i = 0; i < polygonArray.length; ++i) {
                        polygonArray[i] = new Polygon(new int[]{rectangle.x + x[i], rectangle.x + x[i] + 1, rectangle.x + x[i + 1], rectangle.x + x[i + 1] + 1}, new int[]{rectangle.y + y[i], rectangle.y + y[i], rectangle.y + y[i + 1], rectangle.y + y[i + 1]}, 4);
                    }
                    block50: for (Patch p : Display.this.getLayer().getAll(Patch.class)) {
                        if (!p.isVisible()) continue;
                        Area a = p.getArea();
                        for (int i = 0; i < polygonArray.length; ++i) {
                            Area c = new Area(polygonArray[i]);
                            c.intersect(a);
                            if (M.isEmpty(c)) continue;
                            hashSet.add(p);
                            continue block50;
                        }
                    }
                    if (hashSet.isEmpty()) {
                        Utils.showMessage("No images intersect the ROI!");
                        return;
                    }
                    for (int i = 1; i < proi.getNCoordinates(); ++i) {
                        for (int k = i + 2; k < proi.getNCoordinates(); ++k) {
                            if (null == M.computeSegmentsIntersection(x[i - 1], y[i - 1], x[i], y[i], x[k - 1], y[k - 1], x[k], y[k])) continue;
                            Utils.showMessage("Cannot split images with a polygon ROI that intersects itself!");
                            return;
                        }
                    }
                    final Area[] as = M.splitArea(new Area(Display.this.getLayerSet().get2DBounds()), proi, Display.this.getLayerSet().get2DBounds());
                    Color[] c = new Color[]{Color.blue, Color.red};
                    int i = 0;
                    for (Area a : as) {
                        Display.this.getLayer().getOverlay().add(a, c[i++], null, true, false, 0.4f);
                    }
                    Display.repaint(Display.this.getLayer());
                    final YesNoDialog yn = new YesNoDialog((Frame)Display.this.frame, "Check", "Does the splitting match your expectations?\nPush 'yes' to split the images.", false);
                    yn.setModal(false);
                    for (WindowListener wl : yn.getWindowListeners()) {
                        yn.removeWindowListener(wl);
                    }
                    yn.setClosingTask(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                for (Area a : as) {
                                    Display.this.getLayer().getOverlay().remove(a);
                                }
                                if (!yn.yesPressed()) {
                                    Utils.log2("Pushed 'no'");
                                    return;
                                }
                                Bureaucrat.createAndStart((Worker)new Worker.Task("Spliting images"){

                                    @Override
                                    public void exec() {
                                        ShapeRoi r1 = new ShapeRoi((Shape)as[0]);
                                        ShapeRoi r2 = new ShapeRoi((Shape)as[1]);
                                        ArrayList fus = new ArrayList();
                                        for (Patch p : hashSet) {
                                            Patch copy = (Patch)p.clone(p.getProject(), false);
                                            p.addAlphaMask((Roi)r1, 0);
                                            copy.addAlphaMask((Roi)r2, 0);
                                            fus.add(p.updateMipMaps());
                                            fus.add(copy.updateMipMaps());
                                            p.getLayer().add(copy);
                                        }
                                        Utils.wait(fus);
                                    }
                                }, Display.this.project);
                            }
                            catch (Throwable t) {
                                IJError.print(t);
                            }
                            finally {
                                yn.dispose();
                                Display.repaint(Display.this.getLayer());
                            }
                        }
                    });
                    yn.setVisible(true);
                } else if (command.equals("Duplicate")) {
                    HashSet<Class<Stack>> accepted = new HashSet<Class<Stack>>();
                    accepted.add(Patch.class);
                    accepted.add(DLabel.class);
                    accepted.add(Stack.class);
                    ArrayList<Displayable> arrayList = new ArrayList<Displayable>();
                    ArrayList<Displayable> selected = Display.this.selection.getSelected();
                    for (Displayable d : selected) {
                        if (!accepted.contains(d.getClass())) continue;
                        arrayList.add(d);
                    }
                    if (arrayList.size() > 0) {
                        Display.this.getLayerSet().addChangeTreesStep();
                        for (Displayable d : arrayList) {
                            if (d instanceof ZDisplayable) {
                                d.getLayerSet().add((ZDisplayable)d.clone());
                                continue;
                            }
                            d.getLayer().add(d.clone());
                        }
                        Display.this.getLayerSet().addChangeTreesStep();
                    } else if (selected.size() > 0) {
                        Utils.log("Can only duplicate images and text labels.\nDuplicate *other* objects in the Project Tree.\n");
                    }
                } else if (command.equals("Create subproject")) {
                    void var3_115;
                    Roi roi = Display.this.canvas.getFakeImagePlus().getRoi();
                    if (null != roi) {
                        if (!Utils.check("Use bounds as defined by the ROI:\n" + roi.getBounds() + " ?")) {
                            return;
                        }
                        Rectangle rectangle = roi.getBounds();
                    } else {
                        Rectangle rectangle = Display.this.getLayerSet().get2DBounds();
                    }
                    GenericDialog gd = new GenericDialog("Choose layer range");
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.addCheckbox("Ignore hidden images", true);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    Layer first = Display.this.layer.getParent().getLayer(gd.getNextChoiceIndex());
                    Layer last = Display.this.layer.getParent().getLayer(gd.getNextChoiceIndex());
                    boolean bl = gd.getNextBoolean();
                    Project project = Display.this.getProject().createSubproject((Rectangle)var3_115, first, last, bl);
                    if (null == project) {
                        Utils.log("ERROR: failed to create subproject.");
                        return;
                    }
                    LayerSet subls = project.getRootLayerSet();
                    Display.createDisplay(project, subls.getLayer(0));
                } else if (command.startsWith("Image stack under selected Arealist")) {
                    int type;
                    if (null == Display.this.active || Display.this.active.getClass() != AreaList.class) {
                        return;
                    }
                    GenericDialog gd = new GenericDialog("Stack options");
                    String[] stringArray = new String[]{"8-bit", "16-bit", "32-bit", "RGB"};
                    gd.addChoice("type:", stringArray, stringArray[0]);
                    gd.addSlider("Scale: ", 1.0, 100.0, 100.0);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    switch (gd.getNextChoiceIndex()) {
                        case 0: {
                            type = 0;
                            break;
                        }
                        case 1: {
                            type = 1;
                            break;
                        }
                        case 2: {
                            type = 2;
                            break;
                        }
                        case 3: {
                            type = 4;
                            break;
                        }
                        default: {
                            type = 0;
                        }
                    }
                    ImagePlus imp = ((AreaList)Display.this.active).getStack(type, gd.getNextNumber() / 100.0);
                    if (null != imp) {
                        imp.show();
                    }
                } else if (command.equals("Fly through selected Treeline/AreaTree")) {
                    if (null == Display.this.active || !(Display.this.active instanceof Tree)) {
                        return;
                    }
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Creating fly through", true){

                        @Override
                        public void exec() {
                            ImagePlus imp;
                            GenericDialog gd = new GenericDialog("Fly through");
                            gd.addNumericField("Width", 512.0, 0);
                            gd.addNumericField("Height", 512.0, 0);
                            String[] types = new String[]{"8-bit gray", "Color RGB"};
                            gd.addChoice("Image type", types, types[0]);
                            gd.addSlider("scale", 0.0, 100.0, 100.0);
                            gd.addCheckbox("save to file", false);
                            gd.showDialog();
                            if (gd.wasCanceled()) {
                                return;
                            }
                            int w = (int)gd.getNextNumber();
                            int h = (int)gd.getNextNumber();
                            int type = 0 == gd.getNextChoiceIndex() ? 0 : 4;
                            double scale = gd.getNextNumber();
                            if (w <= 0 || h <= 0) {
                                Utils.log("Invalid width or height: " + w + ", " + h);
                                return;
                            }
                            if (0.0 == scale || Double.isNaN(scale)) {
                                Utils.log("Invalid scale: " + scale);
                                return;
                            }
                            String dir = null;
                            if (gd.getNextBoolean()) {
                                DirectoryChooser dc = new DirectoryChooser("Target directory");
                                dir = dc.getDirectory();
                                if (null == dir) {
                                    return;
                                }
                                dir = Utils.fixDir(dir);
                            }
                            if (null == (imp = ((Tree)Display.this.active).flyThroughMarked(w, h, scale / 100.0, type, dir))) {
                                Utils.log("Mark a node first!");
                                return;
                            }
                            imp.show();
                        }
                    }, Display.this.project);
                } else if (command.startsWith("Arealists as labels")) {
                    List<Displayable> al;
                    GenericDialog gd = new GenericDialog("Export labels");
                    gd.addSlider("Scale: ", 1.0, 100.0, 100.0);
                    String[] stringArray = new String[]{"All area list", "Selected area lists"};
                    gd.addChoice("Export: ", stringArray, stringArray[0]);
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.addCheckbox("Visible only", true);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    float scale = (float)(gd.getNextNumber() / 100.0);
                    List<Displayable> list = al = 0 == gd.getNextChoiceIndex() ? Display.this.layer.getParent().getZDisplayables(AreaList.class) : Display.this.selection.getSelectedSorted(AreaList.class);
                    if (null == al) {
                        Utils.log("No area lists found to export.");
                        return;
                    }
                    int first = gd.getNextChoiceIndex();
                    int n = gd.getNextChoiceIndex();
                    boolean bl = gd.getNextBoolean();
                    if (-1 != command.indexOf("(amira)")) {
                        AreaList.exportAsLabels(al, Display.this.canvas.getFakeImagePlus().getRoi(), scale, first, n, bl, true, true);
                    } else if (-1 != command.indexOf("(tif)")) {
                        AreaList.exportAsLabels(al, Display.this.canvas.getFakeImagePlus().getRoi(), scale, first, n, bl, false, false);
                    }
                } else if (command.equals("Project properties...")) {
                    Display.this.project.adjustProperties();
                } else if (command.equals("Release memory...")) {
                    Bureaucrat.createAndStart(new Worker("Releasing memory"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            this.startedWorking();
                            try {
                                GenericDialog gd = new GenericDialog("Release Memory");
                                int max = (int)(IJ.maxMemory() / 1000000L);
                                gd.addSlider("Megabytes: ", 0.0, (double)max, (double)(max / 2));
                                gd.showDialog();
                                if (!gd.wasCanceled()) {
                                    int n_mb = (int)gd.getNextNumber();
                                    Display.this.project.getLoader().releaseToFit((long)n_mb * 1000000L);
                                }
                            }
                            catch (Throwable e) {
                                IJError.print(e);
                            }
                            finally {
                                this.finishedWorking();
                            }
                        }
                    }, Display.this.project);
                } else if (command.equals("Create sibling project with retiled layers")) {
                    GenericDialog gd = new GenericDialog("Export flattened layers");
                    gd.addNumericField("Tile_width", 2048.0, 0);
                    gd.addNumericField("Tile_height", 2048.0, 0);
                    String[] stringArray = new String[]{"16-bit", "RGB color"};
                    gd.addChoice("Export_image_type", stringArray, stringArray[0]);
                    gd.addCheckbox("Create mipmaps", true);
                    gd.addNumericField("Number_of_threads_to_use", (double)Runtime.getRuntime().availableProcessors(), 0);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    DirectoryChooser dc = new DirectoryChooser("Choose target folder");
                    final String folder = dc.getDirectory();
                    if (null == folder) {
                        return;
                    }
                    final int tileWidth = (int)gd.getNextNumber();
                    final int n = (int)gd.getNextNumber();
                    if (tileWidth < 0 || n < 0) {
                        Utils.showMessage("Invalid tile sizes: " + tileWidth + ", " + n);
                        return;
                    }
                    if (tileWidth != n && !Utils.check("The tile width (" + tileWidth + ") differs from the tile height (" + n + ").\nContinue anyway?")) {
                        return;
                    }
                    final int n5 = 0 == gd.getNextChoiceIndex() ? 1 : 4;
                    final boolean createMipMaps = gd.getNextBoolean();
                    final int nThreads = (int)gd.getNextNumber();
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Export flattened sibling project"){

                        @Override
                        public void exec() {
                            try {
                                ProjectTiler.createRetiledSibling(Display.this.project, folder, tileWidth, n, n5, true, nThreads, createMipMaps);
                            }
                            catch (Throwable t) {
                                Utils.showMessage("ERROR: " + t);
                                IJError.print(t);
                            }
                        }
                    }, Display.this.project);
                } else if (command.equals("Flush image cache")) {
                    Loader.releaseAllCaches();
                } else if (command.equals("Regenerate all mipmaps")) {
                    Display.this.project.getLoader().regenerateMipMaps(Display.this.getLayerSet().getDisplayables(Patch.class));
                } else if (command.equals("Regenerate mipmaps (selected images)")) {
                    Display.this.project.getLoader().regenerateMipMaps(Display.this.selection.getSelected(Patch.class));
                } else if (command.equals("Tags...")) {
                    File f = Utils.chooseFile(null, "tags", ".xml");
                    if (null == f) {
                        return;
                    }
                    if (!Utils.saveToFile(f, Display.this.getLayerSet().exportTags())) {
                        Utils.logAll("ERROR when saving tags to file " + f.getAbsolutePath());
                    }
                } else if (command.equals("Tags ...")) {
                    String[] ff = Utils.selectFile("Import tags");
                    if (null == ff) {
                        return;
                    }
                    GenericDialog genericDialog = new GenericDialog("Import tags");
                    String[] modes = new String[]{"Append to current tags", "Replace current tags"};
                    genericDialog.addChoice("Import tags mode:", modes, modes[0]);
                    genericDialog.addMessage("Replacing current tags\nwill remove all tags\n from all nodes first!");
                    genericDialog.showDialog();
                    if (genericDialog.wasCanceled()) {
                        return;
                    }
                    Display.this.getLayerSet().importTags(ff[0] + '/' + ff[1], 1 == genericDialog.getNextChoiceIndex());
                } else if (command.equals("Connectivity graph...")) {
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Connectivity graph"){

                        @Override
                        public void exec() {
                            Graph.extractAndShowGraph(Display.this.getLayerSet());
                        }
                    }, Display.this.getProject());
                } else if (command.equals("NeuroML...")) {
                    GenericDialog gd = new GenericDialog("Export NeuroML");
                    String[] stringArray = new String[]{"NeuroML (arbors and synapses)", "MorphML (arbors)"};
                    gd.addChoice("Type:", stringArray, stringArray[0]);
                    String[] b = new String[]{"All treelines and areatrees", "Selected treelines and areatrees"};
                    gd.addChoice("Export:", b, b[0]);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    final int type = gd.getNextChoiceIndex();
                    final int export = gd.getNextChoiceIndex();
                    SaveDialog saveDialog = new SaveDialog("Choose .mml file", null, ".mml");
                    String string = saveDialog.getFileName();
                    if (null == string) {
                        return;
                    }
                    final File f = new File(saveDialog.getDirectory() + string);
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Export NeuroML"){

                        @Override
                        public void exec() {
                            OutputStreamWriter w = null;
                            try {
                                HashSet trees = new HashSet();
                                ArrayList<Displayable> ds = null;
                                switch (export) {
                                    case 0: {
                                        ds = Display.this.getLayerSet().getZDisplayables();
                                        break;
                                    }
                                    case 1: {
                                        ds = Display.this.selection.getSelected();
                                    }
                                }
                                for (Displayable displayable : ds) {
                                    if (displayable.getClass() != Treeline.class && displayable.getClass() != AreaTree.class) continue;
                                    trees.add((Tree)displayable);
                                }
                                if (trees.isEmpty()) {
                                    Utils.showMessage("No trees to export!");
                                    return;
                                }
                                w = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(f), 65536), "8859_1");
                                switch (type) {
                                    case 0: {
                                        NeuroML.exportNeuroML(trees, (Writer)w);
                                        break;
                                    }
                                    case 1: {
                                        NeuroML.exportMorphML(trees, (Writer)w);
                                    }
                                }
                                w.flush();
                                w.close();
                            }
                            catch (Throwable t) {
                                IJError.print(t);
                                try {
                                    if (null != w) {
                                        w.close();
                                    }
                                }
                                catch (Exception ee) {
                                    IJError.print(ee);
                                }
                            }
                        }
                    }, Display.this.getProject());
                } else if (command.equals("Measure")) {
                    if (Display.this.selection.isEmpty()) {
                        Utils.log("Nothing selected to measure!");
                        return;
                    }
                    Display.this.selection.measure();
                } else if (command.equals("Area interpolation options...")) {
                    GenericDialog gd = new GenericDialog("Area interpolation");
                    boolean bl = Display.this.project.getBooleanProperty("always_interpolate_areas_with_distance_map");
                    gd.addCheckbox("Always use distance map method", bl);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    Display.this.project.setProperty("always_interpolate_areas_with_distance_map", gd.getNextBoolean() ? "true" : null);
                } else {
                    Utils.log2("Display: don't know what to do with command " + command);
                }
            }
        });
    }

    public void adjustMinAndMaxGUI() {
        final ArrayList<Displayable> list = this.selection.getSelected(Patch.class);
        if (list.isEmpty()) {
            Utils.log("No images selected!");
            return;
        }
        Bureaucrat.createAndStart((Worker)new Worker.Task("Init contrast adjustment"){

            @Override
            public void exec() {
                try {
                    Display.this.setMode(new ContrastAdjustmentMode(Display.this, list));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Utils.log("All images must be of the same type!");
                }
            }
        }, ((Displayable)list.get(0)).getProject());
    }

    public void adjustMeasurementOptions() {
        GenericDialog gd = new GenericDialog("Measurement options");
        gd.addMessage("The point interdistance for resampling the contours\nof AreaLists when measuring areas and volumes.\nThe recommended value is one calibrated unit, in pixels.\nThe default value is one pixel.");
        gd.addNumericField("Resolution", (double)this.project.getProperty("measurement_resampling_delta", 1.0f), 1, 10, "pixels");
        gd.addMessage("Whether to measure the largest diameter of an AreaList\nwhich is the largest distance between any two points of its contours.\nA very expensive operation, by default it is turned off.");
        boolean diameters = this.project.getBooleanProperty("measure_largest_diameter");
        gd.addCheckbox("Measure_largest_diameter", diameters);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        float delta = (float)gd.getNextNumber();
        if (Float.isNaN(delta) || delta <= 0.0f) {
            Utils.log("Rejected resampling resolution of " + delta + ", which should be larger than zero.");
        } else {
            this.project.setProperty("measurement_resampling_delta", Float.toString(delta));
        }
        boolean diameters2 = gd.getNextBoolean();
        if (diameters != diameters2) {
            this.project.setProperty("measure_largest_diameter", Boolean.toString(diameters2));
        }
    }

    public void adjustGroupProperties(Collection<Displayable> col) {
        if (col.isEmpty()) {
            return;
        }
        Displayable first = col.iterator().next();
        GenericDialog gd = new GenericDialog("Properties of selected");
        gd.addSlider("alpha: ", 0.0, 100.0, (double)((int)(first.getAlpha() * 100.0f)));
        gd.addCheckbox("visible", first.isVisible());
        gd.addSlider("Red: ", 0.0, 255.0, (double)first.getColor().getRed());
        gd.addSlider("Green: ", 0.0, 255.0, (double)first.getColor().getGreen());
        gd.addSlider("Blue: ", 0.0, 255.0, (double)first.getColor().getBlue());
        gd.addCheckbox("locked", first.isLocked2());
        gd.addChoice("composite mode: ", Displayable.compositeModes, Displayable.compositeModes[first.getCompositeMode()]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        HashSet<Displayable> hs = new HashSet<Displayable>(col);
        String[] fields = new String[]{"alpha", "visible", "color", "locked", "compositeMode"};
        this.getLayerSet().addDataEditStep(hs, fields);
        float alpha = (float)gd.getNextNumber();
        boolean visible = gd.getNextBoolean();
        Color color = new Color((int)gd.getNextNumber(), (int)gd.getNextNumber(), (int)gd.getNextNumber());
        boolean locked = gd.getNextBoolean();
        byte compositeMode = (byte)gd.getNextChoiceIndex();
        for (Displayable d : col) {
            d.setAlpha(alpha);
            d.setVisible(visible);
            d.setColor(color);
            d.setLocked(locked);
            d.setCompositeMode(compositeMode);
        }
        this.getLayerSet().addDataEditStep(hs, fields);
    }

    public void adjustProperties() {
        GenericDialog gd = new GenericDialog("Properties", (Frame)this.frame);
        gd.addSlider("layer_scroll_step: ", 1.0, (double)this.layer.getParent().size(), (double)this.scroll_step);
        gd.addChoice("snapshots_mode", LayerSet.snapshot_modes, LayerSet.snapshot_modes[this.layer.getParent().getSnapshotsMode()]);
        gd.addCheckbox("prefer_snapshots_quality", this.layer.getParent().snapshotsQuality());
        Loader lo = this.getProject().getLoader();
        boolean using_mipmaps = lo.isMipMapsRegenerationEnabled();
        gd.addCheckbox("enable_mipmaps", using_mipmaps);
        gd.addCheckbox("enable_layer_pixels virtualization", this.layer.getParent().isPixelsVirtualizationEnabled());
        double max = this.layer.getParent().getLayerWidth() < this.layer.getParent().getLayerHeight() ? (double)this.layer.getParent().getLayerWidth() : (double)this.layer.getParent().getLayerHeight();
        gd.addSlider("max_dimension of virtualized layer pixels: ", 0.0, max, (double)this.layer.getParent().getPixelsMaxDimension());
        gd.addCheckbox("Show arrow heads in Treeline/AreaTree", this.layer.getParent().paint_arrows);
        gd.addCheckbox("Show edge confidence boxes in Treeline/AreaTree", this.layer.getParent().paint_edge_confidence_boxes);
        gd.addSlider("Stroke width (Treeline, AreaTree, Ball)", 1.0, 10.0, (double)DisplayCanvas.DEFAULT_STROKE.getLineWidth());
        gd.addCheckbox("Show color cues", this.layer.getParent().color_cues);
        gd.addSlider("+/- layers to color cue", 0.0, 10.0, (double)this.layer.getParent().n_layers_color_cue);
        gd.addCheckbox("Show color cues for areas", this.layer.getParent().area_color_cues);
        gd.addCheckbox("Use red/blue for color cues", this.layer.getParent().use_color_cue_colors);
        gd.addCheckbox("Prepaint images", this.layer.getParent().prepaint);
        gd.addSlider("Preload ahead from sections: ", 0.0, (double)this.layer.getParent().size(), (double)this.layer.getParent().preload_ahead);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int sc = (int)gd.getNextNumber();
        if (sc < 1) {
            sc = 1;
        }
        this.scroll_step = sc;
        this.updateInDatabase("scroll_step");
        this.layer.getParent().setSnapshotsMode(gd.getNextChoiceIndex());
        this.layer.getParent().setSnapshotsQuality(gd.getNextBoolean());
        boolean using_mipmaps2 = gd.getNextBoolean();
        if (using_mipmaps2 != using_mipmaps) {
            if (!using_mipmaps2 && using_mipmaps) {
                lo.setMipMapsRegeneration(false);
                lo.flushMipMaps(true);
            } else if (using_mipmaps2 && !using_mipmaps) {
                lo.setMipMapsRegeneration(true);
                lo.generateMipMaps(this.layer.getParent().getDisplayables(Patch.class));
            }
        }
        this.layer.getParent().setPixelsVirtualizationEnabled(gd.getNextBoolean());
        this.layer.getParent().setPixelsMaxDimension((int)gd.getNextNumber());
        this.layer.getParent().paint_arrows = gd.getNextBoolean();
        this.layer.getParent().paint_edge_confidence_boxes = gd.getNextBoolean();
        DisplayCanvas.DEFAULT_STROKE = new BasicStroke((float)Math.max(1.0, gd.getNextNumber()), 0, 0);
        this.layer.getParent().color_cues = gd.getNextBoolean();
        this.layer.getParent().n_layers_color_cue = (int)gd.getNextNumber();
        this.layer.getParent().area_color_cues = gd.getNextBoolean();
        this.layer.getParent().use_color_cue_colors = gd.getNextBoolean();
        this.layer.getParent().prepaint = gd.getNextBoolean();
        this.layer.getParent().preload_ahead = (int)Math.min(gd.getNextNumber(), (double)this.layer.getParent().size());
        Display.repaint(this.layer.getParent());
    }

    public static void updateTransform(Displayable displ) {
        for (Display d : al_displays) {
            if (!d.selection.contains(displ)) continue;
            d.selection.updateTransform(displ);
        }
    }

    public int getScrollStep() {
        return this.scroll_step;
    }

    public void setScrollStep(int scroll_step) {
        if (scroll_step < 1) {
            scroll_step = 1;
        }
        this.scroll_step = scroll_step;
        this.updateInDatabase("scroll_step");
    }

    protected Bureaucrat importImage() {
        Worker worker = new Worker("Import image"){

            @Override
            public void run() {
                this.startedWorking();
                try {
                    Rectangle srcRect = Display.this.canvas.getSrcRect();
                    int x = srcRect.x + srcRect.width / 2;
                    int y = srcRect.y + srcRect.height / 2;
                    Patch p = Display.this.project.getLoader().importImage(Display.this.project, x, y);
                    if (null == p) {
                        this.finishedWorking();
                        Utils.showMessage("Could not open the image.");
                        return;
                    }
                    Display.this.getLayerSet().addLayerContentStep(Display.this.layer);
                    Display.this.layer.add(p);
                    Display.this.getLayerSet().addLayerContentStep(Display.this.layer);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                this.finishedWorking();
            }
        };
        return Bureaucrat.createAndStart(worker, this.getProject());
    }

    protected Bureaucrat importNextImage() {
        Worker worker = new Worker("Import image"){

            @Override
            public void run() {
                this.startedWorking();
                try {
                    Rectangle srcRect = Display.this.canvas.getSrcRect();
                    int x = srcRect.x + srcRect.width / 2;
                    int y = srcRect.y + srcRect.height / 2;
                    Patch p = Display.this.project.getLoader().importNextImage(Display.this.project, x, y);
                    if (null == p) {
                        Utils.showMessage("Could not open next image.");
                        this.finishedWorking();
                        return;
                    }
                    Display.this.getLayerSet().addLayerContentStep(Display.this.layer);
                    Display.this.layer.add(p);
                    Display.this.getLayerSet().addLayerContentStep(Display.this.layer);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                this.finishedWorking();
            }
        };
        return Bureaucrat.createAndStart(worker, this.getProject());
    }

    public void setChannel(int c, float alpha) {
        int a = (int)(255.0f * alpha);
        int l = (this.c_alphas & 0xFF000000) >> 24;
        int r = (this.c_alphas & 0xFF0000) >> 16;
        int g = (this.c_alphas & 0xFF00) >> 8;
        int b = this.c_alphas & 0xFF;
        switch (c) {
            case 1: {
                this.c_alphas = (l << 24) + (r << 16) + (g << 8) + b;
                break;
            }
            case 2: {
                this.c_alphas = (l << 24) + (a << 16) + (g << 8) + b;
                break;
            }
            case 4: {
                this.c_alphas = (l << 24) + (r << 16) + (a << 8) + b;
                break;
            }
            case 8: {
                this.c_alphas = (l << 24) + (r << 16) + (g << 8) + a;
            }
        }
        this.canvas.repaint(true);
        this.updateInDatabase("c_alphas");
    }

    public void setActiveChannel(Channel channel) {
        for (int i = 0; i < 4; ++i) {
            if (channel != this.channels[i]) {
                this.channels[i].setActive(false);
                continue;
            }
            channel.setActive(true);
        }
        Utils.updateComponent(this.panel_channels);
        this.transp_slider.setValue((int)(channel.getAlpha() * 100.0f));
    }

    public int getDisplayChannelAlphas() {
        return this.c_alphas;
    }

    public int getChannelAlphas() {
        return ((int)(this.channels[0].getAlpha() * 255.0f) << 24) + ((int)(this.channels[1].getAlpha() * 255.0f) << 16) + ((int)(this.channels[2].getAlpha() * 255.0f) << 8) + (int)(this.channels[3].getAlpha() * 255.0f);
    }

    public int getChannelAlphasState() {
        return ((this.channels[0].isSelected() ? 255 : 0) << 24) + ((this.channels[1].isSelected() ? 255 : 0) << 16) + ((this.channels[2].isSelected() ? 255 : 0) << 8) + (this.channels[3].isSelected() ? 255 : 0);
    }

    public static void showFront(Layer layer) {
        Display display = front;
        if (null == display || display.layer.getParent() != layer.getParent()) {
            display = new Display(layer.getProject(), layer, null);
        } else {
            display.setLayer(layer);
        }
    }

    public static void showCentered(Layer layer, Displayable displ, boolean select, boolean shift_down) {
        Display display = front;
        if (null == display || display.layer.getParent() != layer.getParent()) {
            display = new Display(layer.getProject(), layer, displ);
        }
        display.show(layer, displ, select, shift_down);
    }

    public void show(Layer layer, Displayable displ, boolean select, boolean shift_down) {
        if (this.layer != layer) {
            this.setLayer(layer);
        }
        if (select) {
            if (!shift_down) {
                this.selection.clear();
            }
            this.selection.add(displ);
        } else {
            this.selection.clear();
        }
        this.showCentered(displ);
    }

    public final void center(final double x, final double y) {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle r = (Rectangle)Display.this.canvas.getSrcRect().clone();
                r.x = (int)x - r.width / 2;
                r.y = (int)y - r.height / 2;
                Display.this.canvas.center(r, Display.this.canvas.getMagnification());
            }
        });
    }

    public final void center(Coordinate<?> c) {
        if (null == c) {
            return;
        }
        this.slt.set(c.layer);
        this.center(c.x, c.y);
    }

    public final void centerIfNotWithinSrcRect(Coordinate<?> c) {
        if (null == c) {
            return;
        }
        this.slt.set(c.layer);
        Rectangle srcRect = this.canvas.getSrcRect();
        if (srcRect.contains((int)(c.x + 0.5), (int)(c.y + 0.5))) {
            return;
        }
        this.center(c.x, c.y);
    }

    public final void animateBrowsingTo(Coordinate<?> c) {
        if (null == c) {
            return;
        }
        double padding = 50.0 / this.canvas.getMagnification();
        this.canvas.animateBrowsing(new Rectangle((int)(c.x - padding), (int)(c.y - padding), (int)(2.0 * padding), (int)(2.0 * padding)), c.layer);
    }

    public static final void centerAt(Coordinate c) {
        Display.centerAt(c, false, false);
    }

    public static final void centerAt(final Coordinate<Displayable> c, final boolean select, final boolean shift_down) {
        if (null == c) {
            return;
        }
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display display;
                Layer la = c.layer;
                if (null == la) {
                    if (null == c.object) {
                        return;
                    }
                    la = ((Displayable)c.object).getProject().getRootLayerSet().getLayer(0);
                    if (null == la) {
                        return;
                    }
                }
                if (null == (display = front) || la.getParent() != display.getLayerSet()) {
                    display = new Display(la.getProject(), la);
                }
                display.center(c);
                if (select) {
                    if (!shift_down) {
                        display.selection.clear();
                    }
                    display.selection.add((Displayable)c.object);
                }
            }
        });
    }

    private final void showCentered(final Displayable displ) {
        if (null == displ) {
            return;
        }
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                displ.setVisible(true);
                Rectangle box = displ.getBoundingBox();
                if (0 == box.width && 0 == box.height) {
                    box.width = 100;
                    box.height = 100;
                } else if (0 == box.width) {
                    box.width = box.height;
                } else if (0 == box.height) {
                    box.height = box.width;
                }
                Display.this.canvas.showCentered(box);
                ((RollingPanel)Display.this.ht_tabs.get(displ.getClass())).scrollToShow(displ);
                if (displ instanceof ZDisplayable) {
                    ZDisplayable zd = (ZDisplayable)displ;
                    Display.this.setLayer(zd.getFirstLayer());
                }
            }
        });
    }

    public void eventOccurred(int eventID) {
        if (0 == eventID) {
            if (this != front || null == this.active || !this.project.isInputEnabled()) {
                return;
            }
            this.selection.setColor(Toolbar.getForegroundColor());
            Display.repaint(Display.front.layer, this.selection.getBox(), 0);
        } else if (4 == eventID) {
            Display.repaintToolbar();
        }
    }

    public void imageClosed(ImagePlus imp) {
    }

    public void imageOpened(ImagePlus imp) {
    }

    public static void flushAll() {
        for (Display d : al_displays) {
            d.canvas.flush();
        }
        Thread.yield();
    }

    public static Display getFront() {
        Set<Display> ds = al_displays;
        if (null == front && ds.size() > 0) {
            Utils.log2("Fixing error with null 'Display.getFront()'");
            Display d = (Display)ds.iterator().next();
            d.frame.toFront();
            front = d;
        }
        return front;
    }

    public static Display getOrCreateFront(Project project) {
        Display df = front;
        if (null != df && df.project == project) {
            return df;
        }
        for (Display d : al_displays) {
            if (d.project != project) continue;
            d.frame.toFront();
            return d;
        }
        LayerSet ls = project.getRootLayerSet();
        if (0 == ls.size()) {
            return null;
        }
        return new Display(project, ls.getLayer(0));
    }

    public static void setCursorToAll(Cursor c) {
        for (Display d : al_displays) {
            if (null == d.frame) continue;
            d.frame.setCursor(c);
        }
    }

    public static void updateCheckboxes(Displayable displ, final int cb, final boolean state) {
        for (Display d : al_displays) {
            final DisplayablePanel dp = d.ht_panels.get(displ);
            if (null == dp) continue;
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dp.updateCheckbox(cb, state);
                }
            });
        }
    }

    public static void updateCheckboxes(final Collection<Displayable> displs, final int cb, final boolean state) {
        if (null == displs || 0 == displs.size()) {
            return;
        }
        Project p = displs.iterator().next().getProject();
        for (final Display d : al_displays) {
            if (d.getProject() != p) continue;
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Displayable displ : displs) {
                        DisplayablePanel dp = (DisplayablePanel)d.ht_panels.get(displ);
                        if (null == dp) continue;
                        dp.updateCheckbox(cb, state);
                    }
                }
            });
        }
    }

    public static void updateCheckboxes(final Collection<Displayable> displs, final int cb) {
        if (null == displs || 0 == displs.size()) {
            return;
        }
        Project p = displs.iterator().next().getProject();
        for (final Display d : al_displays) {
            if (d.getProject() != p) continue;
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Displayable displ : displs) {
                        DisplayablePanel dp = (DisplayablePanel)d.ht_panels.get(displ);
                        if (null == dp) continue;
                        dp.updateCheckbox(cb);
                    }
                }
            });
        }
    }

    protected boolean isActiveWindow() {
        return this.frame.isActive();
    }

    public static void setReceivesInput(Project project, boolean b) {
        for (Display d : al_displays) {
            if (d.project != project) continue;
            d.canvas.setReceivesInput(b);
        }
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        if (hs.contains("t2_display")) {
            return;
        }
        hs.add("t2_display");
        sb_header.append(indent).append("<!ELEMENT t2_display EMPTY>\n").append(indent).append("<!ATTLIST t2_display id NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display layer_id NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display x NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display y NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display magnification NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display srcrect_x NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display srcrect_y NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display srcrect_width NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display srcrect_height NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display scroll_step NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display c_alphas NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display c_alphas_state NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display filter_enabled NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display filter_min_max_enabled NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display filter_min NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display filter_max NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display filter_invert NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display filter_clahe_enabled NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display filter_clahe_block_size NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display filter_clahe_histogram_bins NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_display filter_clahe_max_slope NMTOKEN #REQUIRED>\n");
    }

    public static void exportXML(Project project, Writer writer, String indent, XMLOptions options) throws Exception {
        StringBuilder sb_body = new StringBuilder();
        String in = indent + "\t";
        for (Display d : al_displays) {
            if (d.project != project) continue;
            Rectangle r = d.frame.getBounds();
            Rectangle srcRect = d.canvas.getSrcRect();
            double magnification = d.canvas.getMagnification();
            sb_body.append(indent).append("<t2_display id=\"").append(d.id).append("\"\n").append(in).append("layer_id=\"").append(d.layer.getId()).append("\"\n").append(in).append("c_alphas=\"").append(d.c_alphas).append("\"\n").append(in).append("c_alphas_state=\"").append(d.getChannelAlphasState()).append("\"\n").append(in).append("x=\"").append(r.x).append("\"\n").append(in).append("y=\"").append(r.y).append("\"\n").append(in).append("magnification=\"").append(magnification).append("\"\n").append(in).append("srcrect_x=\"").append(srcRect.x).append("\"\n").append(in).append("srcrect_y=\"").append(srcRect.y).append("\"\n").append(in).append("srcrect_width=\"").append(srcRect.width).append("\"\n").append(in).append("srcrect_height=\"").append(srcRect.height).append("\"\n").append(in).append("scroll_step=\"").append(d.scroll_step).append("\"\n").append(in).append("filter_enabled=\"").append(d.filter_enabled).append("\"\n").append(in).append("filter_min_max_enabled=\"").append(d.filter_min_max_enabled).append("\"\n").append(in).append("filter_min=\"").append(d.filter_min).append("\"\n").append(in).append("filter_max=\"").append(d.filter_max).append("\"\n").append(in).append("filter_invert=\"").append(d.filter_invert).append("\"\n").append(in).append("filter_clahe_enabled=\"").append(d.filter_clahe_enabled).append("\"\n").append(in).append("filter_clahe_block_size=\"").append(d.filter_clahe_block_size).append("\"\n").append(in).append("filter_clahe_histogram_bins=\"").append(d.filter_clahe_histogram_bins).append("\"\n").append(in).append("filter_clahe_max_slope=\"").append(d.filter_clahe_max_slope).append("\"\n");
            sb_body.append(indent).append("/>\n");
        }
        writer.write(sb_body.toString());
    }

    private void updateToolTab() {
        OptionPanel op = null;
        switch (ProjectToolbar.getToolId()) {
            case 15: {
                op = Segmentation.fmp.asOptionPanel();
                break;
            }
            case 17: {
                op = AreaWrapper.PP.asOptionPanel();
                break;
            }
        }
        this.scroll_options.getViewport().removeAll();
        if (null != op) {
            op.bottomPadding();
            this.scroll_options.setViewportView(op);
        }
        this.scroll_options.invalidate();
        this.scroll_options.validate();
        this.scroll_options.repaint();
    }

    public static void toolChanged(String tool_name) {
        Utils.log2("tool name: " + tool_name);
        for (Display d : al_displays) {
            d.updateToolTab();
            Utils.updateComponent(d.toolbar_panel);
            Utils.log2("updating toolbar_panel");
        }
    }

    public static void toolChanged(int tool) {
        if (16 == tool) {
            HashSet<Layer> s = new HashSet<Layer>();
            for (Display d : al_displays) {
                if (null == d.active || s.contains(d.layer)) continue;
                Display.repaint(d.layer, d.selection.getBox(), 2);
                s.add(d.layer);
            }
        }
        for (Display d : al_displays) {
            d.updateToolTab();
        }
        if (null != front) {
            try {
                WindowManager.setTempCurrentImage((ImagePlus)Display.front.canvas.getFakeImagePlus());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isLiveFilteringEnabled() {
        return this.filter_enabled;
    }

    private OptionPanel createFilterOptionPanel() {
        OptionPanel fop = new OptionPanel();
        Runnable reaction = new Runnable(){

            @Override
            public void run() {
                Display.repaint(Display.this.getLayer());
            }
        };
        fop.addCheckbox("Live filters enabled", this.filter_enabled, new OptionPanel.BooleanSetter(this, "filter_enabled", reaction));
        fop.addMessage("Contrast:");
        fop.addCheckbox("Min/Max enabled", this.filter_min_max_enabled, new OptionPanel.BooleanSetter(this, "filter_min_max_enabled", reaction));
        fop.addNumericField("Min:", this.filter_min, 0, new OptionPanel.IntSetter(this, "filter_min", reaction, 0, 255));
        fop.addNumericField("Max:", this.filter_max, 0, new OptionPanel.IntSetter(this, "filter_max", reaction, 0, 255));
        fop.addCheckbox("Invert", this.filter_invert, new OptionPanel.BooleanSetter(this, "filter_invert", reaction));
        fop.addMessage("CLAHE options:");
        fop.addCheckbox("CLAHE enabled", this.filter_clahe_enabled, new OptionPanel.BooleanSetter(this, "filter_clahe_enabled", reaction));
        fop.addNumericField("block size:", this.filter_clahe_block_size, 0, new OptionPanel.IntSetter(this, "filter_clahe_block_size", reaction, 1, Integer.MAX_VALUE));
        fop.addNumericField("histogram bins:", this.filter_clahe_histogram_bins, 0, new OptionPanel.IntSetter(this, "filter_clahe_histogram_bins", reaction, 1, Integer.MAX_VALUE));
        fop.addNumericField("max slope:", this.filter_clahe_max_slope, 2, new OptionPanel.FloatSetter(this, "filter_clahe_max_slope", reaction, 0, Integer.MAX_VALUE));
        return fop;
    }

    protected Image applyFilters(Image img) {
        if (!this.filter_enabled) {
            return img;
        }
        return this.applyFilters(new ImagePlus("filtered", img)).getProcessor().createImage();
    }

    protected ImagePlus applyFilters(ImageProcessor ip) {
        ImagePlus imp = new ImagePlus("filtered", ip);
        this.applyFilters(imp);
        return imp;
    }

    protected ImagePlus applyFilters(ImagePlus imp) {
        if (!this.filter_enabled) {
            return imp;
        }
        if (this.filter_min_max_enabled) {
            imp.getProcessor().setMinAndMax((double)this.filter_min, (double)this.filter_max);
        }
        if (this.filter_invert) {
            imp.getProcessor().invert();
        }
        if (this.filter_clahe_enabled) {
            Flat.getFastInstance().run(imp, this.filter_clahe_block_size, this.filter_clahe_histogram_bins, this.filter_clahe_max_slope, null, false);
        }
        return imp;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public final boolean isSelected(Displayable d) {
        return this.selection.contains(d);
    }

    public static void updateSelection() {
        Display.updateSelection(null);
    }

    public static void updateSelection(Display calling) {
        HashSet<Layer> hs = new HashSet<Layer>();
        for (Display d : al_displays) {
            if (hs.contains(d.layer)) continue;
            hs.add(d.layer);
            if (null == d || null == d.selection) {
                Utils.log2("d is : " + d + " d.selection is " + d.selection);
            } else {
                d.selection.update();
            }
            if (d == calling) continue;
            if (d.selection.getNLinked() > 1) {
                d.canvas.setUpdateGraphics(true);
            }
            d.canvas.repaint(d.selection.getLinkedBox(), Selection.PADDING);
            d.navigator.repaint(true);
        }
    }

    public static void clearSelection(Layer layer) {
        for (Display d : al_displays) {
            if (d.layer != layer) continue;
            d.selection.clear();
        }
    }

    public static void clearSelection() {
        for (Display d : al_displays) {
            d.selection.clear();
        }
    }

    public static void clearSelection(Project p) {
        for (Display d : al_displays) {
            if (d.project != p) continue;
            d.selection.clear();
        }
    }

    private void setTempCurrentImage() {
        WindowManager.setCurrentWindow((ImageWindow)this.canvas.getFakeImagePlus().getWindow());
        WindowManager.setTempCurrentImage((ImagePlus)this.canvas.getFakeImagePlus());
    }

    public static boolean willPaint(Displayable displ) {
        Rectangle box = null;
        for (Display d : al_displays) {
            if (displ.getLayer() != d.layer) continue;
            if (null == box) {
                box = displ.getBoundingBox(null);
            }
            if (!d.canvas.getSrcRect().intersects(box)) continue;
            return true;
        }
        return false;
    }

    public void hideDeselected(boolean not_images) {
        ArrayList<ZDisplayable> all = this.layer.getParent().getZDisplayables();
        all.addAll(this.layer.getDisplayables());
        all.removeAll(this.selection.getSelected());
        if (not_images) {
            all.removeAll(this.layer.getDisplayables(Patch.class));
        }
        for (Displayable displayable : all) {
            if (!displayable.isVisible()) continue;
            displayable.setVisible(false);
            Display.updateCheckboxes(displayable, 2, false);
        }
        Display.update(this.layer);
    }

    public static void flush(Displayable displ) {
        for (Display d : al_displays) {
            d.selection.removeFromPrev(displ);
        }
    }

    public void resizeCanvas(Rectangle bounds) {
        if (bounds.width <= 0 || bounds.height <= 0) {
            throw new IllegalArgumentException("width and height must be larger than zero.");
        }
        this.layer.getParent().setDimensions(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void resizeCanvas() {
        GenericDialog gd = new GenericDialog("Resize LayerSet");
        gd.addNumericField("new width: ", (double)this.layer.getLayerWidth(), 1, 8, "pixels");
        gd.addNumericField("new height: ", (double)this.layer.getLayerHeight(), 1, 8, "pixels");
        gd.addChoice("Anchor: ", LayerSet.ANCHORS, LayerSet.ANCHORS[7]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        float new_width = (float)gd.getNextNumber();
        float new_height = (float)gd.getNextNumber();
        this.layer.getParent().setDimensions(new_width, new_height, gd.getNextChoiceIndex());
    }

    protected void duplicateLinkAndSendTo(Displayable active, int position, Layer other_layer) {
        if (null == active || !(active instanceof Profile)) {
            return;
        }
        if (active.getLayer() == other_layer) {
            return;
        }
        HashSet<DoStep> dataedits = new HashSet<DoStep>();
        dataedits.add(new Displayable.DoEdit(active).init(active, new String[]{"data"}));
        this.getLayerSet().addChangeTreesStep(dataedits);
        Profile profile = this.project.getProjectTree().duplicateChild((Profile)active, position, other_layer);
        if (null == profile) {
            this.getLayerSet().removeLastUndoStep();
            return;
        }
        active.link(profile);
        other_layer.add(profile);
        this.slt.setAndWait(other_layer);
        this.selection.add(profile);
        dataedits = new HashSet();
        dataedits.add(new Displayable.DoEdit(active).init(active, new String[]{"data"}));
        dataedits.add(new Displayable.DoEdit(profile).init(profile, new String[]{"data"}));
        this.getLayerSet().addChangeTreesStep(dataedits);
    }

    protected void setTranspOverlayImages(boolean b) {
        this.transp_overlay_images = b;
        this.updateMultiPaint();
    }

    protected void setTranspOverlayAreas(boolean b) {
        this.transp_overlay_areas = b;
        this.updateMultiPaint();
    }

    protected void setTranspOverlayTextLabels(boolean b) {
        this.transp_overlay_text_labels = b;
        this.updateMultiPaint();
    }

    protected void updateMultiPaint() {
        this.classes_to_multipaint = this.getClassesToMultiPaint();
        this.canvas.repaint(true);
    }

    protected Set<Class<?>> getClassesToMultiPaint() {
        HashSet include = new HashSet();
        if (this.transp_overlay_images) {
            include.add(Patch.class);
            include.add(Stack.class);
        }
        if (this.transp_overlay_areas) {
            include.add(AreaList.class);
            include.add(Profile.class);
        }
        if (this.transp_overlay_text_labels) {
            include.add(DLabel.class);
        }
        return include;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte getLayerCompositeMode(Layer layer) {
        HashMap<Layer, Byte> hashMap = this.layer_composites;
        synchronized (hashMap) {
            Byte b = this.layer_composites.get(layer);
            return null == b ? (byte)0 : b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLayerCompositeMode(Layer layer, byte compositeMode) {
        HashMap<Layer, Byte> hashMap = this.layer_composites;
        synchronized (hashMap) {
            if (-1 == compositeMode || 0 == compositeMode) {
                this.layer_composites.remove(layer);
            } else {
                this.layer_composites.put(layer, compositeMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetLayerComposites() {
        HashMap<Layer, Byte> hashMap = this.layer_composites;
        synchronized (hashMap) {
            this.layer_composites.clear();
        }
        this.canvas.repaint(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetLayerColors() {
        HashMap<Color, Layer> hashMap = this.layer_channels;
        synchronized (hashMap) {
            for (Layer l : new ArrayList<Layer>(this.layer_channels.values())) {
                LayerPanel lp = this.layer_panels.get(l);
                lp.setColor(Color.white);
                this.setColorChannel(lp.layer, Color.white);
                lp.slider.setEnabled(true);
            }
            this.layer_channels.clear();
        }
        this.canvas.repaint(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetLayerAlphas() {
        HashMap<Color, Layer> hashMap = this.layer_channels;
        synchronized (hashMap) {
            for (LayerPanel lp : new ArrayList<LayerPanel>(this.layer_alpha.values())) {
                lp.setAlpha(0.0f);
            }
            this.layer_alpha.clear();
        }
        this.canvas.repaint(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeLayerAlpha(LayerPanel lp, float a) {
        HashMap<Color, Layer> hashMap = this.layer_channels;
        synchronized (hashMap) {
            if (M.equals(0.0, a)) {
                this.layer_alpha.remove(lp.layer.getParent().indexOf(lp.layer));
            } else {
                this.layer_alpha.put(lp.layer.getParent().indexOf(lp.layer), lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPaintMode(HashMap<Color, Layer> hm, ArrayList<LayerPanel> list) {
        HashMap<Color, Layer> hashMap = this.layer_channels;
        synchronized (hashMap) {
            if (this.layer_channels.size() > 0) {
                hm.putAll(this.layer_channels);
                hm.put(Color.green, this.layer);
                return 2;
            }
            list.addAll(this.layer_alpha.values());
            int len = list.size();
            if (len > 1) {
                return 1;
            }
            if (1 == len) {
                if (list.get((int)0).layer == this.layer) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setColorChannel(Layer layer, Color color) {
        HashMap<Color, Layer> hashMap = this.layer_channels;
        synchronized (hashMap) {
            if (Color.white == color) {
                Iterator<Layer> it = this.layer_channels.values().iterator();
                while (it.hasNext()) {
                    if (it.next() != layer) continue;
                    it.remove();
                    break;
                }
                this.canvas.repaint();
            } else if (Color.red == color || Color.blue == color) {
                Layer l = this.layer_channels.remove(color);
                if (null != l) {
                    this.layer_panels.get(l).setColor(Color.white);
                }
                this.layer_channels.put(color, layer);
                this.tabs.repaint();
                this.canvas.repaint();
            } else {
                Utils.log2("Trying to set unacceptable color for layer " + layer + " : " + color);
            }
            boolean b = 0 == this.layer_channels.size();
            for (LayerPanel lp : this.layer_panels.values()) {
                lp.slider.setEnabled(b);
            }
        }
        this.canvas.repaint(true);
    }

    public static final void updateComponentTreeUI() {
        try {
            for (Display d : al_displays) {
                SwingUtilities.updateComponentTreeUI(d.frame);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    public static final Bureaucrat snap(final Patch patch) {
        final HashSet<Displayable> linked = patch.getLinkedGroup(null);
        patch.getLayerSet().addTransformStep(linked);
        Bureaucrat burro = AlignTask.snap(patch, null, false);
        burro.addPostTask(new Runnable(){

            @Override
            public void run() {
                patch.getLayerSet().addTransformStep(linked);
            }
        });
        return burro;
    }

    public void setMode(final Mode mode) {
        ProjectToolbar.setTool(10);
        this.mode = mode;
        this.canvas.repaint(true);
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.this.scroller.setEnabled(mode.canChangeLayer());
            }
        });
    }

    public Mode getMode() {
        return this.mode;
    }

    private static final Hashtable<String, ProjectThing> findLandmarkNodes(Project p, String landmarks_type) {
        HashSet<ProjectThing> landmark_nodes = p.getRootProjectThing().findChildrenOfTypeR(landmarks_type);
        Hashtable<String, ProjectThing> map = new Hashtable<String, ProjectThing>();
        for (ProjectThing pt : landmark_nodes) {
            map.put(pt.toString() + "# " + pt.getId(), pt);
        }
        return map;
    }

    private boolean insertStack(ProjectThing target_landmarks, Project source, ProjectThing source_landmarks, Patch stack_patch) {
        ArrayList<Object> l1 = new ArrayList<Object>();
        ArrayList<Ball> l2 = new ArrayList<Ball>();
        ArrayList<ProjectThing> b1s = source_landmarks.findChildrenOfType("ball");
        ArrayList<ProjectThing> b2s = target_landmarks.findChildrenOfType("ball");
        HashSet<String> seen = new HashSet<String>();
        for (ProjectThing projectThing : b1s) {
            Object ball1 = (Ball)projectThing.getObject();
            if (null == ball1) {
                Utils.log("ERROR: there's an empty 'ball' node in target project" + this.project.toString());
                return false;
            }
            String title1 = ((Displayable)ball1).getTitle();
            for (ProjectThing b2 : b2s) {
                Ball ball2 = (Ball)b2.getObject();
                if (null == ball2) {
                    Utils.log("ERROR: there's an empty 'ball' node in source project" + source.toString());
                    return false;
                }
                if (!title1.equals(ball2.getTitle()) || seen.contains(title1)) continue;
                seen.add(title1);
                l1.add(ball1);
                l2.add(ball2);
            }
        }
        if (l1.size() < 4) {
            Utils.log("ERROR: found only " + l1.size() + " common landmarks: needs at least 4!");
            return false;
        }
        ArrayList<double[]> c1 = new ArrayList<double[]>();
        for (Object ball1 : l1) {
            Map<Layer, double[]> m = ((Ball)ball1).getRawBalls();
            if (1 != m.size()) {
                Utils.log("ERROR: ball object " + ball1 + " from target project " + this.project + " has " + m.size() + " balls instead of just 1.");
                return false;
            }
            Map.Entry<Layer, double[]> e = m.entrySet().iterator().next();
            Layer layer = e.getKey();
            double[] xyr = e.getValue();
            double[] fin = new double[]{xyr[0], xyr[1]};
            AffineTransform affine = ((Displayable)ball1).getAffineTransformCopy();
            try {
                affine.preConcatenate(stack_patch.getAffineTransform().createInverse());
            }
            catch (Exception nite) {
                IJError.print(nite);
                return false;
            }
            double[] fout = new double[2];
            affine.transform(fin, 0, fout, 0, 1);
            c1.add(new double[]{fout[0], fout[1], layer.getParent().indexOf(layer)});
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (Ball ball2 : l2) {
            double[][] b = ball2.getBalls();
            if (1 != b.length) {
                Utils.log("ERROR: ball object " + ball2 + " from source project " + source + " has " + b.length + " balls instead of just 1.");
                return false;
            }
            double[] fin = new double[]{b[0][0], b[0][1]};
            AffineTransform affine = ball2.getAffineTransformCopy();
            double[] fout = new double[2];
            affine.transform(fin, 0, fout, 0, 1);
            arrayList.add(new double[]{fout[0], fout[1], b[0][2]});
        }
        Utils.log("Landmarks:");
        Iterator it1 = c1.iterator();
        Iterator it2 = arrayList.iterator();
        while (it1.hasNext()) {
            Utils.log(Utils.toString(it1.next()) + " <--> " + Utils.toString(it2.next()));
        }
        ArrayList<PointMatch> pm = new ArrayList<PointMatch>();
        Iterator it12 = c1.iterator();
        Iterator it22 = arrayList.iterator();
        while (it12.hasNext()) {
            pm.add(new PointMatch(new Point((double[])it12.next()), new Point((double[])it22.next())));
        }
        AffineModel3D aff3d = new AffineModel3D();
        try {
            aff3d.fit(pm);
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
        String path = stack_patch.getImageFilePath();
        Stack st = new Stack(this.project, new File(path).getName(), 0.0, 0.0, this.getLayerSet().getLayers().get(0), path);
        st.setInvertibleCoordinateTransform((InvertibleCoordinateTransform)aff3d);
        this.getLayerSet().add(st);
        return true;
    }

    private static List<Patch> getPatchStacks(LayerSet ls) {
        HashSet<Patch> stacks = new HashSet<Patch>();
        for (Patch pa : ls.getAll(Patch.class)) {
            PatchStack ps;
            if (stacks.contains(pa) || 1 == (ps = pa.makePatchStack()).getNSlices()) continue;
            stacks.add(ps.getPatch(0));
        }
        return new ArrayList<Patch>(stacks);
    }

    public static Bureaucrat removeAlphaMasks(final Collection<Patch> patches) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Remove alpha masks" + (patches.size() > 1 ? "s" : "")){

            @Override
            public void exec() {
                if (null == patches || patches.isEmpty()) {
                    return;
                }
                ArrayList<Future<Boolean>> jobs = new ArrayList<Future<Boolean>>();
                for (Patch patch : patches) {
                    patch.setAlphaMask(null);
                    Future<Boolean> job = patch.getProject().getLoader().regenerateMipMaps(patch);
                    if (null == job) continue;
                    jobs.add(job);
                }
                for (Future future : jobs) {
                    try {
                        future.get();
                    }
                    catch (Exception exception) {}
                }
            }
        }, patches.iterator().next().getProject());
    }

    public Roi getRoi() {
        return this.canvas.getFakeImagePlus().getRoi();
    }

    public <T extends Displayable> List<T> find() {
        GenericDialog gd = new GenericDialog("Select matching");
        Utils.addLayerRangeChoices(this.layer, gd);
        gd.addStringField("Regular expression:", "");
        TreeMap<String, Class<Dissector>> types = new TreeMap<String, Class<Dissector>>();
        types.put("01 - All", Displayable.class);
        types.put("02 - Image (Patch, Stack)", ImageData.class);
        types.put("03 - Non-image (VectorData subtypes)", VectorData.class);
        types.put("04 - Tree (Treeline, AreaTree, Connector)", Tree.class);
        types.put("05 - Area container (AreaTree, AreaList)", AreaContainer.class);
        types.put("06 - Text labels", DLabel.class);
        types.put("07 - Patch (image)", Patch.class);
        types.put("08 - Stack (image)", Stack.class);
        types.put("09 - AreaList", AreaList.class);
        types.put("10 - AreaTree", AreaTree.class);
        types.put("11 - Treeline", Treeline.class);
        types.put("12 - Connector", Connector.class);
        types.put("13 - Ball", Ball.class);
        types.put("14 - Pipe", Pipe.class);
        types.put("15 - Polyline", Polyline.class);
        types.put("16 - Profile", Profile.class);
        types.put("17 - Dissector", Dissector.class);
        gd.addChoice("Type:", types.keySet().toArray(new String[types.size()]), (String)types.firstKey());
        gd.addCheckbox("Visible only", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return Collections.EMPTY_LIST;
        }
        int first = gd.getNextChoiceIndex();
        int last = gd.getNextChoiceIndex();
        return this.find(gd.getNextString(), gd.getNextBoolean(), (Class)types.get(gd.getNextChoice()), first, last);
    }

    public <T extends Displayable> List<T> find(String regex, boolean visible_only, Class<T> c, int firstLayerIndex, int lastLayerIndex) {
        return Display.find(regex, visible_only, c, this.layer.getParent().getLayers(firstLayerIndex, lastLayerIndex));
    }

    private static final String fixRegex(String regex) {
        if (regex.charAt(0) != '^') {
            regex = regex.startsWith(".*") ? "^" + regex : "^.*" + regex;
        }
        if (regex.charAt(regex.length() - 1) != '$') {
            regex = regex.endsWith(".*") ? regex + "$" : regex + ".*$";
        }
        return regex;
    }

    public static <T extends Displayable> List<T> find(String regex, boolean visible_only, Class<T> c, List<Layer> layers) {
        Utils.log2(regex, (Object)visible_only, c, layers);
        ArrayList<Displayable> ds = new ArrayList<Displayable>();
        Pattern pattern = null == regex || 0 == regex.length() ? null : Pattern.compile(Display.fixRegex(regex));
        for (Layer l : layers) {
            for (Displayable d : l.getDisplayables()) {
                if (visible_only && !d.isVisible() || !c.isInstance(d)) continue;
                if (null == pattern) {
                    ds.add(d);
                    continue;
                }
                if (!pattern.matcher(d.getTitle()).matches()) continue;
                ds.add(d);
            }
        }
        block2: for (ZDisplayable d : layers.get(0).getParent().getZDisplayables()) {
            if (visible_only && !d.isVisible() || !c.isInstance(d) || null != pattern && !pattern.matcher(d.getTitle()).matches()) continue;
            for (Layer l : layers) {
                if (!d.paintsAt(l)) continue;
                ds.add(d);
                continue block2;
            }
        }
        return ds;
    }

    private static class UpdateDimensionField
    implements TextListener {
        final TextField width;
        final TextField height;
        final TextField scale;
        final Scrollbar bar;
        final int initial_width;
        final int initial_height;

        UpdateDimensionField(int initial_width, int initial_height, TextField width, TextField height, TextField scale, Scrollbar bar) {
            this.initial_width = initial_width;
            this.initial_height = initial_height;
            this.width = width;
            this.height = height;
            this.scale = scale;
            this.bar = bar;
        }

        @Override
        public void textValueChanged(TextEvent e) {
            try {
                TextField source = (TextField)e.getSource();
                if (this.scale == source && (this.scale.isFocusOwner() || this.bar.isFocusOwner())) {
                    double sc = Double.parseDouble(this.scale.getText()) / 100.0;
                    this.width.setText(Integer.toString((int)(sc * (double)this.initial_width + 0.5)));
                    this.height.setText(Integer.toString((int)(sc * (double)this.initial_height + 0.5)));
                } else if (this.width == source && this.width.isFocusOwner()) {
                    this.set(this.width, this.height, this.initial_width, this.initial_height);
                } else if (this.height == source && this.height.isFocusOwner()) {
                    this.set(this.height, this.width, this.initial_height, this.initial_width);
                }
            }
            catch (NumberFormatException nfe) {
                Utils.logAll("Unparsable number: " + nfe.getMessage());
            }
            catch (Exception ee) {
                IJError.print(ee);
            }
        }

        private void set(TextField source, TextField target, int initial_source, int initial_target) {
            int dim = (int)(Double.parseDouble(source.getText()) + 0.5);
            double sc = (double)dim / (double)initial_source;
            this.scale.setText(Utils.cutNumber(sc * 100.0, 3));
            target.setText(Integer.toString((int)(sc * (double)initial_target + 0.5)));
        }
    }

    private static class ByTypeListener
    implements ActionListener {
        final Display d;

        ByTypeListener(Display d) {
            this.d = d;
        }

        @Override
        public void actionPerformed(final ActionEvent ae) {
            final String command = ae.getActionCommand();
            final Area aroi = M.getArea(this.d.canvas.getFakeImagePlus().getRoi());
            this.d.dispatcher.exec(new Runnable(){

                @Override
                public void run() {
                    try {
                        String type = command;
                        if (type.equals("Image")) {
                            type = "Patch";
                        } else if (type.equals("Text")) {
                            type = "DLabel";
                        }
                        Class<?> c = Class.forName("ini.trakem2.display." + type);
                        ArrayList<Displayable> a = new ArrayList<Displayable>();
                        if (null != aroi) {
                            a.addAll(d.layer.getDisplayables(c, aroi, true));
                            a.addAll(d.layer.getParent().findZDisplayables(c, d.layer, aroi, true, true));
                        } else {
                            a.addAll(d.layer.getDisplayables(c));
                            a.addAll(d.layer.getParent().getZDisplayables(c));
                            Iterator it = a.iterator();
                            while (it.hasNext()) {
                                if (((Displayable)it.next()).isVisible()) continue;
                                it.remove();
                            }
                        }
                        if (0 == a.size()) {
                            return;
                        }
                        boolean selected = false;
                        if (0 == ae.getModifiers()) {
                            Utils.log2("first");
                            d.selection.clear();
                            d.selection.selectAll(a);
                            selected = true;
                        } else if (0 == (ae.getModifiers() ^ 1)) {
                            Utils.log2("with shift");
                            d.selection.selectAll(a);
                            selected = true;
                        }
                        if (selected) {
                            d.selection.setActive((Displayable)a.get(a.size() - 1));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        Utils.log2(e.toString());
                    }
                }
            });
        }
    }

    private class SetToolListener
    implements ActionListener {
        final int tool;

        SetToolListener(int tool) {
            this.tool = tool;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ProjectToolbar.setTool(this.tool);
            Display.this.toolbar_panel.repaint();
        }
    }

    private class MenuScriptListener
    implements ActionListener {
        private MenuScriptListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            final String command = ae.getActionCommand();
            Bureaucrat.createAndStart((Worker)new Worker.Task("Setting preprocessor script"){

                @Override
                public void exec() {
                    try {
                        if (command.equals("Set preprocessor script layer-wise...")) {
                            Collection ls = MenuScriptListener.this.getLayerList("Set preprocessor script");
                            if (null == ls) {
                                return;
                            }
                            String path = MenuScriptListener.this.getScriptPath();
                            if (null == path) {
                                return;
                            }
                            MenuScriptListener.this.setScriptPathToLayers(ls, path);
                        } else if (command.equals("Set preprocessor script (selected images)...")) {
                            if (Display.this.selection.isEmpty()) {
                                return;
                            }
                            String path = MenuScriptListener.this.getScriptPath();
                            if (null == path) {
                                return;
                            }
                            MenuScriptListener.this.setScriptPath(Display.this.selection.get(Patch.class), path);
                        } else if (command.equals("Remove preprocessor script layer-wise...")) {
                            Collection ls = MenuScriptListener.this.getLayerList("Remove preprocessor script");
                            if (null == ls) {
                                return;
                            }
                            MenuScriptListener.this.setScriptPathToLayers(ls, null);
                        } else if (command.equals("Remove preprocessor script (selected images)...")) {
                            if (Display.this.selection.isEmpty()) {
                                return;
                            }
                            MenuScriptListener.this.setScriptPath(Display.this.selection.get(Patch.class), null);
                        }
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                }
            }, Display.this.project);
        }

        private void setScriptPathToLayers(Collection<Layer> ls, String script) throws Exception {
            ArrayList<Patch> ds = new ArrayList<Patch>();
            for (Layer la : ls) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ds.addAll(la.getAll(Patch.class));
            }
            this.setScriptPath(ds, script);
        }

        private void setScriptPath(Collection<Patch> list, final String script) throws Exception {
            Process.progressive(list, new TaskFactory<Patch, Object>(){

                @Override
                public Object process(Patch p) {
                    p.setPreprocessorScriptPath(script);
                    try {
                        p.updateMipMaps().get();
                    }
                    catch (Throwable t) {
                        IJError.print(t);
                    }
                    return null;
                }
            }, Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        }

        private Collection<Layer> getLayerList(String title) {
            GenericDialog gd = new GenericDialog(title);
            Utils.addLayerRangeChoices(Display.this.layer, gd);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            return Display.this.layer.getParent().getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1);
        }

        private String getScriptPath() {
            OpenDialog od = new OpenDialog("Select script", OpenDialog.getLastDirectory(), null);
            String dir = od.getDirectory();
            if (null == dir) {
                return null;
            }
            if (IJ.isWindows()) {
                dir = dir.replace('\\', '/');
            }
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            return dir + od.getFileName();
        }
    }

    private class StartTransformMenuListener
    implements ActionListener {
        private StartTransformMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("Transform (affine)")) {
                if (null == Display.this.active) {
                    return;
                }
                Display.this.getLayerSet().addTransformStepWithData(Display.this.selection.getAffected());
                Display.this.setMode(new AffineTransformMode(Display.this));
            } else if (command.equals("Transform (non-linear)")) {
                if (null == Display.this.active) {
                    return;
                }
                Display.this.getLayerSet().addTransformStepWithData(Display.this.selection.getAffected());
                ArrayList<Displayable> col = Display.this.selection.getSelected(Patch.class);
                for (Displayable d : col) {
                    if (!d.isLinked()) continue;
                    Utils.showMessage("Can't enter manual non-linear transformation mode:\nat least one image is linked.");
                    return;
                }
                Display.this.setMode(new NonLinearTransformMode(Display.this, col));
            } else if (command.equals("Remove coordinate transforms (selected images)")) {
                if (null == Display.this.active) {
                    return;
                }
                ArrayList<Displayable> col = Display.this.selection.getSelected(Patch.class);
                if (col.isEmpty()) {
                    return;
                }
                Display.this.removeCoordinateTransforms(col);
            } else if (command.equals("Remove coordinate transforms layer-wise")) {
                GenericDialog gd = new GenericDialog("Remove Coordinate Transforms");
                gd.addMessage("Remove coordinate transforms");
                gd.addMessage("for all images in:");
                Utils.addLayerRangeChoices(Display.this.layer, gd);
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                ArrayList<Patch> patches = new ArrayList<Patch>();
                for (Layer layer : Display.this.getLayerSet().getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1)) {
                    patches.addAll(layer.getDisplayables(Patch.class));
                }
                Display.this.removeCoordinateTransforms(patches);
            } else if (command.equals("Remove rotation, scaling and shear (selected images)")) {
                if (null == Display.this.active) {
                    return;
                }
                ArrayList<Displayable> col = Display.this.selection.getSelected(Patch.class);
                if (col.isEmpty()) {
                    return;
                }
                Display.this.removeScalingRotationShear(col);
            } else if (command.equals("Remove rotation, scaling and shear layer-wise")) {
                GenericDialog gd = new GenericDialog("Remove Scaling/Rotation/Shear");
                gd.addMessage("Remove scaling, translation");
                gd.addMessage("and shear for all images in:");
                Utils.addLayerRangeChoices(Display.this.layer, gd);
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                ArrayList<Patch> patches = new ArrayList<Patch>();
                for (Layer layer : Display.this.getLayerSet().getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1)) {
                    patches.addAll(layer.getDisplayables(Patch.class));
                }
                Display.this.removeScalingRotationShear(patches);
            } else if (command.equals("Adjust mesh resolution (selected images)")) {
                if (null == Display.this.active) {
                    return;
                }
                List<Patch> col = Display.this.selection.get(Patch.class);
                if (col.isEmpty()) {
                    return;
                }
                GenericDialog gd = new GenericDialog("Adjust mesh resolution");
                gd.addSlider("Mesh resolution:", 2.0, 512.0, (double)((Patch)(Display.this.active.getClass() == Patch.class ? Display.this.active : (Displayable)col.get(0))).getMeshResolution());
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                Display.this.setMeshResolution(col, (int)gd.getNextNumber());
            } else if (command.equals("Adjust mesh resolution layer-wise")) {
                GenericDialog gd = new GenericDialog("Adjust mesh resolution");
                Utils.addLayerRangeChoices(Display.this.layer, gd);
                gd.addSlider("Mesh resolution:", 2.0, 512.0, (double)Display.this.project.getProperty("mesh_resolution", 32));
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                ArrayList<Patch> patches = new ArrayList<Patch>();
                for (Layer layer : Display.this.getLayerSet().getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1)) {
                    patches.addAll(layer.getAll(Patch.class));
                }
                Display.this.setMeshResolution(patches, (int)gd.getNextNumber());
            } else if (command.startsWith("Set coordinate transform of selected image")) {
                List<Patch> patches;
                if (null == Display.this.active || !(Display.this.active instanceof Patch)) {
                    return;
                }
                Object ct = ((Patch)Display.this.active).getCoordinateTransform();
                if (null == ct) {
                    Utils.showMessage("The selected image does not have a coordinate transform!");
                    return;
                }
                GenericDialog gd = new GenericDialog("Set coordinate transform");
                gd.addChoice("Existing coordinate transform", new String[]{"Replace", "Append", "Pre-append"}, "Replace");
                gd.addCheckbox("Only the lens distortion correction", false);
                if (command.endsWith("to other selected images")) {
                    patches = Display.this.selection.get(Patch.class);
                    patches.remove((Patch)Display.this.active);
                    if (patches.isEmpty()) {
                        Utils.showMessage("Select more than one image!");
                        return;
                    }
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                } else if (command.endsWith("layer-wise")) {
                    Utils.addLayerRangeChoices(Display.this.layer, gd);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    patches = new ArrayList<Patch>();
                    for (Layer layer : Display.this.getLayerSet().getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1)) {
                        patches.addAll(layer.getAll(Patch.class));
                    }
                } else {
                    return;
                }
                int existingCT = gd.getNextChoiceIndex();
                boolean only_lens_model = gd.getNextBoolean();
                if (only_lens_model && null == (ct = this.findFirstLensDeformationModel((CoordinateTransform)ct))) {
                    Utils.showMessage("Could not find a lens distortion correction model\n in image " + Display.this.active);
                    return;
                }
                Display.this.setCoordinateTransform(patches, (CoordinateTransform)ct, existingCT);
            } else if (command.equals("Set affine transform of selected image to other selected images")) {
                if (null == Display.this.active || !(Display.this.active instanceof Patch)) {
                    return;
                }
                AffineTransform aff = Display.this.active.getAffineTransformCopy();
                HashSet<Layer> layers = new HashSet<Layer>();
                ArrayList<Displayable> patches = Display.this.selection.getSelected(Patch.class);
                Display.this.getLayerSet().addTransformStep((Collection<? extends Displayable>)patches);
                for (Displayable p : patches) {
                    if (p == Display.this.active) continue;
                    p.setAffineTransform(aff);
                    layers.add(p.getLayer());
                }
                for (Layer l : layers) {
                    l.recreateBuckets();
                }
                Display.this.getLayerSet().addTransformStep((Collection<? extends Displayable>)patches);
            } else if (command.equals("Set affine transform of selected image layer-wise")) {
                if (null == Display.this.active || !(Display.this.active instanceof Patch)) {
                    return;
                }
                AffineTransform aff = Display.this.active.getAffineTransformCopy();
                GenericDialog gd = new GenericDialog("Choose range of layers");
                Utils.addLayerRangeChoices(Display.this.layer, gd);
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                ArrayList<Patch> patches = new ArrayList<Patch>();
                List<Layer> layers = Display.this.getLayerSet().getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1);
                for (Layer layer : layers) {
                    patches.addAll(layer.getAll(Patch.class));
                }
                Display.this.getLayerSet().addTransformStep((Collection<? extends Displayable>)patches);
                for (Patch p : patches) {
                    p.setAffineTransform(aff);
                }
                for (Layer l : layers) {
                    l.recreateBuckets();
                }
                Display.this.getLayerSet().addTransformStep((Collection<? extends Displayable>)patches);
            }
            Display.repaint();
        }

        private NonLinearTransform findFirstLensDeformationModel(CoordinateTransform ct) {
            while (CoordinateTransformList.class.isInstance(ct)) {
                ct = (CoordinateTransform)((CoordinateTransformList)ct).get(0);
            }
            if (ct instanceof NonLinearTransform) {
                return (NonLinearTransform)ct;
            }
            return null;
        }
    }

    protected class GridOverlay {
        ArrayList<Line2D> lines = new ArrayList();
        int ox = 0;
        int oy = 0;
        int width = (int)Display.access$300(Display.this).getLayerWidth();
        int height = (int)Display.access$300(Display.this).getLayerHeight();
        int xoffset = 0;
        int yoffset = 0;
        int tilewidth = 100;
        int tileheight = 100;
        int linewidth = 1;
        boolean visible = true;
        Color color = new Color(255, 255, 0, 255);

        protected GridOverlay() {
        }

        void init() {
            this.lines.clear();
            if (0 != this.xoffset) {
                this.lines.add(new Line2D.Float(this.ox, this.oy, this.ox, this.oy + this.height));
            }
            this.lines.add(new Line2D.Float(this.ox + this.width, this.oy, this.ox + this.width, this.oy + this.height));
            for (int x = this.ox + this.xoffset; x <= this.ox + this.width; x += this.tilewidth) {
                this.lines.add(new Line2D.Float(x, this.oy, x, this.oy + this.height));
            }
            if (0 != this.yoffset) {
                this.lines.add(new Line2D.Float(this.ox, this.oy, this.ox + this.width, this.oy));
            }
            this.lines.add(new Line2D.Float(this.ox, this.oy + this.height, this.ox + this.width, this.oy + this.height));
            for (int y = this.oy + this.yoffset; y <= this.oy + this.height; y += this.tileheight) {
                this.lines.add(new Line2D.Float(this.ox, y, this.ox + this.width, y));
            }
        }

        protected void paint(Graphics2D g) {
            if (!this.visible) {
                return;
            }
            g.setStroke(new BasicStroke((float)((double)this.linewidth / Display.this.canvas.getMagnification())));
            g.setColor(this.color);
            for (Line2D line : this.lines) {
                g.draw(line);
            }
        }

        void setup(Roi roi) {
            GenericDialog gd = new GenericDialog("Grid overlay");
            Calibration cal = Display.this.getLayerSet().getCalibration();
            gd.addNumericField("Top-left corner X:", (double)this.ox * cal.pixelWidth, 1, 10, cal.getUnits());
            gd.addNumericField("Top-left corner Y:", (double)this.oy * cal.pixelHeight, 1, 10, cal.getUnits());
            gd.addNumericField("Grid total width:", (double)this.width * cal.pixelWidth, 1, 10, cal.getUnits());
            gd.addNumericField("Grid total height:", (double)this.height * cal.pixelHeight, 1, 10, cal.getUnits());
            gd.addCheckbox("Read bounds from ROI", null != roi);
            ((Component)gd.getCheckboxes().get(0)).setEnabled(null != roi);
            gd.addMessage("");
            gd.addNumericField("Tile width:", (double)this.tilewidth * cal.pixelWidth, 1, 10, cal.getUnits());
            gd.addNumericField("Tile height:", (double)this.tileheight * cal.pixelHeight, 1, 10, cal.getUnits());
            gd.addNumericField("Tile offset X:", (double)this.xoffset * cal.pixelWidth, 1, 10, cal.getUnits());
            gd.addNumericField("Tile offset Y:", (double)this.yoffset * cal.pixelHeight, 1, 10, cal.getUnits());
            gd.addMessage("");
            gd.addNumericField("Line width:", (double)this.linewidth, 1, 10, "pixels");
            gd.addSlider("Red: ", 0.0, 255.0, (double)this.color.getRed());
            gd.addSlider("Green: ", 0.0, 255.0, (double)this.color.getGreen());
            gd.addSlider("Blue: ", 0.0, 255.0, (double)this.color.getBlue());
            gd.addSlider("Alpha: ", 0.0, 255.0, (double)this.color.getAlpha());
            gd.addMessage("");
            gd.addCheckbox("Visible", this.visible);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            this.ox = (int)(gd.getNextNumber() / cal.pixelWidth);
            this.oy = (int)(gd.getNextNumber() / cal.pixelHeight);
            this.width = (int)(gd.getNextNumber() / cal.pixelWidth);
            this.height = (int)(gd.getNextNumber() / cal.pixelHeight);
            if (gd.getNextBoolean() && null != roi) {
                Rectangle r = roi.getBounds();
                this.ox = r.x;
                this.oy = r.y;
                this.width = r.width;
                this.height = r.height;
            }
            this.tilewidth = (int)(gd.getNextNumber() / cal.pixelWidth);
            this.tileheight = (int)(gd.getNextNumber() / cal.pixelHeight);
            this.xoffset = (int)(gd.getNextNumber() / cal.pixelWidth) % this.tilewidth;
            this.yoffset = (int)(gd.getNextNumber() / cal.pixelHeight) % this.tileheight;
            this.linewidth = (int)gd.getNextNumber();
            this.color = new Color((int)gd.getNextNumber(), (int)gd.getNextNumber(), (int)gd.getNextNumber(), (int)gd.getNextNumber());
            this.visible = gd.getNextBoolean();
            this.init();
        }
    }

    private final class GraphMenuListener
    implements ActionListener {
        private GraphMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            final String command = ae.getActionCommand();
            final ArrayList<Displayable> sel = Display.this.selection.getSelected();
            if (null == sel || sel.isEmpty()) {
                return;
            }
            Bureaucrat.createAndStart((Worker)new Worker.Task(command){

                @Override
                public void exec() {
                    ArrayList<ZDisplayable> connectors = Display.this.getLayerSet().getZDisplayables(Connector.class);
                    HashSet<Displayable> to_select = new HashSet<Displayable>();
                    if (command.equals("Select outgoing Connectors")) {
                        for (Connector connector : connectors) {
                            Set<Displayable> origins = connector.getOrigins();
                            origins.retainAll(sel);
                            if (origins.isEmpty()) continue;
                            to_select.add(connector);
                        }
                    } else if (command.equals("Select incoming Connectors")) {
                        for (Connector connector : connectors) {
                            for (Set<Displayable> targets : connector.getTargets()) {
                                targets.retainAll(sel);
                                if (targets.isEmpty()) continue;
                                to_select.add(connector);
                            }
                        }
                    } else if (command.equals("Select downstream targets")) {
                        for (Connector connector : connectors) {
                            Set<Displayable> origins = connector.getOrigins();
                            origins.retainAll(sel);
                            if (origins.isEmpty()) continue;
                            for (Set<Displayable> targets : connector.getTargets()) {
                                to_select.addAll(targets);
                            }
                        }
                    } else if (command.equals("Select upstream targets")) {
                        block5: for (Connector connector : connectors) {
                            for (Set<Displayable> targets : connector.getTargets()) {
                                targets.retainAll(sel);
                                if (targets.isEmpty()) continue;
                                to_select.addAll(connector.getOrigins());
                                continue block5;
                            }
                        }
                    }
                    Display.this.selection.selectAll(new ArrayList(to_select));
                }
            }, Display.this.project);
        }
    }

    private class TransparencySliderListener
    extends MouseAdapter
    implements ChangeListener {
        private TransparencySliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            float new_value = ((JSlider)ce.getSource()).getValue();
            Display.this.setTransparency(new_value / 100.0f);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            Display.this.navigator.repaint(true);
        }
    }

    private class ToolbarPanel
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        Method drawButton;
        Field lineType;
        Field SIZE;
        Field OFFSET;
        Toolbar toolbar = Toolbar.getInstance();
        int size;
        int scale = 1;

        ToolbarPanel() {
            this.setBackground(Color.white);
            this.addMouseListener(this);
            try {
                this.drawButton = Toolbar.class.getDeclaredMethod("drawButton", Graphics.class, Integer.TYPE);
                this.drawButton.setAccessible(true);
                this.lineType = Toolbar.class.getDeclaredField("lineType");
                this.lineType.setAccessible(true);
                this.SIZE = Toolbar.class.getDeclaredField("buttonHeight");
                this.SIZE.setAccessible(true);
                this.OFFSET = Toolbar.class.getDeclaredField("OFFSET");
                this.OFFSET.setAccessible(true);
                this.size = (Integer)this.SIZE.get(null);
                Field scaleField = Toolbar.class.getDeclaredField("scale");
                scaleField.setAccessible(true);
                this.scale = (Integer)scaleField.get(null);
            }
            catch (Exception e) {
                IJError.print(e);
                this.scale = 1;
            }
            Dimension dim = new Dimension(9 * this.size, this.size + this.size);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
            this.setMaximumSize(dim);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics gr) {
            try {
                int i;
                BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                Graphics g = bi.getGraphics();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                if (this.scale == 1) {
                    if (Prefs.getGuiScale() > 1.0) {
                        g2d.setStroke(new BasicStroke(IJ.isMacOSX() ? 1.4f : 1.25f));
                    }
                } else {
                    g2d.setStroke(new BasicStroke(this.scale));
                }
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                for (i = 0; i < 4; ++i) {
                    this.drawButton.invoke((Object)this.toolbar, g, i);
                }
                this.drawButton.invoke((Object)this.toolbar, g, this.lineType.get(this.toolbar));
                while (i <= 9) {
                    this.drawButton.invoke((Object)this.toolbar, g, i);
                    ++i;
                }
                this.drawButton.invoke((Object)this.toolbar, g, 14);
                AffineTransform aff = new AffineTransform();
                aff.translate(-this.size * 9, this.size - 1);
                ((Graphics2D)g).setTransform(aff);
                while (i < 18) {
                    this.drawButton.invoke((Object)this.toolbar, g, i);
                    ++i;
                }
                gr.drawImage(bi, 0, 0, null);
                bi.flush();
                g.dispose();
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            int x = me.getX();
            int y = me.getY();
            if (y > this.size) {
                if (x > this.size * 7) {
                    return;
                }
                x += this.size * 9;
                y -= this.size;
            } else if (x > this.size * 9) {
                return;
            }
            Toolbar.getInstance().mousePressed(new MouseEvent((Component)this.toolbar, me.getID(), System.currentTimeMillis(), me.getModifiers(), x, y, me.getClickCount(), me.isPopupTrigger()));
            this.repaint();
            Display.toolChanged(ProjectToolbar.getToolId());
        }

        @Override
        public void mouseReleased(MouseEvent me) {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }
    }

    private final class ScrollerModel
    extends DefaultBoundedRangeModel {
        private static final long serialVersionUID = 1L;
        int index;

        ScrollerModel(Layer la) {
            this.index = la.getParent().indexOf(la);
        }

        public void setValueWithoutEvent(int index) {
            this.index = index;
            Display.this.scroller.updateUI();
        }

        @Override
        public void setValue(int index) {
            this.index = index;
            super.setValue(index);
        }

        @Override
        public int getValue() {
            return this.index;
        }
    }

    private final class ImagePreloader
    extends Thread {
        private Layer oldLayer;
        private Layer newLayer;
        private int nLayers;
        private boolean restart = false;

        ImagePreloader() {
            this.setPriority(5);
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void reset(Layer oldLayer, Layer newLayer, int nLayers) {
            ImagePreloader imagePreloader = this;
            synchronized (imagePreloader) {
                this.restart = true;
                this.oldLayer = oldLayer;
                this.newLayer = newLayer;
                this.nLayers = nLayers;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: while (!this.isInterrupted()) {
                int nLayers;
                Layer newLayer;
                Layer oldLayer;
                ImagePreloader imagePreloader = this;
                synchronized (imagePreloader) {
                    try {
                        if (!this.restart) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    oldLayer = this.oldLayer;
                    newLayer = this.newLayer;
                    this.oldLayer = null;
                    this.newLayer = null;
                    nLayers = this.nLayers;
                    this.restart = false;
                }
                LayerSet ls = oldLayer.getParent();
                int old_layer_index = ls.indexOf(oldLayer);
                int new_layer_index = ls.indexOf(newLayer);
                int sign = new_layer_index - old_layer_index;
                Area aroi = new Area(Display.this.canvas.getSrcRect());
                double mag = Display.this.canvas.getMagnification();
                block6: for (Layer la : ls.getLayers(Math.max(0, Math.min(new_layer_index + sign * nLayers, ls.size() - 1)), new_layer_index)) {
                    if (this.restart) continue block5;
                    for (Displayable d : la.getDisplayables(Patch.class, aroi, true)) {
                        if (this.restart) continue block6;
                        if (this.isInterrupted()) {
                            return;
                        }
                        Display.this.project.getLoader().fetchImage((Patch)d, mag);
                    }
                }
            }
        }
    }

    private class SetLayerThread
    extends Thread {
        private volatile Layer layer;
        private final Object lock;

        SetLayerThread() {
            super("SetLayerThread");
            this.lock = new Object();
            this.setPriority(5);
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void set(Layer layer) {
            Object object = this.lock;
            synchronized (object) {
                this.layer = layer;
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        final void setAndWait(Layer layer) {
            if (null != layer) {
                if (layer.getParent().preload_ahead > 0) {
                    Display.this.preloadImagesAhead(Display.this.layer, layer, layer.getParent().preload_ahead);
                }
                Display.this.setLayer(layer);
                Display.this.updateInDatabase("layer_id");
                Display.this.createColumnScreenshots();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                while (null == this.layer) {
                    SetLayerThread setLayerThread = this;
                    synchronized (setLayerThread) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                Layer layer = null;
                Object object = this.lock;
                synchronized (object) {
                    layer = this.layer;
                    this.layer = null;
                }
                if (this.isInterrupted()) {
                    return;
                }
                this.setAndWait(layer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.interrupt();
            SetLayerThread setLayerThread = this;
            synchronized (setLayerThread) {
                this.notify();
            }
        }
    }
}

