/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.imaging.filters.IFilter;
import java.util.Map;
import java.util.Random;

public class ValueToNoise
implements IFilter {
    protected double value = Double.NaN;
    protected double min = 0.0;
    protected double max = 255.0;

    private static final void processFloatNaN(FloatProcessor ip, double min, double max) {
        double scale = max - min;
        Random rnd = new Random();
        int n = ip.getWidth() * ip.getHeight();
        for (int i = 0; i < n; ++i) {
            float v = ip.getf(i);
            if (!Float.isNaN(v)) continue;
            ip.setf(i, (float)(rnd.nextDouble() * scale + min));
        }
    }

    private static final void processFloat(FloatProcessor ip, float value, double min, double max) {
        double scale = max - min;
        Random rnd = new Random();
        int n = ip.getWidth() * ip.getHeight();
        for (int i = 0; i < n; ++i) {
            float v = ip.getf(i);
            if (v != value) continue;
            ip.setf(i, (float)(rnd.nextDouble() * scale + min));
        }
    }

    private static final void processGray(ImageProcessor ip, int value, int min, int max) {
        int scale = max - min + 1;
        Random rnd = new Random();
        int n = ip.getWidth() * ip.getHeight();
        for (int i = 0; i < n; ++i) {
            int v = ip.get(i);
            if (v != value) continue;
            ip.set(i, rnd.nextInt(scale) + min);
        }
    }

    private static final void processColor(ColorProcessor ip, int value, int min, int max) {
        int scale = max - min + 1;
        Random rnd = new Random();
        int n = ip.getWidth() * ip.getHeight();
        for (int i = 0; i < n; ++i) {
            int v = ip.get(i);
            if (v != value) continue;
            int r = rnd.nextInt(scale) + min;
            int g = rnd.nextInt(scale) + min;
            int b = rnd.nextInt(scale) + min;
            ip.set(i, ((0xFF00 | r) << 8 | g) << 8 | b);
        }
    }

    public ValueToNoise() {
    }

    public ValueToNoise(double value, double min, double max) {
        this.set(value, min, max);
    }

    private final void set(double value, double min, double max) {
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public ValueToNoise(Map<String, String> params) {
        try {
            this.set(Double.parseDouble(params.get("value")), Double.parseDouble(params.get("min")), Double.parseDouble(params.get("max")));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Could not create ValueToNoise filter!", nfe);
        }
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        try {
            if (FloatProcessor.class.isInstance(ip)) {
                if (Double.isNaN(this.value)) {
                    ValueToNoise.processFloatNaN((FloatProcessor)ip, this.min, this.max);
                } else {
                    ValueToNoise.processFloat((FloatProcessor)ip, (float)this.value, this.min, this.max);
                }
            } else if (ColorProcessor.class.isInstance(ip)) {
                ValueToNoise.processColor((ColorProcessor)ip, (int)Math.round(this.value), (int)Math.round(this.min), (int)Math.round(this.max));
            } else {
                ValueToNoise.processGray(ip, (int)Math.round(this.value), (int)Math.round(this.min), (int)Math.round(this.max));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ip;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" value=\"" + this.value + "\" min=\"" + this.min + "\" max=\"" + this.max + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() == ValueToNoise.class) {
            ValueToNoise c = (ValueToNoise)o;
            return (Double.isNaN(this.value) && Double.isNaN(c.value) || this.value == c.value) && this.min == c.min && this.max == c.max;
        }
        return false;
    }
}

