/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import amira.AmiraMeshDecoder;
import ij.IJ;
import ij.ImageJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.io.DirectoryChooser;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.StackStatistics;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.MipMapImage;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Polyline;
import ini.trakem2.display.Region;
import ini.trakem2.display.Selection;
import ini.trakem2.display.Stack;
import ini.trakem2.display.YesNoDialog;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.imaging.ContrastEnhancerWrapper;
import ini.trakem2.imaging.FloatProcessorT2;
import ini.trakem2.imaging.LazyVirtualStack;
import ini.trakem2.imaging.PatchStack;
import ini.trakem2.imaging.StitchingTEM;
import ini.trakem2.imaging.filters.IFilter;
import ini.trakem2.io.AmiraImporter;
import ini.trakem2.io.ImageFileFilter;
import ini.trakem2.io.ImageFileHeader;
import ini.trakem2.persistence.Cache;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.ExportMultilevelTiles;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.scripting.PatchScript;
import ini.trakem2.tree.DTDParser;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.CachingThread;
import ini.trakem2.utils.Dispatcher;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Montage;
import ini.trakem2.utils.Saver;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import mpi.fruitfly.general.MultiThreading;
import mpi.fruitfly.math.datastructures.FloatArray2D;
import mpi.fruitfly.registration.ImageFilter;
import mpicbg.trakem2.util.Triple;

public abstract class Loader {
    protected final Object db_lock = new Object();
    protected Opener opener = new Opener();
    protected final int MAX_RETRIES = 3;
    protected boolean changes = false;
    private final AtomicLong nextTempId = new AtomicLong(-1L);
    public static final int ERROR_PATH_NOT_FOUND = Integer.MAX_VALUE;
    public static final IndexColorModel GRAY_LUT = Loader.makeGrayLut();
    protected final Set<Displayable> hs_unloadable = Collections.synchronizedSet(new HashSet());
    public static final BufferedImage NOT_FOUND = new BufferedImage(10, 10, 13, GRAY_LUT);
    public static final BufferedImage REGENERATING;
    private static float heap_fraction;
    private static final Object HEAPLOCK;
    protected final transient Cache mawts = new Cache((long)((float)MAX_MEMORY * heap_fraction));
    protected static transient Vector<Loader> v_loaders;
    private final Set<String> stale_files = Collections.synchronizedSet(new HashSet());
    private int temp_snapshots_mode = 0;
    protected static final Runtime RUNTIME;
    private static final long MAX_MEMORY;
    public static long MIN_FREE_BYTES;
    private static boolean low_memory_conditions;
    private static final Object CROSSLOCK;
    private final Map<String, ImageLoadingLock> ht_plocks = new HashMap<String, ImageLoadingLock>();
    private String last_opened_path = null;
    public static final int PREPROCESSED = -999999;
    private final ArrayList<Bureaucrat> jobs = new ArrayList();
    private JPopupMenu popup_jobs = null;
    protected boolean mipmaps_regen = true;
    private static final ImagePlusAccess ipa;
    private static ExecutorService preloader;
    private static Collection<FutureTask<MipMapImage>> preloads;
    private static int num_preloader_threads;
    public static final int GAUSSIAN = 3;
    public static final int AREA_DOWNSAMPLING = 6;
    public static final Map<Integer, String> MIPMAP_MODES;
    public static final int DEFAULT_MIPMAPS_MODE = 6;
    private final Map<Patch, String> preprocessors = Collections.synchronizedMap(new HashMap());
    private final ExecutorService exec = Utils.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), "loader-do-later");
    private final Dispatcher guiExec = new Dispatcher("GUI Executor");

    public static final IndexColorModel makeGrayLut() {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r[i] = (byte)i;
            g[i] = (byte)i;
            b[i] = (byte)i;
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    public static boolean isSignalImage(Image awt) {
        return REGENERATING == awt || NOT_FOUND == awt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setHeapFraction(float fraction) {
        Object object = HEAPLOCK;
        synchronized (object) {
            if (fraction < 0.0f || fraction > 1.0f) {
                Utils.log("Invalid heap fraction: " + fraction);
                return;
            }
            if (fraction > 0.4f) {
                Utils.log("WARNING setting a heap fraction larger than recommended 0.4: " + fraction);
            }
            heap_fraction = fraction;
            for (Loader l : v_loaders) {
                l.setMaxBytes((long)((float)MAX_MEMORY * fraction));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setMaxBytes(long max_bytes) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.setMaxBytes(max_bytes);
                Utils.log2("Cache max bytes: " + this.mawts.getMaxBytes());
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    public static void debug() {
        Utils.log2("v_loaders: " + Utils.toString(v_loaders));
    }

    protected Loader() {
        v_loaders.add(this);
        if (!ControlWindow.isGUIEnabled()) {
            this.opener.setSilentMode(true);
        }
        Utils.log2("MAX_MEMORY: " + MAX_MEMORY);
        Utils.log2("cache size: " + this.mawts.getMaxBytes());
    }

    public synchronized void destroy() {
        if (null != IJ.getInstance() && IJ.getInstance().quitting()) {
            return;
        }
        Utils.showStatus("Releasing all memory ...", false);
        this.destroyCache();
        v_loaders.remove(this);
        this.exec.shutdownNow();
        this.guiExec.quit();
    }

    public abstract long getNextId();

    public long getNextTempId() {
        return this.nextTempId.getAndDecrement();
    }

    public TemplateThing askForXMLTemplate(Project project) {
        TemplateThing[] roots;
        OpenDialog od = new OpenDialog("Select XML Template", OpenDialog.getDefaultDirectory(), null);
        String filename = od.getFileName();
        if (null == filename || filename.toLowerCase().startsWith("null")) {
            return null;
        }
        String dir = od.getDirectory();
        if (null == dir) {
            return null;
        }
        if (IJ.isWindows()) {
            dir = dir.replace('\\', '/');
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        try {
            roots = DTDParser.extractTemplate(dir + filename);
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        if (null == roots || roots.length < 1) {
            return null;
        }
        if (roots.length > 1) {
            Utils.showMessage("Found more than one root.\nUsing first root only.");
        }
        return roots[0];
    }

    public void startLargeUpdate() {
        LayerSet ls = Project.findProject(this).getRootLayerSet();
        this.temp_snapshots_mode = ls.getSnapshotsMode();
        if (2 != this.temp_snapshots_mode) {
            ls.setSnapshotsMode(2);
        }
    }

    public void commitLargeUpdate() {
        Project.findProject(this).getRootLayerSet().setSnapshotsMode(this.temp_snapshots_mode);
    }

    public void rollback() {
        Project.findProject(this).getRootLayerSet().setSnapshotsMode(this.temp_snapshots_mode);
    }

    public abstract double[][][] fetchBezierArrays(long var1);

    public abstract ArrayList<?> fetchPipePoints(long var1);

    public abstract ArrayList<?> fetchBallPoints(long var1);

    public abstract Area fetchArea(long var1, long var3);

    public abstract boolean addToDatabase(DBObject var1);

    public abstract boolean updateInDatabase(DBObject var1, String var2);

    public abstract boolean updateInDatabase(DBObject var1, Set<String> var2);

    public abstract boolean removeFromDatabase(DBObject var1);

    public void addCrossLink(long project_id, long id1, long id2) {
    }

    public boolean removeCrossLink(long id1, long id2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Displayable d, ImagePlus imp) {
        Object object = this.db_lock;
        synchronized (object) {
            if (Patch.class == d.getClass()) {
                this.cache((Patch)d, imp);
                return;
            }
            Utils.log("Loader.cache: don't know how to cache: " + d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Patch p, ImagePlus imp) {
        if (null == imp || null == imp.getProcessor()) {
            return;
        }
        Object object = this.db_lock;
        synchronized (object) {
            try {
                long id = p.getId();
                ImagePlus cached = this.mawts.get(id);
                if (null == cached || cached != imp || 1 == imp.getStackSize() && imp.getProcessor().getPixels() != cached.getProcessor().getPixels()) {
                    this.mawts.put(id, imp, (int)Math.max(p.getWidth(), p.getHeight()));
                } else {
                    this.mawts.get(id);
                }
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheImagePlus(long id, ImagePlus imp) {
        if (null == imp || null == imp.getProcessor()) {
            return;
        }
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.put(id, imp, Math.max(imp.getWidth(), imp.getHeight()));
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decacheImagePlus(long id) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.removeImagePlus(id);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decacheImagePlus(long[] id) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                for (int i = 0; i < id.length; ++i) {
                    this.mawts.removeImagePlus(id[i]);
                }
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    protected ImagePlus unzipTiff(InputStream i_stream, String title) {
        ImagePlus imp;
        try {
            int len;
            ZipInputStream zis = new ZipInputStream(i_stream);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((len = zis.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            zis.close();
            byte[] bytes = out.toByteArray();
            IJ.redirectErrorMessages();
            imp = this.opener.openTiff((InputStream)new ByteArrayInputStream(bytes), title);
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        return imp;
    }

    public static final long getCurrentMemory() {
        return RUNTIME.totalMemory() - RUNTIME.freeMemory();
    }

    protected static final boolean enoughFreeMemory(long n_bytes) {
        return n_bytes < RUNTIME.freeMemory() + 128000000L;
    }

    public final boolean releaseToFit(int width, int height, int type, float factor) {
        long bytes = width * height;
        switch (type) {
            case 2: {
                bytes *= 5L;
                if (!(factor < 4.0f)) break;
                factor = 4.0f;
                break;
            }
            case 4: {
                bytes *= 4L;
                break;
            }
            case 1: {
                bytes *= 3L;
                break;
            }
        }
        return this.releaseToFit((long)((float)bytes * factor));
    }

    public final boolean releaseToFit(long n_bytes) {
        if (n_bytes > MAX_MEMORY) {
            Utils.log("WARNING: Can't fit " + n_bytes + " bytes in memory.");
            Loader.releaseAllCaches();
            return true;
        }
        return this.releaseMemory(n_bytes) >= n_bytes;
    }

    public static void printCacheStatus() {
        int i = 1;
        for (Loader lo : new ArrayList<Loader>(v_loaders)) {
            Utils.log2("Loader " + i++ + " : mawts: " + lo.mawts.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCache() {
        Object object = this.db_lock;
        synchronized (object) {
            this.mawts.debug();
        }
    }

    public static void printCaches() {
        int i = 1;
        for (Loader lo : new ArrayList<Loader>(v_loaders)) {
            Utils.log2("Loader " + i++ + ":");
            lo.mawts.debug();
        }
    }

    public static long computeDesirableMinFreeBytes() {
        long f = 150000000 * Runtime.getRuntime().availableProcessors();
        if (f > MAX_MEMORY / 2L) {
            Utils.logAll("WARNING you are operating with low memory\n  considering the number of CPU cores.\n  Please restart with a higher -Xmx value.");
            low_memory_conditions = true;
            return MAX_MEMORY / 2L;
        }
        return f;
    }

    public static void setDesirableMinFreeBytes(long n_bytes) {
        long f = Loader.computeDesirableMinFreeBytes();
        long max = IJ.maxMemory();
        if (n_bytes < f) {
            Utils.logAll("Refusing to use " + n_bytes + " as the desirable amount of free memory bytes,\n  considering the lower limit at " + f);
        } else if (n_bytes > max) {
            Utils.logAll("Refusing to use a number of minimally free memory bytes larger than max_memory " + max);
        } else {
            if (n_bytes > max / 2L) {
                Utils.logAll("WARNING you are setting a value of minimally free memory bytes larger than half the maximum memory.");
            }
            f = n_bytes;
        }
        MIN_FREE_BYTES = f;
        Utils.logAll("Using min free bytes " + MIN_FREE_BYTES + " (max memory: " + max + ")");
    }

    public static final long measureSize(ImagePlus imp) {
        if (null == imp) {
            return 0L;
        }
        long size = imp.getWidth() * imp.getHeight() * imp.getNSlices();
        switch (imp.getType()) {
            case 1: {
                return size * 2L + 100L;
            }
            case 2: 
            case 4: {
                return size * 4L + 100L;
            }
            case 0: {
                return size + 100L;
            }
            case 3: {
                return size + 868L;
            }
        }
        return 0L;
    }

    static final long measureSize(Image img) {
        if (null == img) {
            return 0L;
        }
        return img.getWidth(null) * img.getHeight(null) * 4 + 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long releaseMemory(long min_free_bytes) {
        Object object = CROSSLOCK;
        synchronized (object) {
            Object object2 = this.db_lock;
            synchronized (object2) {
                try {
                    return this.releaseMemory2(min_free_bytes);
                }
                catch (Throwable e) {
                    IJError.print(e);
                    return 0L;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long releaseAndFlushOthers(long min_free_bytes) {
        if (1 == v_loaders.size()) {
            return 0L;
        }
        long released = 0L;
        for (Loader lo : new ArrayList<Loader>(v_loaders)) {
            if (lo == this) continue;
            Object object = lo.db_lock;
            synchronized (object) {
                try {
                    if ((released += lo.mawts.removeAndFlushSome(min_free_bytes)) >= min_free_bytes) {
                        return released;
                    }
                }
                catch (Throwable t) {
                    lo.handleCacheError(t);
                }
            }
        }
        return released;
    }

    @Deprecated
    protected final long releaseMemory2() {
        return this.releaseMemory2(MIN_FREE_BYTES);
    }

    private final long releaseMemory2(long min_free_bytes) {
        long released = 0L;
        try {
            if ((released += this.releaseAndFlushOthers(min_free_bytes)) >= min_free_bytes) {
                return released;
            }
            if (0 != this.mawts.size()) {
                try {
                    released += this.mawts.ensureFree(min_free_bytes);
                }
                catch (Throwable t) {
                    this.handleCacheError(t);
                }
                if (released >= min_free_bytes) {
                    return released;
                }
            }
            if (0 == this.mawts.size()) {
                CachingThread.releaseAll();
                Polyline.flushTraceCache(Project.findProject(this));
                Thread.yield();
                if (!Loader.enoughFreeMemory(min_free_bytes)) {
                    Utils.log("TrakEM: empty cache -- please free up some memory");
                    if (WindowManager.getWindowCount() != Display.getDisplayCount()) {
                        Utils.log("For example, close other open images.");
                    }
                }
            }
            if (!Loader.enoughFreeMemory(min_free_bytes) && WindowManager.getWindowCount() != Display.getDisplayCount() && (released += this.releaseAndFlushOthers(min_free_bytes)) < min_free_bytes) {
                released += this.mawts.removeAndFlushSome(min_free_bytes);
            }
        }
        catch (Throwable e) {
            this.handleCacheError(e);
        }
        return released;
    }

    public static void releaseAllCaches() {
        for (Loader lo : new ArrayList<Loader>(v_loaders)) {
            lo.releaseAll();
        }
        CachingThread.releaseAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.removeAndFlushAll();
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyCache() {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                ImageJ ij = IJ.getInstance();
                if (null != ij && ij.quitting()) {
                    return;
                }
                if (null != this.mawts) {
                    this.mawts.removeAndFlushAll();
                }
            }
            catch (Throwable t) {
                IJError.print(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decacheAWT(long id) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.removeAndFlushPyramid(id);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getCachedAWT(long id, int level) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                return this.mawts.get(id, level);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheAWT(long id, Image awt) {
        if (null == awt) {
            return;
        }
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.put(id, awt, 0);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    public static final int getMipMapLevel(double mag, double size) {
        if (mag > 1.0) {
            return 0;
        }
        if (mag <= 0.0 || Double.isNaN(mag)) {
            Utils.log2("ERROR: mag is " + mag);
            return 0;
        }
        int level = (int)(1.0E-4 + Math.log(1.0 / mag) / Math.log(2.0));
        int max_level = Loader.getHighestMipMapLevel(size);
        return Math.min(level, max_level);
    }

    public static final double maxDim(Displayable d) {
        return Math.max(d.getWidth(), d.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImagePlusCached(Patch p) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                return null != this.mawts.get(p.getId());
            }
            catch (Throwable t) {
                this.handleCacheError(t);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(Patch p, double mag) {
        int level = Loader.getMipMapLevel(mag, Loader.maxDim(p));
        Object object = this.db_lock;
        synchronized (object) {
            try {
                return this.mawts.contains(p.getId(), level);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MipMapImage getCached(long id, int level) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                return this.mawts.getClosestAbove(id, level);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCached(long id, int level) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.remove(id, level);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCached(long id) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.remove(id);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MipMapImage getCachedClosestAboveImage(Patch p, double mag) {
        int level = Loader.getMipMapLevel(mag, Loader.maxDim(p));
        Object object = this.db_lock;
        synchronized (object) {
            try {
                return this.mawts.getClosestAbove(p.getId(), level);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MipMapImage getCachedClosestBelowImage(Patch p, double mag) {
        int level = Loader.getMipMapLevel(mag, Loader.maxDim(p));
        Object object = this.db_lock;
        synchronized (object) {
            try {
                return this.mawts.getClosestBelow(p.getId(), level);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
        return null;
    }

    protected final ImageLoadingLock getOrMakeImageLoadingLock(long id, int level) {
        return this.getOrMakeImageLoadingLock("" + id + '.' + level);
    }

    protected final ImageLoadingLock getOrMakeImageLoadingLock(String key) {
        ImageLoadingLock plock = this.ht_plocks.get(key);
        if (null != plock) {
            return plock;
        }
        plock = new ImageLoadingLock(key);
        this.ht_plocks.put(key, plock);
        return plock;
    }

    protected final void removeImageLoadingLock(ImageLoadingLock pl) {
        this.ht_plocks.remove(pl.key);
    }

    public MipMapImage fetchDataImage(Patch p, double mag) {
        return this.fetchImage(p, mag);
    }

    public MipMapImage fetchImage(Patch p) {
        return this.fetchImage(p, 1.0);
    }

    public MipMapImage fetchImage(Patch p, double mag) {
        if (mag > 1.0) {
            mag = 1.0;
        }
        int max_level = Loader.getHighestMipMapLevel(p);
        int level = Math.max(Math.min(max_level, Loader.getMipMapLevel(mag, Loader.maxDim(p))), Math.max(0, p.getProject().getFirstMipMapLevelSaved()));
        return this.fetchAWTImage(p, level, max_level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final MipMapImage fetchAWTImage(Patch p, int level, int max_level) {
        Object scale3;
        Image mawt;
        long id = p.getId();
        ImageLoadingLock plock = null;
        Object object = this.db_lock;
        // MONITORENTER : object
        try {
            if (null == this.mawts) {
                // MONITOREXIT : object
                return new MipMapImage(NOT_FOUND, p.getWidth() / (float)NOT_FOUND.getWidth(), p.getHeight() / (float)NOT_FOUND.getHeight());
            }
            if (level >= 0 && this.isMipMapsRegenerationEnabled()) {
                mawt = this.mawts.get(id, level);
                if (null != mawt) {
                    double scale2 = Math.pow(2.0, level);
                    // MONITOREXIT : object
                    return new MipMapImage(mawt, scale2, scale2);
                }
                plock = this.getOrMakeImageLoadingLock(p.getId(), level);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        MipMapImage mipMap = null;
        if (level >= 0 && this.isMipMapsRegenerationEnabled()) {
            block63: {
                ImageLoadingLock e = plock;
                // MONITORENTER : e
                Object object2 = this.db_lock;
                // MONITORENTER : object2
                Image mawt2 = this.mawts.get(id, level);
                // MONITOREXIT : object2
                if (null != mawt2) {
                    double scale3 = Math.pow(2.0, level);
                    // MONITOREXIT : e
                    return new MipMapImage(mawt2, scale3, scale3);
                }
                // MONITOREXIT : e
                long n_bytes = this.estimateImageFileSize(p, level);
                this.releaseToFit(n_bytes * 8L);
                scale3 = plock;
                // MONITORENTER : scale3
                try {
                    mipMap = this.fetchMipMapAWT(p, level, n_bytes);
                }
                catch (Throwable t) {
                    IJError.print(t);
                    mipMap = null;
                }
                Object object3 = this.db_lock;
                // MONITORENTER : object3
                try {
                    if (null != mipMap) {
                        if (REGENERATING != mipMap.image) {
                            this.mawts.put(id, mipMap.image, level);
                            Display.repaintSnapshot(p);
                        }
                        MipMapImage mipMapImage = mipMap;
                        return mipMapImage;
                    }
                    mipMap = this.mawts.getClosestAbove(id, level);
                    if (mipMap == null) {
                        int lev = this.getClosestMipMapLevel(p, level, max_level);
                        if (lev > -1) {
                            mipMap = this.fetchMipMapAWT(p, lev, n_bytes);
                            if (null != mipMap) {
                                this.mawts.put(id, mipMap.image, lev);
                                Display.repaintSnapshot(p);
                                MipMapImage mipMapImage = mipMap;
                                return mipMapImage;
                            }
                            break block63;
                        }
                        if (Integer.MAX_VALUE == lev) {
                            mipMap = new MipMapImage(NOT_FOUND, p.getWidth() / (float)NOT_FOUND.getWidth(), p.getHeight() / (float)NOT_FOUND.getHeight());
                        }
                        break block63;
                    }
                    MipMapImage lev = mipMap;
                    return lev;
                }
                catch (Throwable t) {
                    this.handleCacheError(t);
                }
                finally {
                    this.removeImageLoadingLock(plock);
                }
            }
            // MONITOREXIT : object3
            // MONITOREXIT : scale3
        }
        Object n_bytes = this.db_lock;
        // MONITORENTER : n_bytes
        try {
            mipMap = this.mawts.getClosestAbove(id, level);
            if (null != mipMap) {
                // MONITOREXIT : n_bytes
                return mipMap;
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        if (this.hs_unloadable.contains(p)) {
            return new MipMapImage(NOT_FOUND, p.getWidth() / (float)NOT_FOUND.getWidth(), p.getHeight() / (float)NOT_FOUND.getHeight());
        }
        n_bytes = this.db_lock;
        // MONITORENTER : n_bytes
        try {
            plock = this.getOrMakeImageLoadingLock(p.getId(), level);
        }
        catch (Exception e) {
            if (null != plock) {
                this.removeImageLoadingLock(plock);
            }
            // MONITOREXIT : n_bytes
            return new MipMapImage(NOT_FOUND, p.getWidth() / (float)NOT_FOUND.getWidth(), p.getHeight() / (float)NOT_FOUND.getHeight());
        }
        n_bytes = plock;
        // MONITORENTER : n_bytes
        mipMap = this.mawts.getClosestAbove(id, level);
        if (null != mipMap) {
            Object e = this.db_lock;
            // MONITORENTER : e
            this.removeImageLoadingLock(plock);
            // MONITOREXIT : e
            // MONITOREXIT : n_bytes
            return mipMap;
        }
        // MONITOREXIT : n_bytes
        mawt = null;
        try {
            Patch.PatchImage pai = p.createTransformedImage();
            scale3 = plock;
            // MONITORENTER : scale3
            if (null != pai && null != pai.target) {
                mawt = pai.createImage(p.getMin(), p.getMax());
            }
            // MONITOREXIT : scale3
        }
        catch (Exception e) {
            Utils.log2("Could not create an image for Patch " + p);
            mawt = null;
        }
        Object object4 = this.db_lock;
        // MONITORENTER : object4
        try {
            if (null == mawt) return new MipMapImage(NOT_FOUND, p.getWidth() / (float)NOT_FOUND.getWidth(), p.getHeight() / (float)NOT_FOUND.getHeight());
            this.mawts.put(id, mawt, 0);
            Display.repaintSnapshot(p);
            scale3 = new MipMapImage(mawt, 1.0, 1.0);
            return scale3;
        }
        catch (Throwable t) {
            this.handleCacheError(t);
            return new MipMapImage(NOT_FOUND, p.getWidth() / (float)NOT_FOUND.getWidth(), p.getHeight() / (float)NOT_FOUND.getHeight());
        }
        finally {
            this.removeImageLoadingLock(plock);
        }
    }

    @Deprecated
    public ByteProcessor fetchImageMask(Patch p) {
        return p.getAlphaMask();
    }

    @Deprecated
    public void storeAlphaMask(Patch p, ByteProcessor fp) {
        p.setAlphaMask(fp);
    }

    @Deprecated
    public boolean removeAlphaMask(Patch p) {
        return p.setAlphaMask(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePlus getCachedImagePlus(long id) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                return this.mawts.get(id);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
        return null;
    }

    public abstract ImagePlus fetchImagePlus(Patch var1);

    public ImageProcessor fetchImageProcessor(Patch p) {
        return null;
    }

    public ImagePlus fetchImagePlus(Stack p) {
        return null;
    }

    public abstract Object[] fetchLabel(DLabel var1);

    protected InputStream createZippedStream(ImagePlus imp) throws Exception {
        FileInfo fi = imp.getFileInfo();
        Object info = imp.getProperty("Info");
        if (info != null && info instanceof String) {
            fi.info = (String)info;
        }
        if (null == fi.description) {
            fi.description = new FileSaver(imp).getDescriptionString();
        }
        TiffEncoder te = new TiffEncoder(fi);
        ByteArrayInputStream i_stream = null;
        ByteArrayOutputStream o_bytes = new ByteArrayOutputStream();
        DataOutputStream o_stream = null;
        try {
            o_bytes = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(o_bytes);
            o_stream = new DataOutputStream(new BufferedOutputStream(zos));
            zos.putNextEntry(new ZipEntry(imp.getTitle()));
            te.write(o_stream);
            o_stream.flush();
            o_stream.close();
            byte[] bytes = o_bytes.toByteArray();
            i_stream = new ByteArrayInputStream(bytes);
        }
        catch (Exception e) {
            Utils.log("Loader: ImagePlus NOT zipped! Problems at writing the ImagePlus using the TiffEncoder.write(dos) :\n " + e);
            try {
                if (null != o_stream) {
                    o_stream.close();
                }
                if (null != i_stream) {
                    i_stream.close();
                }
            }
            catch (IOException ioe) {
                Utils.log("Loader: Attempt to clean up streams failed.");
                IJError.print(ioe);
            }
            return null;
        }
        return i_stream;
    }

    public synchronized ImagePlus openStack() {
        File f;
        OpenDialog od = new OpenDialog("Select stack", OpenDialog.getDefaultDirectory(), null);
        String file_name = od.getFileName();
        if (null == file_name || file_name.toLowerCase().startsWith("null")) {
            return null;
        }
        String dir = od.getDirectory().replace('\\', '/');
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        if (!(f = new File(dir + file_name)).exists()) {
            Utils.showMessage("File " + dir + file_name + " does not exist.");
            return null;
        }
        if (file_name.toLowerCase().endsWith(".xml")) {
            Utils.showMessage("Cannot import " + file_name + " as a stack.");
            return null;
        }
        long size = f.length() / 1024L;
        if (file_name.length() - 4 == file_name.toLowerCase().lastIndexOf(".zip")) {
            size = (long)((double)size * 2.5);
        }
        this.releaseToFit(size);
        ImagePlus imp_stack = null;
        try {
            IJ.redirectErrorMessages();
            imp_stack = this.openImagePlus(f.getCanonicalPath());
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        if (null == imp_stack) {
            Utils.showMessage("Can't open the stack.");
            return null;
        }
        if (1 == imp_stack.getStackSize()) {
            Utils.showMessage("Not a stack!");
            return null;
        }
        return imp_stack;
    }

    public Bureaucrat importSequenceAsGrid(Layer layer) {
        return this.importSequenceAsGrid(layer, null);
    }

    public Bureaucrat importSequenceAsGrid(Layer layer, String dir) {
        return this.importSequenceAsGrid(layer, dir, null);
    }

    public Bureaucrat importSequenceAsGrid(Layer first_layer, String dir, String[] image_file_names) {
        int last;
        Object[] all_images = null;
        Object file = null;
        File images_dir = null;
        if (null != dir && null != image_file_names) {
            all_images = image_file_names;
            images_dir = new File(dir);
        } else if (null == dir) {
            String[] dn = Utils.selectFile("Select first image");
            if (null == dn) {
                return null;
            }
            dir = dn[0];
            file = dn[1];
            images_dir = new File(dir);
        } else {
            images_dir = new File(dir);
            if (!images_dir.exists() || !images_dir.isDirectory()) {
                Utils.showMessage("Something went wrong:\n\tCan't find directory " + dir);
                return null;
            }
        }
        if (null == image_file_names) {
            all_images = images_dir.list(new ImageFileFilter("", null));
        }
        if (null == file && all_images.length > 0) {
            file = all_images[0];
        }
        int n_max = all_images.length;
        int side = (int)Math.floor(Math.sqrt(n_max));
        GenericDialog gd = new GenericDialog("Conventions");
        gd.addStringField("file_name_matches: ", "");
        gd.addNumericField("first_image: ", 1.0, 0);
        gd.addNumericField("last_image: ", (double)n_max, 0);
        gd.addCheckbox("Reverse list order", false);
        gd.addNumericField("number_of_rows: ", (double)side, 0);
        gd.addNumericField("number_of_columns: ", (double)side, 0);
        gd.addNumericField("number_of_slices: ", 1.0, 0);
        gd.addMessage("The top left coordinate for the imported grid:");
        gd.addNumericField("base_x: ", 0.0, 3);
        gd.addNumericField("base_y: ", 0.0, 3);
        gd.addMessage("Amount of image overlap, in pixels");
        gd.addNumericField("bottom-top overlap: ", 0.0, 2);
        gd.addNumericField("left-right overlap: ", 0.0, 2);
        gd.addCheckbox("link images", false);
        gd.addCheckbox("montage with phase correlation", true);
        gd.addCheckbox("homogenize_contrast", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        String regex = gd.getNextString();
        Utils.log2("using regex: " + regex);
        int first = (int)gd.getNextNumber();
        if (first < 1) {
            first = 1;
        }
        if ((last = (int)gd.getNextNumber()) < 1) {
            last = 1;
        }
        if (last < first) {
            Utils.showMessage("Last is smaller that first!");
            return null;
        }
        boolean reverse_order = gd.getNextBoolean();
        final int n_rows = (int)gd.getNextNumber();
        final int n_cols = (int)gd.getNextNumber();
        final int n_slices = (int)gd.getNextNumber();
        double bx = gd.getNextNumber();
        double by = gd.getNextNumber();
        double bt_overlap = gd.getNextNumber();
        double lr_overlap = gd.getNextNumber();
        boolean link_images = gd.getNextBoolean();
        boolean stitch_tiles = gd.getNextBoolean();
        boolean homogenize_contrast = gd.getNextBoolean();
        Object[] file_names = null;
        if (null == image_file_names) {
            file_names = images_dir.list(new ImageFileFilter(regex, null));
            Arrays.sort(file_names);
            if (reverse_order) {
                for (int i = file_names.length / 2; i > -1; --i) {
                    Object tmp = file_names[i];
                    int j = file_names.length - 1 - i;
                    file_names[i] = file_names[j];
                    file_names[j] = tmp;
                }
            }
        } else {
            file_names = all_images;
        }
        if (0 == file_names.length) {
            Utils.showMessage("No images found.");
            return null;
        }
        boolean found_first = false;
        for (int i = 0; i < file_names.length; ++i) {
            if (!((String)file).equals(file_names[i])) continue;
            found_first = true;
            break;
        }
        if (!found_first) {
            file = file_names[0];
            Utils.log("Using " + (String)file + " as the reference image for size.");
        }
        if (last > file_names.length) {
            last = file_names.length - 1;
        }
        if (first < 1) {
            first = 1;
        }
        if (1 != first || last != file_names.length) {
            Utils.log("Cropping list.");
            String[] file_names2 = new String[last - first + 1];
            System.arraycopy(file_names, first - 1, file_names2, 0, file_names2.length);
            file_names = file_names2;
        }
        if (file_names.length != n_rows * n_cols * n_slices) {
            Utils.log("ERROR: rows * cols * slices does not match with the number of selected images.");
            Utils.log("n_images:" + file_names.length + "  rows,cols,slices : " + n_rows + "," + n_cols + "," + n_slices + "  total=" + n_rows * n_cols * n_slices);
            return null;
        }
        Object[] file_names_ = file_names;
        String dir_ = dir;
        Object file_ = file;
        double bt_overlap_ = bt_overlap;
        double lr_overlap_ = lr_overlap;
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Importing", true, (String[])file_names_, first_layer, stitch_tiles, dir_, (String)file_, bx, by, bt_overlap_, lr_overlap_, link_images, homogenize_contrast){
            final /* synthetic */ String[] val$file_names_;
            final /* synthetic */ Layer val$first_layer;
            final /* synthetic */ boolean val$stitch_tiles;
            final /* synthetic */ String val$dir_;
            final /* synthetic */ String val$file_;
            final /* synthetic */ double val$bx;
            final /* synthetic */ double val$by;
            final /* synthetic */ double val$bt_overlap_;
            final /* synthetic */ double val$lr_overlap_;
            final /* synthetic */ boolean val$link_images;
            final /* synthetic */ boolean val$homogenize_contrast;
            {
                this.val$file_names_ = stringArray;
                this.val$first_layer = layer;
                this.val$stitch_tiles = bl;
                this.val$dir_ = string;
                this.val$file_ = string2;
                this.val$bx = d;
                this.val$by = d2;
                this.val$bt_overlap_ = d3;
                this.val$lr_overlap_ = d4;
                this.val$link_images = bl2;
                this.val$homogenize_contrast = bl3;
                super(title, interrupt_on_quit);
            }

            @Override
            public void exec() {
                StitchingTEM.PhaseCorrelationParam pc_param = null;
                for (int sl = 0; sl < n_slices; ++sl) {
                    Layer layer;
                    if (Thread.currentThread().isInterrupted() || this.hasQuitted()) {
                        return;
                    }
                    Utils.log("Importing " + (sl + 1) + "/" + n_slices);
                    int start = sl * n_rows * n_cols;
                    ArrayList<String[]> cols = new ArrayList<String[]>();
                    for (int i = 0; i < n_cols; ++i) {
                        String[] col = new String[n_rows];
                        for (int j = 0; j < n_rows; ++j) {
                            col[j] = this.val$file_names_[start + j * n_cols + i];
                        }
                        cols.add(col);
                    }
                    Layer layer2 = layer = 0 == sl ? this.val$first_layer : this.val$first_layer.getParent().getLayer(this.val$first_layer.getZ() + this.val$first_layer.getThickness() * (double)sl, this.val$first_layer.getThickness(), true);
                    if (this.val$stitch_tiles && null == pc_param) {
                        pc_param = new StitchingTEM.PhaseCorrelationParam();
                        pc_param.setup(layer);
                    }
                    Loader.this.insertGrid(layer, this.val$dir_, this.val$file_, n_rows * n_cols, cols, this.val$bx, this.val$by, this.val$bt_overlap_, this.val$lr_overlap_, this.val$link_images, this.val$stitch_tiles, this.val$homogenize_contrast, pc_param, this);
                }
            }
        }, first_layer.getProject());
    }

    public Bureaucrat importGrid(Layer layer) {
        return this.importGrid(layer, null);
    }

    public Bureaucrat importGrid(final Layer layer, String dir) {
        try {
            String file = null;
            if (null == dir) {
                String[] dn = Utils.selectFile("Select first image");
                if (null == dn) {
                    return null;
                }
                dir = dn[0];
                file = dn[1];
            }
            String convention = "cdd";
            boolean chars_are_columns = true;
            GenericDialog gd = new GenericDialog("Conventions");
            gd.addStringField("file_name_contains:", "");
            gd.addNumericField("base_x: ", 0.0, 3);
            gd.addNumericField("base_y: ", 0.0, 3);
            gd.addMessage("Use: x(any), c(haracter), d(igit)");
            gd.addStringField("convention: ", convention);
            String[] cr = new String[]{"columns", "rows"};
            gd.addChoice("characters are: ", cr, cr[0]);
            gd.addMessage("[File extension ignored]");
            gd.addNumericField("bottom-top overlap: ", 0.0, 3);
            gd.addNumericField("left-right overlap: ", 0.0, 3);
            gd.addCheckbox("link_images", false);
            gd.addCheckbox("montage with phase correlation", false);
            gd.addCheckbox("homogenize_contrast", true);
            Component[] c = new Component[]{(Component)gd.getSliders().get(gd.getSliders().size() - 2), (Component)gd.getNumericFields().get(gd.getNumericFields().size() - 2), (Component)gd.getSliders().get(gd.getSliders().size() - 1), (Component)gd.getNumericFields().get(gd.getNumericFields().size() - 1), (Component)gd.getChoices().get(gd.getChoices().size() - 1)};
            Utils.addEnablerListener((Checkbox)gd.getCheckboxes().get(gd.getCheckboxes().size() - 1), c, null);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            String regex = gd.getNextString();
            final double bx = gd.getNextNumber();
            final double by = gd.getNextNumber();
            convention = gd.getNextString().toLowerCase();
            if (null == convention || convention.equals("") || -1 == convention.indexOf(99) || -1 == convention.indexOf(100)) {
                Utils.showMessage("Convention '" + convention + "' needs both c(haracters) and d(igits), optionally 'x', and nothing else!");
                return null;
            }
            chars_are_columns = 0 == gd.getNextChoiceIndex();
            double bt_overlap = gd.getNextNumber();
            double lr_overlap = gd.getNextNumber();
            final boolean link_images = gd.getNextBoolean();
            final boolean stitch_tiles = gd.getNextBoolean();
            final boolean homogenize_contrast = gd.getNextBoolean();
            File images_dir = new File(dir);
            if (!images_dir.exists() || !images_dir.isDirectory()) {
                Utils.showMessage("Something went wrong:\n\tCan't find directory " + dir);
                return null;
            }
            final String[] file_names = images_dir.list(new ImageFileFilter(regex, convention));
            if (null == file && file_names.length > 0) {
                file = file_names[0];
            }
            Utils.showStatus("Adding " + file_names.length + " patches.", false);
            if (0 == file_names.length) {
                Utils.log("Zero files match the convention '" + convention + "'");
                return null;
            }
            Montage montage = new Montage(convention, chars_are_columns);
            montage.addAll(file_names);
            final ArrayList<String[]> cols = montage.getCols();
            final String dir_ = dir;
            final double bt_overlap_ = bt_overlap;
            final double lr_overlap_ = lr_overlap;
            final String file_ = file;
            return Bureaucrat.createAndStart((Worker)new Worker.Task("Insert grid", true){

                @Override
                public void exec() {
                    StitchingTEM.PhaseCorrelationParam pc_param = null;
                    if (stitch_tiles) {
                        pc_param = new StitchingTEM.PhaseCorrelationParam();
                        pc_param.setup(layer);
                    }
                    Loader.this.insertGrid(layer, dir_, file_, file_names.length, cols, bx, by, bt_overlap_, lr_overlap_, link_images, stitch_tiles, homogenize_contrast, pc_param, this);
                }
            }, layer.getProject());
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    private void insertGrid(Layer layer, String dir_, String first_image_name, int n_images, ArrayList<String[]> cols, double bx, double by, double bt_overlap, double lr_overlap, boolean link_images, boolean stitch_tiles, boolean homogenize_contrast, StitchingTEM.PhaseCorrelationParam pc_param, Worker worker) {
        try {
            int j;
            String dir = dir_;
            ArrayList<Patch> al = new ArrayList<Patch>();
            Utils.showProgress(0.0);
            this.opener.setSilentMode(true);
            int x = 0;
            int y = 0;
            int largest_y = 0;
            ImagePlus img = null;
            dir = dir.replace('\\', '/');
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            String path = dir + first_image_name;
            this.releaseToFit(new File(path).length() * 3L);
            IJ.redirectErrorMessages();
            ImagePlus first_img = this.openImagePlus(path);
            if (null == first_img) {
                Utils.log("Selected image to open first is null.");
                return;
            }
            if (null == first_img) {
                return;
            }
            int first_image_width = first_img.getWidth();
            int first_image_height = first_img.getHeight();
            int first_image_type = first_img.getType();
            Patch[][] pall = new Patch[cols.size()][cols.get(0).length];
            int k = 0;
            boolean auto_fix_all = false;
            boolean ignore_all = false;
            boolean resize = false;
            if (!ControlWindow.isGUIEnabled()) {
                auto_fix_all = true;
                resize = true;
            }
            ArrayList fus = new ArrayList();
            this.startLargeUpdate();
            for (int i = 0; i < cols.size(); ++i) {
                String[] rows = cols.get(i);
                if (i > 0) {
                    x = (int)((double)x - lr_overlap);
                }
                for (j = 0; j < rows.length; ++j) {
                    if (Thread.currentThread().isInterrupted()) {
                        Display.repaint(layer);
                        this.rollback();
                        return;
                    }
                    if (j > 0) {
                        y = (int)((double)y - bt_overlap);
                    }
                    String file_name = rows[j];
                    path = dir + file_name;
                    if (null != first_img && file_name.equals(first_image_name)) {
                        img = first_img;
                        first_img = null;
                    } else {
                        this.releaseToFit(first_image_width, first_image_height, first_image_type, 1.5f);
                        try {
                            IJ.redirectErrorMessages();
                            img = this.openImagePlus(path);
                        }
                        catch (OutOfMemoryError oome) {
                            Loader.printMemState();
                            throw oome;
                        }
                    }
                    if (null == img) {
                        Utils.log("null image! skipping.");
                        pall[i][j] = null;
                        continue;
                    }
                    int width = img.getWidth();
                    int height = img.getHeight();
                    int rw = width;
                    int rh = height;
                    if (width != first_image_width || height != first_image_height) {
                        int new_width = first_image_width;
                        int new_height = first_image_height;
                        if (!auto_fix_all && !ignore_all) {
                            GenericDialog gdr = new GenericDialog("Size mismatch!");
                            gdr.addMessage("The size of " + file_name + " is " + width + " x " + height);
                            gdr.addMessage("but the selected image was " + first_image_width + " x " + first_image_height);
                            gdr.addMessage("Adjust to selected image dimensions?");
                            gdr.addNumericField("width: ", (double)first_image_width, 0);
                            gdr.addNumericField("height: ", (double)first_image_height, 0);
                            gdr.addMessage("[If dimensions are changed they will apply only to this image]");
                            gdr.addMessage("");
                            String[] au = new String[]{"fix all", "ignore all"};
                            gdr.addChoice("Automate:", au, au[1]);
                            gdr.addMessage("Cancel == NO    OK = YES");
                            gdr.showDialog();
                            if (gdr.wasCanceled()) {
                                resize = false;
                            }
                            resize = true;
                            new_width = (int)gdr.getNextNumber();
                            new_height = (int)gdr.getNextNumber();
                            int iau = gdr.getNextChoiceIndex();
                            auto_fix_all = new_width != first_image_width || new_height != first_image_height ? false : 0 == iau;
                            boolean bl = ignore_all = 1 == iau;
                            if (ignore_all) {
                                resize = false;
                            }
                        }
                        if (resize) {
                            rw = first_image_width;
                            rh = first_image_height;
                        }
                    }
                    Patch patch = new Patch(layer.getProject(), img.getTitle(), bx + (double)x, by + (double)y, img);
                    if (width != rw || height != rh) {
                        patch.setDimensions(rw, rh, false);
                    }
                    this.addedPatchFrom(path, patch);
                    if (homogenize_contrast) {
                        this.setMipMapsRegeneration(false);
                    } else {
                        fus.add(this.regenerateMipMaps(patch));
                    }
                    layer.add(patch, true);
                    patch.updateInDatabase("tiff_snapshot");
                    pall[i][j] = patch;
                    al.add(patch);
                    if (ControlWindow.isGUIEnabled()) {
                        layer.getParent().enlargeToFit(patch, 7);
                    }
                    y += img.getHeight();
                    Utils.showProgress((double)k / (double)n_images);
                    ++k;
                }
                x += img.getWidth();
                if (largest_y < y) {
                    largest_y = y;
                }
                y = 0;
            }
            Patch[] pa = new Patch[al.size()];
            int f = 0;
            for (j = 0; j < pall[0].length; ++j) {
                for (int i = 0; i < pall.length; ++i) {
                    pa[f++] = pall[i][j];
                }
            }
            Display.clearSelection(layer);
            for (j = 0; j < pa.length; ++j) {
                layer.moveBottom(pa[j]);
            }
            Display.clearSelection(layer);
            if (homogenize_contrast) {
                if (null != worker) {
                    worker.setTaskName("Enhancing contrast");
                }
                int tmp_type = pa[0].getType();
                for (int e = 1; e < pa.length; ++e) {
                    if (pa[e].getType() == tmp_type) continue;
                    tmp_type = Integer.MAX_VALUE;
                    Utils.log("Can't homogenize histograms: images are not all of the same type.\nFirst offending image is: " + al.get(e));
                    break;
                }
                if (Integer.MAX_VALUE != tmp_type) {
                    int count;
                    ArrayList<ImageStatistics> al_st = new ArrayList<ImageStatistics>();
                    ArrayList<Patch> al_p = new ArrayList<Patch>();
                    int type = -1;
                    for (int i = 0; i < pa.length; ++i) {
                        if (Thread.currentThread().isInterrupted()) {
                            Display.repaint(layer);
                            this.rollback();
                            return;
                        }
                        ImagePlus imp = this.fetchImagePlus(pa[i]);
                        if (imp.getWidth() > 1024) {
                            this.releaseToFit(1024, imp.getHeight() * 1024 / imp.getWidth(), imp.getType(), 1.1f);
                            imp = new ImagePlus(imp.getTitle(), imp.getProcessor().resize(1024));
                        }
                        if (-1 == type) {
                            type = imp.getType();
                        }
                        ImageStatistics i_st = imp.getStatistics();
                        int q = 0;
                        for (ImageStatistics st : al_st) {
                            ++q;
                            if (!(st.stdDev > i_st.stdDev)) continue;
                            break;
                        }
                        if (q == al.size()) {
                            al_st.add(i_st);
                            al_p.add(pa[i]);
                            continue;
                        }
                        al_st.add(q, i_st);
                        al_p.add(q, pa[i]);
                    }
                    ArrayList al_p2 = new ArrayList(al_p);
                    if (pa.length > 3) {
                        int i = 0;
                        while ((double)i <= (double)pa.length * 0.25) {
                            al_p.remove(i);
                            ++i;
                        }
                        int count2 = i;
                        i = pa.length - 1 - count2;
                        while ((double)i > (double)pa.length * 0.75 - (double)count2) {
                            al_p.remove(i);
                            --i;
                        }
                    }
                    Patch[] p50 = new Patch[al_p.size()];
                    al_p.toArray(p50);
                    StackStatistics stats = new StackStatistics((ImagePlus)new PatchStack(p50, 1));
                    int autoThreshold = 0;
                    double min = 0.0;
                    double max = 0.0;
                    int limit = stats.pixelCount / 10;
                    int[] histogram = stats.histogram;
                    autoThreshold = 1 == type || 2 == type ? 2500 : 5000;
                    int threshold = stats.pixelCount / autoThreshold;
                    int i = -1;
                    boolean found = false;
                    do {
                        if ((count = histogram[++i]) > limit) {
                            count = 0;
                        }
                        boolean bl = found = count > threshold;
                    } while (!found && i < 255);
                    int hmin = i;
                    i = 256;
                    do {
                        if ((count = histogram[--i]) > limit) {
                            count = 0;
                        }
                        boolean bl = found = count > threshold;
                    } while (!found && i > 0);
                    int hmax = i;
                    if (hmax >= hmin && (min = stats.histMin + (double)hmin * stats.binSize) == (max = stats.histMin + (double)hmax * stats.binSize)) {
                        min = stats.min;
                        max = stats.max;
                    }
                    double target_mean = this.getMeanOfRange((ImageStatistics)stats, min, max);
                    Utils.log2("Loader min,max: " + min + ", " + max + ",   target mean: " + target_mean);
                    for (i = al_p2.size() - 1; i > -1; --i) {
                        Patch p = (Patch)al_p2.get(i);
                        double dm = target_mean - this.getMeanOfRange((ImageStatistics)al_st.get(i), min, max);
                        p.setMinAndMax(min - dm, max - dm);
                    }
                    this.setMipMapsRegeneration(true);
                    if (this.isMipMapsRegenerationEnabled()) {
                        for (Patch p : al) {
                            fus.add(this.regenerateMipMaps(p));
                        }
                    }
                    Display.repaint(layer, new Rectangle(0, 0, (int)layer.getParent().getLayerWidth(), (int)layer.getParent().getLayerHeight()), 0);
                }
            }
            if (stitch_tiles) {
                Utils.wait(fus);
                layer.getParent().addTransformStep(new HashSet<Displayable>(layer.getDisplayables(Patch.class)));
                if (null != Display.getFront()) {
                    Display.getFront().getCanvas().waitForRepaint();
                }
                if (null != worker) {
                    worker.setTaskName("Stitching");
                }
                StitchingTEM.stitch(pa, cols.size(), bt_overlap, lr_overlap, true, pc_param).run();
            }
            if (link_images) {
                if (null != worker) {
                    worker.setTaskName("Linking");
                }
                for (int i = 0; i < pall.length; ++i) {
                    for (int j2 = 0; j2 < pall[0].length; ++j2) {
                        Patch p = pall[i][j2];
                        if (null == p) continue;
                        if (i > 0 && null != pall[i - 1][j2]) {
                            p.link(pall[i - 1][j2]);
                        }
                        if (i < pall.length - 1 && null != pall[i + 1][j2]) {
                            p.link(pall[i + 1][j2]);
                        }
                        if (j2 > 0 && null != pall[i][j2 - 1]) {
                            p.link(pall[i][j2 - 1]);
                        }
                        if (j2 >= pall[0].length - 1 || null == pall[i][j2 + 1]) continue;
                        p.link(pall[i][j2 + 1]);
                    }
                }
            }
            this.commitLargeUpdate();
            layer.getParent().setMinimumDimensions();
            layer.updateInDatabase("stack_index");
            Display.update(layer);
            layer.recreateBuckets();
        }
        catch (Throwable t) {
            IJError.print(t);
            this.rollback();
            this.setMipMapsRegeneration(true);
        }
    }

    public Bureaucrat importImages(Layer ref_layer) {
        return this.importImages(ref_layer, null, null, 0.0, 0.0, false, 1.0f, 0);
    }

    public Bureaucrat importImages(Layer ref_layer, String abs_text_file_path_, String column_separator_, double layer_thickness_, double calibration_, boolean homogenize_contrast_, float scale_, int border_width_) {
        if (null == abs_text_file_path_) {
            String[] file = Utils.selectFile("Select text file");
            if (null == file) {
                return null;
            }
            abs_text_file_path_ = file[0] + file[1];
        }
        if (null == column_separator_ || 0 == column_separator_.length() || Double.isNaN(layer_thickness_) || layer_thickness_ <= 0.0 || Double.isNaN(calibration_) || calibration_ <= 0.0) {
            Calibration cal = ref_layer.getParent().getCalibrationCopy();
            GenericDialog gdd = new GenericDialog("Options");
            String[] separators = new String[]{"tab", "space", "comma (,)"};
            gdd.addMessage("Choose a layer to act as the zero for the Z coordinates:");
            Utils.addLayerChoice("Base layer", ref_layer, gdd);
            gdd.addChoice("Column separator: ", separators, separators[0]);
            gdd.addNumericField("Layer thickness: ", cal.pixelDepth, 2);
            gdd.addNumericField("Calibration (data to pixels): ", 1.0, 2);
            gdd.addCheckbox("Homogenize contrast layer-wise", homogenize_contrast_);
            gdd.addSlider("Scale:", 0.0, 100.0, 100.0);
            gdd.addNumericField("Hide border with alpha mask", 0.0, 0, 6, "pixels");
            gdd.showDialog();
            if (gdd.wasCanceled()) {
                return null;
            }
            layer_thickness_ = gdd.getNextNumber();
            if (layer_thickness_ < 0.0 || Double.isNaN(layer_thickness_)) {
                Utils.log("Improper layer thickness value.");
                return null;
            }
            calibration_ = gdd.getNextNumber();
            if (0.0 == calibration_ || Double.isNaN(calibration_)) {
                Utils.log("Improper calibration value.");
                return null;
            }
            layer_thickness_ /= cal.pixelWidth;
            ref_layer = ref_layer.getParent().getLayer(gdd.getNextChoiceIndex());
            column_separator_ = "\t";
            switch (gdd.getNextChoiceIndex()) {
                case 1: {
                    column_separator_ = " ";
                    break;
                }
                case 2: {
                    column_separator_ = ",";
                    break;
                }
            }
            homogenize_contrast_ = gdd.getNextBoolean();
            double sc = gdd.getNextNumber();
            scale_ = Double.isNaN(sc) ? 1.0f : (float)sc / 100.0f;
            int border = (int)gdd.getNextNumber();
            if (border < 0) {
                Utils.log("Nonsensical border value: " + border);
                return null;
            }
            border_width_ = border;
        }
        if (Float.isNaN(scale_) || scale_ < 0.0f || scale_ > 1.0f) {
            Utils.log("Non-sensical scale: " + scale_ + "\nUsing scale of 1 instead.");
            scale_ = 1.0f;
        }
        final Layer base_layer = ref_layer;
        final String abs_text_file_path = abs_text_file_path_;
        final String column_separator = column_separator_;
        final double layer_thickness = layer_thickness_;
        final double calibration = calibration_;
        final boolean homogenize_contrast = homogenize_contrast_;
        final float scale = scale_;
        final int border_width = border_width_;
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Importing images", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void exec() {
                try {
                    String script_path;
                    int NP;
                    final String[] lines = Utils.openTextFileLines(abs_text_file_path);
                    if (null == lines || 0 == lines.length) {
                        Utils.log2("No images to import from " + abs_text_file_path);
                        return;
                    }
                    ContrastEnhancerWrapper cew = null;
                    if (homogenize_contrast) {
                        cew = new ContrastEnhancerWrapper();
                        cew.showDialog();
                    }
                    String sep2 = column_separator + column_separator;
                    String base_dir = null;
                    final Vector fus = new Vector();
                    LayerSet layer_set = base_layer.getParent();
                    double z_zero = base_layer.getZ();
                    final AtomicInteger n_imported = new AtomicInteger(0);
                    HashSet<Layer> touched_layers = new HashSet<Layer>();
                    int np = NP = Runtime.getRuntime().availableProcessors();
                    switch (np) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            np /= 2;
                        }
                    }
                    ThreadPoolExecutor ex = Utils.newFixedThreadPool(np, "import-images");
                    ArrayList imported = new ArrayList();
                    final 3 wo = this;
                    if ((double)Math.abs(scale - (float)((int)scale)) > 0.01) {
                        double sigma = Math.sqrt(Math.pow(1.0f / scale, 2.0) - 0.25);
                        String script = "import ij.ImagePlus;\n" + "import ij.process.ImageProcessor;\n" + "import ij.plugin.filter.GaussianBlur;\n" + "GaussianBlur blur = new GaussianBlur();\n" + "double accuracy = (imp.getType() == ImagePlus.GRAY8 || imp.getType() == ImagePlus.COLOR_RGB) ? 0.002 : 0.0002;\n" + "imp.getProcessor().setInterpolationMethod(ImageProcessor.NONE);\n" + "blur.blurGaussian(imp.getProcessor()," + sigma + ',' + sigma + ",accuracy);\n" + "imp.setProcessor(imp.getTitle(), imp.getProcessor().resize((int)(imp.getWidth() * " + scale + "), (int)(imp.getHeight() * " + scale + ")));";
                        File f = new File(Loader.this.getStorageFolder() + "resize-" + scale + ".bsh");
                        int v = 1;
                        while (f.exists()) {
                            f = new File(Loader.this.getStorageFolder() + "resize-" + scale + "." + v + ".bsh");
                            ++v;
                        }
                        String string = script_path = Utils.saveToFile(f, script) ? f.getAbsolutePath() : null;
                        if (null == script_path) {
                            Utils.log("Could NOT save a preprocessor script for image scaling\nat path " + f.getAbsolutePath());
                        }
                    } else {
                        script_path = null;
                    }
                    Utils.log("Scaling script path is " + script_path);
                    final AtomicReference last_mask = new AtomicReference();
                    for (int i = 0; i < lines.length; ++i) {
                        File f;
                        if (Thread.currentThread().isInterrupted() || this.hasQuitted()) {
                            this.quit();
                            return;
                        }
                        String line = lines[i].replace('\\', '/').trim();
                        int ic = line.indexOf(35);
                        if (-1 != ic) {
                            line = line.substring(0, ic);
                        }
                        if (0 == line.length() || '#' == line.charAt(0)) continue;
                        while (-1 != line.indexOf(sep2)) {
                            line = line.replaceAll(sep2, column_separator);
                        }
                        final String[] column = line.split(column_separator);
                        if (column.length < 4) {
                            Utils.log("Less than 4 columns: can't import from line " + i + " : " + line);
                            continue;
                        }
                        double x = 0.0;
                        double y = 0.0;
                        double z = 0.0;
                        try {
                            x = Double.parseDouble(column[1].trim());
                            y = Double.parseDouble(column[2].trim());
                            z = Double.parseDouble(column[3].trim());
                        }
                        catch (NumberFormatException nfe) {
                            Utils.log("Non-numeric value in a numeric column at line " + i + " : " + line);
                            continue;
                        }
                        x *= calibration;
                        y *= calibration;
                        z = z * calibration + z_zero;
                        String path = column[0].trim();
                        if (0 == path.length()) continue;
                        if ((!IJ.isWindows() && '/' != path.charAt(0) || IJ.isWindows() && 1 != path.indexOf(":/")) && null == base_dir) {
                            DirectoryChooser dc = new DirectoryChooser("Choose source directory");
                            String dir = dc.getDirectory();
                            if (null == dir) {
                                return;
                            }
                            base_dir = Utils.fixDir(dir);
                        }
                        if (null != base_dir) {
                            path = base_dir + path;
                        }
                        if (!(f = new File(path)).exists()) {
                            Utils.log("No file found for path " + path);
                            continue;
                        }
                        final Layer layer = layer_set.getLayer(z, layer_thickness, true);
                        touched_layers.add(layer);
                        final String imagefilepath = path;
                        final double xx = x * (double)scale;
                        final double yy = y * (double)scale;
                        final Callable<Patch> creator = column.length >= 9 ? new Callable<Patch>(){

                            private final int parseInt(String t) {
                                if (t.equals("-")) {
                                    return -1;
                                }
                                return Integer.parseInt(t);
                            }

                            private final double parseDouble(String t) {
                                if (t.equals("-")) {
                                    return Double.NaN;
                                }
                                return Double.parseDouble(t);
                            }

                            @Override
                            public Patch call() throws Exception {
                                int o_width = this.parseInt(column[4].trim());
                                int o_height = this.parseInt(column[5].trim());
                                double min = this.parseDouble(column[6].trim());
                                double max = this.parseDouble(column[7].trim());
                                int type = this.parseInt(column[8].trim());
                                if (-1 == type || -1 == o_width || -1 == o_height) {
                                    ImageFileHeader ifh = new ImageFileHeader(imagefilepath);
                                    o_width = ifh.width;
                                    o_height = ifh.height;
                                    type = ifh.type;
                                    if (!ifh.isSupportedType()) {
                                        Utils.log("Incompatible image type: " + imagefilepath);
                                        return null;
                                    }
                                }
                                ImagePlus imp = null;
                                if (Double.isNaN(min) || Double.isNaN(max)) {
                                    imp = Loader.this.openImagePlus(imagefilepath);
                                    min = imp.getProcessor().getMin();
                                    max = imp.getProcessor().getMax();
                                }
                                Patch patch = new Patch(layer.getProject(), new File(imagefilepath).getName(), o_width, o_height, o_width, o_height, type, 1.0f, Color.yellow, false, min, max, new AffineTransform(1.0, 0.0, 0.0, 1.0, xx, yy), imagefilepath);
                                if (null != script_path && null != imp) {
                                    Loader.this.cacheImagePlus(patch.getId(), imp);
                                }
                                return patch;
                            }
                        } : new Callable<Patch>(){

                            @Override
                            public Patch call() throws Exception {
                                IJ.redirectErrorMessages();
                                ImageFileHeader ifh = new ImageFileHeader(imagefilepath);
                                int o_width = ifh.width;
                                int o_height = ifh.height;
                                int type = ifh.type;
                                if (!ifh.isSupportedType()) {
                                    Utils.log("Incompatible image type: " + imagefilepath);
                                    return null;
                                }
                                double min = 0.0;
                                double max = 255.0;
                                switch (type) {
                                    case 1: 
                                    case 2: {
                                        ImagePlus imp = Loader.this.openImagePlus(imagefilepath);
                                        if (null == imp) {
                                            Utils.log("Ignoring unopenable image from " + imagefilepath);
                                            return null;
                                        }
                                        min = imp.getProcessor().getMin();
                                        max = imp.getProcessor().getMax();
                                    }
                                }
                                Patch patch = new Patch(layer.getProject(), new File(imagefilepath).getName(), o_width, o_height, o_width, o_height, type, 1.0f, Color.yellow, false, min, max, new AffineTransform(1.0, 0.0, 0.0, 1.0, xx, yy), imagefilepath);
                                return patch;
                            }
                        };
                        if (0 == i % (NP + NP)) {
                            ArrayList a = new ArrayList(NP + NP);
                            Vector<Future<?>> vector = fus;
                            synchronized (vector) {
                                void var39_39;
                                boolean bl = false;
                                while (!fus.isEmpty() && var39_39 < NP) {
                                    a.add(fus.remove(0));
                                    ++var39_39;
                                }
                            }
                            for (Future future : a) {
                                try {
                                    if (wo.hasQuitted()) {
                                        return;
                                    }
                                    future.get();
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                        }
                        imported.add(ex.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Patch patch;
                                if (wo.hasQuitted()) {
                                    return;
                                }
                                IJ.redirectErrorMessages();
                                try {
                                    patch = (Patch)creator.call();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    Utils.log("Could not load patch from " + imagefilepath);
                                    return;
                                }
                                if (null != script_path) {
                                    try {
                                        patch.setPreprocessorScriptPath(script_path);
                                    }
                                    catch (Throwable t) {
                                        Utils.log("FAILED to set a scaling preprocessor script to patch " + patch);
                                        IJError.print(t);
                                    }
                                }
                                if (border_width > 0) {
                                    Triple m = (Triple)last_mask.get();
                                    if (null != m && ((Integer)m.a).intValue() == patch.getOWidth() && ((Integer)m.b).intValue() == patch.getOHeight()) {
                                        patch.setAlphaMask((ByteProcessor)m.c);
                                    } else {
                                        ByteProcessor mask = new ByteProcessor(patch.getOWidth(), patch.getOHeight());
                                        mask.setValue(255.0);
                                        mask.setRoi(new Roi(border_width, border_width, mask.getWidth() - 2 * border_width, mask.getHeight() - 2 * border_width));
                                        mask.fill();
                                        patch.setAlphaMask(mask);
                                        last_mask.set(new Triple((Object)mask.getWidth(), (Object)mask.getHeight(), (Object)mask));
                                    }
                                }
                                if (!homogenize_contrast) {
                                    fus.add(Loader.this.regenerateMipMaps(patch));
                                }
                                Layer layer2 = layer;
                                synchronized (layer2) {
                                    layer.add(patch, true);
                                }
                                wo.setTaskName("Imported " + (n_imported.incrementAndGet() + 1) + "/" + lines.length);
                            }
                        }));
                    }
                    Utils.wait(imported);
                    ex.shutdown();
                    if (0 == n_imported.get()) {
                        Utils.log("No images imported.");
                        return;
                    }
                    base_layer.getParent().setMinimumDimensions();
                    Display.repaint(base_layer.getParent());
                    Loader.this.recreateBuckets(touched_layers);
                    if (homogenize_contrast) {
                        this.setTaskName("Enhance contrast");
                        cew.applyLayerWise(touched_layers);
                        cew.shutdown();
                    }
                    Utils.wait(fus);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }, base_layer.getProject());
    }

    public Bureaucrat importLabelsAsAreaLists(Layer layer) {
        return this.importLabelsAsAreaLists(layer, null, 0.0, 0.0, 0.4f, false);
    }

    public Bureaucrat importLabelsAsAreaLists(final Layer first_layer, final String path_, final double base_x_, final double base_y_, final float alpha_, final boolean add_background_) {
        Worker worker = new Worker("Import labels as arealists"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.startedWorking();
                try {
                    AmiraMeshDecoder decoder;
                    String path = path_;
                    if (null == path) {
                        OpenDialog od = new OpenDialog("Select stack", "");
                        String name = od.getFileName();
                        if (null == name || 0 == name.length()) {
                            return;
                        }
                        String dir = od.getDirectory().replace('\\', '/');
                        if (!dir.endsWith("/")) {
                            dir = dir + "/";
                        }
                        path = dir + name;
                    }
                    if (path.toLowerCase().endsWith(".xml")) {
                        Utils.log("Avoided opening a TrakEM2 project.");
                        return;
                    }
                    double base_x = base_x_;
                    double base_y = base_y_;
                    float alpha = alpha_;
                    boolean add_background = add_background_;
                    Layer layer = first_layer;
                    if (Double.MAX_VALUE == base_x || Double.MAX_VALUE == base_y || alpha < 0.0f || alpha > 1.0f) {
                        GenericDialog gd = new GenericDialog("Base x, y");
                        Utils.addLayerChoice("First layer:", first_layer, gd);
                        gd.addNumericField("Base_X:", 0.0, 0);
                        gd.addNumericField("Base_Y:", 0.0, 0);
                        gd.addSlider("Alpha:", 0.0, 100.0, 40.0);
                        gd.addCheckbox("Add background (zero)", false);
                        gd.showDialog();
                        if (gd.wasCanceled()) {
                            return;
                        }
                        layer = first_layer.getParent().getLayer(gd.getNextChoiceIndex());
                        base_x = gd.getNextNumber();
                        base_y = gd.getNextNumber();
                        if (Double.isNaN(base_x) || Double.isNaN(base_y)) {
                            Utils.log("Base x or y is NaN!");
                            return;
                        }
                        alpha = (float)(gd.getNextNumber() / 100.0);
                        add_background = gd.getNextBoolean();
                    }
                    Loader.this.releaseToFit(new File(path).length() * 3L);
                    Object imp = path.toLowerCase().endsWith(".am") ? ((decoder = new AmiraMeshDecoder()).open(path) ? new ImagePlus(path, decoder.getStack()) : null) : Loader.this.openImagePlus(path);
                    if (null == imp) {
                        Utils.log("Could not open image at " + path);
                        return;
                    }
                    Map<Float, AreaList> alis = AmiraImporter.extractAreaLists(imp, layer, base_x, base_y, alpha, add_background);
                    if (!this.hasQuitted() && alis.size() > 0) {
                        layer.getProject().getProjectTree().insertSegmentations(alis.values());
                    }
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                finally {
                    this.finishedWorking();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, first_layer.getProject());
    }

    public void recreateBuckets(Collection<Layer> col) {
        Layer[] lall = new Layer[col.size()];
        col.toArray(lall);
        this.recreateBuckets(lall);
    }

    public void recreateBuckets(final Layer[] la) {
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = MultiThreading.newThreads();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    this.setPriority(5);
                    int i = ai.getAndIncrement();
                    while (i < la.length) {
                        la[i].recreateBuckets();
                        i = ai.getAndIncrement();
                    }
                }
            };
        }
        MultiThreading.startAndJoin(threads);
    }

    private double getMeanOfRange(ImageStatistics st, double min, double max) {
        int b;
        if (min == max) {
            return min;
        }
        double mean = 0.0;
        int nn = 0;
        int first_bin = 0;
        int last_bin = st.nBins - 1;
        for (b = 0; b < st.nBins; ++b) {
            if (!(st.min + st.binSize * (double)b > min)) continue;
            first_bin = b;
            break;
        }
        for (b = last_bin; b > first_bin; --b) {
            if (!(st.max - st.binSize * (double)b <= max)) continue;
            last_bin = b;
            break;
        }
        for (int h = first_bin; h <= last_bin; ++h) {
            nn += st.histogram[h];
            mean += (double)(h * st.histogram[h]);
        }
        return mean /= (double)nn;
    }

    public abstract ImagePlus fetchOriginal(Patch var1);

    public Bureaucrat makeFlatImage(Layer[] layer, Rectangle srcRect, double scale, int c_alphas, int type, boolean force_to_file, boolean quality) {
        return this.makeFlatImage(layer, srcRect, scale, c_alphas, type, force_to_file, quality, Color.black);
    }

    public Bureaucrat makeFlatImage(Layer[] layer, Rectangle srcRect, double scale, int c_alphas, int type, boolean force_to_file, boolean quality, Color background) {
        return this.makeFlatImage(layer, srcRect, scale, c_alphas, type, force_to_file, "tif", quality, background);
    }

    public Bureaucrat makeFlatImage(final Layer[] layer, final Rectangle srcRect, final double scale, final int c_alphas, final int type, final boolean force_to_file, final String format, final boolean quality, final Color background) {
        if (null == layer || 0 == layer.length) {
            Utils.log2("makeFlatImage: null or empty list of layers to process.");
            return null;
        }
        Worker worker = new Worker("making flat images"){

            @Override
            public void run() {
                try {
                    long size;
                    this.startedWorking();
                    Rectangle srcRect_ = srcRect;
                    if (null == srcRect_) {
                        srcRect_ = layer[0].getParent().get2DBounds();
                    }
                    ImagePlus imp = null;
                    String target_dir = null;
                    boolean choose_dir = force_to_file;
                    if (!force_to_file && (double)(size = (long)Math.ceil((double)srcRect_.width * scale * ((double)srcRect_.height * scale) * (double)(0 == type ? 1 : 4) * (double)layer.length)) > (double)IJ.maxMemory() * 0.9) {
                        YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "WARNING", "The resulting stack of flat images is too large to fit in memory.\nChoose a directory to save the slices as an image sequence?");
                        if (yn.yesPressed()) {
                            choose_dir = true;
                        } else {
                            if (yn.cancelPressed()) {
                                this.finishedWorking();
                                return;
                            }
                            choose_dir = false;
                        }
                    }
                    if (choose_dir) {
                        DirectoryChooser dc = new DirectoryChooser("Target directory");
                        target_dir = dc.getDirectory();
                        if (null == target_dir || target_dir.toLowerCase().startsWith("null")) {
                            this.finishedWorking();
                            return;
                        }
                        if (IJ.isWindows()) {
                            target_dir = target_dir.replace('\\', '/');
                        }
                        if (!target_dir.endsWith("/")) {
                            target_dir = target_dir + "/";
                        }
                    }
                    if (layer.length > 1) {
                        ImageStack stack = null;
                        Utils.showProgress(0.0);
                        for (int i = 0; i < layer.length; ++i) {
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            Loader.this.releaseAll();
                            Utils.showProgress((float)i / (float)layer.length);
                            ImagePlus slice = Loader.this.getFlatImage(layer[i], srcRect_, scale, c_alphas, type, Displayable.class, null, quality, background);
                            if (null == slice) {
                                Utils.log("Could not retrieve flat image for " + layer[i].toString());
                                continue;
                            }
                            if (null != target_dir) {
                                Loader.this.saveToPath(slice, target_dir, layer[i].getPrintableTitle(), ".tif");
                                continue;
                            }
                            if (null == stack) {
                                stack = new ImageStack(slice.getWidth(), slice.getHeight());
                            }
                            stack.addSlice(layer[i].getProject().findLayerThing(layer[i]).toString(), slice.getProcessor());
                        }
                        Utils.showProgress(1.0);
                        if (null != stack) {
                            imp = new ImagePlus("z=" + layer[0].getZ() + " to z=" + layer[layer.length - 1].getZ(), stack);
                            Calibration impCalibration = layer[0].getParent().getCalibrationCopy();
                            impCalibration.pixelWidth /= scale;
                            impCalibration.pixelHeight /= scale;
                            imp.setCalibration(impCalibration);
                        }
                    } else {
                        imp = Loader.this.getFlatImage(layer[0], srcRect_, scale, c_alphas, type, Displayable.class, null, quality, background);
                        if (null != target_dir) {
                            Loader.this.saveToPath(imp, target_dir, layer[0].getPrintableTitle(), format);
                            imp = null;
                        }
                    }
                    if (null != imp) {
                        imp.show();
                    }
                }
                catch (Throwable e) {
                    IJError.print(e);
                }
                this.finishedWorking();
            }
        };
        return Bureaucrat.createAndStart(worker, layer[0].getProject());
    }

    private void saveToPath(ImagePlus imp, String dir, String file_name, String extension) {
        if (null == imp) {
            Utils.log2("Loader.saveToPath: can't save a null image.");
            return;
        }
        String path = dir + "/" + file_name;
        File file = new File(path + extension);
        int k = 1;
        while (file.exists()) {
            file = new File(path + "_" + k + ".tif");
            ++k;
        }
        try {
            new Saver(extension).save(imp, file.getAbsolutePath());
        }
        catch (OutOfMemoryError oome) {
            Utils.log2("Not enough memory. Could not save image for " + file_name);
            IJError.print(oome);
        }
        catch (Exception e) {
            Utils.log2("Could not save image for " + file_name);
            IJError.print(e);
        }
    }

    public ImagePlus getFlatImage(Layer layer, Rectangle srcRect_, double scale, int c_alphas, int type, Class<?> clazz, boolean quality) {
        return this.getFlatImage(layer, srcRect_, scale, c_alphas, type, clazz, null, quality, Color.black);
    }

    public ImagePlus getFlatImage(Layer layer, Rectangle srcRect_, double scale, int c_alphas, int type, Class<?> clazz, List<? extends Displayable> al_displ) {
        return this.getFlatImage(layer, srcRect_, scale, c_alphas, type, clazz, al_displ, false, Color.black);
    }

    public ImagePlus getFlatImage(Layer layer, Rectangle srcRect_, double scale, int c_alphas, int type, Class<?> clazz, List<? extends Displayable> al_displ, boolean quality) {
        return this.getFlatImage(layer, srcRect_, scale, c_alphas, type, clazz, al_displ, quality, Color.black);
    }

    public ImagePlus getFlatImage(Selection selection, double scale, int c_alphas, int type, boolean quality, Color background) {
        return this.getFlatImage(selection.getLayer(), selection.getBox(), scale, c_alphas, type, null, selection.getSelected(), quality, background);
    }

    public ImagePlus getFlatImage(Layer layer, Rectangle srcRect_, double scale, int c_alphas, int type, Class<?> clazz, List<? extends Displayable> al_displ, boolean quality, Color background) {
        return this.getFlatImage(layer, srcRect_, scale, c_alphas, type, clazz, al_displ, quality, background, null);
    }

    public ImagePlus getFlatImage(Layer layer, Rectangle srcRect_, double scale, int c_alphas, int type, Class<?> clazz, List<? extends Displayable> al_displ, boolean quality, Color background, Displayable active) {
        Image bi = this.getFlatAWTImage(layer, srcRect_, scale, c_alphas, type, clazz, al_displ, quality, background, active);
        ImagePlus imp = new ImagePlus(layer.getPrintableTitle(), bi);
        Calibration impCalibration = layer.getParent().getCalibrationCopy();
        impCalibration.pixelWidth /= scale;
        impCalibration.pixelHeight /= scale;
        imp.setCalibration(impCalibration);
        bi.flush();
        return imp;
    }

    public Image getFlatAWTImage(Layer layer, Rectangle srcRect_, double scale, int c_alphas, int type, Class<?> clazz, List<? extends Displayable> al_displ, boolean quality, Color background) {
        return this.getFlatAWTImage(layer, srcRect_, scale, c_alphas, type, clazz, al_displ, quality, background, null);
    }

    public Image getFlatAWTImage(Layer layer, Rectangle srcRect_, double scale, int c_alphas, int type, Class<?> clazz, List<? extends Displayable> al_displ, boolean quality, Color background, Displayable active) {
        try {
            int bih;
            int biw;
            double scaleP;
            double scalePX;
            double scalePY;
            Rectangle srcRect;
            int w = 0;
            int h = 0;
            Rectangle rectangle = srcRect = null == srcRect_ ? null : (Rectangle)srcRect_.clone();
            if (null != srcRect) {
                w = srcRect.width;
                h = srcRect.height;
            } else {
                w = (int)Math.ceil(layer.getLayerWidth());
                h = (int)Math.ceil(layer.getLayerHeight());
                srcRect = new Rectangle(0, 0, w, h);
            }
            int ww = (int)Math.ceil((double)w * scale);
            int hh = (int)Math.ceil((double)h * scale);
            if (quality) {
                if ((double)ww * (double)hh >= Math.pow(2.0, 30.0)) {
                    scalePX = scalePY = scale;
                    scaleP = scalePY;
                    quality = false;
                    biw = ww;
                    bih = hh;
                    Utils.log("Can't use 'quality' flag for getFlatAWTImage: would be too large");
                } else {
                    double max_area = Math.min((double)srcRect.width * (double)srcRect.height, Math.pow(2.0, 30.0));
                    scaleP = Math.sqrt((double)ww * (double)hh) / Math.sqrt(max_area);
                    biw = (int)Math.ceil((double)ww / scaleP);
                    bih = (int)Math.ceil((double)hh / scaleP);
                    scalePX = (double)biw / (double)ww * scale;
                    scalePY = (double)bih / (double)hh * scale;
                }
            } else {
                scalePX = scalePY = scale;
                scaleP = scalePY;
                biw = ww;
                bih = hh;
            }
            long n_bytes = (long)((double)(biw * bih) * (0 == type ? 1.0 : 4.0));
            this.releaseToFit(n_bytes);
            BufferedImage bi = null;
            switch (type) {
                case 0: {
                    bi = new BufferedImage(biw, bih, 13, GRAY_LUT);
                    break;
                }
                case 4: {
                    bi = new BufferedImage(biw, bih, 2);
                    break;
                }
                default: {
                    Utils.log2("Left bi,icm as null");
                }
            }
            Graphics2D g2d = bi.createGraphics();
            g2d.setColor(background);
            g2d.fillRect(0, 0, bi.getWidth(), bi.getHeight());
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ArrayList<Displayable> al_zdispl = null;
            if (null == al_displ) {
                al_displ = new ArrayList<Displayable>(layer.find(clazz, srcRect, true, true));
                al_zdispl = new ArrayList<Displayable>(layer.getParent().findZDisplayables(clazz, layer, srcRect, true, true));
            } else {
                al_displ = new ArrayList<Displayable>(al_displ);
                HashSet<ZDisplayable> az = new HashSet<ZDisplayable>();
                Iterator<? extends Displayable> it = al_displ.iterator();
                while (it.hasNext()) {
                    Displayable ob = it.next();
                    if (!(ob instanceof ZDisplayable)) continue;
                    it.remove();
                    az.add((ZDisplayable)ob);
                }
                ArrayList<ZDisplayable> al_zdispl2 = layer.getParent().getZDisplayables();
                Iterator<ZDisplayable> it2 = al_zdispl2.iterator();
                while (it2.hasNext()) {
                    if (az.contains(it2.next())) continue;
                    it2.remove();
                }
                al_zdispl = al_zdispl2;
            }
            AffineTransform at_original = g2d.getTransform();
            AffineTransform atc = new AffineTransform();
            atc.scale(scalePX, scalePY);
            atc.translate(-srcRect.x, -srcRect.y);
            at_original.preConcatenate(atc);
            g2d.setTransform(at_original);
            boolean zd_done = false;
            List<Layer> layers = layer.getParent().getColorCueLayerRange(layer);
            for (Displayable displayable : al_displ) {
                if (!zd_done && displayable instanceof DLabel) {
                    zd_done = true;
                    for (ZDisplayable zDisplayable : al_zdispl) {
                        if (zDisplayable.isOutOfRepaintingClip(scaleP, srcRect, null)) continue;
                        zDisplayable.paint(g2d, srcRect, scaleP, active == zDisplayable, c_alphas, layer, layers);
                    }
                }
                if (displayable.isOutOfRepaintingClip(scaleP, srcRect, null)) continue;
                displayable.paintOffscreen(g2d, srcRect, scaleP, active == displayable, c_alphas, layer, layers);
            }
            if (!zd_done) {
                zd_done = true;
                for (ZDisplayable zDisplayable : al_zdispl) {
                    if (zDisplayable.isOutOfRepaintingClip(scaleP, srcRect, null)) continue;
                    zDisplayable.paint(g2d, srcRect, scaleP, active == zDisplayable, c_alphas, layer, layers);
                }
            }
            this.releaseToFit((long)((double)n_bytes * 2.3));
            try {
                if (quality) {
                    Image scaled = null;
                    if (!this.isMipMapsRegenerationEnabled() || scale >= 0.499) {
                        scaled = bi.getScaledInstance(ww, hh, 16);
                        if (0 == type) {
                            BufferedImage bufferedImage = new BufferedImage(ww, hh, 10);
                            bufferedImage.createGraphics().drawImage(scaled, 0, 0, null);
                            scaled.flush();
                            scaled = bufferedImage;
                        }
                    } else {
                        scaled = bi.getType() == 13 ? new BufferedImage(ww, hh, bi.getType(), GRAY_LUT) : new BufferedImage(ww, hh, bi.getType());
                        Graphics2D graphics2D = (Graphics2D)scaled.getGraphics();
                        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2D.drawImage(bi, 0, 0, ww, hh, null);
                    }
                    bi.flush();
                    return scaled;
                }
                return bi;
            }
            catch (OutOfMemoryError oome) {
                Utils.log("Not enough memory to create the ImagePlus. Try scaling it down or not using the 'quality' flag.");
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return null;
    }

    public Bureaucrat makePrescaledTiles(Layer[] layers, Class<?> clazz, Rectangle srcRect, int c_alphas, int type, String target_dir, int strategy, Saver saver, int tileSide, int directory_structure_type, boolean skip_empty_tiles, boolean use_layer_indices, int n_threads) {
        return ExportMultilevelTiles.makePrescaledTiles(layers, clazz, srcRect, c_alphas, type, target_dir, strategy, saver, tileSide, directory_structure_type, skip_empty_tiles, use_layer_indices, n_threads);
    }

    public void addedPatchFrom(String path, Patch patch) {
    }

    public Bureaucrat importImage(final Layer layer, final double x, final double y, final String path, final boolean synch_mipmap_generation) {
        Worker worker = new Worker("Importing image"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    this.startedWorking();
                    try {
                        if (null == layer) {
                            Utils.log("Can't import. No layer found.");
                            this.finishedWorking();
                            return;
                        }
                        Patch p = Loader.this.importImage(layer.getProject(), x, y, path, synch_mipmap_generation);
                        if (null == p) break block6;
                        Layer layer2 = layer;
                        synchronized (layer2) {
                            layer.add(p);
                        }
                        layer.getParent().enlargeToFit(p, 7);
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                }
                this.finishedWorking();
            }
        };
        return Bureaucrat.createAndStart(worker, layer.getProject());
    }

    public Patch importImage(Project project, double x, double y) {
        return this.importImage(project, x, y, null, false);
    }

    public Patch importImage(Project project, double x, double y, String path, boolean synch_mipmap_generation) {
        if (null == path) {
            OpenDialog od = new OpenDialog("Import image", "");
            String name = od.getFileName();
            if (null == name || 0 == name.length()) {
                return null;
            }
            String dir = od.getDirectory().replace('\\', '/');
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            path = dir + name;
        } else {
            path = path.replace('\\', '/');
        }
        if (path.toLowerCase().endsWith(".xml")) {
            Utils.showMessage("Cannot import " + path + " as a stack.");
            return null;
        }
        this.releaseToFit(new File(path).length() * 3L);
        IJ.redirectErrorMessages();
        ImagePlus imp = this.openImagePlus(path);
        if (null == imp) {
            return null;
        }
        if (imp.getNSlices() > 1) {
            Layer layer = Display.getFrontLayer(project);
            if (null == layer) {
                return null;
            }
            this.importStack(layer, x, y, imp, true, path, true);
            return null;
        }
        if (0 == imp.getWidth() || 0 == imp.getHeight()) {
            Utils.showMessage("Can't import image of zero width or height.");
            Loader.flush(imp);
            return null;
        }
        Patch p = new Patch(project, imp.getTitle(), x, y, imp);
        this.addedPatchFrom(path, p);
        this.last_opened_path = path;
        if (this.isMipMapsRegenerationEnabled()) {
            if (synch_mipmap_generation) {
                try {
                    this.regenerateMipMaps(p).get();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            } else {
                this.regenerateMipMaps(p);
            }
        }
        return p;
    }

    public Patch importNextImage(Project project, double x, double y) {
        if (null == this.last_opened_path) {
            return this.importImage(project, x, y);
        }
        int i_slash = this.last_opened_path.lastIndexOf("/");
        String dir_name = this.last_opened_path.substring(0, i_slash + 1);
        File dir = new File(dir_name);
        String last_file = this.last_opened_path.substring(i_slash + 1);
        String[] file_names = dir.list();
        String next_file = null;
        String exts = "tiftiffjpgjpegpnggifzipdicombmppgm";
        block0: for (int i = 0; i < file_names.length; ++i) {
            if (!last_file.equals(file_names[i]) || i >= file_names.length - 1) continue;
            for (int j = i + 1; j < file_names.length; ++j) {
                String ext = file_names[j].substring(file_names[j].lastIndexOf(46) + 1).toLowerCase();
                if (-1 == "tiftiffjpgjpegpnggifzipdicombmppgm".indexOf(ext)) continue;
                next_file = file_names[j];
                break block0;
            }
            break;
        }
        if (null == next_file) {
            Utils.showMessage("No more files after " + last_file);
            return null;
        }
        this.releaseToFit(new File(dir_name + next_file).length() * 3L);
        IJ.redirectErrorMessages();
        ImagePlus imp = this.openImagePlus(dir_name + next_file);
        if (null == imp) {
            return null;
        }
        if (0 == imp.getWidth() || 0 == imp.getHeight()) {
            Utils.showMessage("Can't import image of zero width or height.");
            Loader.flush(imp);
            return null;
        }
        String path = dir + "/" + next_file;
        Patch p = new Patch(project, imp.getTitle(), x, y, imp);
        this.addedPatchFrom(path, p);
        this.last_opened_path = path;
        if (this.isMipMapsRegenerationEnabled()) {
            this.regenerateMipMaps(p);
        }
        return p;
    }

    public Bureaucrat importStack(Layer first_layer, ImagePlus imp_stack_, boolean ask_for_data) {
        return this.importStack(first_layer, imp_stack_, ask_for_data, null);
    }

    public Bureaucrat importStack(Layer first_layer, ImagePlus imp_stack_, boolean ask_for_data, String filepath_) {
        return this.importStack(first_layer, 0.0, 0.0, imp_stack_, ask_for_data, filepath_, true);
    }

    public Bureaucrat importStack(final Layer first_layer, final double x, final double y, final ImagePlus imp_stack_, final boolean ask_for_data, final String filepath_, final boolean one_patch_per_layer_) {
        Utils.log2("Loader.importStack filepath: " + filepath_);
        if (null == first_layer) {
            return null;
        }
        Worker worker = new Worker("import stack"){

            @Override
            public void run() {
                this.startedWorking();
                try {
                    Collection<AreaList> alis;
                    YesNoDialog yn;
                    double current_thickness;
                    YesNoDialog yn2;
                    String filepath = filepath_;
                    boolean one_patch_per_layer = one_patch_per_layer_;
                    ImagePlus[] stks = null;
                    boolean choose = false;
                    if (null == imp_stack_) {
                        stks = Utils.findOpenStacks();
                        choose = null == stks || stks.length > 0;
                    } else {
                        stks = new ImagePlus[]{imp_stack_};
                    }
                    ImagePlus imp_stack = null;
                    if (null == stks) {
                        imp_stack = Loader.this.openStack();
                    } else if (choose) {
                        GenericDialog gd = new GenericDialog("Choose one");
                        gd.addMessage("Choose a stack from the list or 'open...' to bring up a file chooser dialog:");
                        String[] list = new String[stks.length + 1];
                        for (int i = 0; i < list.length - 1; ++i) {
                            list[i] = stks[i].getTitle();
                        }
                        list[list.length - 1] = "[  Open stack...  ]";
                        gd.addChoice("choose stack: ", list, list[0]);
                        gd.showDialog();
                        if (gd.wasCanceled()) {
                            this.finishedWorking();
                            return;
                        }
                        int i_choice = gd.getNextChoiceIndex();
                        imp_stack = list.length - 1 == i_choice ? first_layer.getProject().getLoader().openStack() : stks[i_choice];
                    } else {
                        imp_stack = imp_stack_;
                    }
                    if (null == imp_stack) {
                        this.finishedWorking();
                        return;
                    }
                    String props = (String)imp_stack.getProperty("Info");
                    if (null != props && -1 != props.indexOf("Materials {") && !(yn2 = new YesNoDialog((Frame)IJ.getInstance(), "Warning", "You are importing a stack of Amira labels as a regular image stack. Continue anyway?")).yesPressed()) {
                        this.finishedWorking();
                        return;
                    }
                    double layer_width = first_layer.getLayerWidth();
                    double layer_height = first_layer.getLayerHeight();
                    double thickness = current_thickness = first_layer.getThickness();
                    boolean expand_layer_set = false;
                    boolean lock_stack = false;
                    if (ask_for_data) {
                        GenericDialog gd = new GenericDialog("Slice separation?");
                        gd.addMessage("Please enter the slice thickness, in pixels");
                        gd.addNumericField("slice_thickness: ", Math.abs(imp_stack.getCalibration().pixelDepth / imp_stack.getCalibration().pixelHeight), 3);
                        if (layer_width != (double)imp_stack.getWidth() || layer_height != (double)imp_stack.getHeight()) {
                            gd.addCheckbox("Resize canvas to fit stack", true);
                        }
                        gd.addCheckbox("Lock stack", false);
                        String[] importStackTypes = new String[]{"One slice per layer (Patches)", "Image volume (Stack)"};
                        if (imp_stack.getStack().isVirtual()) {
                            one_patch_per_layer = true;
                        }
                        gd.addChoice("Import stack as:", importStackTypes, importStackTypes[0]);
                        ((Component)gd.getChoices().get(0)).setEnabled(!imp_stack.getStack().isVirtual());
                        gd.showDialog();
                        if (gd.wasCanceled()) {
                            if (null == stks) {
                                Loader.flush(imp_stack);
                            }
                            this.finishedWorking();
                            return;
                        }
                        if (layer_width != (double)imp_stack.getWidth() || layer_height != (double)imp_stack.getHeight()) {
                            expand_layer_set = gd.getNextBoolean();
                        }
                        lock_stack = gd.getNextBoolean();
                        thickness = gd.getNextNumber();
                        if (thickness != current_thickness) {
                            if (1 == first_layer.getParent().size() && first_layer.isEmpty()) {
                                yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Mismatch!", "The current layer's thickness is " + current_thickness + "\nwhich is " + (thickness < current_thickness ? "larger" : "smaller") + " than\nthe desired " + thickness + " for each stack slice.\nAdjust current layer's thickness to " + thickness + " ?");
                                if (yn.cancelPressed()) {
                                    if (null != imp_stack_) {
                                        Loader.flush(imp_stack);
                                    }
                                    this.finishedWorking();
                                    return;
                                }
                                if (yn.yesPressed()) {
                                    first_layer.setThickness(thickness);
                                }
                            } else {
                                yn = new YesNoDialog((Frame)IJ.getInstance(), "WARNING", "There's more than one layer or the current layer is not empty\nso the thickness cannot be adjusted. Proceed anyway?");
                                if (!yn.yesPressed()) {
                                    this.finishedWorking();
                                    return;
                                }
                            }
                        }
                        boolean bl = one_patch_per_layer = imp_stack.getStack().isVirtual() || 0 == gd.getNextChoiceIndex();
                    }
                    if (null == imp_stack.getStack()) {
                        Utils.showMessage("Not a stack.");
                        this.finishedWorking();
                        return;
                    }
                    boolean calibrate = true;
                    if (ask_for_data && first_layer.getParent().isCalibrated()) {
                        if (!ControlWindow.isGUIEnabled()) {
                            Utils.log2("Loader.importStack: overriding LayerSet calibration with that of the imported stack.");
                        } else {
                            YesNoDialog yn3 = new YesNoDialog("Calibration", "The layer set is already calibrated. Override with the stack calibration values?");
                            if (!yn3.yesPressed()) {
                                calibrate = false;
                            }
                        }
                    }
                    if (calibrate) {
                        first_layer.getParent().setCalibration(imp_stack.getCalibration());
                    }
                    if (layer_width < (double)imp_stack.getWidth() || layer_height < (double)imp_stack.getHeight()) {
                        expand_layer_set = true;
                    }
                    if (!imp_stack.getStack().isVirtual()) {
                        if (null == filepath) {
                            FileInfo fi = imp_stack.getOriginalFileInfo();
                            if (null != fi && null != fi.directory && null != fi.fileName) {
                                filepath = fi.directory.replace('\\', '/');
                                if (!filepath.endsWith("/")) {
                                    filepath = filepath + '/';
                                }
                                filepath = filepath + fi.fileName;
                            }
                            Utils.log2("Getting filepath from FileInfo: " + filepath);
                            if (null == filepath || !filepath.startsWith("http://") && !new File(filepath).exists()) {
                                filepath = Loader.this.handlePathlessImage(imp_stack);
                            }
                        } else {
                            filepath = filepath.replace('\\', '/');
                        }
                    }
                    if (!one_patch_per_layer) {
                        Stack st = new Stack(first_layer.getProject(), new File(filepath).getName(), x, y, first_layer, filepath);
                        first_layer.getParent().add(st);
                        this.finishedWorking();
                        return;
                    }
                    Patch last_patch = Loader.this.importStackAsPatches(first_layer.getProject(), first_layer, x, y, imp_stack, null != imp_stack_ && null != imp_stack_.getCanvas(), filepath);
                    if (null != last_patch) {
                        last_patch.setLocked(lock_stack);
                        Display.updateCheckboxes(last_patch.getLinkedGroup(null), 1, true);
                    }
                    if (expand_layer_set) {
                        last_patch.getLayer().getParent().setMinimumDimensions();
                    }
                    Utils.log2("props: " + props);
                    if (null != props && -1 == props.indexOf("Materials {") && -1 != props.indexOf("CoordType") && (yn = new YesNoDialog((Frame)IJ.getInstance(), "Amira Importer", "Import labels as well?")).yesPressed() && null != (alis = AmiraImporter.importAmiraLabels(first_layer, last_patch.getX(), last_patch.getY(), imp_stack.getOriginalFileInfo().directory))) {
                        first_layer.getProject().getProjectTree().insertSegmentations(alis);
                        for (AreaList ali : alis) {
                            ali.linkPatches();
                        }
                    }
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                this.finishedWorking();
            }
        };
        return Bureaucrat.createAndStart(worker, first_layer.getProject());
    }

    public String handlePathlessImage(ImagePlus imp) {
        return null;
    }

    protected Patch importStackAsPatches(Project project, Layer first_layer, ImagePlus stack, boolean as_copy, String filepath) {
        return this.importStackAsPatches(project, first_layer, Double.MAX_VALUE, Double.MAX_VALUE, stack, as_copy, filepath);
    }

    protected abstract Patch importStackAsPatches(Project var1, Layer var2, double var3, double var5, ImagePlus var7, boolean var8, String var9);

    public final boolean markStaleFileForDeletionUponSaving(String path) {
        return this.stale_files.add(path);
    }

    private final long estimateXMLFileSize(File fxml) {
        try {
            if (fxml.exists()) {
                return Math.min(fxml.length(), Math.max((long)((double)MAX_MEMORY * 0.6), MIN_FREE_BYTES));
            }
        }
        catch (Throwable t) {
            IJError.print(t, true);
        }
        return MIN_FREE_BYTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String export(Project project, File fxml, XMLOptions options) {
        String path = null;
        if (null == project) return null;
        if (null == fxml) {
            return null;
        }
        this.releaseToFit(this.estimateXMLFileSize(fxml));
        try {
            ArrayList<String> stales;
            File fpd;
            if (options.export_images && !(this instanceof FSLoader)) {
                YesNoCancelDialog yn = ControlWindow.makeYesNoCancelDialog("Export images?", "Export images as well?");
                if (yn.cancelPressed()) {
                    return null;
                }
                options.export_images = yn.yesPressed();
            }
            if (options.export_images) {
                options.patches_dir = this.makePatchesDir(fxml);
            }
            File ftmp = IJ.isWindows() ? fxml : new File(fxml.getAbsolutePath() + ".tmp");
            FileOutputStream fos = new FileOutputStream(ftmp);
            OutputStreamWriter writer = fxml.getName().endsWith(".xml.gz") ? new OutputStreamWriter((OutputStream)new GZIPOutputStream(new BufferedOutputStream(fos)), "8859_1") : new OutputStreamWriter((OutputStream)new BufferedOutputStream(fos), "8859_1");
            try {
                this.writeXMLTo(project, writer, options);
                fos.getFD().sync();
            }
            catch (Exception e) {
                Utils.log("FAILED to write to the file at " + fxml);
                IJError.print(e);
                path = null;
                String string = null;
                return string;
            }
            finally {
                ((Writer)writer).close();
                writer = null;
            }
            if (!IJ.isWindows()) {
                try {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!ftmp.renameTo(fxml)) {
                        Utils.logAll("ERROR: could not rename " + ftmp.getName() + " to " + fxml.getName());
                        return null;
                    }
                }
                catch (Exception e) {
                    Utils.log("FAILED to save the file at " + fxml);
                    IJError.print(e);
                    return null;
                }
            }
            this.setChanged(false);
            path = fxml.getAbsolutePath().replace('\\', '/');
            project.setTitle(fxml.getName());
            if (options.export_images && (fpd = new File(options.patches_dir)).exists() && fpd.isDirectory()) {
                File[] ff = fpd.listFiles();
                boolean rm = true;
                for (int k = 0; k < ff.length; ++k) {
                    if (ff[k].isHidden()) continue;
                    rm = false;
                    break;
                }
                if (rm) {
                    try {
                        fpd.delete();
                    }
                    catch (Exception e) {
                        Utils.log2("Could not delete empty directory " + options.patches_dir);
                        IJError.print(e);
                    }
                }
            }
            Set<String> set = this.stale_files;
            synchronized (set) {
                stales = new ArrayList<String>(this.stale_files);
                this.stale_files.clear();
            }
            for (String stale_path : stales) {
                File f = new File(stale_path);
                if (f.exists()) {
                    if (f.delete()) {
                        Utils.logAll("Deleted stale file at " + stale_path);
                        continue;
                    }
                    Utils.logAll("FAILED to delete stale file at " + stale_path);
                    continue;
                }
                Utils.logAll("Ignoring non-existent stale file " + stale_path);
            }
        }
        catch (Throwable t) {
            IJError.print(t);
        }
        ControlWindow.updateTitle(project);
        return path;
    }

    public void writeXMLTo(Project project, Writer writer, XMLOptions options) throws Exception {
        StringBuilder sb_header = new StringBuilder(30000).append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE ").append(project.getDocType()).append(" [\n");
        project.exportDTD(sb_header, new HashSet<String>(), "\t");
        sb_header.append("] >\n\n");
        writer.write(sb_header.toString());
        sb_header = null;
        project.exportXML(writer, "", options);
        writer.flush();
    }

    protected static long countObjects(LayerSet ls) {
        int count = 1;
        for (Layer la : ls.getLayers()) {
            count += la.getNDisplayables();
            for (Displayable ls2 : la.getDisplayables(LayerSet.class)) {
                count = (int)((long)count + Loader.countObjects((LayerSet)ls2));
            }
        }
        return count;
    }

    public String save(Project project, XMLOptions options) {
        String path = this.saveAs(project, options);
        if (null != path) {
            this.setChanged(false);
        }
        return path;
    }

    public String saveAs(Project project, XMLOptions options) {
        return this.saveAs(project, null, options);
    }

    public String saveAs(Project project, String xmlpath, XMLOptions options) {
        File fxml;
        String storage_dir = this.getStorageFolder();
        String mipmaps_dir = this.getMipMapsFolder();
        File file = fxml = null == xmlpath ? Utils.chooseFile(storage_dir, "untitled.xml", null) : new File(xmlpath);
        if (null == fxml) {
            return null;
        }
        String name = fxml.getName();
        if (!name.endsWith(".xml") && !name.endsWith(".xml.gz")) {
            fxml = new File(Utils.fixDir(fxml.getParent()) + name + ".xml.gz");
        }
        Map<Long, String> copy = this.getPathsCopy();
        this.makeAllPathsRelativeTo(fxml.getAbsolutePath().replace('\\', '/'), project);
        String path = this.export(project, fxml, options);
        if (null != path) {
            this.setChanged(false);
        } else {
            this.restorePaths(copy, mipmaps_dir, storage_dir);
        }
        return path;
    }

    protected void makeAllPathsRelativeTo(String xml_path, Project project) {
    }

    protected Map<Long, String> getPathsCopy() {
        return null;
    }

    protected void restorePaths(Map<Long, String> copy, String mipmaps_folder, String storage_folder) {
    }

    public String saveAs(String path, XMLOptions options) {
        if (null == path) {
            return null;
        }
        options.export_images = this.getClass() != FSLoader.class;
        return this.export(Project.findProject(this), new File(path), options);
    }

    private String extractRelativeFolderPath(File fxml) {
        try {
            String patches_dir = Utils.fixDir(fxml.getParent()) + fxml.getName();
            if (patches_dir.toLowerCase().lastIndexOf(".xml") == patches_dir.length() - 4) {
                patches_dir = patches_dir.substring(0, patches_dir.lastIndexOf(46));
            }
            return patches_dir + "_images";
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    protected String makePatchesDir(File fxml) {
        String patches_dir = this.extractRelativeFolderPath(fxml);
        if (null == patches_dir) {
            return null;
        }
        File dir = new File(patches_dir);
        String patches_dir2 = null;
        int i = 1;
        while (dir.exists()) {
            patches_dir2 = patches_dir + "_" + Integer.toString(i);
            dir = new File(patches_dir2);
            ++i;
        }
        if (null != patches_dir2) {
            patches_dir = patches_dir2;
        }
        try {
            dir.mkdir();
        }
        catch (Exception e) {
            IJError.print(e);
            Utils.showMessage("Could not create a directory for the images.");
            return null;
        }
        return Utils.fixDir(patches_dir);
    }

    public String exportImage(Patch patch, String path, boolean overwrite) {
        return this.exportImage(patch, this.fetchImagePlus(patch), path, overwrite);
    }

    public String exportImage(Patch patch, ImagePlus imp, String path, boolean overwrite) {
        if (null == path || null == imp || !overwrite && new File(path).exists()) {
            return null;
        }
        try {
            if (imp.getNSlices() > 1) {
                new FileSaver(imp).saveAsTiffStack(path);
            } else {
                new FileSaver(imp).saveAsTiff(path);
            }
        }
        catch (Exception e) {
            Utils.log("Could not save an image for Patch #" + patch.getId() + " at: " + path);
            IJError.print(e);
            return null;
        }
        return path;
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanged(boolean changed) {
        this.changes = changed;
    }

    public String getPath(Patch patch) {
        return null;
    }

    public String getAbsolutePath(Patch patch) {
        return null;
    }

    public String getImageFilePath(Patch p) {
        return null;
    }

    public void setupMenuItems(JMenu menu, Project project) {
    }

    public Bureaucrat saveTask(Project project, String command) {
        return project.saveTask(command);
    }

    public boolean isAsynchronous() {
        return this.getClass() == FSLoader.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decache(ImagePlus imp) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                long id = this.mawts.seqFindId(imp);
                Utils.log2("decaching " + id);
                if (Long.MIN_VALUE == id) {
                    return;
                }
                this.mawts.removeAndFlushPyramid(id);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    protected boolean mapIntensities(Patch p, ImagePlus imp) {
        Utils.log("Mapping intensities not implemented for this loader (patch " + p.getTitle() + ").");
        return false;
    }

    public boolean clearIntensityMap(Patch p) {
        Utils.log("Clearing intensity maps not implemented for this loader (patch " + p.getTitle() + ").");
        return false;
    }

    protected final ImagePlus preProcess(Patch p, ImagePlus imp, long image_n_bytes) {
        if (null == p) {
            return imp;
        }
        try {
            IFilter[] fs;
            String path = this.preprocessors.get(p);
            boolean update = false;
            if (null != path) {
                File f = new File(path);
                if (!f.exists()) {
                    Utils.log("ERROR: preprocessor script file does NOT exist: " + path);
                    return imp;
                }
                if (!f.canRead()) {
                    Utils.log("ERROR: can NOT read preprocessor script file at: " + path);
                    return imp;
                }
                if (null == imp) {
                    imp = new ImagePlus();
                } else {
                    imp.getProcessor().setMinAndMax(p.getMin(), p.getMax());
                }
                this.releaseToFit(Math.min(10L * image_n_bytes, MAX_MEMORY / 4L));
                PatchScript.run(p, imp, path);
                if (null != imp.getProcessor() && null != imp.getProcessor().getPixels() && imp.getWidth() > 0 && imp.getHeight() > 0) {
                    update = true;
                } else {
                    Utils.log("ERROR: preprocessor script failed to create a valid image:\n  ImageProcessor: " + imp.getProcessor() + "\n  pixel array: " + (null == imp.getProcessor() ? null : imp.getProcessor().getPixels()) + "\n  width: " + imp.getWidth() + "\n  height: " + imp.getHeight());
                }
            }
            if (null != (fs = p.getFilters()) && fs.length > 0) {
                ImageProcessor ip = imp.getProcessor();
                for (IFilter filter : fs) {
                    ip = filter.process(ip);
                }
                if (ip != imp.getProcessor()) {
                    imp.setProcessor(ip);
                }
                update = true;
            }
            if (update |= this.mapIntensities(p, imp)) {
                FileInfo fi = imp.getOriginalFileInfo();
                if (null != fi) {
                    fi.fileFormat = -999999;
                }
                this.cache(p, imp);
                p.updatePixelProperties(imp);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return imp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Bureaucrat burro) {
        ArrayList<Bureaucrat> arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.add(burro);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(Bureaucrat burro) {
        ArrayList<Bureaucrat> arrayList = this.jobs;
        synchronized (arrayList) {
            if (null != this.popup_jobs && this.popup_jobs.isVisible()) {
                this.popup_jobs.setVisible(false);
            }
            this.jobs.remove(burro);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPopupMenu getJobsPopup(Display display) {
        ArrayList<Bureaucrat> arrayList = this.jobs;
        synchronized (arrayList) {
            this.popup_jobs = new JPopupMenu("Cancel jobs:");
            int i = 1;
            for (Bureaucrat burro : this.jobs) {
                JMenuItem item = new JMenuItem("Job " + i + ": " + burro.getTaskName());
                item.addActionListener(display);
                this.popup_jobs.add(item);
                ++i;
            }
        }
        return this.popup_jobs;
    }

    public void quitJob(final String name) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setPriority(5);
                Bureaucrat burro = null;
                ArrayList arrayList = Loader.this.jobs;
                synchronized (arrayList) {
                    if (null == name && Loader.this.jobs.size() > 0) {
                        burro = (Bureaucrat)Loader.this.jobs.get(Loader.this.jobs.size() - 1);
                    } else {
                        int i = Integer.parseInt(name.substring(4, name.indexOf(58)));
                        if (i >= 1 && i <= Loader.this.jobs.size()) {
                            burro = (Bureaucrat)Loader.this.jobs.get(i - 1);
                        }
                    }
                }
                if (null != burro) {
                    burro.quit();
                }
                arrayList = Loader.this.jobs;
                synchronized (arrayList) {
                    Loader.this.popup_jobs = null;
                }
                Utils.showStatus("Job canceled.", false);
            }
        }.start();
    }

    public static final void printMemState() {
        StringBuilder sb = new StringBuilder("mem in use: ").append((float)IJ.currentMemory() * 100.0f / (float)MAX_MEMORY).append("%\n");
        int i = 0;
        for (Loader lo : (Vector)v_loaders.clone()) {
            long b = lo.mawts.getBytes();
            long mb = lo.mawts.getMaxBytes();
            sb.append(++i).append(": cache size: ").append(b).append(" / ").append(mb).append(" (").append((float)(100L * b) / (float)mb).append("%)").append(" (ids: ").append(lo.mawts.size()).append(')');
        }
        Utils.log2(sb.toString());
    }

    protected final ImagePlus openImage(String path) {
        if (null == path) {
            return null;
        }
        try {
            if (path.startsWith("//")) {
                path = path.replace('/', '\\');
            }
            Utils.log2("opening image " + path);
            return this.openImagePlus(path, 0);
        }
        catch (Exception e) {
            Utils.log("Could not open image at " + path);
            e.printStackTrace();
            return null;
        }
    }

    public final ImagePlus openImagePlus(String path) {
        return this.openImagePlus(path, 0);
    }

    private final ImagePlus openImagePlus(String path, int retries) {
        while (retries < 3) {
            try {
                IJ.redirectErrorMessages();
                ImagePlus imp = this.opener.openImage(path);
                if (null != imp) {
                    imp.killRoi();
                }
                return imp;
            }
            catch (OutOfMemoryError oome) {
                Utils.log2("openImagePlus: recovering from OutOfMemoryError");
                this.recoverOOME();
                Thread.yield();
                ++retries;
            }
            catch (Throwable t) {
                IJError.print(t);
                break;
            }
        }
        return null;
    }

    protected final String getInternalFileName(Patch p) {
        int i;
        String path = this.getAbsolutePath(p);
        if (null == path) {
            return null;
        }
        for (i = path.length() - 1; i > -1 && '/' != path.charAt(i); --i) {
        }
        return path.substring(i + 1);
    }

    public final String getFileName(Patch p) {
        String name = this.getInternalFileName(p);
        int i = name.lastIndexOf("-----#slice=");
        if (-1 == i) {
            return name;
        }
        return name.substring(0, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSnapPaintable(long id) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                return this.mawts.contains(id);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
                return false;
            }
        }
    }

    public void setMipMapsRegeneration(boolean b) {
        Project.findProject(this).setProperty("mipmaps_regen", Boolean.toString(b));
        this.mipmaps_regen = b;
    }

    public boolean isMipMapsRegenerationEnabled() {
        return this.mipmaps_regen && this.usesMipMapsFolder();
    }

    public boolean getMipMapsRegenerationEnabled() {
        return this.mipmaps_regen;
    }

    public void flushMipMaps(boolean forget_dir_mipmaps) {
    }

    public void flushMipMaps(long id) {
    }

    protected boolean generateMipMaps(Patch patch) {
        return false;
    }

    public Future<Boolean> removeMipMaps(Patch patch) {
        return null;
    }

    public Bureaucrat generateMipMaps(ArrayList<Displayable> al) {
        return this.generateMipMaps(al, false);
    }

    public Bureaucrat generateMipMaps(ArrayList<Displayable> al, boolean overwrite) {
        return null;
    }

    public boolean usesMipMapsFolder() {
        return false;
    }

    public int getClosestMipMapLevel(Patch patch, int level, int max_level) {
        return 0;
    }

    protected MipMapImage fetchMipMapAWT(Patch patch, int level, long n_bytes) {
        return null;
    }

    public boolean checkMipMapFileExists(Patch p, double magnification) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustChannels(Patch p, int old_channels) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.removeAndFlushPyramid(p.getId());
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    protected final void handleCacheError(Throwable t) {
        Utils.log("ERROR with image cache!");
        IJError.print(t);
        try {
            this.mawts.removeAndFlushAll();
        }
        catch (Throwable tt) {
            Utils.log("FAILED to recover image cache error: " + tt + "\nPlease save and reopen project!");
        }
    }

    public static ImageProcessor scaleImage(ImagePlus imp, double mag, boolean quality) {
        if (mag > 1.0) {
            mag = 1.0;
        }
        Object ip = imp.getProcessor();
        if (Math.abs(mag - 1.0) < 1.0E-6) {
            return ip;
        }
        int w = ip.getWidth();
        int h = ip.getHeight();
        if (quality) {
            double sigma = Math.sqrt(Math.pow(2.0, Loader.getMipMapLevel(mag, Math.max(imp.getWidth(), imp.getHeight()))) - 0.25);
            ip = new FloatProcessorT2(w, h, ImageFilter.computeGaussianFastMirror((FloatArray2D)new FloatArray2D((float[])((float[])ip.convertToFloat().getPixels()), (int)w, (int)h), (double)((double)((float)sigma))).data, ip.getDefaultColorModel(), ip.getMin(), ip.getMax());
            ip = ip.resize((int)((double)w * mag), (int)((double)h * mag));
            return Utils.convertTo(ip, imp.getType(), false);
        }
        return ip.resize((int)((double)w * mag), (int)((double)h * mag));
    }

    public static ImageProcessor scaleImage(ImagePlus imp, int level, boolean quality) {
        if (level <= 0) {
            return imp.getProcessor();
        }
        Object ip = imp.getProcessor();
        int w = ip.getWidth();
        int h = ip.getHeight();
        double mag = 1.0 / Math.pow(2.0, level);
        if (quality) {
            double sigma = Math.sqrt(Math.pow(2.0, level) - 0.25);
            ip = new FloatProcessorT2(w, h, ImageFilter.computeGaussianFastMirror((FloatArray2D)new FloatArray2D((float[])((float[])ip.convertToFloat().getPixels()), (int)w, (int)h), (double)((double)((float)sigma))).data, ip.getDefaultColorModel(), ip.getMin(), ip.getMax());
            ip = ip.resize((int)((double)w * mag), (int)((double)h * mag));
            return Utils.convertTo(ip, imp.getType(), false);
        }
        return ip.resize((int)((double)w * mag), (int)((double)h * mag));
    }

    public boolean serialize(Object ob, String path) {
        try {
            File fdir = new File(path).getParentFile();
            if (null == fdir) {
                return false;
            }
            fdir.mkdirs();
            if (!fdir.exists()) {
                Utils.log2("Could not create folder " + fdir.getAbsolutePath());
                return false;
            }
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(path));
            out.writeObject(ob);
            out.close();
            return true;
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
    }

    public Object deserialize(String path) {
        try {
            if (!new File(path).exists()) {
                return null;
            }
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(path));
            Object ob = in.readObject();
            in.close();
            return ob;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void insertXMLOptions(StringBuilder sb_body, String indent) {
    }

    public Bureaucrat enhanceContrast(final Collection<Layer> layers) {
        if (null == layers || 0 == layers.size()) {
            return null;
        }
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Enhancing contrast"){

            @Override
            public void exec() {
                ContrastEnhancerWrapper cew = new ContrastEnhancerWrapper();
                if (!cew.showDialog()) {
                    return;
                }
                cew.applyLayerWise(layers);
                cew.shutdown();
            }
        }, layers.iterator().next().getProject());
    }

    public Bureaucrat enhanceContrast(final Collection<Displayable> patches, final Patch reference) {
        if (null == patches || 0 == patches.size()) {
            return null;
        }
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Enhancing contrast"){

            @Override
            public void exec() {
                ContrastEnhancerWrapper cew = new ContrastEnhancerWrapper(reference);
                if (!cew.showDialog()) {
                    return;
                }
                cew.apply(patches);
                cew.shutdown();
            }
        }, patches.iterator().next().getProject());
    }

    public Bureaucrat setMinAndMax(final Collection<? extends Displayable> patches, final double min, final double max) {
        Worker worker = new Worker("Set min and max"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.startedWorking();
                    if (Double.isNaN(min) || Double.isNaN(max)) {
                        Utils.log("WARNING:\nUnacceptable min and max values: " + min + ", " + max);
                        this.finishedWorking();
                        return;
                    }
                    ArrayList fus = new ArrayList();
                    for (Displayable d : patches) {
                        if (d.getClass() != Patch.class) continue;
                        Patch p = (Patch)d;
                        p.setMinAndMax(min, max);
                        fus.add(Loader.this.regenerateMipMaps(p));
                    }
                    Utils.wait(fus);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                finally {
                    this.finishedWorking();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, Project.findProject(this));
    }

    public long estimateImageFileSize(Patch p, int level) {
        if (0 == level) {
            return (long)(p.getWidth() * p.getHeight() * 5.0f + 1024.0f);
        }
        double scale = 1.0 / Math.pow(2.0, level);
        return (long)((double)p.getWidth() * scale * (double)p.getHeight() * scale * 5.0 + 1024.0);
    }

    public static final void flush(ImagePlus imp) {
        if (null == imp) {
            return;
        }
        Roi roi = imp.getRoi();
        if (null != roi) {
            roi.setImage(null);
        }
        ipa.notifyListeners(imp, 1);
    }

    public String getStorageFolder() {
        return System.getProperty("user.home").replace('\\', '/');
    }

    public String getImageStorageFolder() {
        return this.getStorageFolder();
    }

    public String getMipMapsFolder() {
        return null;
    }

    public Patch addNewImage(ImagePlus imp) {
        return this.addNewImage(imp, 0.0, 0.0);
    }

    public Patch addNewImage(ImagePlus imp, double x, double y) {
        String filename = imp.getTitle();
        if (!filename.toLowerCase().endsWith(".tif")) {
            filename = filename + ".tif";
        }
        String path = this.getStorageFolder() + "/" + filename;
        new FileSaver(imp).saveAsTiff(path);
        Patch pa = new Patch(Project.findProject(this), imp.getTitle(), x, y, imp);
        this.addedPatchFrom(path, pa);
        if (this.isMipMapsRegenerationEnabled()) {
            this.regenerateMipMaps(pa);
        }
        return pa;
    }

    public String makeProjectName() {
        return "Untitled " + ControlWindow.getTabIndex(Project.findProject(this));
    }

    public static void setupPreloaderThreads(int count) {
        num_preloader_threads = count;
        if (null != preloader) {
            preloader.shutdownNow();
        }
        if (num_preloader_threads < 1) {
            Utils.log("Disabling preloading threads.");
            num_preloader_threads = 0;
            return;
        }
        if (num_preloader_threads > 4) {
            Utils.log("WARNING: setting preloader threads to more than the recommended maximum of " + Math.min(4, Runtime.getRuntime().availableProcessors() - 1) + ": " + num_preloader_threads);
        }
        preloader = Utils.newFixedThreadPool(num_preloader_threads);
    }

    public static final void setupPreloader(ControlWindow master) {
        if (num_preloader_threads < 1) {
            return;
        }
        if (null == preloader) {
            preloader = Utils.newFixedThreadPool(num_preloader_threads, "preloader");
        }
    }

    public static final void destroyPreloader(ControlWindow master) {
        preloads.clear();
        if (null != preloader) {
            preloader.shutdownNow();
            preloader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preload(final Collection<Patch> patches, final double mag, final boolean repaint) {
        if (low_memory_conditions || num_preloader_threads < 1) {
            return;
        }
        if (null != preloader) {
            return;
        }
        Loader.setupPreloader(null);
        Collection<FutureTask<MipMapImage>> collection = preloads;
        synchronized (collection) {
            for (FutureTask<MipMapImage> fu : preloads) {
                fu.cancel(false);
            }
        }
        preloads.clear();
        try {
            preloader.submit(new Runnable(){

                @Override
                public void run() {
                    for (Patch p : patches) {
                        Loader.preload(p, mag, repaint);
                    }
                }
            });
        }
        catch (Throwable t) {
            Utils.log2("Ignoring error with preloading");
        }
    }

    public static final FutureTask<MipMapImage> preload(final Patch p, final double mag, final boolean repaint) {
        FutureTask[] fu;
        if (low_memory_conditions || num_preloader_threads < 1) {
            return null;
        }
        fu = new FutureTask[]{new FutureTask<MipMapImage>(new Callable<MipMapImage>(){

            @Override
            public MipMapImage call() {
                block11: {
                    try {
                        if (p.getProject().getLoader().hs_unloadable.contains(p)) {
                            MipMapImage mipMapImage = null;
                            return mipMapImage;
                        }
                        if (repaint) {
                            if (Display.willPaint(p)) {
                                MipMapImage mipMap = p.getProject().getLoader().fetchImage(p, mag);
                                if (null != mipMap && !Loader.isSignalImage(mipMap.image) && p.getProject().getLoader().isCached(p, mag)) {
                                    Display.repaint(p.getLayer(), p, p.getBoundingBox(null), 1, true, false);
                                }
                                MipMapImage mipMapImage = mipMap;
                                return mipMapImage;
                            }
                            break block11;
                        }
                        MipMapImage mipMap = p.getProject().getLoader().fetchImage(p, mag);
                        return mipMap;
                    }
                    catch (Throwable t) {
                        IJError.print(t);
                    }
                    finally {
                        preloads.remove(fu[0]);
                    }
                }
                return null;
            }
        })};
        try {
            preloads.add(fu[0]);
            preloader.submit(fu[0]);
        }
        catch (Throwable t) {
            Utils.log2("Ignoring error with preloading a Patch");
        }
        return fu[0];
    }

    public static final int getHighestMipMapLevel(Patch p) {
        return (int)(0.5 + (Math.log(Math.min(p.getWidth(), p.getHeight())) - Math.log(64.0)) / Math.log(2.0));
    }

    public static final int getHighestMipMapLevel(double size) {
        return (int)(0.5 + (Math.log(size) - Math.log(64.0)) / Math.log(2.0));
    }

    public static final String getMipMapModeName(int mode) {
        String s = MIPMAP_MODES.get(mode);
        return null == s ? MIPMAP_MODES.get(6) : s;
    }

    public static final int getMipMapModeIndex(String mode) {
        if (null == mode) {
            return 6;
        }
        String lmode = mode.toLowerCase();
        for (Map.Entry<Integer, String> e : MIPMAP_MODES.entrySet()) {
            if (!e.getValue().toLowerCase().equals(lmode)) continue;
            return e.getKey();
        }
        return 6;
    }

    public Bureaucrat generateLayerMipMaps(Layer[] la, int starting_level) {
        return null;
    }

    public void recoverOOME() {
        long start;
        this.releaseToFit(IJ.maxMemory() / 2L);
        long end = start = System.currentTimeMillis();
        long startmem = IJ.currentMemory();
        for (int i = 0; i < 3; ++i) {
            System.gc();
            Thread.yield();
            end = System.currentTimeMillis();
            if (end - start > 2000L || IJ.currentMemory() < startmem) break;
            start = end;
        }
    }

    public static boolean canReadAndWriteTo(String dir) {
        File fsf = new File(dir);
        return fsf.canWrite() && fsf.canRead();
    }

    public String setImageFile(Patch p, ImagePlus imp) {
        return null;
    }

    public boolean isUnloadable(Displayable p) {
        return this.hs_unloadable.contains(p);
    }

    public void removeFromUnloadable(Displayable p) {
        this.hs_unloadable.remove(p);
    }

    protected static final int[] embedAlpha(int[] pix, byte[] alpha) {
        return Loader.embedAlpha(pix, alpha, null);
    }

    protected static final int[] embedAlpha(int[] pix, byte[] alpha, byte[] outside) {
        if (null == outside) {
            if (null == alpha) {
                return pix;
            }
            for (int i = 0; i < pix.length; ++i) {
                pix[i] = pix[i] & 0xFFFFFF | (alpha[i] & 0xFF) << 24;
            }
        } else {
            for (int i = 0; i < pix.length; ++i) {
                pix[i] = pix[i] & 0xFFFFFF | ((outside[i] & 0xFF) != 255 ? 0 : (alpha[i] & 0xFF) << 24);
            }
        }
        return pix;
    }

    public static final int[] embedAlphaPre(int[] pix, byte[] alpha, byte[] outside) {
        if (null == outside) {
            for (int i = 0; i < pix.length; ++i) {
                int a = alpha[i] & 0xFF;
                double K = (double)a / 255.0;
                int p = pix[i];
                pix[i] = (int)((double)(p >> 16 & 0xFF) * K) << 16 | (int)((double)(p >> 8 & 0xFF) * K) << 8 | (int)((double)(p & 0xFF) * K) | a << 24;
            }
        } else {
            for (int i = 0; i < pix.length; ++i) {
                if (-1 == outside[i]) {
                    int a = alpha[i] & 0xFF;
                    double K = (double)a / 255.0;
                    int p = pix[i];
                    pix[i] = (int)((double)(p >> 16 & 0xFF) * K) << 16 | (int)((double)(p >> 8 & 0xFF) * K) << 8 | (int)((double)(p & 0xFF) * K) | a << 24;
                    continue;
                }
                pix[i] = 0;
            }
        }
        return pix;
    }

    public void queueForMipmapRemoval(Patch p, boolean yes) {
    }

    public void tagForMipmapRemoval(Patch p, boolean yes) {
    }

    public String getUNUId() {
        return Long.toString(System.currentTimeMillis());
    }

    public String getUNUIdFolder() {
        return "trakem2." + this.getUNUId() + "/";
    }

    public Future<Boolean> regenerateMipMaps(Patch patch) {
        return null;
    }

    public Bureaucrat regenerateMipMaps(Collection<? extends Displayable> patches) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getDimensions(String path) {
        ChannelSeparator fr = null;
        try {
            fr = new ChannelSeparator();
            fr.setGroupFiles(false);
            fr.setId(path);
            Dimension dimension = new Dimension(fr.getSizeX(), fr.getSizeY());
            return dimension;
        }
        catch (FormatException fe) {
            Utils.log("Error in reading image file at " + path + "\n" + (Object)((Object)fe));
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            if (null != fr) {
                try {
                    fr.close();
                }
                catch (IOException ioe) {
                    Utils.log2("Could not close IFormatReader: " + ioe);
                }
            }
        }
        return null;
    }

    public Dimension getDimensions(Patch p) {
        String path = this.getAbsolutePath(p);
        int i = path.lastIndexOf("-----#slice=");
        if (-1 != i) {
            path = path.substring(0, i);
        }
        return Loader.getDimensions(path);
    }

    public void setPreprocessorScriptPath(Patch p, String path) {
        this.setPreprocessorScriptPathSilently(p, path);
        this.decacheImagePlus(p.getId());
    }

    public void setPreprocessorScriptPathSilently(Patch p, String path) {
        if (null == path) {
            this.preprocessors.remove(p);
        } else {
            this.preprocessors.put(p, path);
        }
    }

    public String getPreprocessorScriptPath(Patch p) {
        return this.preprocessors.get(p);
    }

    public String makeRelativePath(String path) {
        return path;
    }

    public String getParentFolder() {
        return null;
    }

    public <T> Future<T> doLater(Callable<T> fn) {
        return this.exec.submit(fn);
    }

    public void doGUILater(boolean swing, Runnable fn) {
        this.guiExec.exec(fn, swing);
    }

    public Bureaucrat maskBordersLayerWise(final Collection<Layer> layers, final int left, final int top, final int right, final int bottom) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Crop borders"){

            @Override
            public void exec() {
                ArrayList fus = new ArrayList();
                for (Layer layer : layers) {
                    fus.addAll(Loader.this.maskBorders(left, top, right, bottom, layer.getDisplayables(Patch.class)));
                }
                Utils.wait(fus);
            }
        }, layers.iterator().next().getProject());
    }

    public Bureaucrat maskBorders(final Collection<Displayable> patches, final int left, final int top, final int right, final int bottom) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Crop borders"){

            @Override
            public void exec() {
                Utils.wait(Loader.this.maskBorders(left, top, right, bottom, patches));
            }
        }, patches.iterator().next().getProject());
    }

    public ArrayList<Future<?>> maskBorders(int left, int top, int right, int bottom, Collection<Displayable> patches) {
        ArrayList fus = new ArrayList();
        for (Displayable d : patches) {
            Patch p;
            if (d.getClass() != Patch.class || !(p = (Patch)d).maskBorder(left, top, right, bottom)) continue;
            fus.add(this.regenerateMipMaps(p));
        }
        return fus;
    }

    public <I> ImagePlus createFlyThrough(List<? extends Region<I>> regions, final double magnification, final int type, String dir) {
        ThreadPoolExecutor ex = Utils.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), "fly-through");
        ArrayList<Future<ImagePlus>> fus = new ArrayList<Future<ImagePlus>>();
        for (final Region<I> r : regions) {
            fus.add(ex.submit(new Callable<ImagePlus>(){

                @Override
                public ImagePlus call() {
                    return Loader.this.getFlatImage(r.layer, r.r, magnification, -1, type, Displayable.class, null, true, Color.black);
                }
            }));
        }
        Region<I> r = regions.get(0);
        int w = (int)((double)r.r.width * magnification);
        int h = (int)((double)r.r.height * magnification);
        int size = regions.size();
        ImageStack stack = null == dir ? new ImageStack(w, h) : new VirtualStack(w, h, null, dir);
        int digits = Integer.toString(size).length();
        for (int i = 0; i < size; ++i) {
            try {
                if (Thread.currentThread().isInterrupted()) {
                    ex.shutdownNow();
                    return null;
                }
                if (null == dir) {
                    stack.addSlice(regions.get((int)i).layer.toString(), ((ImagePlus)((Future)fus.get(i)).get()).getProcessor());
                    continue;
                }
                StringBuilder name = new StringBuilder().append(i);
                while (name.length() < digits) {
                    name.insert(0, '0');
                }
                name.append(".png");
                String filename = name.toString();
                new FileSaver((ImagePlus)((Future)fus.get(i)).get()).saveAsPng(dir + filename);
                ((VirtualStack)stack).addSlice(filename);
                continue;
            }
            catch (Throwable t) {
                IJError.print(t);
            }
        }
        ex.shutdown();
        return new ImagePlus("Fly-Through", stack);
    }

    public <I> ImagePlus createLazyFlyThrough(List<? extends Region<I>> regions, final double magnification, final int type, final Displayable active) {
        Region<I> first = regions.get(0);
        int w = (int)((double)first.r.width * magnification);
        int h = (int)((double)first.r.height * magnification);
        LazyVirtualStack stack = new LazyVirtualStack(w, h, regions.size());
        for (final Region<I> r : regions) {
            stack.addSlice(new Callable<ImageProcessor>(){

                @Override
                public ImageProcessor call() {
                    return Loader.this.getFlatImage(r.layer, r.r, magnification, -1, type, Displayable.class, null, true, Color.black, active).getProcessor();
                }
            });
        }
        return new ImagePlus("Fly-Through", (ImageStack)stack);
    }

    public boolean setMipMapFormat(int format) {
        return false;
    }

    public int getMipMapFormat() {
        return -1;
    }

    public Bureaucrat updateMipMapsFormat(int old_format, int new_format) {
        return null;
    }

    public boolean deleteStaleFiles(boolean coordinate_transforms, boolean alpha_masks) {
        return false;
    }

    public String getCoordinateTransformsFolder() {
        return null;
    }

    public String getMasksFolder() {
        return null;
    }

    public long getNextBlobId() {
        return 0L;
    }

    static {
        Graphics2D g = NOT_FOUND.createGraphics();
        g.setColor(Color.white);
        g.drawRect(1, 1, 8, 8);
        g.drawLine(3, 3, 7, 7);
        g.drawLine(7, 3, 3, 7);
        REGENERATING = new BufferedImage(10, 10, 13, GRAY_LUT);
        g = REGENERATING.createGraphics();
        g.setColor(Color.white);
        g.setFont(new Font("SansSerif", 0, 8));
        g.drawString("R", 1, 9);
        heap_fraction = 0.4f;
        HEAPLOCK = new Object();
        v_loaders = new Vector();
        RUNTIME = Runtime.getRuntime();
        MAX_MEMORY = RUNTIME.maxMemory() - 128000000L;
        MIN_FREE_BYTES = Loader.computeDesirableMinFreeBytes();
        low_memory_conditions = false;
        CROSSLOCK = new Object();
        ipa = new ImagePlusAccess();
        preloader = null;
        preloads = new Vector<FutureTask<MipMapImage>>();
        num_preloader_threads = Math.min(4, Runtime.getRuntime().availableProcessors() - 1);
        TreeMap<Integer, String> modes = new TreeMap<Integer, String>();
        modes.put(3, "Gaussian");
        modes.put(6, "Area downsampling");
        MIPMAP_MODES = Collections.unmodifiableSortedMap(modes);
    }

    private static final class ImagePlusAccess
    extends ImagePlus {
        public final void notifyListeners(ImagePlus imp, int action) {
            try {
                for (ImageListener listener : ImagePlus.getListeners()) {
                    switch (action) {
                        case 1: {
                            listener.imageClosed(imp);
                            break;
                        }
                        case 0: {
                            listener.imageOpened(imp);
                            break;
                        }
                        case 2: {
                            listener.imageUpdated(imp);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final class ImageLoadingLock {
        final String key;

        ImageLoadingLock(String key) {
            this.key = key;
        }
    }
}

