/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.mesh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import net.imagej.mesh.Mesh;
import net.imagej.mesh.nio.BufferMesh;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;

class SimplifyMesh {
    private Vector<Triangle> triangles = new Vector();
    private Vector<Vertex> vertices = new Vector();
    private Vector<Ref> refs = new Vector();
    private final Mesh inMesh;
    private final Point p = new Point();

    SimplifyMesh(Mesh mesh) {
        this.inMesh = mesh;
    }

    private void readMesh() {
        this.triangles.clear();
        this.vertices.clear();
        this.refs.clear();
        Point[] meshVerts = new Point[(int)this.inMesh.vertices().size()];
        Iterator<net.imagej.mesh.Vertex> iterator = this.inMesh.vertices().iterator();
        int i = 0;
        while ((long)i < this.inMesh.vertices().size()) {
            Point simpleVertex = new Point();
            simpleVertex.setPosition(iterator.next());
            meshVerts[i] = simpleVertex;
            ++i;
        }
        for (Point meshVert : meshVerts) {
            Vertex v = new Vertex(meshVert);
            this.vertices.add(v);
        }
        int triIndex = 0;
        Iterator<net.imagej.mesh.Triangle> iteratorTriangles = this.inMesh.triangles().iterator();
        int i2 = 0;
        while ((long)i2 < this.inMesh.triangles().size()) {
            net.imagej.mesh.Triangle tria = iteratorTriangles.next();
            Triangle t = new Triangle((int)tria.vertex0(), (int)tria.vertex1(), (int)tria.vertex2());
            this.triangles.add(t);
            this.refs.add(new Ref(triIndex, t.v[0]));
            this.refs.add(new Ref(triIndex, t.v[1]));
            this.refs.add(new Ref(triIndex, t.v[2]));
            ++triIndex;
            ++i2;
        }
    }

    Mesh simplify(float target_percent, double agressiveness) {
        int target_count = (int)((float)this.inMesh.triangles().size() * target_percent);
        return this.simplify(target_count, agressiveness);
    }

    private Mesh simplify(int target_count, double agressiveness) {
        this.readMesh();
        this.triangles.forEach(t -> ((Triangle)t).deleted = false);
        int deleted_triangles = 0;
        Vector<Boolean> deleted0 = new Vector<Boolean>();
        Vector<Boolean> deleted1 = new Vector<Boolean>();
        int triangle_count = this.triangles.size();
        this.p.setPosition(new long[]{0L, 0L, 0L});
        block0: for (int iteration = 0; iteration < 1000 && triangle_count - deleted_triangles > target_count; ++iteration) {
            if (iteration % 5 == 0) {
                this.update_mesh(iteration);
            }
            this.triangles.forEach(t -> ((Triangle)t).dirty = false);
            double threshold = 1.0E-9 * Math.pow((double)iteration + 3.0, agressiveness);
            for (int i = this.triangles.size() - 1; i >= 0; --i) {
                Triangle t2 = this.triangles.get(i);
                if (t2.err[3] > threshold || t2.deleted || t2.dirty) continue;
                for (int j = 0; j < 3; ++j) {
                    if (t2.err[j] >= threshold) continue;
                    int i0 = t2.v[j];
                    int i1 = t2.v[(j + 1) % 3];
                    Vertex v0 = this.vertices.get(i0);
                    Vertex v1 = this.vertices.get(i1);
                    if (v0.border || v1.border) continue;
                    this.p.setPosition(new long[]{0L, 0L, 0L});
                    this.calculate_error(i0, i1, this.p);
                    deleted0.setSize(v0.tcount);
                    deleted1.setSize(v1.tcount);
                    if (this.flipped(this.p, i1, v0, deleted0) || this.flipped(this.p, i0, v1, deleted1)) continue;
                    v0.p.setPosition((RealLocalizable)this.p);
                    v0.q.addLocal(v1.q);
                    int tstart = this.refs.size();
                    deleted_triangles += this.update_triangles(i0, v0, deleted0);
                    deleted_triangles += this.update_triangles(i0, v1, deleted1);
                    int tcount = this.refs.size() - tstart;
                    v0.tstart = tstart;
                    v0.tcount = tcount;
                    break;
                }
                if (triangle_count - deleted_triangles <= target_count) continue block0;
            }
        }
        this.compact_mesh();
        return this.createSimplifiedMesh();
    }

    private boolean flipped(Point p, int i1, Vertex v0, Vector<Boolean> deleted) {
        for (int k = 0; k < v0.tcount; ++k) {
            Point d2;
            Ref ref = this.refs.get(v0.tstart + k);
            Triangle t = this.triangles.get(ref.tid);
            if (t.deleted) continue;
            int s = ref.tvertex;
            int id1 = t.v[(s + 1) % 3];
            int id2 = t.v[(s + 2) % 3];
            if (id1 == i1 || id2 == i1) {
                deleted.set(k, true);
                continue;
            }
            Point d1 = this.vertices.get(id1).p.subtract(p).normalizeLocal();
            if (Math.abs(d1.dot(d2 = this.vertices.get(id2).p.subtract(p).normalizeLocal())) > 0.9999) {
                return true;
            }
            Point n = new Point(d1).crossLocal(d2).normalizeLocal();
            deleted.set(k, false);
            if (!(n.dot(t.n) < 0.2)) continue;
            return true;
        }
        return false;
    }

    private int update_triangles(int i0, Vertex v, Vector<Boolean> deleted) {
        int tris_deleted = 0;
        this.p.setPosition(new long[]{0L, 0L, 0L});
        for (int k = 0; k < v.tcount; ++k) {
            Ref r = this.refs.get(v.tstart + k);
            Triangle t = this.triangles.get(r.tid);
            if (t.deleted) continue;
            if (deleted.get(k).booleanValue()) {
                t.deleted = true;
                ++tris_deleted;
                continue;
            }
            ((Triangle)t).v[((Ref)r).tvertex] = i0;
            t.dirty = true;
            ((Triangle)t).err[0] = this.calculate_error(t.v[0], t.v[1], this.p);
            ((Triangle)t).err[1] = this.calculate_error(t.v[1], t.v[2], this.p);
            ((Triangle)t).err[2] = this.calculate_error(t.v[2], t.v[0], this.p);
            ((Triangle)t).err[3] = Math.min(t.err[0], Math.min(t.err[1], t.err[2]));
            this.refs.add(r);
        }
        return tris_deleted;
    }

    private void update_mesh(int iteration) {
        if (iteration > 0) {
            int dst = 0;
            for (int i = 0; i < this.triangles.size(); ++i) {
                if (this.triangles.get(i).deleted) continue;
                this.triangles.set(dst++, this.triangles.get(i));
            }
            this.triangles.setSize(dst);
        }
        if (iteration == 0) {
            this.vertices.forEach(v -> ((Vertex)v).q.set(new SymmetricMatrix(0.0)));
            this.triangles.forEach(t -> {
                Point[] p = new Point[]{this.vertices.get(((Triangle)t).v[0]).p, this.vertices.get(((Triangle)t).v[1]).p, this.vertices.get(((Triangle)t).v[2]).p};
                Point n = p[1].subtract(p[0]).crossLocal(p[2].subtract(p[0])).normalizeLocal();
                ((Triangle)t).n.setPosition((RealLocalizable)n);
                for (int j = 0; j < 3; ++j) {
                    this.vertices.get(((Triangle)t).v[j]).q.set(this.vertices.get(((Triangle)t).v[j]).q.add(new SymmetricMatrix(n.getFloatPosition(0), n.getFloatPosition(1), n.getFloatPosition(2), -n.dot(p[0]))));
                }
            });
            this.p.setPosition(new long[]{0L, 0L, 0L});
            this.triangles.forEach(t -> {
                for (int j = 0; j < 3; ++j) {
                    ((Triangle)t).err[j] = this.calculate_error(((Triangle)t).v[j], ((Triangle)t).v[(j + 1) % 3], this.p);
                }
                ((Triangle)t).err[3] = Math.min(((Triangle)t).err[0], Math.min(((Triangle)t).err[1], ((Triangle)t).err[2]));
            });
        }
        this.vertices.forEach(v -> {
            ((Vertex)v).tstart = 0;
            ((Vertex)v).tcount = 0;
        });
        this.triangles.forEach(t -> {
            this.vertices.get(((Triangle)t).v[0]).tcount++;
            this.vertices.get(((Triangle)t).v[1]).tcount++;
            this.vertices.get(((Triangle)t).v[2]).tcount++;
        });
        int tstart = 0;
        for (Vertex v2 : this.vertices) {
            v2.tstart = tstart;
            tstart += v2.tcount;
            v2.tcount = 0;
        }
        this.refs.setSize(this.triangles.size() * 3);
        for (int i = 0; i < this.triangles.size(); ++i) {
            Triangle t2 = this.triangles.get(i);
            for (int j = 0; j < 3; ++j) {
                Vertex v3 = this.vertices.get(t2.v[j]);
                this.refs.get(v3.tstart + v3.tcount).tid = i;
                this.refs.get(v3.tstart + v3.tcount).tvertex = j;
                v3.tcount++;
            }
        }
        if (iteration == 0) {
            Vector vcount = new Vector();
            Vector vids = new Vector();
            this.vertices.forEach(v -> ((Vertex)v).border = false);
            this.vertices.forEach(v -> {
                int j;
                vcount.clear();
                vids.clear();
                for (j = 0; j < ((Vertex)v).tcount; ++j) {
                    int k = this.refs.get(((Vertex)v).tstart + j).tid;
                    Triangle t = this.triangles.get(k);
                    for (k = 0; k < 3; ++k) {
                        int ofs;
                        int id = t.v[k];
                        for (ofs = 0; ofs < vcount.size() && (Integer)vids.get(ofs) != id; ++ofs) {
                        }
                        if (ofs == vcount.size()) {
                            vcount.add(1);
                            vids.add(id);
                            continue;
                        }
                        vcount.set(ofs, (Integer)vcount.get(ofs) + 1);
                    }
                }
                for (j = 0; j < vcount.size(); ++j) {
                    if ((Integer)vcount.get(j) != 1) continue;
                    this.vertices.get((Integer)vids.get(j)).border = true;
                }
            });
        }
    }

    private void compact_mesh() {
        int j;
        int dst = 0;
        this.vertices.forEach(v -> ((Vertex)v).tcount = 0);
        for (int i = 0; i < this.triangles.size(); ++i) {
            if (this.triangles.get(i).deleted) continue;
            Triangle t = this.triangles.get(i);
            this.triangles.set(dst++, t);
            for (j = 0; j < 3; ++j) {
                this.vertices.get(t.v[j]).tcount = 1;
            }
        }
        this.triangles.setSize(dst);
        dst = 0;
        for (Vertex vertice : this.vertices) {
            if (vertice.tcount == 0) continue;
            vertice.tstart = dst;
            this.vertices.get(dst).p.setPosition((RealLocalizable)vertice.p);
            ++dst;
        }
        for (Triangle t : this.triangles) {
            for (j = 0; j < 3; ++j) {
                ((Triangle)t).v[j] = this.vertices.get(t.v[j]).tstart;
            }
        }
        this.vertices.setSize(dst);
    }

    private double vertex_error(SymmetricMatrix q, double x, double y, double z) {
        return q.getValue(0) * x * x + 2.0 * q.getValue(1) * x * y + 2.0 * q.getValue(2) * x * z + 2.0 * q.getValue(3) * x + q.getValue(4) * y * y + 2.0 * q.getValue(5) * y * z + 2.0 * q.getValue(6) * y + q.getValue(7) * z * z + 2.0 * q.getValue(8) * z + q.getValue(9);
    }

    private double calculate_error(int id_v1, int id_v2, Point p_result) {
        double error;
        SymmetricMatrix q = this.vertices.get(id_v1).q.add(this.vertices.get(id_v2).q);
        boolean border = this.vertices.get(id_v1).border & this.vertices.get(id_v2).border;
        double det = q.det(0, 1, 2, 1, 4, 5, 2, 5, 7);
        if (det != 0.0 && !border) {
            p_result.setPosition((float)(-1.0 / det * q.det(1, 2, 3, 4, 5, 6, 5, 7, 8)), 0);
            p_result.setPosition((float)(1.0 / det * q.det(0, 2, 3, 1, 5, 6, 2, 7, 8)), 1);
            p_result.setPosition((float)(-1.0 / det * q.det(0, 1, 3, 1, 4, 6, 2, 5, 8)), 2);
            error = this.vertex_error(q, p_result.getFloatPosition(0), p_result.getFloatPosition(1), p_result.getFloatPosition(2));
        } else {
            double error3;
            double error2;
            Point p1 = this.vertices.get(id_v1).p;
            Point p2 = this.vertices.get(id_v2).p;
            Point p3 = p1.add(p2).divide(2.0f);
            double error1 = this.vertex_error(q, p1.getFloatPosition(0), p1.getFloatPosition(1), p1.getFloatPosition(2));
            if (error1 == (error = Math.min(error1, Math.min(error2 = this.vertex_error(q, p2.getFloatPosition(0), p2.getFloatPosition(1), p2.getFloatPosition(2)), error3 = this.vertex_error(q, p3.getFloatPosition(0), p3.getFloatPosition(1), p3.getFloatPosition(2)))))) {
                p_result.setPosition((RealLocalizable)p1);
            }
            if (error2 == error) {
                p_result.setPosition((RealLocalizable)p2);
            }
            if (error3 == error) {
                p_result.setPosition((RealLocalizable)p3);
            }
        }
        return error;
    }

    private Mesh createSimplifiedMesh() {
        Point[] vertArray = new Point[this.vertices.size()];
        for (int i = 0; i < vertArray.length; ++i) {
            Vertex v = this.vertices.get(i);
            vertArray[i] = v.p;
        }
        ArrayList indexList = new ArrayList();
        this.triangles.forEach(t -> {
            indexList.add(((Triangle)t).v[0]);
            indexList.add(((Triangle)t).v[1]);
            indexList.add(((Triangle)t).v[2]);
        });
        BufferMesh mesh = new BufferMesh(vertArray.length, this.triangles.size());
        for (int i = 0; i < vertArray.length; ++i) {
            mesh.vertices().add(vertArray[i].getFloatPosition(0), vertArray[i].getFloatPosition(1), vertArray[i].getFloatPosition(2));
        }
        this.triangles.forEach(triangle -> mesh.triangles().add(((Triangle)triangle).v[0], ((Triangle)triangle).v[1], ((Triangle)triangle).v[2]));
        return mesh;
    }

    private static class Point
    extends RealPoint {
        Point() {
            super(3);
        }

        Point(Point d1) {
            super((RealLocalizable)d1);
        }

        Point subtract(Point p) {
            Point res = new Point(this);
            for (int i = 0; i < this.numDimensions(); ++i) {
                res.setPosition(this.getDoublePosition(i) - p.getDoublePosition(i), i);
            }
            return res;
        }

        Point normalizeLocal() {
            double z;
            double y;
            double x = this.getDoublePosition(0);
            double length = x * x + (y = this.getDoublePosition(1)) * y + (z = this.getDoublePosition(2)) * z;
            if (length != 1.0 && length != 0.0) {
                length = 1.0 / Math.sqrt(length);
                x *= length;
                y *= length;
                z *= length;
            }
            this.setPosition(new double[]{x, y, z});
            return this;
        }

        Point add(Point p) {
            Point res = new Point(this);
            for (int i = 0; i < this.numDimensions(); ++i) {
                res.setPosition(this.getDoublePosition(i) + p.getDoublePosition(i), i);
            }
            return res;
        }

        Point divide(float v) {
            Point res = new Point(this);
            for (int i = 0; i < this.numDimensions(); ++i) {
                res.setPosition(this.getDoublePosition(i) / (double)v, i);
            }
            return res;
        }

        double dot(Point p) {
            return this.getDoublePosition(0) * p.getDoublePosition(0) + this.getDoublePosition(1) * p.getDoublePosition(1) + this.getDoublePosition(2) * p.getDoublePosition(2);
        }

        Point crossLocal(Point p) {
            double x = this.getDoublePosition(0);
            double y = this.getDoublePosition(1);
            double z = this.getDoublePosition(2);
            double otherX = p.getDoublePosition(0);
            double otherY = p.getDoublePosition(1);
            double otherZ = p.getDoublePosition(2);
            double tempx = y * otherZ - z * otherY;
            double tempy = z * otherX - x * otherZ;
            this.setPosition(x * otherY - y * otherX, 2);
            this.setPosition(tempx, 0);
            this.setPosition(tempy, 1);
            return this;
        }
    }

    static class Ref {
        private int tid;
        private int tvertex;

        Ref(int tid, int tvertex) {
            this.tid = tid;
            this.tvertex = tvertex;
        }
    }

    static class Triangle {
        private final int[] v = new int[3];
        private final double[] err = new double[4];
        private boolean deleted = false;
        private boolean dirty = false;
        private final Point n = new Point();

        Triangle(int a, int b, int c) {
            this.v[0] = a;
            this.v[1] = b;
            this.v[2] = c;
        }
    }

    static class Vertex {
        private final Point p;
        private int tstart;
        private int tcount;
        private final SymmetricMatrix q = new SymmetricMatrix(0.0);
        private boolean border;

        Vertex(Point p) {
            this.p = new Point(p);
        }
    }

    static class SymmetricMatrix {
        private final double[] m = new double[10];

        SymmetricMatrix(double c) {
            for (int i = 0; i < 10; ++i) {
                this.m[i] = c;
            }
        }

        SymmetricMatrix(double m11, double m12, double m13, double m14, double m22, double m23, double m24, double m33, double m34, double m44) {
            this.m[0] = m11;
            this.m[1] = m12;
            this.m[2] = m13;
            this.m[3] = m14;
            this.m[4] = m22;
            this.m[5] = m23;
            this.m[6] = m24;
            this.m[7] = m33;
            this.m[8] = m34;
            this.m[9] = m44;
        }

        SymmetricMatrix(double a, double b, double c, double d) {
            this.m[0] = a * a;
            this.m[1] = a * b;
            this.m[2] = a * c;
            this.m[3] = a * d;
            this.m[4] = b * b;
            this.m[5] = b * c;
            this.m[6] = b * d;
            this.m[7] = c * c;
            this.m[8] = c * d;
            this.m[9] = d * d;
        }

        void set(SymmetricMatrix s) {
            System.arraycopy(s.m, 0, this.m, 0, this.m.length);
        }

        final double getValue(int c) {
            return this.m[c];
        }

        final double det(int a11, int a12, int a13, int a21, int a22, int a23, int a31, int a32, int a33) {
            return this.m[a11] * this.m[a22] * this.m[a33] + this.m[a13] * this.m[a21] * this.m[a32] + this.m[a12] * this.m[a23] * this.m[a31] - this.m[a13] * this.m[a22] * this.m[a31] - this.m[a11] * this.m[a23] * this.m[a32] - this.m[a12] * this.m[a21] * this.m[a33];
        }

        final SymmetricMatrix add(SymmetricMatrix n) {
            return new SymmetricMatrix(this.m[0] + n.getValue(0), this.m[1] + n.getValue(1), this.m[2] + n.getValue(2), this.m[3] + n.getValue(3), this.m[4] + n.getValue(4), this.m[5] + n.getValue(5), this.m[6] + n.getValue(6), this.m[7] + n.getValue(7), this.m[8] + n.getValue(8), this.m[9] + n.getValue(9));
        }

        void addLocal(SymmetricMatrix n) {
            this.m[0] = this.m[0] + n.getValue(0);
            this.m[1] = this.m[1] + n.getValue(1);
            this.m[2] = this.m[2] + n.getValue(2);
            this.m[3] = this.m[3] + n.getValue(3);
            this.m[4] = this.m[4] + n.getValue(4);
            this.m[5] = this.m[5] + n.getValue(5);
            this.m[6] = this.m[6] + n.getValue(6);
            this.m[7] = this.m[7] + n.getValue(7);
            this.m[8] = this.m[8] + n.getValue(8);
            this.m[9] = this.m[9] + n.getValue(9);
        }
    }
}

