/*
 * Decompiled with CFR 0.152.
 */
package process;

import fiji.util.node.Leaf;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.models.Point;
import net.imglib2.util.Util;

public class Particle
extends Point
implements Leaf<Particle> {
    private static final long serialVersionUID = 1L;
    protected final int id;
    protected DifferenceOfGaussianPeak<FloatType> peak;
    protected double weight = 1.0;
    protected double distance = -1.0;
    float diameter = 1.0f;
    float zStretching = 1.0f;
    protected boolean useW = true;

    public Particle(int id, DifferenceOfGaussianPeak<FloatType> peak, float zStretching) {
        super(Particle.getSubPixelPosition(peak));
        this.id = id;
        this.peak = peak;
        this.zStretching = zStretching;
        this.restoreCoordinates();
    }

    private static final double[] getSubPixelPosition(DifferenceOfGaussianPeak<FloatType> peak) {
        int n = peak.getNumDimensions();
        double[] p = new double[n];
        for (int d = 0; d < n; ++d) {
            p[d] = peak.getSubPixelPosition(d);
        }
        return p;
    }

    public DifferenceOfGaussianPeak<FloatType> getPeak() {
        return this.peak;
    }

    public void restoreCoordinates() {
        for (int d = 0; d < this.l.length; ++d) {
            this.l[d] = this.w[d] = (double)this.peak.getSubPixelPosition(d);
        }
        if (this.l.length >= 3) {
            this.l[2] = this.l[2] * (double)this.zStretching;
            this.w[2] = this.w[2] * (double)this.zStretching;
        }
    }

    public long getID() {
        return this.id;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setDiameter(float diameter) {
        this.diameter = diameter;
    }

    public float getDiameter() {
        return this.diameter;
    }

    public final void setW(float[] wn) {
        for (int i = 0; i < Math.min(this.w.length, wn.length); ++i) {
            this.w[i] = wn[i];
        }
    }

    public final void resetW() {
        for (int i = 0; i < this.w.length; ++i) {
            this.w[i] = this.l[i];
        }
    }

    public void setUseW(boolean useW) {
        this.useW = useW;
    }

    public boolean getUseW() {
        return this.useW;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public float get(int k) {
        if (this.useW) {
            return (float)this.w[k];
        }
        return (float)this.l[k];
    }

    public void set(float v, int k) {
        if (this.useW) {
            this.w[k] = v;
        } else {
            this.l[k] = v;
        }
    }

    public String toString() {
        return "DustParticle " + this.getID() + " l" + Util.printCoordinates((double[])this.getL()) + "; w" + Util.printCoordinates((double[])this.getW());
    }

    public boolean isLeaf() {
        return true;
    }

    public float distanceTo(Particle o) {
        double distance = 0.0;
        for (int d = 0; d < this.l.length; ++d) {
            double a = o.get(d) - this.get(d);
            distance += a * a;
        }
        return (float)Math.sqrt(distance);
    }

    public Particle[] createArray(int n) {
        return new Particle[n];
    }

    public int getNumDimensions() {
        return this.l.length;
    }

    public boolean equals(Particle o) {
        if (this.useW) {
            for (int d = 0; d < this.l.length; ++d) {
                if (this.w[d] == o.w[d]) continue;
                return false;
            }
        } else {
            for (int d = 0; d < this.l.length; ++d) {
                if (this.l[d] == o.l[d]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(Particle nucleus1, Particle nucleus2) {
        return nucleus1.getID() == nucleus2.getID();
    }
}

