/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.ImgLibUtils;
import fiji.expressionparser.function.ImgLibFunction;
import java.util.Stack;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.floydsteinberg.FloydSteinbergDithering;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class ImgLibDithering<T extends RealType<T>>
extends PostfixMathCommand
implements ImgLibFunction<T> {
    public ImgLibDithering() {
        this.numberOfParameters = -1;
    }

    public boolean checkNumberOfParameters(int n) {
        return n == 1 || n == 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        FloydSteinbergDithering dither = null;
        if (this.curNumberOfParameters == 1) {
            Object param = stack.pop();
            if (!(param instanceof Img)) {
                throw new ParseException("In function " + this.getFunctionString() + ": First argument must be an image, got a " + param.getClass().getSimpleName());
            }
            Img img = (Img)param;
            dither = new FloydSteinbergDithering((RandomAccessibleInterval)img);
        } else {
            Object param2 = stack.pop();
            Object param1 = stack.pop();
            if (!(param1 instanceof Img)) {
                throw new ParseException("In function " + this.getFunctionString() + ": First argument must be an image, got a " + param1.getClass().getSimpleName());
            }
            Img img = (Img)param1;
            if (param2 instanceof RealType) {
                float dither_threshold = ((FloatType)param2).getRealFloat();
                dither = new FloydSteinbergDithering((RandomAccessibleInterval)img, dither_threshold);
            } else {
                throw new ParseException("In function " + this.getFunctionString() + ": Second argument must be a number, got a " + param2.getClass().getSimpleName());
            }
        }
        dither.process();
        Img result = dither.getResult();
        if (result == null) {
            throw new RuntimeException("Floyd-Steinberg dithering unfortunately not available with this version of ImgLib2!");
        }
        Img<FloatType> float_result = ImgLibUtils.copyToFloatTypeImage(result);
        stack.push(float_result);
    }

    @Override
    public String getDocumentationString() {
        return "<h3>Floyd-Steinberg dithering</h3> This function returns a 2 level, dithered version of the input, using the Floyd-Steinberg algorithm (possibily extended to nD). Syntax: <br><code>" + this.getFunctionString() + "(A)</code><br> or <br><code>" + this.getFunctionString() + "(A, thr)</code><br> with A an image and thr the threshold used for dithering. ";
    }

    @Override
    public String getFunctionString() {
        return "dither";
    }
}

