/*
 * Decompiled with CFR 0.152.
 */
package fiji.process;

import fiji.expressionparser.ImgLibParser;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Test_JEP {
    public static <T extends RealType<T> & NativeType<T>> void main(String[] args) {
        System.out.println("Testing JEP extension");
        System.out.println("\nCreating point image.");
        ImagePlus imp = NewImage.createFloatImage((String)"Point", (int)128, (int)128, (int)32, (int)1);
        float[] px = (float[])imp.getStack().getPixels(16);
        px[8256] = 1000.0f;
        ImagePlusImg img = ImagePlusAdapter.wrap((ImagePlus)imp);
        imp.show();
        float max = Float.NEGATIVE_INFINITY;
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < imp.getStackSize(); ++i) {
            ImageProcessor ip = imp.getStack().getProcessor(i + 1);
            for (int index = 0; index < ip.getPixelCount(); ++index) {
                if (ip.getf(index) > max) {
                    max = ip.getf(index);
                }
                if (!(ip.getf(index) < min)) continue;
                min = ip.getf(index);
            }
        }
        System.out.println(String.format("Min and max: %.2f - %.2f", Float.valueOf(min), Float.valueOf(max)));
        System.out.println("\nImage converted to ImgLib: " + img);
        String[] expressions = new String[]{"A * A", "2 * A", "A + A - 2*A", "(2*A-A) / A", "gauss(A,1.5)", "gauss(A,3) > A", "gauss(A,3) == A", "A == A"};
        ImgLibParser parser = new ImgLibParser();
        parser.addStandardFunctions();
        parser.addImgLibAlgorithms();
        for (String expression : expressions) {
            System.err.flush();
            System.out.println("\nTrying expression: " + expression);
            parser.addVariable("A", img);
            try {
                Node root_node = parser.parse(expression);
                System.out.flush();
                Img result = (Img)parser.evaluate(root_node);
                System.out.println("Checking for errors: " + parser.getErrorInfo());
                System.out.println("Resut is: " + result);
                ImagePlus target_imp = ImageJFunctions.show((RandomAccessibleInterval)result);
                target_imp.show();
                max = Float.NEGATIVE_INFINITY;
                min = Float.POSITIVE_INFINITY;
                for (int i = 0; i < target_imp.getStackSize(); ++i) {
                    FloatProcessor fp = (FloatProcessor)target_imp.getStack().getProcessor(i + 1);
                    float[] arr = (float[])fp.getPixels();
                    for (int j = 0; j < arr.length; ++j) {
                        if (arr[j] > max) {
                            max = arr[j];
                        }
                        if (!(arr[j] < min)) continue;
                        min = arr[j];
                    }
                }
                target_imp.setDisplayRange((double)min, (double)max);
                target_imp.updateAndDraw();
                System.out.println(String.format("Min and max: %.2f - %.2f", Float.valueOf(min), Float.valueOf(max)));
            }
            catch (ParseException e) {
                System.out.flush();
                System.err.println("Cound not evaluate expression: " + expression);
                System.err.println("Reason: " + e.getErrorInfo());
            }
            System.err.flush();
            System.out.flush();
        }
    }
}

