/*
 * Decompiled with CFR 0.152.
 */
package io.scif.lifesci;

import io.scif.MetaTable;
import java.io.IOException;
import java.util.StringTokenizer;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

public class SDTInfo {
    public static final short BH_HEADER_CHKSUM = 21930;
    public static final short BH_HEADER_NOT_VALID = 4369;
    public static final short BH_HEADER_VALID = 21845;
    public static final int FIFO_IMAGE_MODE = 13;
    public static final String SETUP_IDENTIFIER = "\u0004SPC Setup Script File\u0004";
    public static final String DATA_IDENTIFIER = "\u0004SPC Setup & Data File\u0004";
    public static final String FLOW_DATA_IDENTIFIER = "\u0004SPC Flow Data File\u0004";
    public static final String DLL_DATA_IDENTIFIER = "\u0004SPC DLL Data File\u0004";
    public static final String FCS_DATA_IDENTIFIER = "\u0004SPC FCS Data File\u0004";
    public static final String X_STRING = "#SP [SP_SCAN_X,I,";
    public static final String Y_STRING = "#SP [SP_SCAN_Y,I,";
    public static final String T_STRING = "#SP [SP_ADC_RE,I,";
    public static final String C_STRING1 = "#SP [SP_SCAN_RX,I,";
    public static final String C_STRING2 = "#SP [SP_SCAN_RY,I,";
    public int width;
    public int height;
    public int timeBins;
    public int channels;
    public int timepoints;
    public short revision;
    public int infoOffs;
    public short infoLength;
    public int setupOffs;
    public short setupLength;
    public int dataBlockOffs;
    public short noOfDataBlocks;
    public int dataBlockLength;
    public int measDescBlockOffs;
    public short noOfMeasDescBlocks;
    public short measDescBlockLength;
    public int headerValid;
    public long reserved1;
    public int reserved2;
    public int chksum;
    public String info;
    public String setup;
    public boolean hasMeasureInfo;
    public String time;
    public String date;
    public String modSerNo;
    public short measMode;
    public float cfdLL;
    public float cfdLH;
    public float cfdZC;
    public float cfdHF;
    public float synZC;
    public short synFD;
    public float synHF;
    public float tacR;
    public short tacG;
    public float tacOF;
    public float tacLL;
    public float tacLH;
    public short adcRE;
    public short ealDE;
    public short ncx;
    public short ncy;
    public int page;
    public float colT;
    public float repT;
    public short stopt;
    public int overfl;
    public short useMotor;
    public int steps;
    public float offset;
    public short dither;
    public short incr;
    public short memBank;
    public String modType;
    public float synTH;
    public short deadTimeComp;
    public short polarityL;
    public short polarityF;
    public short polarityP;
    public short linediv;
    public short accumulate;
    public int flbckY;
    public int flbckX;
    public int bordU;
    public int bordL;
    public float pixTime;
    public short pixClk;
    public short trigger;
    public int scanX;
    public int scanY;
    public int scanRX;
    public int scanRY;
    public short fifoTyp;
    public int epxDiv;
    public int modTypeCode;
    public int modFpgaVer;
    public float overflowCorrFactor;
    public int adcZoom;
    public int cycles;
    public boolean hasMeasStopInfo;
    public int status;
    public int flags;
    public float stopTime;
    public int curStep;
    public int curCycle;
    public int curPage;
    public float minSyncRate;
    public float minCfdRate;
    public float minTacRate;
    public float minAdcRate;
    public float maxSyncRate;
    public float maxCfdRate;
    public float maxTacRate;
    public float maxAdcRate;
    public int mReserved1;
    public float mReserved2;
    public boolean hasMeasFCSInfo;
    public int chan;
    public int fcsDecayCalc;
    public long mtResol;
    public float cortime;
    public long calcPhotons;
    public int fcsPoints;
    public float endTime;
    public int overruns;
    public int fcsType;
    public int crossChan;
    public int mod;
    public int crossMod;
    public long crossMtResol;
    public boolean hasExtendedMeasureInfo;
    public int imageX;
    public int imageY;
    public int imageRX;
    public int imageRY;
    public short xyGain;
    public short masterClock;
    public short adcDE;
    public short detType;
    public short xAxis;
    public boolean hasMeasHISTInfo;
    public float fidaTime;
    public float fildaTime;
    public int fidaPoints;
    public int fildaPoints;
    public float mcsTime;
    public int mcsPoints;
    public short blockNo;
    public int dataOffs;
    public int nextBlockOffs;
    public int blockType;
    public short measDescBlockNo;
    public long lblockNo;
    public long blockLength;

    public SDTInfo(DataHandle<Location> handle, MetaTable meta) throws IOException {
        String token;
        this.revision = handle.readShort();
        this.infoOffs = handle.readInt();
        this.infoLength = handle.readShort();
        this.setupOffs = handle.readInt();
        this.setupLength = handle.readShort();
        this.dataBlockOffs = handle.readInt();
        this.noOfDataBlocks = handle.readShort();
        this.dataBlockLength = handle.readInt();
        this.measDescBlockOffs = handle.readInt();
        this.noOfMeasDescBlocks = handle.readShort();
        this.measDescBlockLength = handle.readShort();
        this.headerValid = handle.readUnsignedShort();
        this.reserved1 = 0xFFFFFFFFL & (long)handle.readInt();
        this.reserved2 = handle.readUnsignedShort();
        this.chksum = handle.readUnsignedShort();
        if (meta != null) {
            String bhfileHeader = "bhfileHeader.";
            meta.put((Object)"bhfileHeader.revision", (Object)new Short(this.revision));
            meta.put((Object)"bhfileHeader.infoOffs", (Object)new Integer(this.infoOffs));
            meta.put((Object)"bhfileHeader.infoLength", (Object)new Short(this.infoLength));
            meta.put((Object)"bhfileHeader.setupOffs", (Object)new Integer(this.setupOffs));
            meta.put((Object)"bhfileHeader.dataBlockOffs", (Object)new Integer(this.dataBlockOffs));
            meta.put((Object)"bhfileHeader.noOfDataBlocks", (Object)new Short(this.noOfDataBlocks));
            meta.put((Object)"bhfileHeader.dataBlockLength", (Object)new Integer(this.dataBlockLength));
            meta.put((Object)"bhfileHeader.measDescBlockOffs", (Object)new Integer(this.measDescBlockOffs));
            meta.put((Object)"bhfileHeader.noOfMeasDescBlocks", (Object)new Short(this.noOfMeasDescBlocks));
            meta.put((Object)"bhfileHeader.measDescBlockLength", (Object)new Integer(this.measDescBlockLength));
            meta.put((Object)"bhfileHeader.headerValid", (Object)new Integer(this.headerValid));
            meta.put((Object)"bhfileHeader.reserved1", (Object)new Long(this.reserved1));
            meta.put((Object)"bhfileHeader.reserved2", (Object)new Integer(this.reserved2));
            meta.put((Object)"bhfileHeader.chksum", (Object)new Integer(this.chksum));
        }
        handle.seek((long)this.infoOffs);
        byte[] infoBytes = new byte[this.infoLength];
        handle.readFully(infoBytes);
        this.info = new String(infoBytes, "UTF-8");
        StringTokenizer st = new StringTokenizer(this.info, "\n");
        int count = st.countTokens();
        st.nextToken();
        String key = null;
        String value = null;
        for (int i = 1; i < count - 1; ++i) {
            token = st.nextToken().trim();
            if (token.indexOf(":") == -1) continue;
            key = token.substring(0, token.indexOf(":")).trim();
            value = token.substring(token.indexOf(":") + 1).trim();
            if (meta == null) continue;
            meta.put((Object)key, (Object)value);
        }
        handle.seek((long)this.setupOffs);
        byte[] setupBytes = new byte[this.setupLength];
        handle.readFully(setupBytes);
        this.setup = new String(setupBytes, "UTF-8");
        st = new StringTokenizer(this.setup, "\n");
        while (st.hasMoreTokens()) {
            int end;
            int ndx;
            token = st.nextToken().trim();
            if (token.startsWith("#SP") || token.startsWith("#DI") || token.startsWith("#PR") || token.startsWith("#MP")) {
                int open = token.indexOf("[");
                key = token.substring(open + 1, token.indexOf(",", open));
                value = token.substring(token.lastIndexOf(",") + 1, token.length() - 1);
            } else if (token.startsWith("#TR") || token.startsWith("#WI")) {
                key = token.substring(0, token.indexOf("[")).trim();
                value = token.substring(token.indexOf("[") + 1, token.indexOf("]"));
            }
            if (key != null && value != null && meta != null) {
                meta.put((Object)key, (Object)value);
            }
            if (token.indexOf(X_STRING) != -1) {
                ndx = token.indexOf(X_STRING) + X_STRING.length();
                end = token.indexOf("]", ndx);
                this.width = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(Y_STRING) != -1) {
                ndx = token.indexOf(Y_STRING) + Y_STRING.length();
                end = token.indexOf("]", ndx);
                this.height = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(T_STRING) != -1) {
                ndx = token.indexOf(T_STRING) + T_STRING.length();
                end = token.indexOf("]", ndx);
                this.timeBins = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(C_STRING1) != -1) {
                ndx = token.indexOf(C_STRING1) + C_STRING1.length();
                end = token.indexOf("]", ndx);
                this.channels = this.nonZeroProduct(this.channels, Integer.parseInt(token.substring(ndx, end)));
                continue;
            }
            if (token.indexOf(C_STRING2) == -1) continue;
            ndx = token.indexOf(C_STRING2) + C_STRING2.length();
            end = token.indexOf("]", ndx);
            this.channels = this.nonZeroProduct(this.channels, Integer.parseInt(token.substring(ndx, end)));
        }
        if (this.noOfMeasDescBlocks > 0) {
            String measureInfo;
            handle.seek((long)this.measDescBlockOffs);
            this.hasMeasureInfo = this.measDescBlockLength >= 211;
            this.hasMeasStopInfo = this.measDescBlockLength >= 271;
            this.hasMeasFCSInfo = this.measDescBlockLength >= 309;
            this.hasExtendedMeasureInfo = this.measDescBlockLength >= 335;
            boolean bl = this.hasMeasHISTInfo = this.measDescBlockLength >= 359;
            if (this.hasMeasureInfo) {
                this.time = handle.readString(9).trim();
                this.date = handle.readString(11).trim();
                this.modSerNo = handle.readString(16).trim();
                this.measMode = handle.readShort();
                this.cfdLL = handle.readFloat();
                this.cfdLH = handle.readFloat();
                this.cfdZC = handle.readFloat();
                this.cfdHF = handle.readFloat();
                this.synZC = handle.readFloat();
                this.synFD = handle.readShort();
                this.synHF = handle.readFloat();
                this.tacR = handle.readFloat();
                this.tacG = handle.readShort();
                this.tacOF = handle.readFloat();
                this.tacLL = handle.readFloat();
                this.tacLH = handle.readFloat();
                this.adcRE = handle.readShort();
                this.ealDE = handle.readShort();
                this.ncx = handle.readShort();
                this.ncy = handle.readShort();
                this.page = handle.readUnsignedShort();
                this.colT = handle.readFloat();
                this.repT = handle.readFloat();
                this.stopt = handle.readShort();
                this.overfl = handle.readUnsignedByte();
                this.useMotor = handle.readShort();
                this.steps = handle.readUnsignedShort();
                this.offset = handle.readFloat();
                this.dither = handle.readShort();
                this.incr = handle.readShort();
                this.memBank = handle.readShort();
                this.modType = handle.readString(16).trim();
                this.synTH = handle.readFloat();
                this.deadTimeComp = handle.readShort();
                this.polarityL = handle.readShort();
                this.polarityF = handle.readShort();
                this.polarityP = handle.readShort();
                this.linediv = handle.readShort();
                this.accumulate = handle.readShort();
                this.flbckY = handle.readInt();
                this.flbckX = handle.readInt();
                this.bordU = handle.readInt();
                this.bordL = handle.readInt();
                this.pixTime = handle.readFloat();
                this.pixClk = handle.readShort();
                this.trigger = handle.readShort();
                this.scanX = handle.readInt();
                this.scanY = handle.readInt();
                this.scanRX = handle.readInt();
                this.scanRY = handle.readInt();
                this.fifoTyp = handle.readShort();
                this.epxDiv = handle.readInt();
                this.modTypeCode = handle.readUnsignedShort();
                this.modFpgaVer = handle.readUnsignedShort();
                this.overflowCorrFactor = handle.readFloat();
                this.adcZoom = handle.readInt();
                this.cycles = handle.readInt();
                this.timepoints = this.stopt;
                if (meta != null) {
                    measureInfo = "MeasureInfo.";
                    meta.put((Object)"MeasureInfo.time", (Object)this.time);
                    meta.put((Object)"MeasureInfo.date", (Object)this.date);
                    meta.put((Object)"MeasureInfo.modSerNo", (Object)this.modSerNo);
                    meta.put((Object)"MeasureInfo.measMode", (Object)new Short(this.measMode));
                    meta.put((Object)"MeasureInfo.cfdLL", (Object)new Float(this.cfdLL));
                    meta.put((Object)"MeasureInfo.cfdLH", (Object)new Float(this.cfdLH));
                    meta.put((Object)"MeasureInfo.cfdZC", (Object)new Float(this.cfdZC));
                    meta.put((Object)"MeasureInfo.cfdHF", (Object)new Float(this.cfdHF));
                    meta.put((Object)"MeasureInfo.synZC", (Object)new Float(this.synZC));
                    meta.put((Object)"MeasureInfo.synFD", (Object)new Short(this.synFD));
                    meta.put((Object)"MeasureInfo.synHF", (Object)new Float(this.synHF));
                    meta.put((Object)"MeasureInfo.tacR", (Object)new Float(this.tacR));
                    meta.put((Object)"MeasureInfo.tacG", (Object)new Short(this.tacG));
                    meta.put((Object)"MeasureInfo.tacOF", (Object)new Float(this.tacOF));
                    meta.put((Object)"MeasureInfo.tacLL", (Object)new Float(this.tacLL));
                    meta.put((Object)"MeasureInfo.tacLH", (Object)new Float(this.tacLH));
                    meta.put((Object)"MeasureInfo.adcRE", (Object)new Short(this.adcRE));
                    meta.put((Object)"MeasureInfo.ealDE", (Object)new Short(this.ealDE));
                    meta.put((Object)"MeasureInfo.ncx", (Object)new Short(this.ncx));
                    meta.put((Object)"MeasureInfo.ncy", (Object)new Short(this.ncy));
                    meta.put((Object)"MeasureInfo.page", (Object)new Integer(this.page));
                    meta.put((Object)"MeasureInfo.colT", (Object)new Float(this.colT));
                    meta.put((Object)"MeasureInfo.repT", (Object)new Float(this.repT));
                    meta.put((Object)"MeasureInfo.stopt", (Object)new Short(this.stopt));
                    meta.put((Object)"MeasureInfo.overfl", (Object)new Integer(this.overfl));
                    meta.put((Object)"MeasureInfo.useMotor", (Object)new Short(this.useMotor));
                    meta.put((Object)"MeasureInfo.steps", (Object)new Integer(this.steps));
                    meta.put((Object)"MeasureInfo.offset", (Object)new Float(this.offset));
                    meta.put((Object)"MeasureInfo.dither", (Object)new Short(this.dither));
                    meta.put((Object)"MeasureInfo.incr", (Object)new Short(this.incr));
                    meta.put((Object)"MeasureInfo.memBank", (Object)new Short(this.memBank));
                    meta.put((Object)"MeasureInfo.modType", (Object)this.modType);
                    meta.put((Object)"MeasureInfo.synTH", (Object)new Float(this.synTH));
                    meta.put((Object)"MeasureInfo.deadTimeComp", (Object)new Short(this.deadTimeComp));
                    meta.put((Object)"MeasureInfo.polarityL", (Object)new Short(this.polarityL));
                    meta.put((Object)"MeasureInfo.polarityF", (Object)new Short(this.polarityF));
                    meta.put((Object)"MeasureInfo.polarityP", (Object)new Short(this.polarityP));
                    meta.put((Object)"MeasureInfo.linediv", (Object)new Short(this.linediv));
                    meta.put((Object)"MeasureInfo.accumulate", (Object)new Short(this.accumulate));
                    meta.put((Object)"MeasureInfo.flbckY", (Object)new Integer(this.flbckY));
                    meta.put((Object)"MeasureInfo.flbckX", (Object)new Integer(this.flbckX));
                    meta.put((Object)"MeasureInfo.bordU", (Object)new Integer(this.bordU));
                    meta.put((Object)"MeasureInfo.bordL", (Object)new Integer(this.bordL));
                    meta.put((Object)"MeasureInfo.pixTime", (Object)new Float(this.pixTime));
                    meta.put((Object)"MeasureInfo.pixClk", (Object)new Short(this.pixClk));
                    meta.put((Object)"MeasureInfo.trigger", (Object)new Short(this.trigger));
                    meta.put((Object)"MeasureInfo.scanX", (Object)new Integer(this.scanX));
                    meta.put((Object)"MeasureInfo.scanY", (Object)new Integer(this.scanY));
                    meta.put((Object)"MeasureInfo.scanRX", (Object)new Integer(this.scanRX));
                    meta.put((Object)"MeasureInfo.scanRY", (Object)new Integer(this.scanRY));
                    meta.put((Object)"MeasureInfo.fifoTyp", (Object)new Short(this.fifoTyp));
                    meta.put((Object)"MeasureInfo.epxDiv", (Object)new Integer(this.epxDiv));
                    meta.put((Object)"MeasureInfo.modTypeCode", (Object)new Integer(this.modTypeCode));
                    meta.put((Object)"MeasureInfo.modFpgaVer", (Object)new Integer(this.modFpgaVer));
                    meta.put((Object)"MeasureInfo.overflowCorrFactor", (Object)new Float(this.overflowCorrFactor));
                    meta.put((Object)"MeasureInfo.adcZoom", (Object)new Integer(this.adcZoom));
                    meta.put((Object)"MeasureInfo.cycles", (Object)new Integer(this.cycles));
                }
                if (this.scanX > 0) {
                    this.width = this.scanX;
                }
                if (this.scanY > 0) {
                    this.height = this.scanY;
                }
                if (this.adcRE > 0) {
                    this.timeBins = this.adcRE;
                }
                if (this.scanRX > 0 || this.scanRY > 0) {
                    this.channels = this.nonZeroProduct(this.scanRX, this.scanRY);
                }
            }
            if (this.hasMeasStopInfo) {
                this.status = handle.readUnsignedShort();
                this.flags = handle.readUnsignedShort();
                this.stopTime = handle.readFloat();
                this.curStep = handle.readInt();
                this.curCycle = handle.readInt();
                this.curPage = handle.readInt();
                this.minSyncRate = handle.readFloat();
                this.minCfdRate = handle.readFloat();
                this.minTacRate = handle.readFloat();
                this.minAdcRate = handle.readFloat();
                this.maxSyncRate = handle.readFloat();
                this.maxCfdRate = handle.readFloat();
                this.maxTacRate = handle.readFloat();
                this.maxAdcRate = handle.readFloat();
                this.mReserved1 = handle.readInt();
                this.mReserved2 = handle.readFloat();
                if (meta != null) {
                    String measStopInfo = "MeasStopInfo.";
                    meta.put((Object)"MeasStopInfo.status", (Object)new Integer(this.status));
                    meta.put((Object)"MeasStopInfo.flags", (Object)new Integer(this.flags));
                    meta.put((Object)"MeasStopInfo.stopTime", (Object)new Float(this.stopTime));
                    meta.put((Object)"MeasStopInfo.curStep", (Object)new Integer(this.curStep));
                    meta.put((Object)"MeasStopInfo.curCycle", (Object)new Integer(this.curCycle));
                    meta.put((Object)"MeasStopInfo.curPage", (Object)new Integer(this.curPage));
                    meta.put((Object)"MeasStopInfo.minSyncRate", (Object)new Float(this.minSyncRate));
                    meta.put((Object)"MeasStopInfo.minCfdRate", (Object)new Float(this.minCfdRate));
                    meta.put((Object)"MeasStopInfo.minTacRate", (Object)new Float(this.minTacRate));
                    meta.put((Object)"MeasStopInfo.minAdcRate", (Object)new Float(this.minAdcRate));
                    meta.put((Object)"MeasStopInfo.maxSyncRate", (Object)new Float(this.maxSyncRate));
                    meta.put((Object)"MeasStopInfo.maxCfdRate", (Object)new Float(this.maxCfdRate));
                    meta.put((Object)"MeasStopInfo.maxTacRate", (Object)new Float(this.maxTacRate));
                    meta.put((Object)"MeasStopInfo.maxAdcRate", (Object)new Float(this.maxAdcRate));
                    meta.put((Object)"MeasStopInfo.reserved1", (Object)new Integer(this.mReserved1));
                    meta.put((Object)"MeasStopInfo.reserved2", (Object)new Float(this.mReserved2));
                }
            }
            if (this.hasMeasFCSInfo) {
                this.chan = handle.readUnsignedShort();
                this.fcsDecayCalc = handle.readUnsignedShort();
                this.mtResol = 0xFFFFFFFFL & (long)handle.readInt();
                this.cortime = handle.readFloat();
                this.calcPhotons = 0xFFFFFFFFL & (long)handle.readInt();
                this.fcsPoints = handle.readInt();
                this.endTime = handle.readFloat();
                this.overruns = handle.readUnsignedShort();
                this.fcsType = handle.readUnsignedShort();
                this.crossChan = handle.readUnsignedShort();
                this.mod = handle.readUnsignedShort();
                this.crossMod = handle.readUnsignedShort();
                this.crossMtResol = 0xFFFFFFFFL & (long)handle.readInt();
                if (meta != null) {
                    String measFCSInfo = "MeasFCSInfo.";
                    meta.put((Object)"MeasFCSInfo.chan", (Object)new Integer(this.chan));
                    meta.put((Object)"MeasFCSInfo.fcsDecayCalc", (Object)new Integer(this.fcsDecayCalc));
                    meta.put((Object)"MeasFCSInfo.mtResol", (Object)new Long(this.mtResol));
                    meta.put((Object)"MeasFCSInfo.cortime", (Object)new Float(this.cortime));
                    meta.put((Object)"MeasFCSInfo.calcPhotons", (Object)new Long(this.calcPhotons));
                    meta.put((Object)"MeasFCSInfo.fcsPoints", (Object)new Integer(this.fcsPoints));
                    meta.put((Object)"MeasFCSInfo.endTime", (Object)new Float(this.endTime));
                    meta.put((Object)"MeasFCSInfo.overruns", (Object)new Integer(this.overruns));
                    meta.put((Object)"MeasFCSInfo.fcsType", (Object)new Integer(this.fcsType));
                    meta.put((Object)"MeasFCSInfo.crossChan", (Object)new Integer(this.crossChan));
                    meta.put((Object)"MeasFCSInfo.mod", (Object)new Integer(this.mod));
                    meta.put((Object)"MeasFCSInfo.crossMod", (Object)new Integer(this.crossMod));
                    meta.put((Object)"MeasFCSInfo.crossMtResol", (Object)new Float(this.crossMtResol));
                }
            }
            if (this.hasExtendedMeasureInfo) {
                this.imageX = handle.readInt();
                this.imageY = handle.readInt();
                this.imageRX = handle.readInt();
                this.imageRY = handle.readInt();
                this.xyGain = handle.readShort();
                this.masterClock = handle.readShort();
                this.adcDE = handle.readShort();
                this.detType = handle.readShort();
                this.xAxis = handle.readShort();
                if (meta != null) {
                    measureInfo = "MeasureInfo.";
                    meta.put((Object)"MeasureInfo.imageX", (Object)new Integer(this.imageX));
                    meta.put((Object)"MeasureInfo.imageY", (Object)new Integer(this.imageY));
                    meta.put((Object)"MeasureInfo.imageRX", (Object)new Integer(this.imageRX));
                    meta.put((Object)"MeasureInfo.imageRY", (Object)new Integer(this.imageRY));
                    meta.put((Object)"MeasureInfo.xyGain", (Object)new Short(this.xyGain));
                    meta.put((Object)"MeasureInfo.masterClock", (Object)new Short(this.masterClock));
                    meta.put((Object)"MeasureInfo.adcDE", (Object)new Short(this.adcDE));
                    meta.put((Object)"MeasureInfo.detType", (Object)new Short(this.detType));
                    meta.put((Object)"MeasureInfo.xAxis", (Object)new Short(this.xAxis));
                }
            }
            if (this.hasMeasHISTInfo) {
                this.fidaTime = handle.readFloat();
                this.fildaTime = handle.readFloat();
                this.fidaPoints = handle.readInt();
                this.fildaPoints = handle.readInt();
                this.mcsTime = handle.readFloat();
                this.mcsPoints = handle.readInt();
                if (meta != null) {
                    String measHISTInfo = "MeasHISTInfo.";
                    meta.put((Object)"MeasHISTInfo.fidaTime", (Object)new Float(this.fidaTime));
                    meta.put((Object)"MeasHISTInfo.fildaTime", (Object)new Float(this.fildaTime));
                    meta.put((Object)"MeasHISTInfo.fidaPoints", (Object)new Integer(this.fidaPoints));
                    meta.put((Object)"MeasHISTInfo.fildaPoints", (Object)new Integer(this.fildaPoints));
                    meta.put((Object)"MeasHISTInfo.mcsTime", (Object)new Float(this.mcsTime));
                    meta.put((Object)"MeasHISTInfo.mcsPoints", (Object)new Integer(this.mcsPoints));
                }
            }
        }
        handle.seek((long)this.dataBlockOffs);
        this.readBlockHeader(handle);
        if (meta != null) {
            String bhFileBlockHeader = "BHFileBlockHeader.";
            meta.put((Object)"BHFileBlockHeader.blockNo", (Object)new Short(this.blockNo));
            meta.put((Object)"BHFileBlockHeader.dataOffs", (Object)new Integer(this.dataOffs));
            meta.put((Object)"BHFileBlockHeader.nextBlockOffs", (Object)new Integer(this.nextBlockOffs));
            meta.put((Object)"BHFileBlockHeader.blockType", (Object)new Integer(this.blockType));
            meta.put((Object)"BHFileBlockHeader.measDescBlockNo", (Object)new Short(this.measDescBlockNo));
            meta.put((Object)"BHFileBlockHeader.lblockNo", (Object)new Long(this.lblockNo));
            meta.put((Object)"BHFileBlockHeader.blockLength", (Object)new Long(this.blockLength));
        }
        if (13 == this.measMode) {
            if (this.imageX > 0) {
                this.width = this.imageX;
            }
            if (this.imageY > 0) {
                this.height = this.imageY;
            }
            if (this.imageRX > 0 || this.imageRY > 0) {
                this.channels = this.nonZeroProduct(this.scanRX, this.scanRY);
            }
            this.channels *= this.noOfDataBlocks;
        }
    }

    public void readBlockHeader(DataHandle<Location> stream) throws IOException {
        this.blockNo = stream.readShort();
        this.dataOffs = stream.readInt();
        this.nextBlockOffs = stream.readInt();
        this.blockType = stream.readUnsignedShort();
        this.measDescBlockNo = stream.readShort();
        this.lblockNo = 0xFFFFFFFFL & (long)stream.readInt();
        this.blockLength = 0xFFFFFFFFL & (long)stream.readInt();
    }

    private int nonZeroProduct(int ... args) {
        int product = 1;
        for (int arg : args) {
            if (arg <= 0) continue;
            product *= arg;
        }
        return product;
    }
}

