/*
 * Decompiled with CFR 0.152.
 */
package Bug_Submitter;

import Bug_Submitter.Bug_Submitter;
import ij.IJ;
import ij.WindowManager;
import ij.plugin.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

class NewBugDialog
extends JFrame
implements ActionListener,
WindowListener {
    private final Bug_Submitter bugSubmitter;
    JButton bugzillaAccountCreation;
    JButton submitReport;
    JButton cancel;
    JTextField username;
    JPasswordField password;
    JCheckBox rememberPassword;
    JTextField summary;
    JTextArea description;
    JTextArea systemInfo;
    UndoManager undo;
    private static final String BEST_PRACTICES_URL = "http://fiji.sc/Bug_reporting_best_practices";
    boolean askedToSubmit = false;
    boolean alreadyDisposed = false;

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            WindowManager.addWindow((Frame)this);
        } else {
            WindowManager.removeWindow((Frame)this);
        }
        super.setVisible(visible);
    }

    @Override
    public synchronized void show() {
        WindowManager.addWindow((Frame)this);
        super.show();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewBugDialog.this.dispose();
                }
            });
            return;
        }
        WindowManager.removeWindow((Frame)this);
        this.notify();
        super.dispose();
    }

    public NewBugDialog(Bug_Submitter bugSubmitter, String suggestedUsername, String suggestedPassword, String systemInfoText) {
        super("Bug Report Form");
        this.bugSubmitter = bugSubmitter;
        Container contentPane = this.getContentPane();
        this.addWindowListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 3, 5, 3);
        c.fill = 2;
        c.anchor = 10;
        JPanel labelsPanel = new JPanel();
        labelsPanel.setLayout(new GridBagLayout());
        JTextArea instructions = new JTextArea(3, 30);
        instructions.setEditable(false);
        instructions.setCursor(null);
        instructions.setOpaque(false);
        instructions.setFocusable(false);
        instructions.setLineWrap(true);
        instructions.setWrapStyleWord(true);
        instructions.setText("In order to report a bug, we ask that you create a Bugzilla account.  This is so that you can follow the progress of fixing the problem by email and enables us to ask follow-up questions if that's necessary.");
        this.bugzillaAccountCreation = new JButton("Visit the Bugzilla account creation page");
        this.bugzillaAccountCreation.addActionListener(this);
        GridBagConstraints clabels = new GridBagConstraints();
        clabels.fill = 1;
        clabels.gridx = 0;
        clabels.gridy = 0;
        labelsPanel.add((Component)instructions, clabels);
        clabels.gridx = 1;
        clabels.gridy = 0;
        labelsPanel.add((Component)this.bugzillaAccountCreation, clabels);
        contentPane.add((Component)labelsPanel, c);
        this.username = new JTextField(20);
        this.username.setText(suggestedUsername);
        this.username.addFocusListener(new FocusErrorReset(this.username));
        this.password = new JPasswordField(20);
        this.password.setEchoChar('*');
        if (suggestedPassword != null) {
            this.password.setText(suggestedPassword);
        }
        this.password.addFocusListener(new FocusErrorReset(this.password));
        this.rememberPassword = new JCheckBox("", suggestedPassword != null);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints cl = new GridBagConstraints();
        cl.gridx = 0;
        cl.gridy = 0;
        cl.anchor = 22;
        p.add((Component)new JLabel("Bugzilla username (your email address): "), cl);
        cl.gridx = 1;
        cl.gridy = 0;
        cl.anchor = 21;
        p.add((Component)this.username, cl);
        cl.gridx = 0;
        cl.gridy = 1;
        cl.anchor = 22;
        p.add((Component)new JLabel("Bugzilla password: "), cl);
        cl.gridx = 1;
        cl.gridy = 1;
        cl.anchor = 21;
        p.add((Component)this.password, cl);
        cl.gridx = 0;
        cl.gridy = 2;
        cl.anchor = 22;
        p.add((Component)new JLabel("Remember password (insecure): "), cl);
        cl.gridx = 1;
        cl.gridy = 2;
        cl.anchor = 21;
        p.add((Component)this.rememberPassword, cl);
        c.anchor = 21;
        ++c.gridy;
        contentPane.add((Component)p, c);
        this.summary = new JTextField(30);
        this.summary.addFocusListener(new FocusErrorReset(this.summary));
        this.description = new JTextAreaTabFocus(8, 42);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.addFocusListener(new FocusErrorReset(this.description));
        this.undo = new UndoManager();
        this.description.getDocument().addUndoableEditListener(new SimpleEditListener());
        ActionMap actionMap = this.description.getActionMap();
        actionMap.put("Undo", new UndoAction());
        actionMap.put("Redo", new RedoAction());
        InputMap inputMap = this.description.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke("control Z"), "Undo");
        inputMap.put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.systemInfo = new JTextArea(6, 42);
        this.systemInfo.setLineWrap(true);
        this.systemInfo.setWrapStyleWord(true);
        this.systemInfo.setText(systemInfoText);
        this.systemInfo.setEditable(false);
        JPanel summaryPanel = new JPanel();
        summaryPanel.setLayout(new BorderLayout());
        summaryPanel.add((Component)new JLabel("Summary of the bug: "), "West");
        summaryPanel.add((Component)this.summary, "Center");
        ++c.gridy;
        c.anchor = 21;
        contentPane.add((Component)summaryPanel, c);
        ++c.gridy;
        JLabel descriptionLabel = new JLabel("<html><div width=500px>A full description of the bug (if you are able to, provide a minimal macro that reproduces the issue; feel free to upload \u2013 as small as possible \u2013 images via Help>Upload Sample Image to help those you ask for help to reproduce the problem, see also <a href='http://fiji.sc/Bug_reporting_best_practices'>best bug reporting practices</a>):</div></html>");
        descriptionLabel.setCursor(new Cursor(12));
        descriptionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserLauncher.openURL((String)NewBugDialog.BEST_PRACTICES_URL);
                }
                catch (Throwable t) {
                    IJ.handleException((Throwable)t);
                }
            }
        });
        contentPane.add((Component)descriptionLabel, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        contentPane.add((Component)new JScrollPane(this.description), c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        contentPane.add((Component)new JLabel("Useful information about your system (will be sent as part of your bug report):"), c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 0.5;
        contentPane.add((Component)new JScrollPane(this.systemInfo), c);
        JPanel p2 = new JPanel();
        this.submitReport = new JButton("Submit Bug Report");
        this.submitReport.addActionListener(this);
        p2.add(this.submitReport);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        p2.add(this.cancel);
        c.anchor = 10;
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        contentPane.add((Component)p2, c);
        this.pack();
        Bug_Submitter.addAccelerator(this.cancel, (JComponent)contentPane, this, 87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public void resetForm() {
        this.askedToSubmit = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.bugzillaAccountCreation) {
            new BrowserLauncher().run(this.bugSubmitter.bugzillaBaseURI + "createaccount.cgi");
        } else if (source == this.cancel) {
            this.alreadyDisposed = true;
            this.dispose();
        } else if (source == this.submitReport) {
            boolean success = this.validateForm();
            if (!success) {
                return;
            }
            this.askedToSubmit = true;
            this.alreadyDisposed = true;
            this.dispose();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    private boolean validateForm() {
        boolean error = false;
        Color errorColor = new Color(255, 128, 128);
        if (this.username.getText().trim().length() == 0) {
            this.username.setBackground(errorColor);
            error = true;
        }
        if (this.password.getPassword().length == 0) {
            this.password.setBackground(errorColor);
            error = true;
        }
        if (this.summary.getText().trim().length() == 0) {
            this.summary.setBackground(errorColor);
            error = true;
        }
        if (this.description.getText().trim().length() == 0) {
            this.description.setBackground(errorColor);
            error = true;
        }
        if (error) {
            IJ.error((String)"Please fill in all the fields.");
            return false;
        }
        return true;
    }

    protected class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (NewBugDialog.this.undo.canRedo()) {
                    NewBugDialog.this.undo.redo();
                }
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
    }

    protected class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (NewBugDialog.this.undo.canUndo()) {
                    NewBugDialog.this.undo.undo();
                }
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    protected class SimpleEditListener
    implements UndoableEditListener {
        protected SimpleEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            NewBugDialog.this.undo.addEdit(e.getEdit());
        }
    }

    private class JTextAreaTabFocus
    extends JTextArea {
        public JTextAreaTabFocus(int rows, int columns) {
            super(rows, columns);
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent e) {
            if (e.getID() == 401 && e.getKeyCode() == 9) {
                e.consume();
                if (e.isShiftDown()) {
                    this.transferFocusBackward();
                } else {
                    this.transferFocus();
                }
            } else {
                super.processComponentKeyEvent(e);
            }
        }
    }

    private class FocusErrorReset
    extends FocusAdapter {
        private Color background;

        private FocusErrorReset(Component c) {
            this.background = c.getBackground();
        }

        @Override
        public void focusGained(FocusEvent e) {
            e.getComponent().setBackground(this.background);
        }
    }
}

