/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.clojure;

import clojure.lang.Associative;
import clojure.lang.MapEntry;
import clojure.lang.Namespace;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;

public class ClojureBindings
implements Bindings {
    private static final String CORE_NS = "clojure.core";
    private static final String USER_NS = "user";

    public ClojureBindings() {
        Var nameSpace = RT.var((String)CORE_NS, (String)"*ns*");
        Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{nameSpace, nameSpace.get()}));
        RT.var((String)CORE_NS, (String)"in-ns").invoke((Object)Symbol.intern((String)USER_NS));
        RT.var((String)CORE_NS, (String)"refer").invoke((Object)Symbol.intern((String)CORE_NS));
    }

    @Override
    public int size() {
        return Var.getThreadBindings().count();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return ClojureBindings.map().containsValue(value);
    }

    @Override
    public Object get(Object keyObject) {
        String nameSpace;
        String key = (String)keyObject;
        int dot = key.lastIndexOf(46);
        if (dot < 0) {
            nameSpace = USER_NS;
        } else {
            nameSpace = key.substring(0, dot);
            key = key.substring(dot + 1);
        }
        try {
            return RT.var((String)nameSpace, (String)key).get();
        }
        catch (Error e) {
            return null;
        }
    }

    private Object get(String nameSpace, String key) {
        return RT.var((String)nameSpace, (String)key);
    }

    @Override
    public Object put(String name, Object value) {
        String key;
        String nameSpace;
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            nameSpace = USER_NS;
            key = name;
        } else {
            nameSpace = name.substring(0, dot);
            key = name.substring(dot + 1);
        }
        Object result = this.get(nameSpace, key);
        try {
            Var var = RT.var((String)nameSpace, (String)key, null);
            var.setDynamic();
            Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{var, value}));
        }
        catch (Error error) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return ClojureBindings.map().keySet();
    }

    @Override
    public Collection<Object> values() {
        return ClojureBindings.map().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return ClojureBindings.map().entrySet();
    }

    private static Map<String, Object> map() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Namespace ns = Namespace.find((Symbol)Symbol.intern(null, (String)USER_NS));
        for (Object el : ns.getMappings()) {
            MapEntry entry = (MapEntry)el;
            Symbol key = (Symbol)entry.key();
            Object valAt = ns.getMappings().valAt((Object)key);
            Var valVar = valAt instanceof Var ? (Var)valAt : null;
            if (valVar == null || valVar.ns != ns || !valVar.isBound()) continue;
            map.put(key.getName(), valVar.get());
        }
        return map;
    }
}

