/*
 * Decompiled with CFR 0.152.
 */
package stitching;

import ij.ImagePlus;
import stitching.model.Model;
import stitching.model.Tile;

public class ImageInformation
extends Tile
implements Comparable<ImageInformation> {
    public Object[] imageStack;
    public int w;
    public int d;
    public int h;
    public int imageType;
    public int seriesNumber = -1;
    public String imageName;
    public ImagePlus imp = null;
    public ImagePlus maxIntensity = null;
    public ImagePlus tmp = null;
    public boolean overlaps = false;
    public boolean invalid = false;
    public final float[] offset;
    public final float[] size;
    public boolean closeAtEnd = false;
    public float[] position;
    public final int id;
    public final int dim;

    public ImageInformation(int dim, int id, Model model) {
        super(1.0f, 1.0f, model);
        this.offset = new float[dim];
        this.size = new float[dim];
        this.position = new float[dim];
        this.id = id;
        this.dim = dim;
    }

    public String toString() {
        String out = "Image: '" + this.imageName + "' Imp: '" + this.imp + "' Offset: (";
        for (int i = 0; i < this.offset.length; ++i) {
            out = i < this.offset.length - 1 ? out + this.offset[i] + ", " : out + this.offset[i] + ")";
        }
        return out;
    }

    @Override
    public int compareTo(ImageInformation o) {
        if (this.id < o.id) {
            return -1;
        }
        if (this.id > o.id) {
            return 1;
        }
        return 0;
    }
}

