/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.util.unionfind;

import gnu.trove.map.TLongLongMap;
import gnu.trove.map.hash.TLongLongHashMap;
import java.util.Arrays;
import java.util.function.LongBinaryOperator;
import net.imglib2.algorithm.util.unionfind.UnionFind;

public class LongHashMapUnionFind
implements UnionFind {
    private final TLongLongHashMap parents;
    private int nSets;
    private final LongBinaryOperator comparator;

    public LongHashMapUnionFind() {
        this(new TLongLongHashMap(), 0, Long::compare);
    }

    public LongHashMapUnionFind(TLongLongHashMap parents, int nSets, LongBinaryOperator comparator) {
        this.parents = parents;
        this.nSets = nSets;
        this.comparator = comparator;
    }

    @Override
    public long findRoot(long id) {
        if (!this.parents.contains(id)) {
            this.parents.put(id, id);
            ++this.nSets;
            return id;
        }
        long startIndex1 = id;
        long startIndex2 = id;
        long tmp = id;
        while (startIndex1 != this.parents.get(startIndex1)) {
            startIndex1 = this.parents.get(startIndex1);
        }
        while (startIndex2 != startIndex1) {
            tmp = this.parents.get(startIndex2);
            this.parents.put(startIndex2, startIndex1);
            startIndex2 = tmp;
        }
        return startIndex1;
    }

    @Override
    public long join(long id1, long id2) {
        if (!this.parents.contains(id1)) {
            this.parents.put(id1, id1);
            ++this.nSets;
        }
        if (!this.parents.contains(id2)) {
            this.parents.put(id2, id2);
            ++this.nSets;
        }
        if (id1 == id2) {
            return id1;
        }
        --this.nSets;
        if (this.comparator.applyAsLong(id1, id2) < 0L) {
            this.parents.put(id2, id1);
            return id1;
        }
        this.parents.put(id1, id2);
        return id2;
    }

    @Override
    public long size() {
        return this.parents.size();
    }

    @Override
    public long setCount() {
        return this.nSets;
    }

    public LongHashMapUnionFind clone() {
        return new LongHashMapUnionFind(new TLongLongHashMap((TLongLongMap)this.parents), this.nSets, this.comparator);
    }

    private static int[] intRange(int[] data) {
        return LongHashMapUnionFind.intRange(data, 0);
    }

    private static int[] intRange(int[] data, int offset) {
        Arrays.setAll(data, d -> d + offset);
        return data;
    }
}

