/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display;

import net.imagej.display.DatasetView;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ColorRGB;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Color"), @Menu(label="Spectral Composite...")}, attrs={@Attr(name="no-legacy")})
public class SpectralComposite
extends ContextCommand {
    @Parameter(type=ItemIO.BOTH)
    private DatasetView datasetView;
    @Parameter(label="Starting wavelength", min="1")
    private int startWave = 400;
    @Parameter(label="Ending wavelength", min="1")
    private int endWave = 700;

    public void run() {
        this.spectralComposite();
    }

    public void setView(DatasetView view) {
        this.datasetView = view;
    }

    public DatasetView getView() {
        return this.datasetView;
    }

    public void setStartingWavelength(int waveLength) {
        this.startWave = waveLength;
    }

    public int getStartingWavelength() {
        return this.startWave;
    }

    public void setEndingWavelength(int waveLength) {
        this.endWave = waveLength;
    }

    public int getEndingWavelength() {
        return this.endWave;
    }

    public static ColorRGB wavelengthToColor(int wavelength) {
        double blue;
        double green;
        double red;
        if (wavelength >= 350 && wavelength <= 439) {
            red = -((double)wavelength - 440.0) / 90.0;
            green = 0.0;
            blue = 1.0;
        } else if (wavelength >= 440 && wavelength <= 489) {
            red = 0.0;
            green = ((double)wavelength - 440.0) / 50.0;
            blue = 1.0;
        } else if (wavelength >= 490 && wavelength <= 509) {
            red = 0.0;
            green = 1.0;
            blue = -((double)wavelength - 510.0) / 20.0;
        } else if (wavelength >= 510 && wavelength <= 579) {
            red = ((double)wavelength - 510.0) / 70.0;
            green = 1.0;
            blue = 0.0;
        } else if (wavelength >= 580 && wavelength <= 644) {
            red = 1.0;
            green = -((double)wavelength - 645.0) / 65.0;
            blue = 0.0;
        } else if (wavelength >= 645 && wavelength <= 780) {
            red = 1.0;
            green = 0.0;
            blue = 0.0;
        } else {
            red = 0.0;
            green = 0.0;
            blue = 0.0;
        }
        double factor = wavelength >= 350 && wavelength <= 419 ? 0.3 + 0.7 * ((double)wavelength - 350.0) / 70.0 : (wavelength >= 420 && wavelength <= 700 ? 1.0 : (wavelength >= 701 && wavelength <= 780 ? 0.3 + 0.7 * (780.0 - (double)wavelength) / 80.0 : 0.0));
        double gamma = 1.0;
        int intensityMax = 255;
        int r = SpectralComposite.factorAdjust(red, factor, 255, 1.0);
        int g = SpectralComposite.factorAdjust(green, factor, 255, 1.0);
        int b = SpectralComposite.factorAdjust(blue, factor, 255, 1.0);
        return new ColorRGB(r, g, b);
    }

    public static int factorAdjust(double color, double factor, int intensityMax, double gamma) {
        if (color == 0.0) {
            return 0;
        }
        return (int)Math.round((double)intensityMax * Math.pow(color * factor, gamma));
    }

    private void spectralComposite() {
        int cIndex = this.datasetView.getCompositeDimIndex();
        int cSize = cIndex < 0 ? 1 : (int)this.datasetView.getData().dimension(cIndex);
        for (int c = 0; c < cSize; ++c) {
            int wavelength = this.startWave + (this.endWave - this.startWave) * c / (cSize - 1);
            ColorRGB color = SpectralComposite.wavelengthToColor(wavelength);
            int lutLength = 256;
            byte[][] values = new byte[3][256];
            for (int i = 0; i < 256; ++i) {
                values[0][i] = (byte)(color.getRed() * i / 255);
                values[1][i] = (byte)(color.getGreen() * i / 255);
                values[2][i] = (byte)(color.getBlue() * i / 255);
            }
            ColorTable8 colorTable = new ColorTable8(values);
            this.datasetView.setColorTable((ColorTable)colorTable, c);
        }
        this.datasetView.setComposite(true);
    }
}

