/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.io.ImageOutputFormat;
import org.jhotdraw.draw.io.SerializationInputOutputFormat;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.DnDTracker;
import org.jhotdraw.draw.tool.SelectionTool;
import org.jhotdraw.util.ResourceBundleUtil;

public class DnDMultiEditorSample {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                DefaultDrawingView view1 = new DefaultDrawingView();
                DefaultDrawingView view2 = new DefaultDrawingView();
                DefaultDrawingView view3 = new DefaultDrawingView();
                DefaultDrawingView view4 = new DefaultDrawingView();
                view1.setDrawing(DnDMultiEditorSample.createDrawing());
                view2.setDrawing(DnDMultiEditorSample.createDrawing());
                view3.setDrawing(DnDMultiEditorSample.createDrawing());
                view4.setDrawing(DnDMultiEditorSample.createDrawing());
                DefaultDrawingEditor editor = new DefaultDrawingEditor();
                editor.add(view1);
                editor.add(view2);
                editor.add(view3);
                editor.add(view4);
                JToolBar tb = new JToolBar();
                SelectionTool selectionTool = new SelectionTool();
                selectionTool.setDragTracker(new DnDTracker());
                ButtonFactory.addSelectionToolTo(tb, editor, selectionTool);
                ButtonFactory.addToolTo(tb, editor, new CreationTool(new RectangleFigure()), "edit.createRectangle", labels);
                tb.setOrientation(1);
                JFrame f = new JFrame("Multi-Editor");
                f.setDefaultCloseOperation(3);
                f.setSize(400, 300);
                JPanel innerPane = new JPanel();
                innerPane.setLayout(new FlowLayout(0, 20, 20));
                JScrollPane sp = new JScrollPane(view1.getComponent());
                innerPane.add(sp);
                sp.setPreferredSize(new Dimension(200, 200));
                sp = new JScrollPane(view2.getComponent());
                innerPane.add(sp);
                sp.setPreferredSize(new Dimension(200, 200));
                sp = new JScrollPane(view3.getComponent());
                innerPane.add(sp);
                sp.setPreferredSize(new Dimension(200, 200));
                sp = new JScrollPane(view4.getComponent());
                innerPane.add(sp);
                sp.setPreferredSize(new Dimension(200, 200));
                f.getContentPane().add(new JScrollPane(innerPane));
                f.getContentPane().add((Component)tb, "West");
                f.setVisible(true);
            }
        });
    }

    private static Drawing createDrawing() {
        DefaultDrawing drawing = new DefaultDrawing();
        drawing.addInputFormat(new SerializationInputOutputFormat());
        drawing.addOutputFormat(new SerializationInputOutputFormat());
        drawing.addOutputFormat(new ImageOutputFormat());
        return drawing;
    }
}

