/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Paint;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGAttributeKeys
extends AttributeKeys {
    private static final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
    public static final AttributeKey<String> TITLE = new AttributeKey<Object>("title", String.class, null, true, labels);
    public static final AttributeKey<String> DESCRIPTION = new AttributeKey<Object>("description", String.class, null, true, labels);
    public static final AttributeKey<Color> VIEWPORT_FILL = CANVAS_FILL_COLOR;
    public static final AttributeKey<Double> VIEWPORT_FILL_OPACITY = CANVAS_FILL_OPACITY;
    public static final AttributeKey<Double> VIEWPORT_WIDTH = CANVAS_WIDTH;
    public static final AttributeKey<Double> VIEWPORT_HEIGHT = CANVAS_HEIGHT;
    public static final AttributeKey<TextAnchor> TEXT_ANCHOR = new AttributeKey<TextAnchor>("textAnchor", TextAnchor.class, TextAnchor.START, false, labels);
    public static final AttributeKey<TextAlign> TEXT_ALIGN = new AttributeKey<TextAlign>("textAlign", TextAlign.class, TextAlign.START, false, labels);
    public static final AttributeKey<Gradient> FILL_GRADIENT = new AttributeKey<Object>("fillGradient", Gradient.class, null, true, labels);
    public static final AttributeKey<Double> FILL_OPACITY = new AttributeKey<Double>("fillOpacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<Double> OPACITY = new AttributeKey<Double>("opacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<Gradient> STROKE_GRADIENT = new AttributeKey<Object>("strokeGradient", Gradient.class, null, true, labels);
    public static final AttributeKey<Double> STROKE_OPACITY = new AttributeKey<Double>("strokeOpacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<String> LINK = new AttributeKey<Object>("link", String.class, null, true, labels);
    public static final AttributeKey<String> LINK_TARGET = new AttributeKey<Object>("linkTarget", String.class, null, true, labels);

    @Nullable
    public static Paint getFillPaint(Figure f) {
        double opacity = f.get(FILL_OPACITY);
        if (f.get(FILL_GRADIENT) != null) {
            return f.get(FILL_GRADIENT).getPaint(f, opacity);
        }
        Color color = (Color)f.get(FILL_COLOR);
        if (color != null && opacity != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(opacity * 255.0) << 24, true);
        }
        return color;
    }

    @Nullable
    public static Paint getStrokePaint(Figure f) {
        double opacity = f.get(STROKE_OPACITY);
        if (f.get(STROKE_GRADIENT) != null) {
            return f.get(STROKE_GRADIENT).getPaint(f, opacity);
        }
        Color color = (Color)f.get(STROKE_COLOR);
        if (color != null && opacity != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(opacity * 255.0) << 24, true);
        }
        return color;
    }

    public static void setDefaults(Figure f) {
        f.set(FILL_COLOR, Color.black);
        f.set(WINDING_RULE, AttributeKeys.WindingRule.NON_ZERO);
        f.set(STROKE_COLOR, null);
        f.set(STROKE_WIDTH, 1.0);
        f.set(STROKE_CAP, 0);
        f.set(STROKE_JOIN, 0);
        f.set(STROKE_MITER_LIMIT, 4.0);
        f.set(IS_STROKE_MITER_LIMIT_FACTOR, false);
        f.set(STROKE_DASHES, null);
        f.set(STROKE_DASH_PHASE, 0.0);
        f.set(IS_STROKE_DASH_FACTOR, false);
    }

    public static double getPerpendicularHitGrowth(Figure f) {
        double grow;
        if (f.get(STROKE_COLOR) == null && f.get(STROKE_GRADIENT) == null) {
            grow = SVGAttributeKeys.getPerpendicularFillGrowth(f);
        } else {
            double strokeWidth = AttributeKeys.getStrokeTotalWidth(f);
            grow = SVGAttributeKeys.getPerpendicularDrawGrowth(f) + strokeWidth / 2.0;
        }
        return grow;
    }

    public static enum TextAlign {
        START,
        CENTER,
        END;

    }

    public static enum TextAnchor {
        START,
        MIDDLE,
        END;

    }
}

