/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.label.ByteUtils;
import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetEntryList;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.label.LabelUtils;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.VolatileLabelMultisetArray;
import net.imglib2.view.Views;

public class LabelMultisetTypeDownscaler {
    public static VolatileLabelMultisetArray createDownscaledCell(RandomAccessible<LabelMultisetType> source, Interval interval, int[] factor, int maxNumEntriesPerPixel) {
        return LabelMultisetTypeDownscaler.createDownscaledCell((RandomAccessibleInterval<LabelMultisetType>)Views.interval(source, (Interval)interval), factor, maxNumEntriesPerPixel);
    }

    public static VolatileLabelMultisetArray createDownscaledCell(RandomAccessibleInterval<LabelMultisetType> source, int[] downscaleFactor, int maxNumEntriesPerPixel) {
        RandomAccess sourceAccess = source.randomAccess();
        int numDim = source.numDimensions();
        long[] sourceShape = new long[numDim];
        long[] cellOffset = new long[numDim];
        long[] totalOffset = new long[numDim];
        for (int i = 0; i < numDim; ++i) {
            cellOffset[i] = source.min(i);
            sourceShape[i] = source.max(i) + 1L - cellOffset[i];
        }
        ByteArrayOutputStream listEntryOffsets = new ByteArrayOutputStream();
        LongMappedAccessData listEntryData = LongMappedAccessData.factory.createStorage(32L);
        LabelMultisetEntryList list = new LabelMultisetEntryList(listEntryData, 0L);
        LabelMultisetEntryList list2 = new LabelMultisetEntryList();
        int nextListOffset = 0;
        TIntObjectHashMap offsetsForHashes = new TIntObjectHashMap();
        TLongArrayList argMax = new TLongArrayList();
        LabelMultisetEntry emptyZeroEntry = new LabelMultisetEntry(0L, 0);
        LabelMultisetEntry addRef = (LabelMultisetEntry)list.createRef();
        LabelMultisetEntry entrySetRef = (LabelMultisetEntry)list.createRef();
        int nonEmptyListCount = 0;
        int d = 0;
        block1: while (d < numDim) {
            LabelMultisetType lmt;
            list.createListAt(listEntryData, nextListOffset);
            System.arraycopy(cellOffset, 0, totalOffset, 0, numDim);
            int g = 0;
            block2: while (g < numDim && (lmt = (LabelMultisetType)((Object)sourceAccess.setPositionAndGet(totalOffset))).getAccess().getListDataUsedSizeInBytes() != 0L) {
                for (LabelMultisetType.Entry<Label> labelEntry : lmt.entrySetWithRef(entrySetRef)) {
                    list.add((LabelMultisetEntry)labelEntry, addRef);
                }
                for (g = 0; g < numDim; ++g) {
                    int n = g;
                    totalOffset[n] = totalOffset[n] + 1L;
                    if (totalOffset[g] < cellOffset[g] + (long)downscaleFactor[g] && totalOffset[g] < sourceShape[g]) continue block2;
                    totalOffset[g] = cellOffset[g];
                }
            }
            if (list.isEmpty()) {
                list.add(emptyZeroEntry);
            } else {
                ++nonEmptyListCount;
                list.sortByCount();
                if (maxNumEntriesPerPixel > 0 && list.size() > maxNumEntriesPerPixel) {
                    list.limitSize(maxNumEntriesPerPixel);
                }
                long max = ((LabelMultisetEntry)list.get(list.size() - 1)).getId();
                argMax.add(max);
                list.sortById();
            }
            boolean makeNewList = true;
            int hash = list.hashCode();
            TIntArrayList listOffsets = (TIntArrayList)offsetsForHashes.get(hash);
            if (listOffsets == null) {
                listOffsets = new TIntArrayList();
                offsetsForHashes.put(hash, (Object)listOffsets);
            }
            for (int i = 0; i < listOffsets.size(); ++i) {
                int offset = listOffsets.get(i);
                list2.referToDataAt(listEntryData, offset);
                if (!list.equals(list2)) continue;
                makeNewList = false;
                LabelUtils.writeInt(listEntryOffsets, offset, ByteOrder.BIG_ENDIAN);
                break;
            }
            if (makeNewList) {
                LabelUtils.writeInt(listEntryOffsets, nextListOffset, ByteOrder.BIG_ENDIAN);
                listOffsets.add(nextListOffset);
                nextListOffset += (int)list.getSizeInBytes();
            }
            for (d = 0; d < numDim; ++d) {
                int n = d;
                cellOffset[n] = cellOffset[n] + (long)downscaleFactor[d];
                if (cellOffset[d] < sourceShape[d]) continue block1;
                cellOffset[d] = 0L;
            }
        }
        if (nonEmptyListCount == 0) {
            return new VolatileLabelMultisetArray(0, true, new long[]{-2L});
        }
        IntBuffer intBuffer = ByteBuffer.wrap(listEntryOffsets.toByteArray()).asIntBuffer();
        int[] listOffsets = new int[intBuffer.limit()];
        intBuffer.rewind();
        intBuffer.get(listOffsets);
        return new VolatileLabelMultisetArray(listOffsets, listEntryData, nextListOffset, true, argMax.toArray());
    }

    public static int getSerializedVolatileLabelMultisetArraySize(VolatileLabelMultisetArray array) {
        return VolatileLabelMultisetArray.getRequiredNumberOfBytes(0, array.getCurrentStorageArray(), (int)array.getListDataUsedSizeInBytes());
    }

    public static void serializeVolatileLabelMultisetArray(VolatileLabelMultisetArray array, byte[] bytes) {
        int[] curStorage = array.getCurrentStorageArray();
        long[] data = array.getListData().data;
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.putInt(0);
        for (int d : curStorage) {
            bb.putInt(d);
        }
        for (long i = 0L; i < array.getListDataUsedSizeInBytes(); ++i) {
            bb.put(ByteUtils.getByte(data, i));
        }
    }
}

