/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.model;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.Collection;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.model.TranslationInvariantModel;

public class TranslationInvariantSimilarityModel3D
extends TranslationInvariantModel<TranslationInvariantSimilarityModel3D> {
    protected static final int MIN_NUM_MATCHES = 3;
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double m02 = 0.0;
    protected double m10 = 0.0;
    protected double m11 = 1.0;
    protected double m12 = 0.0;
    protected double m20 = 0.0;
    protected double m21 = 0.0;
    protected double m22 = 1.0;
    protected final double[][] N = new double[4][4];

    @Override
    public boolean canDoNumDimension(int numDimensions) {
        return numDimensions == 3;
    }

    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int numMatches = matches.size();
        if (numMatches < 3) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 3d similarity model, at least " + 3 + " data points required.");
        }
        double r1 = 0.0;
        double r2 = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double x1 = p[0];
            double y1 = p[1];
            double z1 = p[2];
            double x2 = q[0];
            double y2 = q[1];
            double z2 = q[2];
            r1 += x1 * x1 + y1 * y1 + z1 * z1;
            r2 += x2 * x2 + y2 * y2 + z2 * z2;
        }
        double s = Math.sqrt(r2 / r1);
        double Szz = 0.0;
        double Szy = 0.0;
        double Szx = 0.0;
        double Syz = 0.0;
        double Syy = 0.0;
        double Syx = 0.0;
        double Sxz = 0.0;
        double Sxy = 0.0;
        double Sxx = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double x1 = p[0] * s;
            double y1 = p[1] * s;
            double z1 = p[2] * s;
            double x2 = q[0];
            double y2 = q[1];
            double z2 = q[2];
            Sxx += x1 * x2;
            Sxy += x1 * y2;
            Sxz += x1 * z2;
            Syx += y1 * x2;
            Syy += y1 * y2;
            Syz += y1 * z2;
            Szx += z1 * x2;
            Szy += z1 * y2;
            Szz += z1 * z2;
        }
        this.N[0][0] = Sxx + Syy + Szz;
        this.N[0][1] = Syz - Szy;
        this.N[0][2] = Szx - Sxz;
        this.N[0][3] = Sxy - Syx;
        this.N[1][0] = Syz - Szy;
        this.N[1][1] = Sxx - Syy - Szz;
        this.N[1][2] = Sxy + Syx;
        this.N[1][3] = Szx + Sxz;
        this.N[2][0] = Szx - Sxz;
        this.N[2][1] = Sxy + Syx;
        this.N[2][2] = -Sxx + Syy - Szz;
        this.N[2][3] = Syz + Szy;
        this.N[3][0] = Sxy - Syx;
        this.N[3][1] = Szx + Sxz;
        this.N[3][2] = Syz + Szy;
        this.N[3][3] = -Sxx - Syy + Szz;
        EigenvalueDecomposition evd = new EigenvalueDecomposition(new Matrix(this.N));
        double[] eigenvalues = evd.getRealEigenvalues();
        Matrix eigenVectors = evd.getV();
        int index = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(eigenvalues[i] > eigenvalues[index])) continue;
            index = i;
        }
        double q0 = eigenVectors.get(0, index);
        double qx = eigenVectors.get(1, index);
        double qy = eigenVectors.get(2, index);
        double qz = eigenVectors.get(3, index);
        this.m00 = s * (q0 * q0 + qx * qx - qy * qy - qz * qz);
        this.m01 = s * 2.0 * (qx * qy - q0 * qz);
        this.m02 = s * 2.0 * (qx * qz + q0 * qy);
        this.m10 = s * 2.0 * (qy * qx + q0 * qz);
        this.m11 = s * (q0 * q0 - qx * qx + qy * qy - qz * qz);
        this.m12 = s * 2.0 * (qy * qz - q0 * qx);
        this.m20 = s * 2.0 * (qz * qx - q0 * qy);
        this.m21 = s * 2.0 * (qz * qy + q0 * qx);
        this.m22 = s * (q0 * q0 - qx * qx - qy * qy + qz * qz);
    }

    public final void set(TranslationInvariantSimilarityModel3D m) {
        this.m00 = m.m00;
        this.m10 = m.m10;
        this.m20 = m.m20;
        this.m01 = m.m01;
        this.m11 = m.m11;
        this.m21 = m.m21;
        this.m02 = m.m02;
        this.m12 = m.m12;
        this.m22 = m.m22;
        this.cost = m.cost;
    }

    public TranslationInvariantSimilarityModel3D copy() {
        TranslationInvariantSimilarityModel3D m = new TranslationInvariantSimilarityModel3D();
        m.m00 = this.m00;
        m.m10 = this.m10;
        m.m20 = this.m20;
        m.m01 = this.m01;
        m.m11 = this.m11;
        m.m21 = this.m21;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.m22 = this.m22;
        m.cost = this.cost;
        return m;
    }

    public final int getMinNumMatches() {
        return 3;
    }

    public final double[] apply(double[] l) {
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    public final void applyInPlace(double[] l) {
        assert (l.length == 3) : "3d affine transformations can be applied to 3d points only.";
        double l0 = l[0];
        double l1 = l[1];
        l[0] = l0 * this.m00 + l1 * this.m01 + l[2] * this.m02;
        l[1] = l0 * this.m10 + l1 * this.m11 + l[2] * this.m12;
        l[2] = l0 * this.m20 + l1 * this.m21 + l[2] * this.m22;
    }

    public final String toString() {
        return "3d-affine: (" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m20 + ", " + this.m21 + ", " + this.m22 + ")";
    }
}

