/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.popup;

import bdv.export.ExportMipmapInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.util.Pair;
import spim.fiji.plugin.resave.Generic_Resave_HDF5;
import spim.fiji.plugin.resave.ProgressWriterIJ;
import spim.fiji.plugin.resave.Resave_HDF5;
import spim.fiji.plugin.resave.Resave_TIFF;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.popup.ViewExplorerSetable;
import spim.fiji.spimdata.imgloaders.AbstractImgFactoryImgLoader;
import spim.fiji.spimdata.imgloaders.MicroManagerImgLoader;

public class ResavePopup
extends JMenu
implements ViewExplorerSetable {
    public static final int askWhenMoreThan = 5;
    private static final long serialVersionUID = 5234649267634013390L;
    ViewSetupExplorerPanel<?, ?> panel;
    protected static String[] types = new String[]{"As TIFF ...", "As compressed TIFF ...", "As HDF5 ...", "As compressed HDF5 ..."};

    public ResavePopup() {
        super("Resave Dataset");
        JMenuItem tiff = new JMenuItem(types[0]);
        JMenuItem zippedTiff = new JMenuItem(types[1]);
        JMenuItem hdf5 = new JMenuItem(types[2]);
        JMenuItem deflatehdf5 = new JMenuItem(types[3]);
        tiff.addActionListener(new MyActionListener(0));
        zippedTiff.addActionListener(new MyActionListener(1));
        hdf5.addActionListener(new MyActionListener(2));
        deflatehdf5.addActionListener(new MyActionListener(3));
        this.add(tiff);
        this.add(zippedTiff);
        this.add(hdf5);
        this.add(deflatehdf5);
    }

    @Override
    public JMenuItem setViewExplorer(ViewSetupExplorerPanel<? extends AbstractSpimData<? extends AbstractSequenceDescription<?, ?, ?>>, ?> panel) {
        this.panel = panel;
        return this;
    }

    public class MyActionListener
    implements ActionListener {
        final int index;

        public MyActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ResavePopup.this.panel == null) {
                IOFunctions.println("Panel not set for " + this.getClass().getSimpleName());
                return;
            }
            if (!SpimData2.class.isInstance(ResavePopup.this.panel.getSpimData())) {
                IOFunctions.println("Only supported for SpimData2 objects: " + this.getClass().getSimpleName());
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SpimData2 data = (SpimData2)((Object)ResavePopup.this.panel.getSpimData());
                    List<ViewId> viewIds = ResavePopup.this.panel.selectedRowsViewId();
                    String question = viewIds.size() < ResavePopup.this.panel.getTableModel().getElements().size() ? "Are you sure you only want to export " + viewIds.size() + " of " + ResavePopup.this.panel.getTableModel().getElements().size() + " views?\n(the rest will not be visible in the new dataset)\n" : "Resaving all views of the current dataset.\n";
                    if (JOptionPane.showConfirmDialog(null, question + "Note: this will first save the current state of the open XML. Proceed?", "Warning", 0) == 1) {
                        return;
                    }
                    ProgressWriterIJ progressWriter = new ProgressWriterIJ();
                    progressWriter.out().println("Resaving " + viewIds.size() + " views " + types[MyActionListener.this.index]);
                    if (MyActionListener.this.index < 2) {
                        ResavePopup.this.panel.saveXML();
                        Resave_TIFF.Parameters params = new Resave_TIFF.Parameters();
                        boolean bl = params.compress = MyActionListener.this.index != 0;
                        params.imgFactory = AbstractImgFactoryImgLoader.class.isInstance(((SequenceDescription)data.getSequenceDescription()).getImgLoader()) ? ((AbstractImgFactoryImgLoader)((SequenceDescription)data.getSequenceDescription()).getImgLoader()).getImgFactory() : (MicroManagerImgLoader.class.isInstance(((SequenceDescription)data.getSequenceDescription()).getImgLoader()) ? new ArrayImgFactory() : new CellImgFactory());
                        params.xmlFile = ResavePopup.this.panel.xml();
                        Resave_TIFF.writeTIFF(data, viewIds, new File(params.xmlFile).getParent(), params.compress, progressWriter);
                        Pair<SpimData2, List<String>> result = Resave_TIFF.createXMLObject(data, viewIds, params);
                        progressWriter.setProgress(1.01);
                        ResavePopup.this.panel.setSpimData(result.getA());
                        ResavePopup.this.panel.updateContent();
                        ResavePopup.this.panel.saveXML();
                    } else if (MyActionListener.this.index == 2 || MyActionListener.this.index == 3) {
                        ArrayList<ViewSetup> setups = SpimData2.getAllViewSetupsSorted(data, viewIds);
                        Resave_HDF5.loadDimensions(data, setups);
                        ResavePopup.this.panel.saveXML();
                        Map<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = Resave_HDF5.proposeMipmaps(setups);
                        int firstviewSetupId = ((ViewSetup)((SequenceDescription)data.getSequenceDescription()).getViewSetupsOrdered().get(0)).getId();
                        ExportMipmapInfo autoMipmapSettings = perSetupExportMipmapInfo.get(firstviewSetupId);
                        boolean compress = MyActionListener.this.index != 2;
                        String hdf5Filename = ResavePopup.this.panel.xml().substring(0, ResavePopup.this.panel.xml().length() - 4) + ".h5";
                        File hdf5File = new File(hdf5Filename);
                        IOFunctions.println("HDF5 file: " + hdf5File.getAbsolutePath());
                        Generic_Resave_HDF5.Parameters params = new Generic_Resave_HDF5.Parameters(false, autoMipmapSettings.getExportResolutions(), autoMipmapSettings.getSubdivisions(), new File(ResavePopup.this.panel.xml()), hdf5File, compress, false, 1, 0, false, 0, 0, Double.NaN, Double.NaN);
                        Generic_Resave_HDF5.writeHDF5(Resave_HDF5.reduceSpimData2(data, viewIds), params, progressWriter);
                        Pair<SpimData2, List<String>> result = Resave_HDF5.createXMLObject(data, viewIds, params, progressWriter, true);
                        ResavePopup.this.panel.setSpimData(result.getA());
                        ResavePopup.this.panel.updateContent();
                        progressWriter.setProgress(1.0);
                        ResavePopup.this.panel.saveXML();
                        progressWriter.out().println("done");
                    }
                }
            }).start();
        }
    }
}

