/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.geometry;

import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.geometry.GeometryVector;
import org.ojalgo.matrix.store.operation.MultiplyBoth;

public class Primitive64Vector2
extends GeometryVector {
    public double v0;
    public double v1;

    public Primitive64Vector2() {
        super(MultiplyBoth.getPrimitive(2L, 1L), 2L, 1L);
    }

    public Primitive64Vector2(double v0, double v1) {
        this();
        this.v0 = v0;
        this.v1 = v1;
    }

    @Override
    public final void add(int row, double addend) {
        switch (row) {
            case 0: {
                this.v0 += addend;
                break;
            }
            case 1: {
                this.v1 += addend;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public final long count() {
        return 2L;
    }

    @Override
    public final double doubleValue(int index) {
        switch (index) {
            case 0: {
                return this.v0;
            }
            case 1: {
                return this.v1;
            }
        }
        throw new IllegalArgumentException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primitive64Vector2)) {
            return false;
        }
        Primitive64Vector2 other = (Primitive64Vector2)obj;
        if (Double.doubleToLongBits(this.v0) != Double.doubleToLongBits(other.v0)) {
            return false;
        }
        return Double.doubleToLongBits(this.v1) == Double.doubleToLongBits(other.v1);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.v0);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.v1);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public final void modifyOne(int row, UnaryFunction<Double> modifier) {
        switch (row) {
            case 0: {
                this.v0 = modifier.invoke(this.v0);
                break;
            }
            case 1: {
                this.v1 = modifier.invoke(this.v1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public final void set(int row, double value) {
        switch (row) {
            case 0: {
                this.v0 = value;
                break;
            }
            case 1: {
                this.v1 = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

