/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.iotiming;

import java.util.concurrent.ConcurrentHashMap;
import net.imglib2.cache.iotiming.IoStatistics;
import net.imglib2.cache.iotiming.IoTimeBudget;

public class CacheIoTiming {
    private static final ConcurrentHashMap<ThreadGroup, IoStatistics> perThreadGroupIoStatistics = new ConcurrentHashMap();

    public static IoStatistics getIoStatistics() {
        return CacheIoTiming.getIoStatistics(Thread.currentThread().getThreadGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IoStatistics getIoStatistics(ThreadGroup key) {
        IoStatistics statistics = perThreadGroupIoStatistics.get(key);
        if (statistics == null) {
            ConcurrentHashMap<ThreadGroup, IoStatistics> concurrentHashMap = perThreadGroupIoStatistics;
            synchronized (concurrentHashMap) {
                statistics = perThreadGroupIoStatistics.get(key);
                if (statistics == null) {
                    statistics = new IoStatistics();
                    perThreadGroupIoStatistics.put(key, statistics);
                }
            }
        }
        return statistics;
    }

    public static IoTimeBudget getIoTimeBudget() {
        return CacheIoTiming.getIoStatistics().getIoTimeBudget();
    }

    public static IoTimeBudget getIoTimeBudget(ThreadGroup key) {
        return CacheIoTiming.getIoStatistics(key).getIoTimeBudget();
    }

    private CacheIoTiming() {
    }
}

