/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.util;

import java.util.Arrays;
import java.util.function.Function;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.cache.CacheLoader;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;

public class IntervalKeyLoaderAsLongKeyLoader<A>
implements CacheLoader<Long, Cell<A>> {
    private final CellGrid grid;
    private final Function<Interval, A> intervalKeyLoader;

    public IntervalKeyLoaderAsLongKeyLoader(CellGrid grid, Function<Interval, A> intervalKeyLoader) {
        this.grid = grid;
        this.intervalKeyLoader = intervalKeyLoader;
    }

    @Override
    public Cell<A> get(Long key) {
        long index = key;
        int n = this.grid.numDimensions();
        long[] cellMin = new long[n];
        long[] cellMax = new long[n];
        CellGrid.CellDimensionsAndSteps dimsAndSteps = this.grid.getCellDimensions(index, cellMin);
        Arrays.setAll(cellMax, d -> cellMin[d] + (long)dimsAndSteps.dimensions()[d] - 1L);
        A result = this.intervalKeyLoader.apply((Interval)FinalInterval.wrap((long[])cellMin, (long[])cellMax));
        return new Cell(dimsAndSteps, cellMin, result);
    }
}

