/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.io;

import edu.mines.jtk.io.ArrayInput;
import edu.mines.jtk.io.ArrayInputAdapter;
import edu.mines.jtk.io.ArrayOutput;
import edu.mines.jtk.io.ArrayOutputAdapter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;

public class ArrayFile
implements ArrayInput,
ArrayOutput,
Closeable {
    private RandomAccessFile _raf;
    private ByteOrder _bor;
    private ByteOrder _bow;
    private ArrayInput _ai;
    private ArrayOutput _ao;

    public ArrayFile(String name, String mode) throws FileNotFoundException {
        this(name, mode, ByteOrder.BIG_ENDIAN, ByteOrder.BIG_ENDIAN);
    }

    public ArrayFile(File file, String mode) throws FileNotFoundException {
        this(file, mode, ByteOrder.BIG_ENDIAN, ByteOrder.BIG_ENDIAN);
    }

    public ArrayFile(String name, String mode, ByteOrder bor, ByteOrder bow) throws FileNotFoundException {
        this(name != null ? new File(name) : null, mode, bor, bow);
    }

    public ArrayFile(File file, String mode, ByteOrder bor, ByteOrder bow) throws FileNotFoundException {
        this(new RandomAccessFile(file, mode), bor, bow);
    }

    public ArrayFile(RandomAccessFile raf, ByteOrder bor, ByteOrder bow) {
        this._raf = raf;
        this._bor = bor;
        this._bow = bow;
        this._ai = new ArrayInputAdapter(raf, bor);
        this._ao = new ArrayOutputAdapter(raf, bow);
    }

    public ByteOrder getByteOrderRead() {
        return this._bor;
    }

    public ByteOrder getByteOrderWrite() {
        return this._bow;
    }

    public int read() throws IOException {
        return this._raf.read();
    }

    public int read(byte[] b) throws IOException {
        return this._raf.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this._raf.read(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this._ai.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this._ai.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this._ai.skipBytes(n);
    }

    @Override
    public void write(int b) throws IOException {
        this._ao.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this._ao.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this._ao.write(b, off, len);
    }

    public long getFilePointer() throws IOException {
        return this._raf.getFilePointer();
    }

    public void seek(long off) throws IOException {
        this._raf.seek(off);
    }

    public long length() throws IOException {
        return this._raf.length();
    }

    public void setLength(long newLength) throws IOException {
        this._raf.setLength(newLength);
    }

    @Override
    public void close() throws IOException {
        this._raf.close();
        this._raf = null;
        this._ai = null;
        this._ao = null;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this._ai.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this._ai.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this._ai.readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        return this._ai.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this._ai.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return this._ai.readChar();
    }

    @Override
    public final int readInt() throws IOException {
        return this._ai.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this._ai.readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return this._ai.readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this._ai.readDouble();
    }

    @Override
    public final String readLine() throws IOException {
        return this._ai.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this._ai.readUTF();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this._ao.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this._ao.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this._ao.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this._ao.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this._ao.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this._ao.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this._ao.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this._ao.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this._ao.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this._ao.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this._ao.writeUTF(s);
    }

    @Override
    public void readBytes(byte[] v, int k, int n) throws IOException {
        this._ai.readBytes(v, k, n);
    }

    @Override
    public void readBytes(byte[] v) throws IOException {
        this._ai.readBytes(v);
    }

    @Override
    public void readBytes(byte[][] v) throws IOException {
        this._ai.readBytes(v);
    }

    @Override
    public void readBytes(byte[][][] v) throws IOException {
        this._ai.readBytes(v);
    }

    @Override
    public void readChars(char[] v, int k, int n) throws IOException {
        this._ai.readChars(v, k, n);
    }

    @Override
    public void readChars(char[] v) throws IOException {
        this._ai.readChars(v);
    }

    @Override
    public void readChars(char[][] v) throws IOException {
        this._ai.readChars(v);
    }

    @Override
    public void readChars(char[][][] v) throws IOException {
        this._ai.readChars(v);
    }

    @Override
    public void readShorts(short[] v, int k, int n) throws IOException {
        this._ai.readShorts(v, k, n);
    }

    @Override
    public void readShorts(short[] v) throws IOException {
        this._ai.readShorts(v);
    }

    @Override
    public void readShorts(short[][] v) throws IOException {
        this._ai.readShorts(v);
    }

    @Override
    public void readShorts(short[][][] v) throws IOException {
        this._ai.readShorts(v);
    }

    @Override
    public void readInts(int[] v, int k, int n) throws IOException {
        this._ai.readInts(v, k, n);
    }

    @Override
    public void readInts(int[] v) throws IOException {
        this._ai.readInts(v);
    }

    @Override
    public void readInts(int[][] v) throws IOException {
        this._ai.readInts(v);
    }

    @Override
    public void readInts(int[][][] v) throws IOException {
        this._ai.readInts(v);
    }

    @Override
    public void readLongs(long[] v, int k, int n) throws IOException {
        this._ai.readLongs(v, k, n);
    }

    @Override
    public void readLongs(long[] v) throws IOException {
        this._ai.readLongs(v);
    }

    @Override
    public void readLongs(long[][] v) throws IOException {
        this._ai.readLongs(v);
    }

    @Override
    public void readLongs(long[][][] v) throws IOException {
        this._ai.readLongs(v);
    }

    @Override
    public void readFloats(float[] v, int k, int n) throws IOException {
        this._ai.readFloats(v, k, n);
    }

    @Override
    public void readFloats(float[] v) throws IOException {
        this._ai.readFloats(v);
    }

    @Override
    public void readFloats(float[][] v) throws IOException {
        this._ai.readFloats(v);
    }

    @Override
    public void readFloats(float[][][] v) throws IOException {
        this._ai.readFloats(v);
    }

    @Override
    public void readDoubles(double[] v, int k, int n) throws IOException {
        this._ai.readDoubles(v, k, n);
    }

    @Override
    public void readDoubles(double[] v) throws IOException {
        this._ai.readDoubles(v);
    }

    @Override
    public void readDoubles(double[][] v) throws IOException {
        this._ai.readDoubles(v);
    }

    @Override
    public void readDoubles(double[][][] v) throws IOException {
        this._ai.readDoubles(v);
    }

    @Override
    public void writeBytes(byte[] v, int k, int n) throws IOException {
        this._ao.writeBytes(v, k, n);
    }

    @Override
    public void writeBytes(byte[] v) throws IOException {
        this._ao.writeBytes(v);
    }

    @Override
    public void writeBytes(byte[][] v) throws IOException {
        this._ao.writeBytes(v);
    }

    @Override
    public void writeBytes(byte[][][] v) throws IOException {
        this._ao.writeBytes(v);
    }

    @Override
    public void writeChars(char[] v, int k, int n) throws IOException {
        this._ao.writeChars(v, k, n);
    }

    @Override
    public void writeChars(char[] v) throws IOException {
        this._ao.writeChars(v);
    }

    @Override
    public void writeChars(char[][] v) throws IOException {
        this._ao.writeChars(v);
    }

    @Override
    public void writeChars(char[][][] v) throws IOException {
        this._ao.writeChars(v);
    }

    @Override
    public void writeShorts(short[] v, int k, int n) throws IOException {
        this._ao.writeShorts(v, k, n);
    }

    @Override
    public void writeShorts(short[] v) throws IOException {
        this._ao.writeShorts(v);
    }

    @Override
    public void writeShorts(short[][] v) throws IOException {
        this._ao.writeShorts(v);
    }

    @Override
    public void writeShorts(short[][][] v) throws IOException {
        this._ao.writeShorts(v);
    }

    @Override
    public void writeInts(int[] v, int k, int n) throws IOException {
        this._ao.writeInts(v, k, n);
    }

    @Override
    public void writeInts(int[] v) throws IOException {
        this._ao.writeInts(v);
    }

    @Override
    public void writeInts(int[][] v) throws IOException {
        this._ao.writeInts(v);
    }

    @Override
    public void writeInts(int[][][] v) throws IOException {
        this._ao.writeInts(v);
    }

    @Override
    public void writeLongs(long[] v, int k, int n) throws IOException {
        this._ao.writeLongs(v, k, n);
    }

    @Override
    public void writeLongs(long[] v) throws IOException {
        this._ao.writeLongs(v);
    }

    @Override
    public void writeLongs(long[][] v) throws IOException {
        this._ao.writeLongs(v);
    }

    @Override
    public void writeLongs(long[][][] v) throws IOException {
        this._ao.writeLongs(v);
    }

    @Override
    public void writeFloats(float[] v, int k, int n) throws IOException {
        this._ao.writeFloats(v, k, n);
    }

    @Override
    public void writeFloats(float[] v) throws IOException {
        this._ao.writeFloats(v);
    }

    @Override
    public void writeFloats(float[][] v) throws IOException {
        this._ao.writeFloats(v);
    }

    @Override
    public void writeFloats(float[][][] v) throws IOException {
        this._ao.writeFloats(v);
    }

    @Override
    public void writeDoubles(double[] v, int k, int n) throws IOException {
        this._ao.writeDoubles(v, k, n);
    }

    @Override
    public void writeDoubles(double[] v) throws IOException {
        this._ao.writeDoubles(v);
    }

    @Override
    public void writeDoubles(double[][] v) throws IOException {
        this._ao.writeDoubles(v);
    }

    @Override
    public void writeDoubles(double[][][] v) throws IOException {
        this._ao.writeDoubles(v);
    }
}

