/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.la;

import edu.mines.jtk.la.TridiagonalFMatrix;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TridiagonalFMatrixTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(TridiagonalFMatrixTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSolve() {
        int n = 100;
        float[] a = ArrayMath.randfloat(n);
        float[] b = ArrayMath.randfloat(n);
        float[] c = ArrayMath.randfloat(n);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            b[n2] = b[n2] + (a[i] + c[i]);
        }
        TridiagonalFMatrix t = new TridiagonalFMatrix(n, a, b, c);
        float[] r = ArrayMath.randfloat(n);
        float[] u = ArrayMath.zerofloat(n);
        t.solve(r, u);
        float[] s = t.times(u);
        TridiagonalFMatrixTest.assertEqualFuzzy(r, s);
    }

    private static void assertEqualFuzzy(float[] a, float[] b) {
        int n = a.length;
        double eps = 1.0E-6 * (double)ArrayMath.max(ArrayMath.max(a), ArrayMath.max(b));
        for (int j = 0; j < n; ++j) {
            TridiagonalFMatrixTest.assertEquals((double)a[j], (double)b[j], (double)eps);
        }
    }
}

