/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.Float3;

public class Clips {
    private boolean _clipsDirty = true;
    private float _clipMin;
    private float _clipMax;
    private float _percMin = 0.0f;
    private float _percMax = 100.0f;
    private boolean _usePercentiles = true;
    private Object _f;

    public Clips(float[] f) {
        this(0.0, 100.0, f);
    }

    public Clips(float[][] f) {
        this(0.0, 100.0, f);
    }

    public Clips(float[][][] f) {
        this(0.0, 100.0, f);
    }

    public Clips(Float3 f3) {
        this(0.0, 100.0, f3);
    }

    public Clips(double percMin, double percMax, float[] f) {
        this._percMin = (float)percMin;
        this._percMax = (float)percMax;
        this._f = f;
    }

    public Clips(double percMin, double percMax, float[][] f) {
        this._percMin = (float)percMin;
        this._percMax = (float)percMax;
        this._f = f;
    }

    public Clips(double percMin, double percMax, float[][][] f) {
        this._percMin = (float)percMin;
        this._percMax = (float)percMax;
        this._f = f;
    }

    public Clips(double percMin, double percMax, Float3 f3) {
        this._percMin = (float)percMin;
        this._percMax = (float)percMax;
        this._f = f3;
    }

    public void setArray(float[] f) {
        this._f = f;
        this._clipsDirty = true;
    }

    public void setArray(float[][] f) {
        this._f = f;
        this._clipsDirty = true;
    }

    public void setArray(float[][][] f) {
        this._f = f;
        this._clipsDirty = true;
    }

    public void setArray(Float3 f3) {
        this._f = f3;
        this._clipsDirty = true;
    }

    public void setClips(double clipMin, double clipMax) {
        Check.argument(clipMin < clipMax, "clipMin<clipMax");
        if (this._clipMin != (float)clipMin || this._clipMax != (float)clipMax || this._usePercentiles) {
            this._usePercentiles = false;
            this._clipMin = (float)clipMin;
            this._clipMax = (float)clipMax;
            this._clipsDirty = false;
        }
    }

    public float getClipMin() {
        this.updateClips();
        return this._clipMin;
    }

    public float getClipMax() {
        this.updateClips();
        return this._clipMax;
    }

    public void setPercentiles(double percMin, double percMax) {
        Check.argument(0.0 <= percMin, "0<=percMin");
        Check.argument(percMin < percMax, "percMin<percMax");
        Check.argument(percMax <= 100.0, "percMax<=100");
        if (this._percMin != (float)percMin || this._percMax != (float)percMax || !this._usePercentiles) {
            this._usePercentiles = true;
            this._percMin = (float)percMin;
            this._percMax = (float)percMax;
            this._clipsDirty = true;
        }
    }

    public float getPercentileMin() {
        return this._percMin;
    }

    public float getPercentileMax() {
        return this._percMax;
    }

    private void updateClips() {
        if (this._clipsDirty && this._usePercentiles) {
            boolean clipsComputed = false;
            if (this._percMin == 0.0f && this._percMax == 100.0f) {
                if (this._f instanceof float[]) {
                    float[] a = (float[])this._f;
                    this._clipMin = ArrayMath.min(a);
                    this._clipMax = ArrayMath.max(a);
                    clipsComputed = true;
                } else if (this._f instanceof float[][]) {
                    float[][] a = (float[][])this._f;
                    this._clipMin = ArrayMath.min(a);
                    this._clipMax = ArrayMath.max(a);
                    clipsComputed = true;
                } else if (this._f instanceof float[][][]) {
                    float[][][] a = (float[][][])this._f;
                    this._clipMin = ArrayMath.min(a);
                    this._clipMax = ArrayMath.max(a);
                    clipsComputed = true;
                } else if (this._f instanceof Float3) {
                    Float3 f3 = (Float3)this._f;
                    int n1 = f3.getN1();
                    int n2 = f3.getN2();
                    int n3 = f3.getN3();
                    float[][] a = new float[n2][n1];
                    for (int i3 = 0; i3 < n3; ++i3) {
                        f3.get12(n1, n2, 0, 0, i3, a);
                        this._clipMin = ArrayMath.min(this._clipMin, ArrayMath.min(a));
                        this._clipMax = ArrayMath.max(this._clipMax, ArrayMath.max(a));
                    }
                    clipsComputed = true;
                }
            } else {
                float[] a = null;
                if (this._f instanceof float[]) {
                    a = ArrayMath.copy((float[])this._f);
                } else if (this._f instanceof float[][]) {
                    a = ArrayMath.flatten((float[][])this._f);
                } else if (this._f instanceof float[][][]) {
                    a = ArrayMath.flatten((float[][][])this._f);
                } else if (this._f instanceof Float3) {
                    Float3 f3 = (Float3)this._f;
                    int n1 = f3.getN1();
                    int n2 = f3.getN2();
                    int n3 = f3.getN3();
                    a = new float[n1 * n2 * n3];
                    f3.get123(n1, n2, n3, 0, 0, 0, a);
                }
                if (a != null) {
                    int n = a.length;
                    int kmin = (int)ArrayMath.rint((double)this._percMin * 0.01 * (double)(n - 1));
                    if (kmin <= 0) {
                        this._clipMin = ArrayMath.min(a);
                    } else {
                        ArrayMath.quickPartialSort(kmin, a);
                        this._clipMin = a[kmin];
                    }
                    int kmax = (int)ArrayMath.rint((double)this._percMax * 0.01 * (double)(n - 1));
                    if (kmax >= n - 1) {
                        this._clipMax = ArrayMath.max(a);
                    } else {
                        ArrayMath.quickPartialSort(kmax, a);
                        this._clipMax = a[kmax];
                    }
                    clipsComputed = true;
                }
            }
            if (clipsComputed) {
                this.makeClipsValid();
                this._clipsDirty = false;
            }
        }
    }

    private void makeClipsValid() {
        if (this._clipMin >= this._clipMax) {
            double clipAvg = 0.5 * (double)(this._clipMin + this._clipMax);
            double tiny = ArrayMath.max(1.0, (double)Math.ulp(1.0f) * ArrayMath.abs(clipAvg));
            this._clipMin = (float)((double)this._clipMin - tiny);
            this._clipMax = (float)((double)this._clipMax + tiny);
        }
    }
}

