/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.render.VolatileProjector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.iotiming.CacheIoTiming;
import net.imglib2.cache.iotiming.IoStatistics;
import net.imglib2.converter.Converter;
import net.imglib2.type.operators.SetZero;
import net.imglib2.util.Intervals;
import net.imglib2.util.StopWatch;
import net.imglib2.view.Views;

public class VolatileHierarchyProjector<A extends Volatile<?>, B extends SetZero>
implements VolatileProjector {
    private final Converter<? super A, B> converter;
    private final RandomAccessibleInterval<B> target;
    private final List<RandomAccessible<A>> sources;
    private final byte[] mask;
    private volatile boolean valid = false;
    private int numInvalidLevels;
    private final FinalInterval sourceInterval;
    private long lastFrameRenderNanoTime;
    private long lastFrameIoNanoTime;
    private int numInvalidPixels;
    private volatile boolean canceled = false;

    public VolatileHierarchyProjector(List<? extends RandomAccessible<A>> sources, Converter<? super A, B> converter, RandomAccessibleInterval<B> target) {
        this(sources, converter, target, new byte[(int)(target.dimension(0) * target.dimension(1))]);
    }

    public VolatileHierarchyProjector(List<? extends RandomAccessible<A>> sources, Converter<? super A, B> converter, RandomAccessibleInterval<B> target, byte[] maskArray) {
        this.converter = converter;
        this.target = target;
        this.sources = new ArrayList<RandomAccessible<A>>(sources);
        this.numInvalidLevels = sources.size();
        this.mask = maskArray;
        int n = Math.max(2, sources.get(0).numDimensions());
        long[] min = new long[n];
        long[] max = new long[n];
        min[0] = target.min(0);
        max[0] = target.max(0);
        min[1] = target.min(1);
        max[1] = target.max(1);
        this.sourceInterval = new FinalInterval(min, max);
        this.lastFrameRenderNanoTime = -1L;
        this.clearMask();
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public long getLastFrameRenderNanoTime() {
        return this.lastFrameRenderNanoTime;
    }

    public long getLastFrameIoNanoTime() {
        return this.lastFrameIoNanoTime;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void clearMask() {
        int size = (int)Intervals.numElements(this.target);
        Arrays.fill(this.mask, 0, size, (byte)127);
        this.numInvalidLevels = this.sources.size();
    }

    private void clearUntouchedTargetPixels() {
        int i = 0;
        for (SetZero t : Views.flatIterable(this.target)) {
            if (this.mask[i++] != 127) continue;
            t.setZero();
        }
    }

    @Override
    public boolean map(boolean clearUntouchedTargetPixels) {
        if (this.canceled) {
            return false;
        }
        this.valid = false;
        StopWatch stopWatch = StopWatch.createAndStart();
        IoStatistics iostat = CacheIoTiming.getIoStatistics();
        long startTimeIo = iostat.getIoNanoTime();
        for (int resolutionLevel = 0; resolutionLevel < this.numInvalidLevels; ++resolutionLevel) {
            this.numInvalidPixels = 0;
            this.map((byte)resolutionLevel);
            if (this.canceled) {
                return false;
            }
            if (this.numInvalidPixels != 0) continue;
            this.numInvalidLevels = resolutionLevel;
        }
        if (clearUntouchedTargetPixels && this.numInvalidPixels != 0 && !this.canceled) {
            this.clearUntouchedTargetPixels();
        }
        this.lastFrameIoNanoTime = iostat.getIoNanoTime() - startTimeIo;
        long lastFrameTime = stopWatch.nanoTime();
        this.lastFrameRenderNanoTime = lastFrameTime - this.lastFrameIoNanoTime;
        this.valid = this.numInvalidLevels == 0;
        return !this.canceled;
    }

    private void map(byte resolutionIndex) {
        if (this.canceled) {
            return;
        }
        RandomAccess targetRandomAccess = this.target.randomAccess(this.target);
        RandomAccess<A> sourceRandomAccess = this.sources.get(resolutionIndex).randomAccess(this.sourceInterval);
        int width = (int)this.target.dimension(0);
        int height = (int)this.target.dimension(1);
        long[] smin = Intervals.minAsLongArray(this.sourceInterval);
        int myNumInvalidPixels = 0;
        for (int y = 0; y < height; ++y) {
            if (this.canceled) {
                return;
            }
            sourceRandomAccess.setPosition(smin);
            targetRandomAccess.setPosition(smin);
            int mi = y * width;
            for (int x = 0; x < width; ++x) {
                if (this.mask[mi + x] > resolutionIndex) {
                    Volatile a = (Volatile)sourceRandomAccess.get();
                    boolean v = a.isValid();
                    if (v) {
                        this.converter.convert(a, targetRandomAccess.get());
                        this.mask[mi + x] = resolutionIndex;
                    } else {
                        ++myNumInvalidPixels;
                    }
                }
                sourceRandomAccess.fwd(0);
                targetRandomAccess.fwd(0);
            }
            smin[1] = smin[1] + 1L;
        }
        this.numInvalidPixels += myNumInvalidPixels;
    }
}

