/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.imageplus;

import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.imageplus.ByteImagePlus;
import net.imglib2.img.imageplus.FloatImagePlus;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.IntImagePlus;
import net.imglib2.img.imageplus.ShortImagePlus;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class ImagePlusImgFactory<T extends NativeType<T>>
extends PlanarImgFactory<T> {
    public ImagePlusImgFactory(T type) {
        super(type);
    }

    public ImagePlusImg<T, ?> create(long ... dimensions) {
        ImagePlusImg<NativeType, ?> img = this.create(dimensions, (NativeType)this.type(), ((NativeType)this.type()).getNativeTypeFactory());
        return img;
    }

    public ImagePlusImg<T, ?> create(Dimensions dimensions) {
        return this.create(Intervals.dimensionsAsLongArray((Dimensions)dimensions));
    }

    public ImagePlusImg<T, ?> create(int[] dimensions) {
        return this.create(Util.int2long((int[])dimensions));
    }

    private <A extends ArrayDataAccess<A>> ImagePlusImg<T, ?> create(long[] dimensions, T type, NativeTypeFactory<T, A> typeFactory) {
        ImagePlusImg img;
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        switch (typeFactory.getPrimitiveType()) {
            case BYTE: {
                img = new ByteImagePlus(dimensions, entitiesPerPixel);
                break;
            }
            case FLOAT: {
                img = new FloatImagePlus(dimensions, entitiesPerPixel);
                break;
            }
            case INT: {
                img = new IntImagePlus(dimensions, entitiesPerPixel);
                break;
            }
            case SHORT: {
                img = new ShortImagePlus(dimensions, entitiesPerPixel);
                break;
            }
            default: {
                ArrayDataAccess creator = ArrayDataAccessFactory.get(typeFactory);
                img = new ImagePlusImg(creator, dimensions, entitiesPerPixel);
            }
        }
        img.setLinkedType(typeFactory.createLinkedType(img));
        return img;
    }

    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new ImagePlusImgFactory<NativeType>((NativeType)type);
        }
        throw new IncompatibleTypeException((Object)this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    @Deprecated
    public ImagePlusImgFactory() {
    }

    @Deprecated
    public ImagePlusImg<T, ?> create(long[] dimensions, T type) {
        this.cache(type);
        ImagePlusImg<T, ?> img = this.create(dimensions, type, type.getNativeTypeFactory());
        return img;
    }
}

