/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.services.DatasetIOService;
import java.io.IOException;
import java.net.URISyntaxException;
import net.imagej.Dataset;
import org.scijava.io.AbstractIOPlugin;
import org.scijava.io.IOPlugin;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=IOPlugin.class, priority=-100.0)
public class DatasetIOPlugin
extends AbstractIOPlugin<Dataset> {
    @Parameter
    private DatasetIOService datasetIOService;
    @Parameter
    private LocationService locationService;

    public Class<Dataset> getDataType() {
        return Dataset.class;
    }

    public boolean supportsOpen(String source) {
        return this.datasetIOService.canOpen(this.resolve(source, "source"));
    }

    public boolean supportsOpen(Location source) {
        return this.datasetIOService.canOpen(source);
    }

    public boolean supportsSave(String destination) {
        return this.datasetIOService.canSave(this.resolve(destination, "destination"));
    }

    public boolean supportsSave(Location destination) {
        return this.datasetIOService.canSave(destination);
    }

    public Dataset open(String source) throws IOException {
        return this.datasetIOService.open(this.resolve(source, "source"));
    }

    public Dataset open(Location source) throws IOException {
        return this.datasetIOService.open(source);
    }

    public void save(Dataset dataset, String destination) throws IOException {
        this.datasetIOService.save(dataset, this.resolve(destination, "destination"));
    }

    public void save(Dataset dataset, Location destination) throws IOException {
        this.datasetIOService.save(dataset, destination);
    }

    private Location resolve(String uriString, String label) {
        try {
            Location location = this.locationService.resolve(uriString);
            if (location != null) {
                return location;
            }
            throw new IllegalArgumentException("Unresolvable " + label + ": " + uriString);
        }
        catch (URISyntaxException exc) {
            throw new IllegalArgumentException("Invalid " + label + ": " + uriString, exc);
        }
    }
}

