/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.console;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.scijava.log.LogMessage;
import org.scijava.log.LogSource;

class LogSourcesPanel
extends JPanel {
    private static final EnumSet<Level> VALID_LEVELS = EnumSet.range(Level.ERROR, Level.TRACE);
    private final JPopupMenu menu = new JPopupMenu();
    private final Map<LogSource, Item> sourceItems = new HashMap<LogSource, Item>();
    private JTree tree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Log Sources:");
    private Predicate<LogMessage> filter = message -> true;
    private Runnable changeListener = null;
    private List<LogSource> selected;

    LogSourcesPanel(JButton reloadButton) {
        this.initMenu();
        this.initTreeView();
        JButton visibilityButton = this.initVisibilityButton();
        this.setLayout((LayoutManager)new MigLayout("inset 0", "[grow]", "[][grow][]"));
        this.add((Component)new JLabel("Log Sources:"), "grow, wrap");
        this.add((Component)new JScrollPane(this.tree), "grow, wrap");
        this.add((Component)new JLabel(""), "split 3, grow");
        this.add(reloadButton);
        this.add(visibilityButton);
        LogSourcesPanel.actionWhenFocusLost(() -> this.tree.clearSelection(), Arrays.asList(this.tree, visibilityButton));
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public Predicate<LogMessage> getFilter() {
        if (this.filter == null) {
            this.updateFilter();
        }
        return this.filter;
    }

    public void updateSources(Set<LogSource> logSources) {
        for (LogSource sources : logSources) {
            this.getItem(sources);
        }
        this.treeModel.reload();
    }

    private void initTreeView() {
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        cellRenderer.setIcon(null);
        cellRenderer.setLeafIcon(null);
        cellRenderer.setOpenIcon(null);
        this.tree.setCellRenderer(cellRenderer);
        this.tree.setComponentPopupMenu(this.menu);
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this::selectionChanged);
    }

    private void selectionChanged(TreeSelectionEvent treeSelectionEvent) {
        this.selected = this.getSelectedItems().map(item -> item.source).collect(Collectors.toList());
        this.settingsChanged();
    }

    private JButton initVisibilityButton() {
        JButton button = new JButton("Visibility");
        button.addActionListener(a -> this.menu.show(button, 0, button.getHeight()));
        return button;
    }

    private void initMenu() {
        EnumSet<Level> levels = EnumSet.range(Level.ERROR, Level.TRACE);
        this.addMenuItemPerLevel(EnumSet.of(Level.TRACE), level -> "Show all", this::onShowErrorUpToClicked);
        this.addMenuItemPerLevel(EnumSet.of(Level.NONE), level -> "Hide all", this::onShowNoneClicked);
        this.menu.addSeparator();
        this.addMenuItemPerLevel(levels, level -> "Show " + level.toString(), this::onShowLogLevelClicked);
        this.menu.addSeparator();
        this.addMenuItemPerLevel(levels, level -> "Hide " + level.toString(), this::onHideLogLevelClicked);
        this.menu.addSeparator();
        this.addMenuItemPerLevel(levels, LogSourcesPanel::listLevelsErrorTo, this::onShowErrorUpToClicked);
    }

    private void addMenuItemPerLevel(EnumSet<Level> levels, Function<Level, String> title, Consumer<Level> consumer) {
        for (Level level : levels) {
            JMenuItem menuItem = new JMenuItem(title.apply(level));
            menuItem.addActionListener(a -> consumer.accept(level));
            this.menu.add(menuItem);
        }
    }

    private void onShowLogLevelClicked(Level level) {
        this.modifyFilterOnSelection(filter -> {
            filter.add(level);
            return filter;
        });
    }

    private void onHideLogLevelClicked(Level level) {
        this.modifyFilterOnSelection(filter -> {
            filter.remove((Object)level);
            return filter;
        });
    }

    private void onShowErrorUpToClicked(Level level) {
        EnumSet<Level> enumSet = EnumSet.range(Level.ERROR, level);
        this.modifyFilterOnSelection(ignore -> enumSet);
    }

    private void onShowNoneClicked(Level level) {
        EnumSet<Level> enumSet = EnumSet.noneOf(Level.class);
        this.modifyFilterOnSelection(ignore -> enumSet);
    }

    private void modifyFilterOnSelection(Function<EnumSet<Level>, EnumSet<Level>> itemConsumer) {
        this.getSelectedItems().forEach(item -> {
            item.setLevelSet((EnumSet)itemConsumer.apply(item.levels));
            this.treeModel.nodeChanged(item.node);
        });
        this.settingsChanged();
    }

    private Stream<Item> getSelectedItems() {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return Collections.emptyList().stream();
        }
        return Stream.of(selectionPaths).map(path -> this.getItem((DefaultMutableTreeNode)path.getLastPathComponent()));
    }

    private void settingsChanged() {
        this.filter = null;
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    private Item getItem(DefaultMutableTreeNode node) {
        return (Item)node.getUserObject();
    }

    private Item getItem(LogSource source) {
        Item existing = this.sourceItems.get(source);
        return existing == null ? this.initItem(source) : existing;
    }

    private Item initItem(LogSource source) {
        Item item = new Item(source);
        this.sourceItems.put(item.source, item);
        DefaultMutableTreeNode parent = source.isRoot() ? this.rootNode : this.getItem((LogSource)source.parent()).node;
        parent.add(item.node);
        return item;
    }

    private void updateFilter() {
        HashMap filterData = new HashMap();
        EnumSet<Level> none = EnumSet.noneOf(Level.class);
        this.sourceItems.forEach((name, item) -> filterData.put(name, item.visible ? item.levels : none));
        HashSet<LogSource> selectedSources = new HashSet<LogSource>(this.selected);
        this.filter = message -> {
            if (!selectedSources.isEmpty() && !selectedSources.contains(message.source())) {
                return false;
            }
            EnumSet logLevels = (EnumSet)filterData.get(message.source());
            if (logLevels == null) {
                return true;
            }
            return logLevels.contains((Object)Level.of(message.level()));
        };
    }

    private static String listLevelsErrorTo(Level max) {
        return LogSourcesPanel.enumSetToString(EnumSet.range(Level.ERROR, max));
    }

    private static String enumSetToString(EnumSet<Level> levels) {
        StringJoiner s = new StringJoiner(", ");
        for (Level level : levels) {
            s.add(level.toString());
        }
        return s.toString();
    }

    private static void actionWhenFocusLost(final Runnable action, final List<JComponent> components) {
        FocusListener l = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                boolean keepSelection;
                boolean bl = keepSelection = components.contains(e.getOppositeComponent()) || e.isTemporary();
                if (!keepSelection) {
                    action.run();
                }
            }
        };
        components.forEach(c -> c.addFocusListener(l));
    }

    public static void main(String ... args) {
        JFrame frame = new JFrame();
        LogSourcesPanel logLevelPanel = new LogSourcesPanel(new JButton("dummy"));
        LogSource root = LogSource.newRoot();
        HashSet<LogSource> loggers = new HashSet<LogSource>(Arrays.asList(root.subSource("Hello:World"), root.subSource("Hello:Universe"), root.subSource("Hello:foo:bar")));
        logLevelPanel.updateSources(loggers);
        frame.getContentPane().add((Component)logLevelPanel, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    private static enum Level {
        NONE,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;


        static Level of(int x) {
            switch (x) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return ERROR;
                }
                case 2: {
                    return WARN;
                }
                case 3: {
                    return INFO;
                }
                case 4: {
                    return DEBUG;
                }
            }
            if (x >= 5) {
                return TRACE;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class Item {
        DefaultMutableTreeNode node;
        LogSource source;
        EnumSet<Level> levels = EnumSet.range(Level.ERROR, Level.TRACE);
        boolean visible;

        public Item(LogSource source) {
            this.source = source;
            this.visible = true;
            this.node = new DefaultMutableTreeNode(this);
        }

        public String toString() {
            String name = this.source.isRoot() ? "ROOT" : this.source.name();
            return name + " " + this.getLevelString();
        }

        private String getLevelString() {
            if (this.levels.equals(VALID_LEVELS)) {
                return "";
            }
            if (this.levels.isEmpty()) {
                return "[hidden]";
            }
            return this.levels.toString();
        }

        public void setLevelSet(EnumSet<Level> value) {
            this.levels = value.clone();
        }
    }
}

