/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.ToggleWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingToggleWidget
extends SwingInputWidget<Boolean>
implements ChangeListener,
ToggleWidget<JPanel> {
    private JCheckBox checkBox;

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateModel();
    }

    public Boolean getValue() {
        return this.checkBox.isSelected();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.checkBox = new JCheckBox("");
        this.setToolTip(this.checkBox);
        this.getComponent().add(this.checkBox);
        this.checkBox.addChangeListener(this);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isBoolean();
    }

    public void doRefresh() {
        Boolean value = (Boolean)this.get().getValue();
        if (value != this.getValue()) {
            this.checkBox.setSelected(value != null && value != false);
        }
    }
}

