/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;
import oldsegmenters.SegmentatorModel;

public class LabelBinaryOps
implements PlugInFilter {
    public int setup(String arg, ImagePlus imp) {
        return 1;
    }

    public void run(ImageProcessor ip) {
        SegmentatorModel model = new SegmentatorModel(IJ.getImage());
        int currentSlice = model.data.getCurrentSlice();
        ImageProcessor labelData = model.getLabelImagePlus().getStack().getProcessor(currentSlice);
        if (model.getCurrentMaterial() == null) {
            IJ.showMessage((String)"please select a label first");
            return;
        }
        LabelBinaryOps.close(labelData, IJ.getImage().getRoi(), (byte)model.getCurrentMaterial().id);
        model.updateSlice(currentSlice);
    }

    public static void dilate(ImageProcessor labelData, Roi roi, byte id) {
        int width = labelData.getWidth();
        byte[] pixelData = (byte[])labelData.getPixels();
        LabelBinaryOps.dilate(roi, pixelData, width, id);
    }

    private static void dilate(Roi roi, byte[] pixelData, int width, byte id) {
        ArrayList<Integer> dilateOffset = new ArrayList<Integer>();
        Rectangle bounds = roi != null ? roi.getBoundingRect() : new Rectangle(0, 0, width, pixelData.length / width);
        for (int x = bounds.x; x <= bounds.x + bounds.width; ++x) {
            block1: for (int y = bounds.y; y <= bounds.y + bounds.height; ++y) {
                if (!roi.contains(x, y)) continue;
                for (int i = x - 1; i <= x + 1; ++i) {
                    for (int j = y - 1; j <= y + 1; ++j) {
                        int kernalOffset = i + j * width;
                        if (kernalOffset < 0 || kernalOffset >= pixelData.length || pixelData[kernalOffset] != id) continue;
                        dilateOffset.add(x + y * width);
                        continue block1;
                    }
                }
            }
        }
        for (Integer offset : dilateOffset) {
            pixelData[offset.intValue()] = id;
        }
    }

    public static void erode(ImageProcessor labelData, Roi roi, byte id) {
        byte[] pixelData = (byte[])labelData.getPixels();
        int width = labelData.getWidth();
        LabelBinaryOps.erode(roi, pixelData, width, id);
    }

    private static void erode(Roi roi, byte[] pixelData, int width, byte id) {
        ArrayList<Integer> erodeOffsets = new ArrayList<Integer>();
        Rectangle bounds = roi != null ? roi.getBoundingRect() : new Rectangle(0, 0, width, pixelData.length / width);
        for (int x = bounds.x; x <= bounds.x + bounds.width; ++x) {
            block1: for (int y = bounds.y; y <= bounds.y + bounds.height; ++y) {
                if (!roi.contains(x, y)) continue;
                for (int i = x - 1; i <= x + 1; ++i) {
                    for (int j = y - 1; j <= y + 1; ++j) {
                        int kernalOffset = i + j * width;
                        if (kernalOffset < 0 || kernalOffset >= pixelData.length || pixelData[kernalOffset] == id || pixelData[x + y * width] != id) continue;
                        erodeOffsets.add(x + y * width);
                        continue block1;
                    }
                }
            }
        }
        for (Integer errodeOffset : erodeOffsets) {
            pixelData[errodeOffset.intValue()] = 0;
        }
    }

    public static void close(ImageProcessor labelData, Roi roi, byte id) {
        LabelBinaryOps.dilate(labelData, roi, id);
        LabelBinaryOps.erode(labelData, roi, id);
    }

    public static void open(ImageProcessor labelData, Roi roi, byte id) {
        LabelBinaryOps.erode(labelData, roi, id);
        LabelBinaryOps.dilate(labelData, roi, id);
    }

    public static void clean(Roi roi, byte[] pixelData, int width, byte id) {
        LabelBinaryOps.dilate(roi, pixelData, width, id);
        LabelBinaryOps.erode(roi, pixelData, width, id);
        LabelBinaryOps.erode(roi, pixelData, width, id);
        LabelBinaryOps.dilate(roi, pixelData, width, id);
    }
}

