/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

public class FindMinima {
    private static final int NO_MINIMUM = 0;
    private static final int UNLABELLED = 100;
    private static final int MINIMUM = 255;
    private static final int IN_QUEUE = 25;
    protected ImagePlus image;
    private ImagePlus result;
    private int w;
    private int h;
    private int d;
    private byte[][] data;
    private byte[][] minima;

    public FindMinima() {
    }

    public FindMinima(ImagePlus imp) {
        this.init(imp);
    }

    public void init(ImagePlus imp) {
        this.image = imp;
        this.w = imp.getWidth();
        this.h = imp.getHeight();
        this.d = imp.getStackSize();
        this.data = new byte[this.d][];
        for (int z = 0; z < this.d; ++z) {
            this.data[z] = (byte[])imp.getStack().getPixels(z + 1);
        }
        this.minima = new byte[this.d][this.w * this.h];
        ImageStack stack = new ImageStack(this.w, this.h);
        for (int z = 0; z < this.d; ++z) {
            Arrays.fill(this.minima[z], (byte)100);
            stack.addSlice("", (Object)this.minima[z]);
        }
        this.result = new ImagePlus("Minima", stack);
        this.result.setCalibration(this.image.getCalibration());
    }

    private final int get(Point p) {
        return this.data[p.z][p.y * this.w + p.x] & 0xFF;
    }

    private final int getLabel(Point p) {
        return this.minima[p.z][p.y * this.w + p.x] & 0xFF;
    }

    private final void label(Point p) {
        this.minima[((Point)p).z][((Point)p).y * this.w + ((Point)p).x] = -1;
    }

    private final void unlabel(Point p) {
        this.minima[((Point)p).z][((Point)p).y * this.w + ((Point)p).x] = 0;
    }

    private final void inQueue(Point p) {
        this.minima[((Point)p).z][((Point)p).y * this.w + ((Point)p).x] = 25;
    }

    private final boolean isLabelled(Point p) {
        return this.minima[p.z][p.y * this.w + p.x] != 100;
    }

    public ImagePlus createOverlay() {
        ImageStack stack = new ImageStack(this.w, this.h);
        int RED = 0xFF0000;
        for (int z = 0; z < this.d; ++z) {
            ImageProcessor ip = this.image.getStack().getProcessor(z + 1).convertToRGB();
            for (int i = 0; i < this.w * this.h; ++i) {
                if (this.minima[z][i] != -1) continue;
                ip.set(i, RED);
            }
            stack.addSlice("", ip);
        }
        ImagePlus ret = new ImagePlus("overlay", stack);
        ret.setCalibration(this.image.getCalibration());
        return ret;
    }

    public ImagePlus classify() {
        for (int z = 0; z < this.d; ++z) {
            for (int y = 0; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    this.classifyPixel(x, y, z);
                }
            }
            IJ.showProgress((int)z, (int)this.d);
        }
        return this.result;
    }

    public void classifyPixel(int x, int y, int z) {
        Point start = new Point(x, y, z);
        if (this.isLabelled(start)) {
            return;
        }
        LinkedList<Point> s = new LinkedList<Point>();
        ArrayList<Point> closed = new ArrayList<Point>();
        s.add(start);
        closed.add(start);
        this.minima[((Point)start).z][((Point)start).y * this.w + ((Point)start).x] = 25;
        while (!s.isEmpty()) {
            Point p = (Point)s.removeLast();
            int v = this.get(p);
            for (int iz = -1; iz <= 1; ++iz) {
                int zIdx = p.z + iz;
                if (zIdx < 0 || zIdx >= this.d) continue;
                for (int iy = -1; iy <= 1; ++iy) {
                    int yIdx = p.y + iy;
                    if (yIdx < 0 || yIdx >= this.h) continue;
                    for (int ix = -1; ix <= 1; ++ix) {
                        Point nPoint;
                        int xIdx = p.x + ix;
                        if (xIdx < 0 || xIdx >= this.w || this.getLabel(nPoint = new Point(xIdx, yIdx, zIdx)) == 25) continue;
                        int vt = this.get(nPoint);
                        if (vt < v) {
                            for (Point c : closed) {
                                this.unlabel(c);
                            }
                            return;
                        }
                        if (vt > v) continue;
                        int l = this.getLabel(nPoint);
                        switch (l) {
                            case 255: {
                                for (Point c : closed) {
                                    this.label(c);
                                }
                                return;
                            }
                            case 0: {
                                for (Point c : closed) {
                                    this.unlabel(c);
                                }
                                return;
                            }
                        }
                        s.add(nPoint);
                        closed.add(nPoint);
                        this.inQueue(nPoint);
                    }
                }
            }
        }
        for (Point c : closed) {
            this.label(c);
        }
    }

    private static final class Point {
        private int x;
        private int y;
        private int z;

        Point(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            Point p = (Point)o;
            return this.x == p.x && this.y == p.y && this.z == p.z;
        }

        public int hashCode() {
            return this.z * this.y * this.x;
        }
    }
}

