/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.list;

import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.list.ListImg;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class ListImgFactory<T>
extends ImgFactory<T> {
    public ListImgFactory(T type) {
        super(type);
    }

    @Override
    public ListImg<T> create(long ... dimensions) {
        return new ListImg(Dimensions.verify(dimensions), this.type());
    }

    @Override
    public ListImg<T> create(Dimensions dimensions) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions));
    }

    @Override
    public ListImg<T> create(int[] dimensions) {
        return this.create(Util.int2long(dimensions));
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        return new ListImgFactory<S>(type);
    }

    @Deprecated
    public ListImgFactory() {
    }

    @Override
    @Deprecated
    public ListImg<T> create(long[] dim, T type) {
        this.cache(type);
        return new ListImg<T>(dim, type);
    }
}

