/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.GenericByteType;

public class ByteType
extends GenericByteType<ByteType> {
    private static final NativeTypeFactory<ByteType, ByteAccess> typeFactory = NativeTypeFactory.BYTE(ByteType::new);

    public ByteType(NativeImg<?, ? extends ByteAccess> img) {
        super(img);
    }

    public ByteType(byte value) {
        super(value);
    }

    public ByteType(ByteAccess access) {
        super(access);
    }

    public ByteType() {
        super((byte)0);
    }

    @Override
    public NativeTypeFactory<ByteType, ByteAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public ByteType duplicateTypeOnSameNativeImg() {
        return new ByteType(this.img);
    }

    public byte get() {
        return this.getByte();
    }

    @Override
    public void set(byte b) {
        this.setByte(b);
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.set((byte)f);
    }

    @Override
    public void setInteger(long f) {
        this.set((byte)f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.byteValue());
    }

    @Override
    public double getMaxValue() {
        return 127.0;
    }

    @Override
    public double getMinValue() {
        return -128.0;
    }

    @Override
    public ByteType createVariable() {
        return new ByteType(0);
    }

    @Override
    public ByteType copy() {
        return new ByteType(this.dataAccess != null ? this.get() : (byte)0);
    }
}

