/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.Ptr;

public class CharPtr
implements Ptr {
    public final char[] array;
    public final int offset;

    public CharPtr(char[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public CharPtr(char ... array) {
        this.array = array;
        this.offset = 0;
    }

    public static CharPtr fromString(String string) {
        int nchars = string.length();
        char[] array = new char[nchars + 1];
        System.arraycopy(string.toCharArray(), 0, array, 0, nchars);
        return new CharPtr(array);
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public String asString() {
        int length;
        for (length = this.offset; length < this.array.length && this.array[length] != '\u0000'; ++length) {
        }
        return new String(this.array, this.offset, length - this.offset);
    }
}

