/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.mdarray;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

public abstract class MDAbstractArray<T>
implements Serializable,
Iterable<ArrayEntry> {
    private static final long serialVersionUID = 1L;
    protected final int[] dimensions;
    protected int hyperRowLength;
    protected int capacityHyperRows;
    protected int size;

    protected MDAbstractArray(int[] dimensions, int arrayLength, int capacityHyperRows) {
        assert (dimensions != null);
        this.dimensions = dimensions;
        this.hyperRowLength = this.computeHyperRowLength(dimensions);
        if (this.hyperRowLength == 0) {
            this.capacityHyperRows = 0;
            this.size = 0;
        } else {
            if (arrayLength % this.hyperRowLength != 0) {
                throw new IllegalArgumentException("Actual array length " + arrayLength + " does not match hyper-row length " + this.hyperRowLength + ".");
            }
            this.capacityHyperRows = capacityHyperRows > 0 ? capacityHyperRows : Math.max(dimensions[0], arrayLength / this.hyperRowLength);
            this.size = dimensions[0] * this.hyperRowLength;
        }
    }

    protected MDAbstractArray(MDAbstractArray<T> template) {
        this.dimensions = (int[])template.dimensions.clone();
        this.hyperRowLength = template.hyperRowLength;
        this.capacityHyperRows = template.capacityHyperRows;
        this.size = template.size;
    }

    protected int computeHyperRowLength(int[] dimensions) {
        int hyperRowLen = 1;
        int i = 1;
        while (i < dimensions.length) {
            hyperRowLen *= dimensions[i];
            ++i;
        }
        return hyperRowLen;
    }

    public int rank() {
        return this.dimensions.length;
    }

    public int size(int dim) {
        assert (dim < this.dimensions.length);
        return this.dimensions[dim];
    }

    public int[] dimensions() {
        return (int[])this.dimensions.clone();
    }

    public long[] longDimensions() {
        long[] dimensionsCopy = new long[this.dimensions.length];
        int i = 0;
        while (i < dimensionsCopy.length) {
            dimensionsCopy[i] = this.dimensions[i];
            ++i;
        }
        return dimensionsCopy;
    }

    public int size() {
        return this.size;
    }

    public int numberOfHyperRows() {
        return this.numberOfHyperRows();
    }

    public abstract T getAsObject(int var1);

    public abstract T getAsObject(int ... var1);

    public abstract void setToObject(T var1, int ... var2);

    public abstract void setToObject(T var1, int var2);

    public abstract Object getAsFlatArray();

    public abstract Object getCopyAsFlatArray();

    protected abstract void adaptCapacityHyperRows();

    public abstract int capacity();

    public int incNumberOfHyperRows(int count) {
        this.dimensions[0] = this.dimensions[0] + count;
        if (this.dimensions[0] > this.capacityHyperRows) {
            this.capacityHyperRows = Math.max(this.capacityHyperRows * 2, this.dimensions[0]);
            this.adaptCapacityHyperRows();
        }
        this.size += count * this.hyperRowLength;
        return this.dimensions[0];
    }

    public int decNumberOfHyperRows(int count) {
        this.dimensions[0] = this.dimensions[0] - count;
        this.size -= count * this.hyperRowLength;
        return this.dimensions[0];
    }

    public int computeIndex(int ... indices) {
        assert (indices != null);
        assert (indices.length == this.dimensions.length);
        int index = indices[0];
        int i = 1;
        while (i < indices.length) {
            index = index * this.dimensions[i] + indices[i];
            ++i;
        }
        return index;
    }

    public int[] computeReverseIndex(int linearIndex) {
        int[] index = new int[this.dimensions.length];
        int workIndex = linearIndex;
        int blockSize = this.size;
        int i = 0;
        while (i < this.dimensions.length) {
            index[i] = workIndex / (blockSize /= this.dimensions[i]);
            workIndex -= index[i] * blockSize;
            ++i;
        }
        return index;
    }

    public int computeIndex(int indexX, int indexY) {
        assert (2 == this.dimensions.length);
        return this.dimensions[1] * indexX + indexY;
    }

    public int computeIndex(int indexX, int indexY, int indexZ) {
        assert (3 == this.dimensions.length);
        return this.dimensions[2] * (this.dimensions[1] * indexX + indexY) + indexZ;
    }

    public static int[] toInt(long[] dimensions) {
        assert (dimensions != null);
        int[] result = new int[dimensions.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (int)dimensions[i];
            if ((long)result[i] != dimensions[i]) {
                throw new IllegalArgumentException("Dimension " + i + "  is too large (" + dimensions[i] + ")");
            }
            ++i;
        }
        return result;
    }

    public static long[] toLong(int[] dimensions) {
        assert (dimensions != null);
        long[] result = new long[dimensions.length];
        int i = 0;
        while (i < result.length) {
            result[i] = dimensions[i];
            ++i;
        }
        return result;
    }

    public static int getLength(int[] dimensions) {
        return MDAbstractArray.getLength(dimensions, 0);
    }

    public static int getLength(int[] dimensions, int capacityHyperRows) {
        assert (dimensions != null);
        if (dimensions.length == 0) {
            return 0;
        }
        long length = Math.max(capacityHyperRows, dimensions[0]);
        int i = 1;
        while (i < dimensions.length) {
            length *= (long)dimensions[i];
            ++i;
        }
        int intLength = (int)length;
        if (length != (long)intLength) {
            throw new IllegalArgumentException("Length is too large (" + length + ")");
        }
        return intLength;
    }

    public static int getLength(long[] dimensions) {
        return MDAbstractArray.getLength(dimensions, 0L);
    }

    public static int getLength(long[] dimensions, long capacityHyperRows) {
        assert (dimensions != null);
        if (dimensions.length == 0) {
            return 0;
        }
        long length = Math.max(capacityHyperRows, dimensions[0]);
        int i = 1;
        while (i < dimensions.length) {
            length *= dimensions[i];
            ++i;
        }
        int intLength = (int)length;
        if (length != (long)intLength) {
            throw new IllegalArgumentException("Length is too large (" + length + ")");
        }
        return intLength;
    }

    @Override
    public Iterator<ArrayEntry> iterator() {
        return new Iterator<ArrayEntry>(){
            int linearIndex = 0;

            @Override
            public boolean hasNext() {
                return this.linearIndex < MDAbstractArray.this.size;
            }

            @Override
            public ArrayEntry next() {
                ArrayEntry next = new ArrayEntry(this.linearIndex);
                ++this.linearIndex;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        int length = MDAbstractArray.getLength(this.dimensions, 0);
        StringBuilder b = new StringBuilder();
        b.append(ClassUtils.getShortCanonicalName(this.getClass()));
        b.append('(');
        b.append(ArrayUtils.toString((Object)this.dimensions));
        b.append(')');
        if (length <= 100) {
            b.append(": ");
            if (this.dimensions[0] < this.capacityHyperRows) {
                b.append(ArrayUtils.toString((Object)this.getCopyAsFlatArray()));
            } else {
                b.append(ArrayUtils.toString((Object)this.getAsFlatArray()));
            }
        }
        return b.toString();
    }

    public class ArrayEntry {
        private final int linearIndex;

        ArrayEntry(int linearIndex) {
            this.linearIndex = linearIndex;
        }

        public int[] getIndex() {
            return MDAbstractArray.this.computeReverseIndex(this.linearIndex);
        }

        public int getLinearIndex() {
            return this.linearIndex;
        }

        public T getValue() {
            return MDAbstractArray.this.getAsObject(this.linearIndex);
        }
    }
}

