/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Cube;
import fiji.plugin.volumeviewer.Line;
import fiji.plugin.volumeviewer.Pic;
import fiji.plugin.volumeviewer.TextField;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class ImageRegion
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Control control;
    private Pic pic;
    private Image image;
    private int width;
    private int height;
    private TextField[] textField = null;
    private Line[] lines = null;
    private Line[] clipLines = null;
    private Color planeColor = Color.lightGray;
    private Font font0 = new Font("Sans", 0, 18);
    private Font font1 = new Font("Sans", 0, 12);
    private int plotNumber = 1;

    public ImageRegion(Control control) {
        this.control = control;
    }

    public void setPlaneColor(Color color) {
        this.planeColor = color;
    }

    public int[] getValues(int xm, int ym) {
        int[] vals = this.pic.getValuesfromSlices(xm, ym);
        return vals;
    }

    public void newText(int n) {
        this.textField = new TextField[n];
        for (int i = 0; i < this.textField.length; ++i) {
            this.textField[i] = new TextField();
        }
    }

    public void setText(String text, int i, int posx, int posy, int z, Color color) {
        this.textField[i] = new TextField(text, color, posx, posy, z);
    }

    public void setText(String text, int i, int posx, int posy, int z, Color color, int fontNr) {
        this.textField[i] = new TextField(text, color, posx, posy, z, fontNr);
    }

    public void setText(String text, int i, Color color) {
        this.textField[i].setText(text);
        this.textField[i].setColor(color);
    }

    public void setText(String text, int i) {
        this.textField[i].setText(text);
    }

    public void setTextPos(int i, float xpos, float ypos, int z) {
        this.textField[i].setXpos(xpos);
        this.textField[i].setYpos(ypos);
        this.textField[i].setZ(z);
    }

    public void newLines(int n) {
        this.lines = new Line[n];
    }

    public void newClipLine(int n) {
        this.clipLines = new Line[n];
    }

    public void setLine(int i, int x1, int y1, int x2, int y2, int z, Color color) {
        this.lines[i] = new Line(x1, y1, x2, y2, z, color);
    }

    public void setClipLine(int i, int x1, int y1, int x2, int y2, int z, Color color) {
        this.clipLines[i] = new Line(x1, y1, x2, y2, z, color);
    }

    public void setPic(Pic pic) {
        this.pic = pic;
        this.height = pic.getHeight();
        this.width = pic.getWidth();
        this.image = pic.getImage();
    }

    public void setImage(Image image) {
        this.image = image;
    }

    void findLines(Cube cube, float scaledDist, int depthV) {
        int y2;
        int y1;
        int x2;
        int x1;
        cube.findIntersections(scaledDist);
        float[][] iS = cube.getInterSections();
        iS[1][0] = -1.0f;
        iS[0][0] = -1.0f;
        Color color = Color.cyan;
        cube.findSliceIntersectionsXY(scaledDist);
        if (iS[1][0] != -1.0f) {
            x1 = (int)((float)this.pic.xo + iS[0][0] / this.pic.xd);
            x2 = (int)((float)this.pic.xo + iS[1][0] / this.pic.xd);
            y1 = (int)((float)this.pic.yo_xy + iS[0][1] / this.pic.yd);
            y2 = (int)((float)this.pic.yo_xy + iS[1][1] / this.pic.yd);
            this.setLine(0, x1, y1, x2, y2, -1, color);
        } else {
            this.setLine(0, 0, 0, 0, 0, 1, color);
        }
        iS[1][0] = -1.0f;
        iS[0][0] = -1.0f;
        color = Color.green;
        cube.findSliceIntersectionsYZ(scaledDist);
        if (iS[1][0] != -1.0f) {
            x1 = (int)((float)this.pic.xo + iS[0][1] / this.pic.yd);
            x2 = (int)((float)this.pic.xo + iS[1][1] / this.pic.yd);
            y1 = (int)((float)this.pic.yo_yz + ((float)depthV - iS[0][2]) / this.pic.zd);
            y2 = (int)((float)this.pic.yo_yz + ((float)depthV - iS[1][2]) / this.pic.zd);
            this.setLine(1, x1, y1, x2, y2, -1, color);
        } else {
            this.setLine(1, 0, 0, 0, 0, 1, color);
        }
        iS[1][0] = -1.0f;
        iS[0][0] = -1.0f;
        color = Color.red;
        cube.findIntersections_xz(scaledDist);
        if (iS[1][0] != -1.0f) {
            x1 = (int)((float)this.pic.xo + iS[0][0] / this.pic.xd);
            x2 = (int)((float)this.pic.xo + iS[1][0] / this.pic.xd);
            y1 = (int)((float)this.pic.yo_xz + ((float)depthV - iS[0][2]) / this.pic.zd);
            y2 = (int)((float)this.pic.yo_xz + ((float)depthV - iS[1][2]) / this.pic.zd);
            this.setLine(2, x1, y1, x2, y2, -1, color);
        } else {
            this.setLine(2, 0, 0, 0, 0, 1, color);
        }
    }

    public synchronized void saveToImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        this.paint(bufferedImage.createGraphics());
        Graphics2D g2d = bufferedImage.createGraphics();
        Color backgroundColor = this.control.backgroundColor;
        if (backgroundColor.getRed() + backgroundColor.getGreen() + backgroundColor.getGreen() > 384) {
            g2d.setColor(Color.black);
        } else {
            g2d.setColor(Color.white);
        }
        g2d.drawString("Volume Viewer", this.width - 100, this.height - 10);
        g2d.dispose();
        String s = "Volume_Viewer_" + this.plotNumber;
        ImagePlus plotImage = NewImage.createRGBImage((String)s, (int)this.width, (int)this.height, (int)1, (int)1);
        ImageProcessor ip = plotImage.getProcessor();
        int[] pixels = (int[])ip.getPixels();
        bufferedImage.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        plotImage.show();
        plotImage.updateAndDraw();
        ++this.plotNumber;
    }

    public synchronized ImagePlus getImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        this.paint(bufferedImage.createGraphics());
        Graphics2D g2d = bufferedImage.createGraphics();
        Color backgroundColor = this.control.backgroundColor;
        if (backgroundColor.getRed() + backgroundColor.getGreen() + backgroundColor.getGreen() > 384) {
            g2d.setColor(Color.black);
        } else {
            g2d.setColor(Color.white);
        }
        g2d.drawString("Volume Viewer", this.width - 100, this.height - 10);
        g2d.dispose();
        String s = "Volume_Viewer_" + this.plotNumber;
        ImagePlus plotImage = NewImage.createRGBImage((String)s, (int)this.width, (int)this.height, (int)1, (int)1);
        ImageProcessor ip = plotImage.getProcessor();
        int[] pixels = (int[])ip.getPixels();
        bufferedImage.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        ++this.plotNumber;
        return plotImage;
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(this.planeColor);
        g2.clearRect(0, 0, this.width, this.height);
        g2.setFont(this.font0);
        if (this.textField != null && this.control.showAxes) {
            for (i = 0; i < this.textField.length; ++i) {
                if (this.textField[i] == null || !(this.textField[i].getZ() > 0.0f)) continue;
                g2.setColor(this.textField[i].getColor());
                g2.drawString(this.textField[i].getText(), this.textField[i].getXpos(), this.textField[i].getYpos());
            }
        }
        if (this.lines != null) {
            for (i = 0; i < this.lines.length; ++i) {
                if (this.lines[i] == null || this.lines[i].getZ() <= 0) continue;
                g2.setColor(this.lines[i].getColor());
                g2.drawLine(this.lines[i].getX1(), this.lines[i].getY1(), this.lines[i].getX2(), this.lines[i].getY2());
            }
        }
        if (this.image != null) {
            g2.drawImage(this.image, 0, 0, this.width, this.height, this);
        }
        if (this.lines != null) {
            for (i = 0; i < this.lines.length; ++i) {
                if (this.lines[i] == null || this.lines[i].getZ() > 0) continue;
                g2.setColor(this.lines[i].getColor());
                g2.drawLine(this.lines[i].getX1(), this.lines[i].getY1(), this.lines[i].getX2(), this.lines[i].getY2());
            }
        }
        if (this.clipLines != null && this.control.showClipLines) {
            for (i = 0; i < this.clipLines.length; ++i) {
                if (this.clipLines[i] == null) continue;
                g2.setColor(this.clipLines[i].getColor());
                g2.drawLine(this.clipLines[i].getX1(), this.clipLines[i].getY1(), this.clipLines[i].getX2(), this.clipLines[i].getY2());
            }
        }
        if (this.textField != null && this.control.showAxes) {
            for (i = 0; i < this.textField.length; ++i) {
                if (this.textField[i] == null || !(this.textField[i].getZ() <= 0.0f)) continue;
                if (this.textField[i].getFontNr() == 1) {
                    g2.setFont(this.font1);
                }
                g2.setColor(this.textField[i].getColor());
                g2.drawString(this.textField[i].getText(), this.textField[i].getXpos(), this.textField[i].getYpos());
            }
        }
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

