/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.convert;

import java.math.BigDecimal;
import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Plugin;

public final class ConvertTypes {
    private ConvertTypes() {
    }

    @Plugin(type=Ops.Convert.Cfloat64.class, name="convert.cfloat64", attrs={@Attr(name="aliases", value="convert.complexDouble")})
    public static class ComplexToCfloat64<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, ComplexDoubleType>
    implements Ops.Convert.Cfloat64 {
        @Override
        public ComplexDoubleType createOutput(C input) {
            return new ComplexDoubleType();
        }

        @Override
        public void compute(C input, ComplexDoubleType output) {
            output.set(input.getRealDouble(), input.getImaginaryDouble());
        }
    }

    @Plugin(type=Ops.Convert.Float64.class, name="convert.float64", attrs={@Attr(name="aliases", value="convert.double")})
    public static class ComplexToFloat64<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, DoubleType>
    implements Ops.Convert.Float64 {
        @Override
        public DoubleType createOutput(C input) {
            return new DoubleType();
        }

        @Override
        public void compute(C input, DoubleType output) {
            output.set(input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Cfloat32.class, name="convert.cfloat32", attrs={@Attr(name="aliases", value="convert.complexFloat")})
    public static class ComplexToCfloat32<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, ComplexFloatType>
    implements Ops.Convert.Cfloat32 {
        @Override
        public ComplexFloatType createOutput(C input) {
            return new ComplexFloatType();
        }

        @Override
        public void compute(C input, ComplexFloatType output) {
            output.set(input.getRealFloat(), input.getImaginaryFloat());
        }
    }

    @Plugin(type=Ops.Convert.Float32.class, name="convert.float32", attrs={@Attr(name="aliases", value="convert.float")})
    public static class ComplexToFloat32<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, FloatType>
    implements Ops.Convert.Float32 {
        @Override
        public FloatType createOutput(C input) {
            return new FloatType();
        }

        @Override
        public void compute(C input, FloatType output) {
            output.set(input.getRealFloat());
        }
    }

    @Plugin(type=Ops.Convert.Uint128.class, name="convert.uint128", priority=100.0)
    public static class IntegerToUint128<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, Unsigned128BitType>
    implements Ops.Convert.Uint128 {
        @Override
        public Unsigned128BitType createOutput(T input) {
            return new Unsigned128BitType();
        }

        @Override
        public void compute(T input, Unsigned128BitType output) {
            output.set(input.getBigInteger());
        }
    }

    @Plugin(type=Ops.Convert.Uint128.class, name="convert.uint128")
    public static class ComplexToUint128<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, Unsigned128BitType>
    implements Ops.Convert.Uint128 {
        @Override
        public Unsigned128BitType createOutput(C input) {
            return new Unsigned128BitType();
        }

        @Override
        public void compute(C input, Unsigned128BitType output) {
            BigDecimal bd = BigDecimal.valueOf(input.getRealDouble());
            BigDecimal r = bd.remainder(BigDecimal.ONE);
            if (r.compareTo(BigDecimal.ZERO) == 0) {
                output.set(bd.toBigIntegerExact());
            } else {
                output.set(bd.toBigInteger());
            }
        }
    }

    @Plugin(type=Ops.Convert.Uint64.class, name="convert.uint64", priority=100.0, attrs={@Attr(name="aliases", value="convert.unsignedLong")})
    public static class IntegerToUint64<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, UnsignedLongType>
    implements Ops.Convert.Uint64 {
        @Override
        public UnsignedLongType createOutput(T input) {
            return new UnsignedLongType();
        }

        @Override
        public void compute(T input, UnsignedLongType output) {
            output.set(input.getIntegerLong());
        }
    }

    @Plugin(type=Ops.Convert.Uint64.class, name="convert.uint64", attrs={@Attr(name="aliases", value="convert.unsignedLong")})
    public static class ComplexToUint64<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, UnsignedLongType>
    implements Ops.Convert.Uint64 {
        @Override
        public UnsignedLongType createOutput(C input) {
            return new UnsignedLongType();
        }

        @Override
        public void compute(C input, UnsignedLongType output) {
            BigDecimal bd = BigDecimal.valueOf(input.getRealDouble());
            BigDecimal r = bd.remainder(BigDecimal.ONE);
            if (r.compareTo(BigDecimal.ZERO) == 0) {
                output.set(bd.toBigIntegerExact().longValue());
            } else {
                output.set(bd.toBigInteger().longValue());
            }
        }
    }

    @Plugin(type=Ops.Convert.Int64.class, name="convert.int64", priority=100.0, attrs={@Attr(name="aliases", value="convert.long")})
    public static class IntegerToInt64<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, LongType>
    implements Ops.Convert.Int64 {
        @Override
        public LongType createOutput(T input) {
            return new LongType();
        }

        @Override
        public void compute(T input, LongType output) {
            output.set(input.getIntegerLong());
        }
    }

    @Plugin(type=Ops.Convert.Int64.class, name="convert.int64", attrs={@Attr(name="aliases", value="convert.long")})
    public static class ComplexToInt64<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, LongType>
    implements Ops.Convert.Int64 {
        @Override
        public LongType createOutput(C input) {
            return new LongType();
        }

        @Override
        public void compute(C input, LongType output) {
            output.set((long)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Uint32.class, name="convert.uint32", priority=100.0, attrs={@Attr(name="aliases", value="convert.unsignedInt")})
    public static class IntegerToUint32<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, UnsignedIntType>
    implements Ops.Convert.Uint32 {
        @Override
        public UnsignedIntType createOutput(T input) {
            return new UnsignedIntType();
        }

        @Override
        public void compute(T input, UnsignedIntType output) {
            output.set(input.getIntegerLong());
        }
    }

    @Plugin(type=Ops.Convert.Uint32.class, name="convert.uint32", attrs={@Attr(name="aliases", value="convert.unsignedInt")})
    public static class ComplexToUint32<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, UnsignedIntType>
    implements Ops.Convert.Uint32 {
        @Override
        public UnsignedIntType createOutput(C input) {
            return new UnsignedIntType();
        }

        @Override
        public void compute(C input, UnsignedIntType output) {
            output.set((long)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Int32.class, name="convert.int32", priority=100.0, attrs={@Attr(name="aliases", value="convert.int")})
    public static class IntegerToInt32<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, IntType>
    implements Ops.Convert.Int32 {
        @Override
        public IntType createOutput(T input) {
            return new IntType();
        }

        @Override
        public void compute(T input, IntType output) {
            output.set(input.getInteger());
        }
    }

    @Plugin(type=Ops.Convert.Int32.class, name="convert.int32", attrs={@Attr(name="aliases", value="convert.int")})
    public static class ComplexToInt32<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, IntType>
    implements Ops.Convert.Int32 {
        @Override
        public IntType createOutput(C input) {
            return new IntType();
        }

        @Override
        public void compute(C input, IntType output) {
            output.set((int)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Uint16.class, name="convert.uint16", priority=100.0, attrs={@Attr(name="aliases", value="convert.unsignedShort")})
    public static class IntegerToUint16<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, UnsignedShortType>
    implements Ops.Convert.Uint16 {
        @Override
        public UnsignedShortType createOutput(T input) {
            return new UnsignedShortType();
        }

        @Override
        public void compute(T input, UnsignedShortType output) {
            output.set(input.getInteger());
        }
    }

    @Plugin(type=Ops.Convert.Uint16.class, name="convert.uint16", attrs={@Attr(name="aliases", value="convert.unsignedShort")})
    public static class ComplexToUint16<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, UnsignedShortType>
    implements Ops.Convert.Uint16 {
        @Override
        public UnsignedShortType createOutput(C input) {
            return new UnsignedShortType();
        }

        @Override
        public void compute(C input, UnsignedShortType output) {
            output.set((int)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Int16.class, name="convert.int16", priority=100.0)
    public static class IntegerToInt16<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, ShortType>
    implements Ops.Convert.Int16 {
        @Override
        public ShortType createOutput(T input) {
            return new ShortType();
        }

        @Override
        public void compute(T input, ShortType output) {
            output.set((short)input.getIntegerLong());
        }
    }

    @Plugin(type=Ops.Convert.Int16.class, name="convert.int16", attrs={@Attr(name="aliases", value="convert.short")})
    public static class ComplexToInt16<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, ShortType>
    implements Ops.Convert.Int16 {
        @Override
        public ShortType createOutput(C input) {
            return new ShortType();
        }

        @Override
        public void compute(C input, ShortType output) {
            output.set((short)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Uint12.class, name="convert.uint12", priority=100.0)
    public static class IntegerToUint12<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, Unsigned12BitType>
    implements Ops.Convert.Uint12 {
        @Override
        public Unsigned12BitType createOutput(T input) {
            return new Unsigned12BitType();
        }

        @Override
        public void compute(T input, Unsigned12BitType output) {
            output.set(input.getIntegerLong());
        }
    }

    @Plugin(type=Ops.Convert.Uint12.class, name="convert.uint12")
    public static class ComplexToUint12<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, Unsigned12BitType>
    implements Ops.Convert.Uint12 {
        @Override
        public Unsigned12BitType createOutput(C input) {
            return new Unsigned12BitType();
        }

        @Override
        public void compute(C input, Unsigned12BitType output) {
            output.set((long)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Uint8.class, name="convert.uint8", priority=100.0, attrs={@Attr(name="aliases", value="convert.unsignedByte")})
    public static class IntegerToUint8<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, UnsignedByteType>
    implements Ops.Convert.Uint8 {
        @Override
        public UnsignedByteType createOutput(T input) {
            return new UnsignedByteType();
        }

        @Override
        public void compute(T input, UnsignedByteType output) {
            output.set(input.getInteger());
        }
    }

    @Plugin(type=Ops.Convert.Uint8.class, name="convert.uint8", attrs={@Attr(name="aliases", value="convert.unsignedByte")})
    public static class ComplexToUint8<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, UnsignedByteType>
    implements Ops.Convert.Uint8 {
        @Override
        public UnsignedByteType createOutput(C input) {
            return new UnsignedByteType();
        }

        @Override
        public void compute(C input, UnsignedByteType output) {
            output.set((int)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Int8.class, name="convert.int8", priority=100.0)
    public static class IntegerToInt8<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, ByteType>
    implements Ops.Convert.Int8 {
        @Override
        public ByteType createOutput(T input) {
            return new ByteType();
        }

        @Override
        public void compute(T input, ByteType output) {
            output.set((byte)input.getIntegerLong());
        }
    }

    @Plugin(type=Ops.Convert.Int8.class, name="convert.int8", attrs={@Attr(name="aliases", value="convert.byte")})
    public static class ComplexToInt8<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, ByteType>
    implements Ops.Convert.Int8 {
        @Override
        public ByteType createOutput(C input) {
            return new ByteType();
        }

        @Override
        public void compute(C input, ByteType output) {
            output.set((byte)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Uint4.class, name="convert.uint4", priority=100.0)
    public static class IntegerToUint4<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, Unsigned4BitType>
    implements Ops.Convert.Uint4 {
        @Override
        public Unsigned4BitType createOutput(T input) {
            return new Unsigned4BitType();
        }

        @Override
        public void compute(T input, Unsigned4BitType output) {
            output.set(input.getIntegerLong());
        }
    }

    @Plugin(type=Ops.Convert.Uint4.class, name="convert.uint4")
    public static class ComplexToUint4<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, Unsigned4BitType>
    implements Ops.Convert.Uint4 {
        @Override
        public Unsigned4BitType createOutput(C input) {
            return new Unsigned4BitType();
        }

        @Override
        public void compute(C input, Unsigned4BitType output) {
            output.set((long)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Uint2.class, name="convert.uint2", priority=100.0)
    public static class IntegerToUint2<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, Unsigned2BitType>
    implements Ops.Convert.Uint2 {
        @Override
        public Unsigned2BitType createOutput(T input) {
            return new Unsigned2BitType();
        }

        @Override
        public void compute(T input, Unsigned2BitType output) {
            output.set(input.getIntegerLong());
        }
    }

    @Plugin(type=Ops.Convert.Uint2.class, name="convert.uint2")
    public static class ComplexToUint2<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, Unsigned2BitType>
    implements Ops.Convert.Uint2 {
        @Override
        public Unsigned2BitType createOutput(C input) {
            return new Unsigned2BitType();
        }

        @Override
        public void compute(C input, Unsigned2BitType output) {
            output.set((long)input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Convert.Bit.class, name="convert.bit", priority=100.0)
    public static class IntegerToBit<T extends IntegerType<T>>
    extends AbstractUnaryHybridCF<T, BitType>
    implements Ops.Convert.Bit {
        @Override
        public BitType createOutput(T input) {
            return new BitType();
        }

        @Override
        public void compute(T input, BitType output) {
            output.set(input.getIntegerLong() != 0L);
        }
    }

    @Plugin(type=Ops.Convert.Bit.class, name="convert.bit")
    public static class ComplexToBit<C extends ComplexType<C>>
    extends AbstractUnaryHybridCF<C, BitType>
    implements Ops.Convert.Bit {
        @Override
        public BitType createOutput(C input) {
            return new BitType();
        }

        @Override
        public void compute(C input, BitType output) {
            output.set(input.getRealDouble() != 0.0);
        }
    }
}

