/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom;

import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.type.numeric.real.DoubleType;

public abstract class AbstractBoxivity<I>
extends AbstractUnaryHybridCF<I, DoubleType>
implements Ops.Geometric.Boxivity {
    private UnaryFunctionOp<I, DoubleType> areaFunc;
    private UnaryFunctionOp<I, I> smallestEnclosingRectangleFunc;
    private Class<I> inType;

    public AbstractBoxivity(Class<I> inType) {
        this.inType = inType;
    }

    @Override
    public void initialize() {
        this.areaFunc = RTs.function(this.ops(), Ops.Geometric.Size.class, this.in(), new Object[0]);
        this.smallestEnclosingRectangleFunc = Functions.unary(this.ops(), Ops.Geometric.SmallestEnclosingBoundingBox.class, this.inType, this.in(), new Object[0]);
    }

    @Override
    public void compute(I input, DoubleType output) {
        output.set(this.areaFunc.calculate(input).getRealDouble() / this.areaFunc.calculate(this.smallestEnclosingRectangleFunc.calculate(input)).getRealDouble());
    }

    @Override
    public DoubleType createOutput(I input) {
        return new DoubleType();
    }
}

